/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.selectable.BusinessObjectKeysSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusinessObjectKeys BusinessObjectKeys}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class BusinessObjectKeysByKeyFluentHelper
    extends
    FluentHelperByKey<BusinessObjectKeysByKeyFluentHelper, BusinessObjectKeys, BusinessObjectKeysSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusinessObjectKeys
     * BusinessObjectKeys} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code BusinessObjectKeys}
     * @param servicePath
     *            Service path to be used to fetch a single {@code BusinessObjectKeys}
     * @param sAPObjectType
     *            SAP Object Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     */
    public BusinessObjectKeysByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String sAPObjectType )
    {
        super(servicePath, entityCollection);
        this.key.put("SAPObjectType", sAPObjectType);
    }

    @Override
    @Nonnull
    protected Class<BusinessObjectKeys> getEntityClass()
    {
        return BusinessObjectKeys.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
