/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link BusinessEventQueueServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessEventQueueService BusinessEventQueueService},
 * allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultBusinessEventQueueServiceBatch
    extends
    BatchFluentHelperBasic<BusinessEventQueueServiceBatch, BusinessEventQueueServiceBatchChangeSet>
    implements
    BusinessEventQueueServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessEventQueueService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultBusinessEventQueueServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBusinessEventQueueServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessEventQueueService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessEventQueueService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultBusinessEventQueueServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBusinessEventQueueServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessEventQueueService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultBusinessEventQueueServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public BusinessEventQueueServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultBusinessEventQueueServiceBatchChangeSet(this, service);
    }

}
