/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link BusinessEventQueueServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessEventQueueService BusinessEventQueueService}.
 *
 */
public class DefaultBusinessEventQueueServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<BusinessEventQueueServiceBatch, BusinessEventQueueServiceBatchChangeSet>
    implements
    BusinessEventQueueServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessEventQueueService service;

    @SuppressWarnings( "deprecation" )
    DefaultBusinessEventQueueServiceBatchChangeSet(
        @Nonnull final DefaultBusinessEventQueueServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessEventQueueService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultBusinessEventQueueServiceBatchChangeSet getThis()
    {
        return this;
    }

}
