/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.Behqueuedata;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.selectable.BehqueuedataSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.Behqueuedata Behqueuedata} to other
 * entities. Instances of this object are used in query modifier methods of the entity fluent helpers. Contains methods
 * to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class BehqueuedataLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<BehqueuedataLink<ObjectT>, Behqueuedata, ObjectT>
    implements
    BehqueuedataSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public BehqueuedataLink( final String fieldName )
    {
        super(fieldName);
    }

    private BehqueuedataLink( final EntityLink<BehqueuedataLink<ObjectT>, Behqueuedata, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected BehqueuedataLink<ObjectT> translateLinkType(
        final EntityLink<BehqueuedataLink<ObjectT>, Behqueuedata, ObjectT> link )
    {
        return new BehqueuedataLink<ObjectT>(link);
    }

}
