/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.Behqueuedata;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.Behqueuedata Behqueuedata}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.field.BehqueuedataField
 * BehqueuedataField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.link.BehqueuedataLink
 * BehqueuedataLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.Behqueuedata#BUSINESS_EVENT
 * BUSINESS_EVENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.Behqueuedata#SAP_OBJECT_TASK_TYPE_NAME
 * SAP_OBJECT_TASK_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.Behqueuedata#SAP_OBJECT_TYPE_NAME
 * SAP_OBJECT_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.Behqueuedata#SAP_OBJECT_TYPE
 * SAP_OBJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.Behqueuedata#BUS_EVENT_SUBSCRIBER_CODE
 * BUS_EVENT_SUBSCRIBER_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.Behqueuedata#SAP_OBJECT_TASK_CODE
 * SAP_OBJECT_TASK_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.Behqueuedata#BUSINESS_EVENT_SUBSCRIBER_NAME
 * BUSINESS_EVENT_SUBSCRIBER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.Behqueuedata#SAP_BUSINESS_OBJECT_KEY1
 * SAP_BUSINESS_OBJECT_KEY1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.Behqueuedata#SAP_BUSINESS_OBJECT_KEY2
 * SAP_BUSINESS_OBJECT_KEY2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.Behqueuedata#SAP_BUSINESS_OBJECT_KEY3
 * SAP_BUSINESS_OBJECT_KEY3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.Behqueuedata#SAP_BUSINESS_OBJECT_KEY4
 * SAP_BUSINESS_OBJECT_KEY4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.Behqueuedata#SAP_BUSINESS_OBJECT_KEY5
 * SAP_BUSINESS_OBJECT_KEY5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.Behqueuedata#SAP_BUSINESS_OBJECT_KEY6
 * SAP_BUSINESS_OBJECT_KEY6}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.Behqueuedata#SAP_BUSINESS_OBJECT_KEY7
 * SAP_BUSINESS_OBJECT_KEY7}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.Behqueuedata#BUS_EVENT_PRIORITY
 * BUS_EVENT_PRIORITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.Behqueuedata#CREATION_UTC_DATE_TIME
 * CREATION_UTC_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.Behqueuedata#TO_BUS_OBJECTS
 * TO_BUS_OBJECTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.Behqueuedata#TO_KEYS TO_KEYS}</li>
 * </ul>
 *
 */
public interface BehqueuedataSelectable extends EntitySelectable<Behqueuedata>
{

}
