/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusObjects;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusObjects BusObjects}. This interface
 * is used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.field.BusObjectsField
 * BusObjectsField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.link.BusObjectsLink BusObjectsLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusObjects#SAP_OBJECT_TYPE
 * SAP_OBJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusObjects#SAP_OBJECT_TYPE_NAME
 * SAP_OBJECT_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusObjects#SAP_OBJECT_TASK_CODE
 * SAP_OBJECT_TASK_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusObjects#SAP_OBJECT_TASK_TYPE_NAME
 * SAP_OBJECT_TASK_TYPE_NAME}</li>
 * </ul>
 *
 */
public interface BusObjectsSelectable extends EntitySelectable<BusObjects>
{

}
