/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusinessObjectKeys;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusinessObjectKeys BusinessObjectKeys}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.field.BusinessObjectKeysField
 * BusinessObjectKeysField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.link.BusinessObjectKeysLink
 * BusinessObjectKeysLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusinessObjectKeys#SAP_OBJECT_TYPE
 * SAP_OBJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusinessObjectKeys#KEY_FIELD_NAME1
 * KEY_FIELD_NAME1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusinessObjectKeys#KEY_FIELD_NAME2
 * KEY_FIELD_NAME2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusinessObjectKeys#KEY_FIELD_NAME3
 * KEY_FIELD_NAME3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusinessObjectKeys#KEY_FIELD_NAME4
 * KEY_FIELD_NAME4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusinessObjectKeys#KEY_FIELD_NAME5
 * KEY_FIELD_NAME5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusinessObjectKeys#KEY_FIELD_NAME6
 * KEY_FIELD_NAME6}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventqueue.BusinessObjectKeys#KEY_FIELD_NAME7
 * KEY_FIELD_NAME7}</li>
 * </ul>
 *
 */
public interface BusinessObjectKeysSelectable extends EntitySelectable<BusinessObjectKeys>
{

}
