/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.field.SubscriptionMaintainField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.selectable.SubscriptionMaintainSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Maintain Subscriptions
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SubscriptionMaintain</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SubscriptionMaintain extends VdmEntity<SubscriptionMaintain>
{

    /**
     * Selector for all available fields of SubscriptionMaintain.
     *
     */
    public final static SubscriptionMaintainSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusEventSubscriberCode</b>
     * </p>
     *
     * @return Subscriber ID
     */
    @Key
    @SerializedName( "BusEventSubscriberCode" )
    @JsonProperty( "BusEventSubscriberCode" )
    @Nullable
    @ODataField( odataName = "BusEventSubscriberCode" )
    private String busEventSubscriberCode;
    /**
     * Use with available fluent helpers to apply the <b>BusEventSubscriberCode</b> field to query operations.
     *
     */
    public final static SubscriptionMaintainField<String> BUS_EVENT_SUBSCRIBER_CODE =
        new SubscriptionMaintainField<String>("BusEventSubscriberCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectType</b>
     * </p>
     *
     * @return SAP Object Type
     */
    @Key
    @SerializedName( "SAPObjectType" )
    @JsonProperty( "SAPObjectType" )
    @Nullable
    @ODataField( odataName = "SAPObjectType" )
    private String sAPObjectType;
    /**
     * Use with available fluent helpers to apply the <b>SAPObjectType</b> field to query operations.
     *
     */
    public final static SubscriptionMaintainField<String> SAP_OBJECT_TYPE =
        new SubscriptionMaintainField<String>("SAPObjectType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectTaskCode</b>
     * </p>
     *
     * @return SAP Object Task Code
     */
    @Key
    @SerializedName( "SAPObjectTaskCode" )
    @JsonProperty( "SAPObjectTaskCode" )
    @Nullable
    @ODataField( odataName = "SAPObjectTaskCode" )
    private String sAPObjectTaskCode;
    /**
     * Use with available fluent helpers to apply the <b>SAPObjectTaskCode</b> field to query operations.
     *
     */
    public final static SubscriptionMaintainField<String> SAP_OBJECT_TASK_CODE =
        new SubscriptionMaintainField<String>("SAPObjectTaskCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusEventSubscriptionStateCode</b>
     * </p>
     *
     * @return State
     */
    @SerializedName( "BusEventSubscriptionStateCode" )
    @JsonProperty( "BusEventSubscriptionStateCode" )
    @Nullable
    @ODataField( odataName = "BusEventSubscriptionStateCode" )
    private String busEventSubscriptionStateCode;
    /**
     * Use with available fluent helpers to apply the <b>BusEventSubscriptionStateCode</b> field to query operations.
     *
     */
    public final static SubscriptionMaintainField<String> BUS_EVENT_SUBSCRIPTION_STATE_CODE =
        new SubscriptionMaintainField<String>("BusEventSubscriptionStateCode");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>BusEventPriority</b>
     * </p>
     *
     * @return Priority
     */
    @SerializedName( "BusEventPriority" )
    @JsonProperty( "BusEventPriority" )
    @Nullable
    @ODataField( odataName = "BusEventPriority" )
    private Short busEventPriority;
    /**
     * Use with available fluent helpers to apply the <b>BusEventPriority</b> field to query operations.
     *
     */
    public final static SubscriptionMaintainField<Short> BUS_EVENT_PRIORITY =
        new SubscriptionMaintainField<Short>("BusEventPriority");

    @Nonnull
    @Override
    public Class<SubscriptionMaintain> getType()
    {
        return SubscriptionMaintain.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusEventSubscriberCode</b>
     * </p>
     *
     * @param busEventSubscriberCode
     *            Subscriber ID
     */
    public void setBusEventSubscriberCode( @Nullable final String busEventSubscriberCode )
    {
        rememberChangedField("BusEventSubscriberCode", this.busEventSubscriberCode);
        this.busEventSubscriberCode = busEventSubscriberCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectType</b>
     * </p>
     *
     * @param sAPObjectType
     *            SAP Object Type
     */
    public void setSAPObjectType( @Nullable final String sAPObjectType )
    {
        rememberChangedField("SAPObjectType", this.sAPObjectType);
        this.sAPObjectType = sAPObjectType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectTaskCode</b>
     * </p>
     *
     * @param sAPObjectTaskCode
     *            SAP Object Task Code
     */
    public void setSAPObjectTaskCode( @Nullable final String sAPObjectTaskCode )
    {
        rememberChangedField("SAPObjectTaskCode", this.sAPObjectTaskCode);
        this.sAPObjectTaskCode = sAPObjectTaskCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusEventSubscriptionStateCode</b>
     * </p>
     *
     * @param busEventSubscriptionStateCode
     *            State
     */
    public void setBusEventSubscriptionStateCode( @Nullable final String busEventSubscriptionStateCode )
    {
        rememberChangedField("BusEventSubscriptionStateCode", this.busEventSubscriptionStateCode);
        this.busEventSubscriptionStateCode = busEventSubscriptionStateCode;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>BusEventPriority</b>
     * </p>
     *
     * @param busEventPriority
     *            Priority
     */
    public void setBusEventPriority( @Nullable final Short busEventPriority )
    {
        rememberChangedField("BusEventPriority", this.busEventPriority);
        this.busEventPriority = busEventPriority;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SubscriptionMaintain";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BusEventSubscriberCode", getBusEventSubscriberCode());
        result.put("SAPObjectType", getSAPObjectType());
        result.put("SAPObjectTaskCode", getSAPObjectTaskCode());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BusEventSubscriberCode", getBusEventSubscriberCode());
        values.put("SAPObjectType", getSAPObjectType());
        values.put("SAPObjectTaskCode", getSAPObjectTaskCode());
        values.put("BusEventSubscriptionStateCode", getBusEventSubscriptionStateCode());
        values.put("BusEventPriority", getBusEventPriority());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BusEventSubscriberCode") ) {
                final Object value = values.remove("BusEventSubscriberCode");
                if( (value == null) || (!value.equals(getBusEventSubscriberCode())) ) {
                    setBusEventSubscriberCode(((String) value));
                }
            }
            if( values.containsKey("SAPObjectType") ) {
                final Object value = values.remove("SAPObjectType");
                if( (value == null) || (!value.equals(getSAPObjectType())) ) {
                    setSAPObjectType(((String) value));
                }
            }
            if( values.containsKey("SAPObjectTaskCode") ) {
                final Object value = values.remove("SAPObjectTaskCode");
                if( (value == null) || (!value.equals(getSAPObjectTaskCode())) ) {
                    setSAPObjectTaskCode(((String) value));
                }
            }
            if( values.containsKey("BusEventSubscriptionStateCode") ) {
                final Object value = values.remove("BusEventSubscriptionStateCode");
                if( (value == null) || (!value.equals(getBusEventSubscriptionStateCode())) ) {
                    setBusEventSubscriptionStateCode(((String) value));
                }
            }
            if( values.containsKey("BusEventPriority") ) {
                final Object value = values.remove("BusEventPriority");
                if( (value == null) || (!value.equals(getBusEventPriority())) ) {
                    setBusEventPriority(((Short) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SubscriptionMaintainField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SubscriptionMaintainField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SubscriptionMaintainField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SubscriptionMaintainField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessEventSubscriptionService.DEFAULT_SERVICE_PATH);
    }

}
