/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.field.SubscriptionReadField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.selectable.SubscriptionReadSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Read Subscriptions
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SubscriptionRead</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SubscriptionRead extends VdmEntity<SubscriptionRead>
{

    /**
     * Selector for all available fields of SubscriptionRead.
     *
     */
    public final static SubscriptionReadSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusEventSubscriberCode</b>
     * </p>
     *
     * @return Subscriber ID
     */
    @Key
    @SerializedName( "BusEventSubscriberCode" )
    @JsonProperty( "BusEventSubscriberCode" )
    @Nullable
    @ODataField( odataName = "BusEventSubscriberCode" )
    private String busEventSubscriberCode;
    /**
     * Use with available fluent helpers to apply the <b>BusEventSubscriberCode</b> field to query operations.
     *
     */
    public final static SubscriptionReadField<String> BUS_EVENT_SUBSCRIBER_CODE =
        new SubscriptionReadField<String>("BusEventSubscriberCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectType</b>
     * </p>
     *
     * @return SAP Object Type
     */
    @Key
    @SerializedName( "SAPObjectType" )
    @JsonProperty( "SAPObjectType" )
    @Nullable
    @ODataField( odataName = "SAPObjectType" )
    private String sAPObjectType;
    /**
     * Use with available fluent helpers to apply the <b>SAPObjectType</b> field to query operations.
     *
     */
    public final static SubscriptionReadField<String> SAP_OBJECT_TYPE =
        new SubscriptionReadField<String>("SAPObjectType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectTaskCode</b>
     * </p>
     *
     * @return SAP Object Task Code
     */
    @Key
    @SerializedName( "SAPObjectTaskCode" )
    @JsonProperty( "SAPObjectTaskCode" )
    @Nullable
    @ODataField( odataName = "SAPObjectTaskCode" )
    private String sAPObjectTaskCode;
    /**
     * Use with available fluent helpers to apply the <b>SAPObjectTaskCode</b> field to query operations.
     *
     */
    public final static SubscriptionReadField<String> SAP_OBJECT_TASK_CODE =
        new SubscriptionReadField<String>("SAPObjectTaskCode");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectTypeName</b>
     * </p>
     *
     * @return SAP Object Type Name
     */
    @SerializedName( "SAPObjectTypeName" )
    @JsonProperty( "SAPObjectTypeName" )
    @Nullable
    @ODataField( odataName = "SAPObjectTypeName" )
    private String sAPObjectTypeName;
    /**
     * Use with available fluent helpers to apply the <b>SAPObjectTypeName</b> field to query operations.
     *
     */
    public final static SubscriptionReadField<String> SAP_OBJECT_TYPE_NAME =
        new SubscriptionReadField<String>("SAPObjectTypeName");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectTaskTypeName</b>
     * </p>
     *
     * @return Obj Task Type Name
     */
    @SerializedName( "SAPObjectTaskTypeName" )
    @JsonProperty( "SAPObjectTaskTypeName" )
    @Nullable
    @ODataField( odataName = "SAPObjectTaskTypeName" )
    private String sAPObjectTaskTypeName;
    /**
     * Use with available fluent helpers to apply the <b>SAPObjectTaskTypeName</b> field to query operations.
     *
     */
    public final static SubscriptionReadField<String> SAP_OBJECT_TASK_TYPE_NAME =
        new SubscriptionReadField<String>("SAPObjectTaskTypeName");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusEventSubscriptionStateCode</b>
     * </p>
     *
     * @return State
     */
    @SerializedName( "BusEventSubscriptionStateCode" )
    @JsonProperty( "BusEventSubscriptionStateCode" )
    @Nullable
    @ODataField( odataName = "BusEventSubscriptionStateCode" )
    private String busEventSubscriptionStateCode;
    /**
     * Use with available fluent helpers to apply the <b>BusEventSubscriptionStateCode</b> field to query operations.
     *
     */
    public final static SubscriptionReadField<String> BUS_EVENT_SUBSCRIPTION_STATE_CODE =
        new SubscriptionReadField<String>("BusEventSubscriptionStateCode");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>BusEventPriority</b>
     * </p>
     *
     * @return Priority
     */
    @SerializedName( "BusEventPriority" )
    @JsonProperty( "BusEventPriority" )
    @Nullable
    @ODataField( odataName = "BusEventPriority" )
    private Short busEventPriority;
    /**
     * Use with available fluent helpers to apply the <b>BusEventPriority</b> field to query operations.
     *
     */
    public final static SubscriptionReadField<Short> BUS_EVENT_PRIORITY =
        new SubscriptionReadField<Short>("BusEventPriority");
    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>BusinessEventSubscriberName</b>
     * </p>
     *
     * @return Subscriber Name
     */
    @SerializedName( "BusinessEventSubscriberName" )
    @JsonProperty( "BusinessEventSubscriberName" )
    @Nullable
    @ODataField( odataName = "BusinessEventSubscriberName" )
    private String businessEventSubscriberName;
    /**
     * Use with available fluent helpers to apply the <b>BusinessEventSubscriberName</b> field to query operations.
     *
     */
    public final static SubscriptionReadField<String> BUSINESS_EVENT_SUBSCRIBER_NAME =
        new SubscriptionReadField<String>("BusinessEventSubscriberName");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationUTCDateTime</b>
     * </p>
     *
     * @return Time Stamp
     */
    @SerializedName( "CreationUTCDateTime" )
    @JsonProperty( "CreationUTCDateTime" )
    @Nullable
    @ODataField( odataName = "CreationUTCDateTime" )
    private BigDecimal creationUTCDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationUTCDateTime</b> field to query operations.
     *
     */
    public final static SubscriptionReadField<BigDecimal> CREATION_UTC_DATE_TIME =
        new SubscriptionReadField<BigDecimal>("CreationUTCDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUserName</b>
     * </p>
     *
     * @return Description
     */
    @SerializedName( "CreatedByUserName" )
    @JsonProperty( "CreatedByUserName" )
    @Nullable
    @ODataField( odataName = "CreatedByUserName" )
    private String createdByUserName;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUserName</b> field to query operations.
     *
     */
    public final static SubscriptionReadField<String> CREATED_BY_USER_NAME =
        new SubscriptionReadField<String>("CreatedByUserName");

    @Nonnull
    @Override
    public Class<SubscriptionRead> getType()
    {
        return SubscriptionRead.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusEventSubscriberCode</b>
     * </p>
     *
     * @param busEventSubscriberCode
     *            Subscriber ID
     */
    public void setBusEventSubscriberCode( @Nullable final String busEventSubscriberCode )
    {
        rememberChangedField("BusEventSubscriberCode", this.busEventSubscriberCode);
        this.busEventSubscriberCode = busEventSubscriberCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectType</b>
     * </p>
     *
     * @param sAPObjectType
     *            SAP Object Type
     */
    public void setSAPObjectType( @Nullable final String sAPObjectType )
    {
        rememberChangedField("SAPObjectType", this.sAPObjectType);
        this.sAPObjectType = sAPObjectType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectTaskCode</b>
     * </p>
     *
     * @param sAPObjectTaskCode
     *            SAP Object Task Code
     */
    public void setSAPObjectTaskCode( @Nullable final String sAPObjectTaskCode )
    {
        rememberChangedField("SAPObjectTaskCode", this.sAPObjectTaskCode);
        this.sAPObjectTaskCode = sAPObjectTaskCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectTypeName</b>
     * </p>
     *
     * @param sAPObjectTypeName
     *            SAP Object Type Name
     */
    public void setSAPObjectTypeName( @Nullable final String sAPObjectTypeName )
    {
        rememberChangedField("SAPObjectTypeName", this.sAPObjectTypeName);
        this.sAPObjectTypeName = sAPObjectTypeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>SAPObjectTaskTypeName</b>
     * </p>
     *
     * @param sAPObjectTaskTypeName
     *            Obj Task Type Name
     */
    public void setSAPObjectTaskTypeName( @Nullable final String sAPObjectTaskTypeName )
    {
        rememberChangedField("SAPObjectTaskTypeName", this.sAPObjectTaskTypeName);
        this.sAPObjectTaskTypeName = sAPObjectTaskTypeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusEventSubscriptionStateCode</b>
     * </p>
     *
     * @param busEventSubscriptionStateCode
     *            State
     */
    public void setBusEventSubscriptionStateCode( @Nullable final String busEventSubscriptionStateCode )
    {
        rememberChangedField("BusEventSubscriptionStateCode", this.busEventSubscriptionStateCode);
        this.busEventSubscriptionStateCode = busEventSubscriptionStateCode;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>BusEventPriority</b>
     * </p>
     *
     * @param busEventPriority
     *            Priority
     */
    public void setBusEventPriority( @Nullable final Short busEventPriority )
    {
        rememberChangedField("BusEventPriority", this.busEventPriority);
        this.busEventPriority = busEventPriority;
    }

    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>BusinessEventSubscriberName</b>
     * </p>
     *
     * @param businessEventSubscriberName
     *            Subscriber Name
     */
    public void setBusinessEventSubscriberName( @Nullable final String businessEventSubscriberName )
    {
        rememberChangedField("BusinessEventSubscriberName", this.businessEventSubscriberName);
        this.businessEventSubscriberName = businessEventSubscriberName;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationUTCDateTime</b>
     * </p>
     *
     * @param creationUTCDateTime
     *            Time Stamp
     */
    public void setCreationUTCDateTime( @Nullable final BigDecimal creationUTCDateTime )
    {
        rememberChangedField("CreationUTCDateTime", this.creationUTCDateTime);
        this.creationUTCDateTime = creationUTCDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUserName</b>
     * </p>
     *
     * @param createdByUserName
     *            Description
     */
    public void setCreatedByUserName( @Nullable final String createdByUserName )
    {
        rememberChangedField("CreatedByUserName", this.createdByUserName);
        this.createdByUserName = createdByUserName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SubscriptionRead";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BusEventSubscriberCode", getBusEventSubscriberCode());
        result.put("SAPObjectType", getSAPObjectType());
        result.put("SAPObjectTaskCode", getSAPObjectTaskCode());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BusEventSubscriberCode", getBusEventSubscriberCode());
        values.put("SAPObjectType", getSAPObjectType());
        values.put("SAPObjectTaskCode", getSAPObjectTaskCode());
        values.put("SAPObjectTypeName", getSAPObjectTypeName());
        values.put("SAPObjectTaskTypeName", getSAPObjectTaskTypeName());
        values.put("BusEventSubscriptionStateCode", getBusEventSubscriptionStateCode());
        values.put("BusEventPriority", getBusEventPriority());
        values.put("BusinessEventSubscriberName", getBusinessEventSubscriberName());
        values.put("CreationUTCDateTime", getCreationUTCDateTime());
        values.put("CreatedByUserName", getCreatedByUserName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BusEventSubscriberCode") ) {
                final Object value = values.remove("BusEventSubscriberCode");
                if( (value == null) || (!value.equals(getBusEventSubscriberCode())) ) {
                    setBusEventSubscriberCode(((String) value));
                }
            }
            if( values.containsKey("SAPObjectType") ) {
                final Object value = values.remove("SAPObjectType");
                if( (value == null) || (!value.equals(getSAPObjectType())) ) {
                    setSAPObjectType(((String) value));
                }
            }
            if( values.containsKey("SAPObjectTaskCode") ) {
                final Object value = values.remove("SAPObjectTaskCode");
                if( (value == null) || (!value.equals(getSAPObjectTaskCode())) ) {
                    setSAPObjectTaskCode(((String) value));
                }
            }
            if( values.containsKey("SAPObjectTypeName") ) {
                final Object value = values.remove("SAPObjectTypeName");
                if( (value == null) || (!value.equals(getSAPObjectTypeName())) ) {
                    setSAPObjectTypeName(((String) value));
                }
            }
            if( values.containsKey("SAPObjectTaskTypeName") ) {
                final Object value = values.remove("SAPObjectTaskTypeName");
                if( (value == null) || (!value.equals(getSAPObjectTaskTypeName())) ) {
                    setSAPObjectTaskTypeName(((String) value));
                }
            }
            if( values.containsKey("BusEventSubscriptionStateCode") ) {
                final Object value = values.remove("BusEventSubscriptionStateCode");
                if( (value == null) || (!value.equals(getBusEventSubscriptionStateCode())) ) {
                    setBusEventSubscriptionStateCode(((String) value));
                }
            }
            if( values.containsKey("BusEventPriority") ) {
                final Object value = values.remove("BusEventPriority");
                if( (value == null) || (!value.equals(getBusEventPriority())) ) {
                    setBusEventPriority(((Short) value));
                }
            }
            if( values.containsKey("BusinessEventSubscriberName") ) {
                final Object value = values.remove("BusinessEventSubscriberName");
                if( (value == null) || (!value.equals(getBusinessEventSubscriberName())) ) {
                    setBusinessEventSubscriberName(((String) value));
                }
            }
            if( values.containsKey("CreationUTCDateTime") ) {
                final Object value = values.remove("CreationUTCDateTime");
                if( (value == null) || (!value.equals(getCreationUTCDateTime())) ) {
                    setCreationUTCDateTime(((BigDecimal) value));
                }
            }
            if( values.containsKey("CreatedByUserName") ) {
                final Object value = values.remove("CreatedByUserName");
                if( (value == null) || (!value.equals(getCreatedByUserName())) ) {
                    setCreatedByUserName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SubscriptionReadField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SubscriptionReadField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SubscriptionReadField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SubscriptionReadField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessEventSubscriptionService.DEFAULT_SERVICE_PATH);
    }

}
