/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.selectable.SubscriptionReadSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionRead
 * SubscriptionRead} entity using key fields. This fluent helper allows methods which modify the underlying query to be
 * called before executing the query itself.
 *
 */
public class SubscriptionReadByKeyFluentHelper
    extends
    FluentHelperByKey<SubscriptionReadByKeyFluentHelper, SubscriptionRead, SubscriptionReadSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionRead
     * SubscriptionRead} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SubscriptionRead}
     * @param busEventSubscriberCode
     *            Subscriber ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param sAPObjectTaskCode
     *            SAP Object Task Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code SubscriptionRead}
     * @param sAPObjectType
     *            SAP Object Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     */
    public SubscriptionReadByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String busEventSubscriberCode,
        final String sAPObjectType,
        final String sAPObjectTaskCode )
    {
        super(servicePath, entityCollection);
        this.key.put("BusEventSubscriberCode", busEventSubscriberCode);
        this.key.put("SAPObjectType", sAPObjectType);
        this.key.put("SAPObjectTaskCode", sAPObjectTaskCode);
    }

    @Override
    @Nonnull
    protected Class<SubscriptionRead> getEntityClass()
    {
        return SubscriptionRead.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
