/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionMaintain;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessEventSubscriptionService
 * BusinessEventSubscriptionService}.
 *
 */
public interface BusinessEventSubscriptionServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<BusinessEventSubscriptionServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<BusinessEventSubscriptionServiceBatch>
{

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionMaintain
     * SubscriptionMaintain} entity and save it to the S/4HANA system.
     *
     * @param subscriptionMaintain
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionMaintain
     *            SubscriptionMaintain} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessEventSubscriptionServiceBatchChangeSet
        createSubscriptionMaintain( @Nonnull final SubscriptionMaintain subscriptionMaintain );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionMaintain
     * SubscriptionMaintain} entity and save it to the S/4HANA system.
     *
     * @param subscriptionMaintain
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionMaintain
     *            SubscriptionMaintain} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessEventSubscriptionServiceBatchChangeSet
        updateSubscriptionMaintain( @Nonnull final SubscriptionMaintain subscriptionMaintain );

}
