/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionMaintain;

/**
 * Implementation of the {@link BusinessEventSubscriptionServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessEventSubscriptionService
 * BusinessEventSubscriptionService}.
 *
 */
public class DefaultBusinessEventSubscriptionServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<BusinessEventSubscriptionServiceBatch, BusinessEventSubscriptionServiceBatchChangeSet>
    implements
    BusinessEventSubscriptionServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessEventSubscriptionService service;

    @SuppressWarnings( "deprecation" )
    DefaultBusinessEventSubscriptionServiceBatchChangeSet(
        @Nonnull final DefaultBusinessEventSubscriptionServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessEventSubscriptionService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultBusinessEventSubscriptionServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public BusinessEventSubscriptionServiceBatchChangeSet createSubscriptionMaintain(
        @Nonnull final SubscriptionMaintain subscriptionMaintain )
    {
        return addRequestCreate(service::createSubscriptionMaintain, subscriptionMaintain);
    }

    @Nonnull
    @Override
    public BusinessEventSubscriptionServiceBatchChangeSet updateSubscriptionMaintain(
        @Nonnull final SubscriptionMaintain subscriptionMaintain )
    {
        return addRequestUpdate(service::updateSubscriptionMaintain, subscriptionMaintain);
    }

}
