/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionMaintain;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionMaintain
 * SubscriptionMaintain}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.field.SubscriptionMaintainField
 * SubscriptionMaintainField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.link.SubscriptionMaintainLink
 * SubscriptionMaintainLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionMaintain#BUS_EVENT_SUBSCRIBER_CODE
 * BUS_EVENT_SUBSCRIBER_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionMaintain#SAP_OBJECT_TYPE
 * SAP_OBJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionMaintain#SAP_OBJECT_TASK_CODE
 * SAP_OBJECT_TASK_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionMaintain#BUS_EVENT_SUBSCRIPTION_STATE_CODE
 * BUS_EVENT_SUBSCRIPTION_STATE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionMaintain#BUS_EVENT_PRIORITY
 * BUS_EVENT_PRIORITY}</li>
 * </ul>
 *
 */
public interface SubscriptionMaintainSelectable extends EntitySelectable<SubscriptionMaintain>
{

}
