/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionRead;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionRead
 * SubscriptionRead}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.field.SubscriptionReadField
 * SubscriptionReadField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.link.SubscriptionReadLink
 * SubscriptionReadLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionRead#BUS_EVENT_SUBSCRIBER_CODE
 * BUS_EVENT_SUBSCRIBER_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionRead#SAP_OBJECT_TYPE
 * SAP_OBJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionRead#SAP_OBJECT_TASK_CODE
 * SAP_OBJECT_TASK_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionRead#SAP_OBJECT_TYPE_NAME
 * SAP_OBJECT_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionRead#SAP_OBJECT_TASK_TYPE_NAME
 * SAP_OBJECT_TASK_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionRead#BUS_EVENT_SUBSCRIPTION_STATE_CODE
 * BUS_EVENT_SUBSCRIPTION_STATE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionRead#BUS_EVENT_PRIORITY
 * BUS_EVENT_PRIORITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionRead#BUSINESS_EVENT_SUBSCRIBER_NAME
 * BUSINESS_EVENT_SUBSCRIBER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionRead#CREATION_UTC_DATE_TIME
 * CREATION_UTC_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesseventsubscription.SubscriptionRead#CREATED_BY_USER_NAME
 * CREATED_BY_USER_NAME}</li>
 * </ul>
 *
 */
public interface SubscriptionReadSelectable extends EntitySelectable<SubscriptionRead>
{

}
