/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.field.AddressFaxNumberField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.selectable.AddressFaxNumberSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Fax Number
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_AddressFaxNumberType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class AddressFaxNumber extends VdmEntity<AddressFaxNumber>
{

    /**
     * Selector for all available fields of AddressFaxNumber.
     *
     */
    public final static AddressFaxNumberSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AddressID</b>
     * </p>
     *
     * @return Address Number
     */
    @Key
    @SerializedName( "AddressID" )
    @JsonProperty( "AddressID" )
    @Nullable
    @ODataField( odataName = "AddressID" )
    private String addressID;
    /**
     * Use with available fluent helpers to apply the <b>AddressID</b> field to query operations.
     *
     */
    public final static AddressFaxNumberField<String> ADDRESS_ID = new AddressFaxNumberField<String>("AddressID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Person</b>
     * </p>
     *
     * @return Person Number
     */
    @Key
    @SerializedName( "Person" )
    @JsonProperty( "Person" )
    @Nullable
    @ODataField( odataName = "Person" )
    private String person;
    /**
     * Use with available fluent helpers to apply the <b>Person</b> field to query operations.
     *
     */
    public final static AddressFaxNumberField<String> PERSON = new AddressFaxNumberField<String>("Person");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrdinalNumber</b>
     * </p>
     *
     * @return Sequence Number
     */
    @Key
    @SerializedName( "OrdinalNumber" )
    @JsonProperty( "OrdinalNumber" )
    @Nullable
    @ODataField( odataName = "OrdinalNumber" )
    private String ordinalNumber;
    /**
     * Use with available fluent helpers to apply the <b>OrdinalNumber</b> field to query operations.
     *
     */
    public final static AddressFaxNumberField<String> ORDINAL_NUMBER =
        new AddressFaxNumberField<String>("OrdinalNumber");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDefaultFaxNumber</b>
     * </p>
     *
     * @return Standard Sender Address in this Communication Type
     */
    @SerializedName( "IsDefaultFaxNumber" )
    @JsonProperty( "IsDefaultFaxNumber" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsDefaultFaxNumber" )
    private Boolean isDefaultFaxNumber;
    /**
     * Use with available fluent helpers to apply the <b>IsDefaultFaxNumber</b> field to query operations.
     *
     */
    public final static AddressFaxNumberField<Boolean> IS_DEFAULT_FAX_NUMBER =
        new AddressFaxNumberField<Boolean>("IsDefaultFaxNumber");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FaxCountry</b>
     * </p>
     *
     * @return Country/Region for Telephone/Fax Number
     */
    @SerializedName( "FaxCountry" )
    @JsonProperty( "FaxCountry" )
    @Nullable
    @ODataField( odataName = "FaxCountry" )
    private String faxCountry;
    /**
     * Use with available fluent helpers to apply the <b>FaxCountry</b> field to query operations.
     *
     */
    public final static AddressFaxNumberField<String> FAX_COUNTRY = new AddressFaxNumberField<String>("FaxCountry");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FaxNumber</b>
     * </p>
     *
     * @return Fax Number: Dialing Code+Number
     */
    @SerializedName( "FaxNumber" )
    @JsonProperty( "FaxNumber" )
    @Nullable
    @ODataField( odataName = "FaxNumber" )
    private String faxNumber;
    /**
     * Use with available fluent helpers to apply the <b>FaxNumber</b> field to query operations.
     *
     */
    public final static AddressFaxNumberField<String> FAX_NUMBER = new AddressFaxNumberField<String>("FaxNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FaxNumberExtension</b>
     * </p>
     *
     * @return Fax no.: Extension
     */
    @SerializedName( "FaxNumberExtension" )
    @JsonProperty( "FaxNumberExtension" )
    @Nullable
    @ODataField( odataName = "FaxNumberExtension" )
    private String faxNumberExtension;
    /**
     * Use with available fluent helpers to apply the <b>FaxNumberExtension</b> field to query operations.
     *
     */
    public final static AddressFaxNumberField<String> FAX_NUMBER_EXTENSION =
        new AddressFaxNumberField<String>("FaxNumberExtension");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>InternationalFaxNumber</b>
     * </p>
     *
     * @return Complete Number: Dialing Code+Number+Extension
     */
    @SerializedName( "InternationalFaxNumber" )
    @JsonProperty( "InternationalFaxNumber" )
    @Nullable
    @ODataField( odataName = "InternationalFaxNumber" )
    private String internationalFaxNumber;
    /**
     * Use with available fluent helpers to apply the <b>InternationalFaxNumber</b> field to query operations.
     *
     */
    public final static AddressFaxNumberField<String> INTERNATIONAL_FAX_NUMBER =
        new AddressFaxNumberField<String>("InternationalFaxNumber");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>AddressCommunicationRemarkText</b>
     * </p>
     *
     * @return Communication link notes
     */
    @SerializedName( "AddressCommunicationRemarkText" )
    @JsonProperty( "AddressCommunicationRemarkText" )
    @Nullable
    @ODataField( odataName = "AddressCommunicationRemarkText" )
    private String addressCommunicationRemarkText;
    /**
     * Use with available fluent helpers to apply the <b>AddressCommunicationRemarkText</b> field to query operations.
     *
     */
    public final static AddressFaxNumberField<String> ADDRESS_COMMUNICATION_REMARK_TEXT =
        new AddressFaxNumberField<String>("AddressCommunicationRemarkText");

    @Nonnull
    @Override
    public Class<AddressFaxNumber> getType()
    {
        return AddressFaxNumber.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AddressID</b>
     * </p>
     *
     * @param addressID
     *            Address Number
     */
    public void setAddressID( @Nullable final String addressID )
    {
        rememberChangedField("AddressID", this.addressID);
        this.addressID = addressID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Person</b>
     * </p>
     *
     * @param person
     *            Person Number
     */
    public void setPerson( @Nullable final String person )
    {
        rememberChangedField("Person", this.person);
        this.person = person;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrdinalNumber</b>
     * </p>
     *
     * @param ordinalNumber
     *            Sequence Number
     */
    public void setOrdinalNumber( @Nullable final String ordinalNumber )
    {
        rememberChangedField("OrdinalNumber", this.ordinalNumber);
        this.ordinalNumber = ordinalNumber;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDefaultFaxNumber</b>
     * </p>
     *
     * @param isDefaultFaxNumber
     *            Standard Sender Address in this Communication Type
     */
    public void setIsDefaultFaxNumber( @Nullable final Boolean isDefaultFaxNumber )
    {
        rememberChangedField("IsDefaultFaxNumber", this.isDefaultFaxNumber);
        this.isDefaultFaxNumber = isDefaultFaxNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FaxCountry</b>
     * </p>
     *
     * @param faxCountry
     *            Country/Region for Telephone/Fax Number
     */
    public void setFaxCountry( @Nullable final String faxCountry )
    {
        rememberChangedField("FaxCountry", this.faxCountry);
        this.faxCountry = faxCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FaxNumber</b>
     * </p>
     *
     * @param faxNumber
     *            Fax Number: Dialing Code+Number
     */
    public void setFaxNumber( @Nullable final String faxNumber )
    {
        rememberChangedField("FaxNumber", this.faxNumber);
        this.faxNumber = faxNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FaxNumberExtension</b>
     * </p>
     *
     * @param faxNumberExtension
     *            Fax no.: Extension
     */
    public void setFaxNumberExtension( @Nullable final String faxNumberExtension )
    {
        rememberChangedField("FaxNumberExtension", this.faxNumberExtension);
        this.faxNumberExtension = faxNumberExtension;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>InternationalFaxNumber</b>
     * </p>
     *
     * @param internationalFaxNumber
     *            Complete Number: Dialing Code+Number+Extension
     */
    public void setInternationalFaxNumber( @Nullable final String internationalFaxNumber )
    {
        rememberChangedField("InternationalFaxNumber", this.internationalFaxNumber);
        this.internationalFaxNumber = internationalFaxNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>AddressCommunicationRemarkText</b>
     * </p>
     *
     * @param addressCommunicationRemarkText
     *            Communication link notes
     */
    public void setAddressCommunicationRemarkText( @Nullable final String addressCommunicationRemarkText )
    {
        rememberChangedField("AddressCommunicationRemarkText", this.addressCommunicationRemarkText);
        this.addressCommunicationRemarkText = addressCommunicationRemarkText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_AddressFaxNumber";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("AddressID", getAddressID());
        result.put("Person", getPerson());
        result.put("OrdinalNumber", getOrdinalNumber());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("AddressID", getAddressID());
        values.put("Person", getPerson());
        values.put("OrdinalNumber", getOrdinalNumber());
        values.put("IsDefaultFaxNumber", getIsDefaultFaxNumber());
        values.put("FaxCountry", getFaxCountry());
        values.put("FaxNumber", getFaxNumber());
        values.put("FaxNumberExtension", getFaxNumberExtension());
        values.put("InternationalFaxNumber", getInternationalFaxNumber());
        values.put("AddressCommunicationRemarkText", getAddressCommunicationRemarkText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("AddressID") ) {
                final Object value = values.remove("AddressID");
                if( (value == null) || (!value.equals(getAddressID())) ) {
                    setAddressID(((String) value));
                }
            }
            if( values.containsKey("Person") ) {
                final Object value = values.remove("Person");
                if( (value == null) || (!value.equals(getPerson())) ) {
                    setPerson(((String) value));
                }
            }
            if( values.containsKey("OrdinalNumber") ) {
                final Object value = values.remove("OrdinalNumber");
                if( (value == null) || (!value.equals(getOrdinalNumber())) ) {
                    setOrdinalNumber(((String) value));
                }
            }
            if( values.containsKey("IsDefaultFaxNumber") ) {
                final Object value = values.remove("IsDefaultFaxNumber");
                if( (value == null) || (!value.equals(getIsDefaultFaxNumber())) ) {
                    setIsDefaultFaxNumber(((Boolean) value));
                }
            }
            if( values.containsKey("FaxCountry") ) {
                final Object value = values.remove("FaxCountry");
                if( (value == null) || (!value.equals(getFaxCountry())) ) {
                    setFaxCountry(((String) value));
                }
            }
            if( values.containsKey("FaxNumber") ) {
                final Object value = values.remove("FaxNumber");
                if( (value == null) || (!value.equals(getFaxNumber())) ) {
                    setFaxNumber(((String) value));
                }
            }
            if( values.containsKey("FaxNumberExtension") ) {
                final Object value = values.remove("FaxNumberExtension");
                if( (value == null) || (!value.equals(getFaxNumberExtension())) ) {
                    setFaxNumberExtension(((String) value));
                }
            }
            if( values.containsKey("InternationalFaxNumber") ) {
                final Object value = values.remove("InternationalFaxNumber");
                if( (value == null) || (!value.equals(getInternationalFaxNumber())) ) {
                    setInternationalFaxNumber(((String) value));
                }
            }
            if( values.containsKey("AddressCommunicationRemarkText") ) {
                final Object value = values.remove("AddressCommunicationRemarkText");
                if( (value == null) || (!value.equals(getAddressCommunicationRemarkText())) ) {
                    setAddressCommunicationRemarkText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> AddressFaxNumberField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new AddressFaxNumberField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> AddressFaxNumberField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new AddressFaxNumberField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessPartnerService.DEFAULT_SERVICE_PATH);
    }

}
