/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.field.BPAddrDepdntIntlLocNumberField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.selectable.BPAddrDepdntIntlLocNumberSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Business Partner Address-Dependent ILN
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BPAddrDepdntIntlLocNumberType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BPAddrDepdntIntlLocNumber extends VdmEntity<BPAddrDepdntIntlLocNumber>
{

    /**
     * Selector for all available fields of BPAddrDepdntIntlLocNumber.
     *
     */
    public final static BPAddrDepdntIntlLocNumberSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     *
     * @return Business Partner Number
     */
    @Key
    @SerializedName( "BusinessPartner" )
    @JsonProperty( "BusinessPartner" )
    @Nullable
    @ODataField( odataName = "BusinessPartner" )
    private String businessPartner;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartner</b> field to query operations.
     *
     */
    public final static BPAddrDepdntIntlLocNumberField<String> BUSINESS_PARTNER =
        new BPAddrDepdntIntlLocNumberField<String>("BusinessPartner");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AddressID</b>
     * </p>
     *
     * @return Address Number
     */
    @Key
    @SerializedName( "AddressID" )
    @JsonProperty( "AddressID" )
    @Nullable
    @ODataField( odataName = "AddressID" )
    private String addressID;
    /**
     * Use with available fluent helpers to apply the <b>AddressID</b> field to query operations.
     *
     */
    public final static BPAddrDepdntIntlLocNumberField<String> ADDRESS_ID =
        new BPAddrDepdntIntlLocNumberField<String>("AddressID");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>InternationalLocationNumber1</b>
     * </p>
     *
     * @return International location number (part 1)
     */
    @SerializedName( "InternationalLocationNumber1" )
    @JsonProperty( "InternationalLocationNumber1" )
    @Nullable
    @ODataField( odataName = "InternationalLocationNumber1" )
    private String internationalLocationNumber1;
    /**
     * Use with available fluent helpers to apply the <b>InternationalLocationNumber1</b> field to query operations.
     *
     */
    public final static BPAddrDepdntIntlLocNumberField<String> INTERNATIONAL_LOCATION_NUMBER1 =
        new BPAddrDepdntIntlLocNumberField<String>("InternationalLocationNumber1");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>InternationalLocationNumber2</b>
     * </p>
     *
     * @return International location number (Part 2)
     */
    @SerializedName( "InternationalLocationNumber2" )
    @JsonProperty( "InternationalLocationNumber2" )
    @Nullable
    @ODataField( odataName = "InternationalLocationNumber2" )
    private String internationalLocationNumber2;
    /**
     * Use with available fluent helpers to apply the <b>InternationalLocationNumber2</b> field to query operations.
     *
     */
    public final static BPAddrDepdntIntlLocNumberField<String> INTERNATIONAL_LOCATION_NUMBER2 =
        new BPAddrDepdntIntlLocNumberField<String>("InternationalLocationNumber2");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InternationalLocationNumber3</b>
     * </p>
     *
     * @return Check digit for the international location number
     */
    @SerializedName( "InternationalLocationNumber3" )
    @JsonProperty( "InternationalLocationNumber3" )
    @Nullable
    @ODataField( odataName = "InternationalLocationNumber3" )
    private String internationalLocationNumber3;
    /**
     * Use with available fluent helpers to apply the <b>InternationalLocationNumber3</b> field to query operations.
     *
     */
    public final static BPAddrDepdntIntlLocNumberField<String> INTERNATIONAL_LOCATION_NUMBER3 =
        new BPAddrDepdntIntlLocNumberField<String>("InternationalLocationNumber3");

    @Nonnull
    @Override
    public Class<BPAddrDepdntIntlLocNumber> getType()
    {
        return BPAddrDepdntIntlLocNumber.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     *
     * @param businessPartner
     *            Business Partner Number
     */
    public void setBusinessPartner( @Nullable final String businessPartner )
    {
        rememberChangedField("BusinessPartner", this.businessPartner);
        this.businessPartner = businessPartner;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AddressID</b>
     * </p>
     *
     * @param addressID
     *            Address Number
     */
    public void setAddressID( @Nullable final String addressID )
    {
        rememberChangedField("AddressID", this.addressID);
        this.addressID = addressID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>InternationalLocationNumber1</b>
     * </p>
     *
     * @param internationalLocationNumber1
     *            International location number (part 1)
     */
    public void setInternationalLocationNumber1( @Nullable final String internationalLocationNumber1 )
    {
        rememberChangedField("InternationalLocationNumber1", this.internationalLocationNumber1);
        this.internationalLocationNumber1 = internationalLocationNumber1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>InternationalLocationNumber2</b>
     * </p>
     *
     * @param internationalLocationNumber2
     *            International location number (Part 2)
     */
    public void setInternationalLocationNumber2( @Nullable final String internationalLocationNumber2 )
    {
        rememberChangedField("InternationalLocationNumber2", this.internationalLocationNumber2);
        this.internationalLocationNumber2 = internationalLocationNumber2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InternationalLocationNumber3</b>
     * </p>
     *
     * @param internationalLocationNumber3
     *            Check digit for the international location number
     */
    public void setInternationalLocationNumber3( @Nullable final String internationalLocationNumber3 )
    {
        rememberChangedField("InternationalLocationNumber3", this.internationalLocationNumber3);
        this.internationalLocationNumber3 = internationalLocationNumber3;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BPAddrDepdntIntlLocNumber";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BusinessPartner", getBusinessPartner());
        result.put("AddressID", getAddressID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BusinessPartner", getBusinessPartner());
        values.put("AddressID", getAddressID());
        values.put("InternationalLocationNumber1", getInternationalLocationNumber1());
        values.put("InternationalLocationNumber2", getInternationalLocationNumber2());
        values.put("InternationalLocationNumber3", getInternationalLocationNumber3());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BusinessPartner") ) {
                final Object value = values.remove("BusinessPartner");
                if( (value == null) || (!value.equals(getBusinessPartner())) ) {
                    setBusinessPartner(((String) value));
                }
            }
            if( values.containsKey("AddressID") ) {
                final Object value = values.remove("AddressID");
                if( (value == null) || (!value.equals(getAddressID())) ) {
                    setAddressID(((String) value));
                }
            }
            if( values.containsKey("InternationalLocationNumber1") ) {
                final Object value = values.remove("InternationalLocationNumber1");
                if( (value == null) || (!value.equals(getInternationalLocationNumber1())) ) {
                    setInternationalLocationNumber1(((String) value));
                }
            }
            if( values.containsKey("InternationalLocationNumber2") ) {
                final Object value = values.remove("InternationalLocationNumber2");
                if( (value == null) || (!value.equals(getInternationalLocationNumber2())) ) {
                    setInternationalLocationNumber2(((String) value));
                }
            }
            if( values.containsKey("InternationalLocationNumber3") ) {
                final Object value = values.remove("InternationalLocationNumber3");
                if( (value == null) || (!value.equals(getInternationalLocationNumber3())) ) {
                    setInternationalLocationNumber3(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BPAddrDepdntIntlLocNumberField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BPAddrDepdntIntlLocNumberField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BPAddrDepdntIntlLocNumberField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BPAddrDepdntIntlLocNumberField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessPartnerService.DEFAULT_SERVICE_PATH);
    }

}
