/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.field.BPCreditWorthinessField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.selectable.BPCreditWorthinessSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Credit Worthiness
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BPCreditWorthinessType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BPCreditWorthiness extends VdmEntity<BPCreditWorthiness>
{

    /**
     * Selector for all available fields of BPCreditWorthiness.
     *
     */
    public final static BPCreditWorthinessSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     *
     * @return Business Partner Number
     */
    @Key
    @SerializedName( "BusinessPartner" )
    @JsonProperty( "BusinessPartner" )
    @Nullable
    @ODataField( odataName = "BusinessPartner" )
    private String businessPartner;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartner</b> field to query operations.
     *
     */
    public final static BPCreditWorthinessField<String> BUSINESS_PARTNER =
        new BPCreditWorthinessField<String>("BusinessPartner");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusPartCreditStanding</b>
     * </p>
     *
     * @return Credit Standing
     */
    @SerializedName( "BusPartCreditStanding" )
    @JsonProperty( "BusPartCreditStanding" )
    @Nullable
    @ODataField( odataName = "BusPartCreditStanding" )
    private String busPartCreditStanding;
    /**
     * Use with available fluent helpers to apply the <b>BusPartCreditStanding</b> field to query operations.
     *
     */
    public final static BPCreditWorthinessField<String> BUS_PART_CREDIT_STANDING =
        new BPCreditWorthinessField<String>("BusPartCreditStanding");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BPCreditStandingStatus</b>
     * </p>
     *
     * @return Status of Credit Standing Information
     */
    @SerializedName( "BPCreditStandingStatus" )
    @JsonProperty( "BPCreditStandingStatus" )
    @Nullable
    @ODataField( odataName = "BPCreditStandingStatus" )
    private String bPCreditStandingStatus;
    /**
     * Use with available fluent helpers to apply the <b>BPCreditStandingStatus</b> field to query operations.
     *
     */
    public final static BPCreditWorthinessField<String> BP_CREDIT_STANDING_STATUS =
        new BPCreditWorthinessField<String>("BPCreditStandingStatus");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CreditRatingAgency</b>
     * </p>
     *
     * @return Institute Providing Credit Standing Information
     */
    @SerializedName( "CreditRatingAgency" )
    @JsonProperty( "CreditRatingAgency" )
    @Nullable
    @ODataField( odataName = "CreditRatingAgency" )
    private String creditRatingAgency;
    /**
     * Use with available fluent helpers to apply the <b>CreditRatingAgency</b> field to query operations.
     *
     */
    public final static BPCreditWorthinessField<String> CREDIT_RATING_AGENCY =
        new BPCreditWorthinessField<String>("CreditRatingAgency");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>BPCreditStandingComment</b>
     * </p>
     *
     * @return Additional Credit Standing Information
     */
    @SerializedName( "BPCreditStandingComment" )
    @JsonProperty( "BPCreditStandingComment" )
    @Nullable
    @ODataField( odataName = "BPCreditStandingComment" )
    private String bPCreditStandingComment;
    /**
     * Use with available fluent helpers to apply the <b>BPCreditStandingComment</b> field to query operations.
     *
     */
    public final static BPCreditWorthinessField<String> BP_CREDIT_STANDING_COMMENT =
        new BPCreditWorthinessField<String>("BPCreditStandingComment");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BPCreditStandingDate</b>
     * </p>
     *
     * @return Date of Credit Standing Information
     */
    @SerializedName( "BPCreditStandingDate" )
    @JsonProperty( "BPCreditStandingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BPCreditStandingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime bPCreditStandingDate;
    /**
     * Use with available fluent helpers to apply the <b>BPCreditStandingDate</b> field to query operations.
     *
     */
    public final static BPCreditWorthinessField<LocalDateTime> BP_CREDIT_STANDING_DATE =
        new BPCreditWorthinessField<LocalDateTime>("BPCreditStandingDate");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPCreditStandingRating</b>
     * </p>
     *
     * @return Rating
     */
    @SerializedName( "BPCreditStandingRating" )
    @JsonProperty( "BPCreditStandingRating" )
    @Nullable
    @ODataField( odataName = "BPCreditStandingRating" )
    private String bPCreditStandingRating;
    /**
     * Use with available fluent helpers to apply the <b>BPCreditStandingRating</b> field to query operations.
     *
     */
    public final static BPCreditWorthinessField<String> BP_CREDIT_STANDING_RATING =
        new BPCreditWorthinessField<String>("BPCreditStandingRating");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BPLegalProceedingStatus</b>
     * </p>
     *
     * @return Status of Legal Proceedings
     */
    @SerializedName( "BPLegalProceedingStatus" )
    @JsonProperty( "BPLegalProceedingStatus" )
    @Nullable
    @ODataField( odataName = "BPLegalProceedingStatus" )
    private String bPLegalProceedingStatus;
    /**
     * Use with available fluent helpers to apply the <b>BPLegalProceedingStatus</b> field to query operations.
     *
     */
    public final static BPCreditWorthinessField<String> BP_LEGAL_PROCEEDING_STATUS =
        new BPCreditWorthinessField<String>("BPLegalProceedingStatus");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BPLglProceedingInitiationDate</b>
     * </p>
     *
     * @return Date of Initiation of Legal Proceedings
     */
    @SerializedName( "BPLglProceedingInitiationDate" )
    @JsonProperty( "BPLglProceedingInitiationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BPLglProceedingInitiationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime bPLglProceedingInitiationDate;
    /**
     * Use with available fluent helpers to apply the <b>BPLglProceedingInitiationDate</b> field to query operations.
     *
     */
    public final static BPCreditWorthinessField<LocalDateTime> BP_LGL_PROCEEDING_INITIATION_DATE =
        new BPCreditWorthinessField<LocalDateTime>("BPLglProceedingInitiationDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerIsUnderOath</b>
     * </p>
     *
     * @return Affidavit
     */
    @SerializedName( "BusinessPartnerIsUnderOath" )
    @JsonProperty( "BusinessPartnerIsUnderOath" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BusinessPartnerIsUnderOath" )
    private Boolean businessPartnerIsUnderOath;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerIsUnderOath</b> field to query operations.
     *
     */
    public final static BPCreditWorthinessField<Boolean> BUSINESS_PARTNER_IS_UNDER_OATH =
        new BPCreditWorthinessField<Boolean>("BusinessPartnerIsUnderOath");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerOathDate</b>
     * </p>
     *
     * @return Date of affidavit
     */
    @SerializedName( "BusinessPartnerOathDate" )
    @JsonProperty( "BusinessPartnerOathDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BusinessPartnerOathDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime businessPartnerOathDate;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerOathDate</b> field to query operations.
     *
     */
    public final static BPCreditWorthinessField<LocalDateTime> BUSINESS_PARTNER_OATH_DATE =
        new BPCreditWorthinessField<LocalDateTime>("BusinessPartnerOathDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerIsBankrupt</b>
     * </p>
     *
     * @return Launch Bankruptcy Proceedings
     */
    @SerializedName( "BusinessPartnerIsBankrupt" )
    @JsonProperty( "BusinessPartnerIsBankrupt" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BusinessPartnerIsBankrupt" )
    private Boolean businessPartnerIsBankrupt;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerIsBankrupt</b> field to query operations.
     *
     */
    public final static BPCreditWorthinessField<Boolean> BUSINESS_PARTNER_IS_BANKRUPT =
        new BPCreditWorthinessField<Boolean>("BusinessPartnerIsBankrupt");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerBankruptcyDate</b>
     * </p>
     *
     * @return Commencement Date of Bankruptcy Proceedings
     */
    @SerializedName( "BusinessPartnerBankruptcyDate" )
    @JsonProperty( "BusinessPartnerBankruptcyDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BusinessPartnerBankruptcyDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime businessPartnerBankruptcyDate;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerBankruptcyDate</b> field to query operations.
     *
     */
    public final static BPCreditWorthinessField<LocalDateTime> BUSINESS_PARTNER_BANKRUPTCY_DATE =
        new BPCreditWorthinessField<LocalDateTime>("BusinessPartnerBankruptcyDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BPForeclosureIsInitiated</b>
     * </p>
     *
     * @return Foreclosure
     */
    @SerializedName( "BPForeclosureIsInitiated" )
    @JsonProperty( "BPForeclosureIsInitiated" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BPForeclosureIsInitiated" )
    private Boolean bPForeclosureIsInitiated;
    /**
     * Use with available fluent helpers to apply the <b>BPForeclosureIsInitiated</b> field to query operations.
     *
     */
    public final static BPCreditWorthinessField<Boolean> BP_FORECLOSURE_IS_INITIATED =
        new BPCreditWorthinessField<Boolean>("BPForeclosureIsInitiated");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BPForeclosureDate</b>
     * </p>
     *
     * @return Date of foreclosure
     */
    @SerializedName( "BPForeclosureDate" )
    @JsonProperty( "BPForeclosureDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BPForeclosureDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime bPForeclosureDate;
    /**
     * Use with available fluent helpers to apply the <b>BPForeclosureDate</b> field to query operations.
     *
     */
    public final static BPCreditWorthinessField<LocalDateTime> BP_FORECLOSURE_DATE =
        new BPCreditWorthinessField<LocalDateTime>("BPForeclosureDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BPCrdtWrthnssAccessChkIsActive</b>
     * </p>
     *
     * @return The bPCrdtWrthnssAccessChkIsActive contained in this entity.
     */
    @SerializedName( "BPCrdtWrthnssAccessChkIsActive" )
    @JsonProperty( "BPCrdtWrthnssAccessChkIsActive" )
    @Nullable
    @ODataField( odataName = "BPCrdtWrthnssAccessChkIsActive" )
    private String bPCrdtWrthnssAccessChkIsActive;
    /**
     * Use with available fluent helpers to apply the <b>BPCrdtWrthnssAccessChkIsActive</b> field to query operations.
     *
     */
    public final static BPCreditWorthinessField<String> BP_CRDT_WRTHNSS_ACCESS_CHK_IS_ACTIVE =
        new BPCreditWorthinessField<String>("BPCrdtWrthnssAccessChkIsActive");

    @Nonnull
    @Override
    public Class<BPCreditWorthiness> getType()
    {
        return BPCreditWorthiness.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     *
     * @param businessPartner
     *            Business Partner Number
     */
    public void setBusinessPartner( @Nullable final String businessPartner )
    {
        rememberChangedField("BusinessPartner", this.businessPartner);
        this.businessPartner = businessPartner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusPartCreditStanding</b>
     * </p>
     *
     * @param busPartCreditStanding
     *            Credit Standing
     */
    public void setBusPartCreditStanding( @Nullable final String busPartCreditStanding )
    {
        rememberChangedField("BusPartCreditStanding", this.busPartCreditStanding);
        this.busPartCreditStanding = busPartCreditStanding;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BPCreditStandingStatus</b>
     * </p>
     *
     * @param bPCreditStandingStatus
     *            Status of Credit Standing Information
     */
    public void setBPCreditStandingStatus( @Nullable final String bPCreditStandingStatus )
    {
        rememberChangedField("BPCreditStandingStatus", this.bPCreditStandingStatus);
        this.bPCreditStandingStatus = bPCreditStandingStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CreditRatingAgency</b>
     * </p>
     *
     * @param creditRatingAgency
     *            Institute Providing Credit Standing Information
     */
    public void setCreditRatingAgency( @Nullable final String creditRatingAgency )
    {
        rememberChangedField("CreditRatingAgency", this.creditRatingAgency);
        this.creditRatingAgency = creditRatingAgency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>BPCreditStandingComment</b>
     * </p>
     *
     * @param bPCreditStandingComment
     *            Additional Credit Standing Information
     */
    public void setBPCreditStandingComment( @Nullable final String bPCreditStandingComment )
    {
        rememberChangedField("BPCreditStandingComment", this.bPCreditStandingComment);
        this.bPCreditStandingComment = bPCreditStandingComment;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BPCreditStandingDate</b>
     * </p>
     *
     * @param bPCreditStandingDate
     *            Date of Credit Standing Information
     */
    public void setBPCreditStandingDate( @Nullable final LocalDateTime bPCreditStandingDate )
    {
        rememberChangedField("BPCreditStandingDate", this.bPCreditStandingDate);
        this.bPCreditStandingDate = bPCreditStandingDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPCreditStandingRating</b>
     * </p>
     *
     * @param bPCreditStandingRating
     *            Rating
     */
    public void setBPCreditStandingRating( @Nullable final String bPCreditStandingRating )
    {
        rememberChangedField("BPCreditStandingRating", this.bPCreditStandingRating);
        this.bPCreditStandingRating = bPCreditStandingRating;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BPLegalProceedingStatus</b>
     * </p>
     *
     * @param bPLegalProceedingStatus
     *            Status of Legal Proceedings
     */
    public void setBPLegalProceedingStatus( @Nullable final String bPLegalProceedingStatus )
    {
        rememberChangedField("BPLegalProceedingStatus", this.bPLegalProceedingStatus);
        this.bPLegalProceedingStatus = bPLegalProceedingStatus;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BPLglProceedingInitiationDate</b>
     * </p>
     *
     * @param bPLglProceedingInitiationDate
     *            Date of Initiation of Legal Proceedings
     */
    public void setBPLglProceedingInitiationDate( @Nullable final LocalDateTime bPLglProceedingInitiationDate )
    {
        rememberChangedField("BPLglProceedingInitiationDate", this.bPLglProceedingInitiationDate);
        this.bPLglProceedingInitiationDate = bPLglProceedingInitiationDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerIsUnderOath</b>
     * </p>
     *
     * @param businessPartnerIsUnderOath
     *            Affidavit
     */
    public void setBusinessPartnerIsUnderOath( @Nullable final Boolean businessPartnerIsUnderOath )
    {
        rememberChangedField("BusinessPartnerIsUnderOath", this.businessPartnerIsUnderOath);
        this.businessPartnerIsUnderOath = businessPartnerIsUnderOath;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerOathDate</b>
     * </p>
     *
     * @param businessPartnerOathDate
     *            Date of affidavit
     */
    public void setBusinessPartnerOathDate( @Nullable final LocalDateTime businessPartnerOathDate )
    {
        rememberChangedField("BusinessPartnerOathDate", this.businessPartnerOathDate);
        this.businessPartnerOathDate = businessPartnerOathDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerIsBankrupt</b>
     * </p>
     *
     * @param businessPartnerIsBankrupt
     *            Launch Bankruptcy Proceedings
     */
    public void setBusinessPartnerIsBankrupt( @Nullable final Boolean businessPartnerIsBankrupt )
    {
        rememberChangedField("BusinessPartnerIsBankrupt", this.businessPartnerIsBankrupt);
        this.businessPartnerIsBankrupt = businessPartnerIsBankrupt;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerBankruptcyDate</b>
     * </p>
     *
     * @param businessPartnerBankruptcyDate
     *            Commencement Date of Bankruptcy Proceedings
     */
    public void setBusinessPartnerBankruptcyDate( @Nullable final LocalDateTime businessPartnerBankruptcyDate )
    {
        rememberChangedField("BusinessPartnerBankruptcyDate", this.businessPartnerBankruptcyDate);
        this.businessPartnerBankruptcyDate = businessPartnerBankruptcyDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BPForeclosureIsInitiated</b>
     * </p>
     *
     * @param bPForeclosureIsInitiated
     *            Foreclosure
     */
    public void setBPForeclosureIsInitiated( @Nullable final Boolean bPForeclosureIsInitiated )
    {
        rememberChangedField("BPForeclosureIsInitiated", this.bPForeclosureIsInitiated);
        this.bPForeclosureIsInitiated = bPForeclosureIsInitiated;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BPForeclosureDate</b>
     * </p>
     *
     * @param bPForeclosureDate
     *            Date of foreclosure
     */
    public void setBPForeclosureDate( @Nullable final LocalDateTime bPForeclosureDate )
    {
        rememberChangedField("BPForeclosureDate", this.bPForeclosureDate);
        this.bPForeclosureDate = bPForeclosureDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BPCrdtWrthnssAccessChkIsActive</b>
     * </p>
     *
     * @param bPCrdtWrthnssAccessChkIsActive
     *            The bPCrdtWrthnssAccessChkIsActive to set.
     */
    public void setBPCrdtWrthnssAccessChkIsActive( @Nullable final String bPCrdtWrthnssAccessChkIsActive )
    {
        rememberChangedField("BPCrdtWrthnssAccessChkIsActive", this.bPCrdtWrthnssAccessChkIsActive);
        this.bPCrdtWrthnssAccessChkIsActive = bPCrdtWrthnssAccessChkIsActive;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BPCreditWorthiness";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BusinessPartner", getBusinessPartner());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BusinessPartner", getBusinessPartner());
        values.put("BusPartCreditStanding", getBusPartCreditStanding());
        values.put("BPCreditStandingStatus", getBPCreditStandingStatus());
        values.put("CreditRatingAgency", getCreditRatingAgency());
        values.put("BPCreditStandingComment", getBPCreditStandingComment());
        values.put("BPCreditStandingDate", getBPCreditStandingDate());
        values.put("BPCreditStandingRating", getBPCreditStandingRating());
        values.put("BPLegalProceedingStatus", getBPLegalProceedingStatus());
        values.put("BPLglProceedingInitiationDate", getBPLglProceedingInitiationDate());
        values.put("BusinessPartnerIsUnderOath", getBusinessPartnerIsUnderOath());
        values.put("BusinessPartnerOathDate", getBusinessPartnerOathDate());
        values.put("BusinessPartnerIsBankrupt", getBusinessPartnerIsBankrupt());
        values.put("BusinessPartnerBankruptcyDate", getBusinessPartnerBankruptcyDate());
        values.put("BPForeclosureIsInitiated", getBPForeclosureIsInitiated());
        values.put("BPForeclosureDate", getBPForeclosureDate());
        values.put("BPCrdtWrthnssAccessChkIsActive", getBPCrdtWrthnssAccessChkIsActive());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BusinessPartner") ) {
                final Object value = values.remove("BusinessPartner");
                if( (value == null) || (!value.equals(getBusinessPartner())) ) {
                    setBusinessPartner(((String) value));
                }
            }
            if( values.containsKey("BusPartCreditStanding") ) {
                final Object value = values.remove("BusPartCreditStanding");
                if( (value == null) || (!value.equals(getBusPartCreditStanding())) ) {
                    setBusPartCreditStanding(((String) value));
                }
            }
            if( values.containsKey("BPCreditStandingStatus") ) {
                final Object value = values.remove("BPCreditStandingStatus");
                if( (value == null) || (!value.equals(getBPCreditStandingStatus())) ) {
                    setBPCreditStandingStatus(((String) value));
                }
            }
            if( values.containsKey("CreditRatingAgency") ) {
                final Object value = values.remove("CreditRatingAgency");
                if( (value == null) || (!value.equals(getCreditRatingAgency())) ) {
                    setCreditRatingAgency(((String) value));
                }
            }
            if( values.containsKey("BPCreditStandingComment") ) {
                final Object value = values.remove("BPCreditStandingComment");
                if( (value == null) || (!value.equals(getBPCreditStandingComment())) ) {
                    setBPCreditStandingComment(((String) value));
                }
            }
            if( values.containsKey("BPCreditStandingDate") ) {
                final Object value = values.remove("BPCreditStandingDate");
                if( (value == null) || (!value.equals(getBPCreditStandingDate())) ) {
                    setBPCreditStandingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BPCreditStandingRating") ) {
                final Object value = values.remove("BPCreditStandingRating");
                if( (value == null) || (!value.equals(getBPCreditStandingRating())) ) {
                    setBPCreditStandingRating(((String) value));
                }
            }
            if( values.containsKey("BPLegalProceedingStatus") ) {
                final Object value = values.remove("BPLegalProceedingStatus");
                if( (value == null) || (!value.equals(getBPLegalProceedingStatus())) ) {
                    setBPLegalProceedingStatus(((String) value));
                }
            }
            if( values.containsKey("BPLglProceedingInitiationDate") ) {
                final Object value = values.remove("BPLglProceedingInitiationDate");
                if( (value == null) || (!value.equals(getBPLglProceedingInitiationDate())) ) {
                    setBPLglProceedingInitiationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BusinessPartnerIsUnderOath") ) {
                final Object value = values.remove("BusinessPartnerIsUnderOath");
                if( (value == null) || (!value.equals(getBusinessPartnerIsUnderOath())) ) {
                    setBusinessPartnerIsUnderOath(((Boolean) value));
                }
            }
            if( values.containsKey("BusinessPartnerOathDate") ) {
                final Object value = values.remove("BusinessPartnerOathDate");
                if( (value == null) || (!value.equals(getBusinessPartnerOathDate())) ) {
                    setBusinessPartnerOathDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BusinessPartnerIsBankrupt") ) {
                final Object value = values.remove("BusinessPartnerIsBankrupt");
                if( (value == null) || (!value.equals(getBusinessPartnerIsBankrupt())) ) {
                    setBusinessPartnerIsBankrupt(((Boolean) value));
                }
            }
            if( values.containsKey("BusinessPartnerBankruptcyDate") ) {
                final Object value = values.remove("BusinessPartnerBankruptcyDate");
                if( (value == null) || (!value.equals(getBusinessPartnerBankruptcyDate())) ) {
                    setBusinessPartnerBankruptcyDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BPForeclosureIsInitiated") ) {
                final Object value = values.remove("BPForeclosureIsInitiated");
                if( (value == null) || (!value.equals(getBPForeclosureIsInitiated())) ) {
                    setBPForeclosureIsInitiated(((Boolean) value));
                }
            }
            if( values.containsKey("BPForeclosureDate") ) {
                final Object value = values.remove("BPForeclosureDate");
                if( (value == null) || (!value.equals(getBPForeclosureDate())) ) {
                    setBPForeclosureDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BPCrdtWrthnssAccessChkIsActive") ) {
                final Object value = values.remove("BPCrdtWrthnssAccessChkIsActive");
                if( (value == null) || (!value.equals(getBPCrdtWrthnssAccessChkIsActive())) ) {
                    setBPCrdtWrthnssAccessChkIsActive(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BPCreditWorthinessField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BPCreditWorthinessField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BPCreditWorthinessField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BPCreditWorthinessField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessPartnerService.DEFAULT_SERVICE_PATH);
    }

}
