/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.field.BPFinancialServicesExtnField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.selectable.BPFinancialServicesExtnSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Financial Services Details
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BPFinancialServicesExtnType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BPFinancialServicesExtn extends VdmEntity<BPFinancialServicesExtn>
{

    /**
     * Selector for all available fields of BPFinancialServicesExtn.
     *
     */
    public final static BPFinancialServicesExtnSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     *
     * @return Business Partner Number
     */
    @Key
    @SerializedName( "BusinessPartner" )
    @JsonProperty( "BusinessPartner" )
    @Nullable
    @ODataField( odataName = "BusinessPartner" )
    private String businessPartner;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartner</b> field to query operations.
     *
     */
    public final static BPFinancialServicesExtnField<String> BUSINESS_PARTNER =
        new BPFinancialServicesExtnField<String>("BusinessPartner");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerIsVIP</b>
     * </p>
     *
     * @return Business Partner Is VIP
     */
    @SerializedName( "BusinessPartnerIsVIP" )
    @JsonProperty( "BusinessPartnerIsVIP" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BusinessPartnerIsVIP" )
    private Boolean businessPartnerIsVIP;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerIsVIP</b> field to query operations.
     *
     */
    public final static BPFinancialServicesExtnField<Boolean> BUSINESS_PARTNER_IS_VIP =
        new BPFinancialServicesExtnField<Boolean>("BusinessPartnerIsVIP");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>TradingPartner</b>
     * </p>
     *
     * @return Company ID of Trading Partner
     */
    @SerializedName( "TradingPartner" )
    @JsonProperty( "TradingPartner" )
    @Nullable
    @ODataField( odataName = "TradingPartner" )
    private String tradingPartner;
    /**
     * Use with available fluent helpers to apply the <b>TradingPartner</b> field to query operations.
     *
     */
    public final static BPFinancialServicesExtnField<String> TRADING_PARTNER =
        new BPFinancialServicesExtnField<String>("TradingPartner");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FactoryCalendar</b>
     * </p>
     *
     * @return Factory calendar
     */
    @SerializedName( "FactoryCalendar" )
    @JsonProperty( "FactoryCalendar" )
    @Nullable
    @ODataField( odataName = "FactoryCalendar" )
    private String factoryCalendar;
    /**
     * Use with available fluent helpers to apply the <b>FactoryCalendar</b> field to query operations.
     *
     */
    public final static BPFinancialServicesExtnField<String> FACTORY_CALENDAR =
        new BPFinancialServicesExtnField<String>("FactoryCalendar");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerOfficeCountry</b>
     * </p>
     *
     * @return Country/Region of Registered Office
     */
    @SerializedName( "BusinessPartnerOfficeCountry" )
    @JsonProperty( "BusinessPartnerOfficeCountry" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerOfficeCountry" )
    private String businessPartnerOfficeCountry;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerOfficeCountry</b> field to query operations.
     *
     */
    public final static BPFinancialServicesExtnField<String> BUSINESS_PARTNER_OFFICE_COUNTRY =
        new BPFinancialServicesExtnField<String>("BusinessPartnerOfficeCountry");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerOfficeRegion</b>
     * </p>
     *
     * @return Region of Registered Office
     */
    @SerializedName( "BusinessPartnerOfficeRegion" )
    @JsonProperty( "BusinessPartnerOfficeRegion" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerOfficeRegion" )
    private String businessPartnerOfficeRegion;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerOfficeRegion</b> field to query operations.
     *
     */
    public final static BPFinancialServicesExtnField<String> BUSINESS_PARTNER_OFFICE_REGION =
        new BPFinancialServicesExtnField<String>("BusinessPartnerOfficeRegion");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BPRegisteredOfficeName</b>
     * </p>
     *
     * @return Registered Office
     */
    @SerializedName( "BPRegisteredOfficeName" )
    @JsonProperty( "BPRegisteredOfficeName" )
    @Nullable
    @ODataField( odataName = "BPRegisteredOfficeName" )
    private String bPRegisteredOfficeName;
    /**
     * Use with available fluent helpers to apply the <b>BPRegisteredOfficeName</b> field to query operations.
     *
     */
    public final static BPFinancialServicesExtnField<String> BP_REGISTERED_OFFICE_NAME =
        new BPFinancialServicesExtnField<String>("BPRegisteredOfficeName");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>BPBalanceSheetCurrency</b>
     * </p>
     *
     * @return Balance Sheet Currency
     */
    @SerializedName( "BPBalanceSheetCurrency" )
    @JsonProperty( "BPBalanceSheetCurrency" )
    @Nullable
    @ODataField( odataName = "BPBalanceSheetCurrency" )
    private String bPBalanceSheetCurrency;
    /**
     * Use with available fluent helpers to apply the <b>BPBalanceSheetCurrency</b> field to query operations.
     *
     */
    public final static BPFinancialServicesExtnField<String> BP_BALANCE_SHEET_CURRENCY =
        new BPFinancialServicesExtnField<String>("BPBalanceSheetCurrency");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPLastCptlIncrAmtInBalShtCrcy</b>
     * </p>
     *
     * @return Amount of last capital increase
     */
    @SerializedName( "BPLastCptlIncrAmtInBalShtCrcy" )
    @JsonProperty( "BPLastCptlIncrAmtInBalShtCrcy" )
    @Nullable
    @ODataField( odataName = "BPLastCptlIncrAmtInBalShtCrcy" )
    private BigDecimal bPLastCptlIncrAmtInBalShtCrcy;
    /**
     * Use with available fluent helpers to apply the <b>BPLastCptlIncrAmtInBalShtCrcy</b> field to query operations.
     *
     */
    public final static BPFinancialServicesExtnField<BigDecimal> BP_LAST_CPTL_INCR_AMT_IN_BAL_SHT_CRCY =
        new BPFinancialServicesExtnField<BigDecimal>("BPLastCptlIncrAmtInBalShtCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BPLastCapitalIncreaseYear</b>
     * </p>
     *
     * @return Year of Last Capital Increase
     */
    @SerializedName( "BPLastCapitalIncreaseYear" )
    @JsonProperty( "BPLastCapitalIncreaseYear" )
    @Nullable
    @ODataField( odataName = "BPLastCapitalIncreaseYear" )
    private String bPLastCapitalIncreaseYear;
    /**
     * Use with available fluent helpers to apply the <b>BPLastCapitalIncreaseYear</b> field to query operations.
     *
     */
    public final static BPFinancialServicesExtnField<String> BP_LAST_CAPITAL_INCREASE_YEAR =
        new BPFinancialServicesExtnField<String>("BPLastCapitalIncreaseYear");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BPBalanceSheetDisplayType</b>
     * </p>
     *
     * @return Balance Sheet Display
     */
    @SerializedName( "BPBalanceSheetDisplayType" )
    @JsonProperty( "BPBalanceSheetDisplayType" )
    @Nullable
    @ODataField( odataName = "BPBalanceSheetDisplayType" )
    private String bPBalanceSheetDisplayType;
    /**
     * Use with available fluent helpers to apply the <b>BPBalanceSheetDisplayType</b> field to query operations.
     *
     */
    public final static BPFinancialServicesExtnField<String> BP_BALANCE_SHEET_DISPLAY_TYPE =
        new BPFinancialServicesExtnField<String>("BPBalanceSheetDisplayType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerCitizenship</b>
     * </p>
     *
     * @return Citizenship
     */
    @SerializedName( "BusinessPartnerCitizenship" )
    @JsonProperty( "BusinessPartnerCitizenship" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerCitizenship" )
    private String businessPartnerCitizenship;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerCitizenship</b> field to query operations.
     *
     */
    public final static BPFinancialServicesExtnField<String> BUSINESS_PARTNER_CITIZENSHIP =
        new BPFinancialServicesExtnField<String>("BusinessPartnerCitizenship");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BPMaritalPropertyRegime</b>
     * </p>
     *
     * @return Marital property regime
     */
    @SerializedName( "BPMaritalPropertyRegime" )
    @JsonProperty( "BPMaritalPropertyRegime" )
    @Nullable
    @ODataField( odataName = "BPMaritalPropertyRegime" )
    private String bPMaritalPropertyRegime;
    /**
     * Use with available fluent helpers to apply the <b>BPMaritalPropertyRegime</b> field to query operations.
     *
     */
    public final static BPFinancialServicesExtnField<String> BP_MARITAL_PROPERTY_REGIME =
        new BPFinancialServicesExtnField<String>("BPMaritalPropertyRegime");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerIncomeCurrency</b>
     * </p>
     *
     * @return Currency of Net Income
     */
    @SerializedName( "BusinessPartnerIncomeCurrency" )
    @JsonProperty( "BusinessPartnerIncomeCurrency" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerIncomeCurrency" )
    private String businessPartnerIncomeCurrency;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerIncomeCurrency</b> field to query operations.
     *
     */
    public final static BPFinancialServicesExtnField<String> BUSINESS_PARTNER_INCOME_CURRENCY =
        new BPFinancialServicesExtnField<String>("BusinessPartnerIncomeCurrency");
    /**
     * Constraints: Not nullable, Precision: 2, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>BPNumberOfChildren</b>
     * </p>
     *
     * @return Number of Children Belonging to the Business Partner
     */
    @SerializedName( "BPNumberOfChildren" )
    @JsonProperty( "BPNumberOfChildren" )
    @Nullable
    @ODataField( odataName = "BPNumberOfChildren" )
    private BigDecimal bPNumberOfChildren;
    /**
     * Use with available fluent helpers to apply the <b>BPNumberOfChildren</b> field to query operations.
     *
     */
    public final static BPFinancialServicesExtnField<BigDecimal> BP_NUMBER_OF_CHILDREN =
        new BPFinancialServicesExtnField<BigDecimal>("BPNumberOfChildren");
    /**
     * Constraints: Not nullable, Precision: 2, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>BPNumberOfHouseholdMembers</b>
     * </p>
     *
     * @return Number of People Living in the Household
     */
    @SerializedName( "BPNumberOfHouseholdMembers" )
    @JsonProperty( "BPNumberOfHouseholdMembers" )
    @Nullable
    @ODataField( odataName = "BPNumberOfHouseholdMembers" )
    private BigDecimal bPNumberOfHouseholdMembers;
    /**
     * Use with available fluent helpers to apply the <b>BPNumberOfHouseholdMembers</b> field to query operations.
     *
     */
    public final static BPFinancialServicesExtnField<BigDecimal> BP_NUMBER_OF_HOUSEHOLD_MEMBERS =
        new BPFinancialServicesExtnField<BigDecimal>("BPNumberOfHouseholdMembers");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPAnnualNetIncAmtInIncomeCrcy</b>
     * </p>
     *
     * @return Net Annual Income
     */
    @SerializedName( "BPAnnualNetIncAmtInIncomeCrcy" )
    @JsonProperty( "BPAnnualNetIncAmtInIncomeCrcy" )
    @Nullable
    @ODataField( odataName = "BPAnnualNetIncAmtInIncomeCrcy" )
    private BigDecimal bPAnnualNetIncAmtInIncomeCrcy;
    /**
     * Use with available fluent helpers to apply the <b>BPAnnualNetIncAmtInIncomeCrcy</b> field to query operations.
     *
     */
    public final static BPFinancialServicesExtnField<BigDecimal> BP_ANNUAL_NET_INC_AMT_IN_INCOME_CRCY =
        new BPFinancialServicesExtnField<BigDecimal>("BPAnnualNetIncAmtInIncomeCrcy");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPMonthlyNetIncAmtInIncomeCrcy</b>
     * </p>
     *
     * @return Monthly Net Income of Business Partner
     */
    @SerializedName( "BPMonthlyNetIncAmtInIncomeCrcy" )
    @JsonProperty( "BPMonthlyNetIncAmtInIncomeCrcy" )
    @Nullable
    @ODataField( odataName = "BPMonthlyNetIncAmtInIncomeCrcy" )
    private BigDecimal bPMonthlyNetIncAmtInIncomeCrcy;
    /**
     * Use with available fluent helpers to apply the <b>BPMonthlyNetIncAmtInIncomeCrcy</b> field to query operations.
     *
     */
    public final static BPFinancialServicesExtnField<BigDecimal> BP_MONTHLY_NET_INC_AMT_IN_INCOME_CRCY =
        new BPFinancialServicesExtnField<BigDecimal>("BPMonthlyNetIncAmtInIncomeCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BPAnnualNetIncomeYear</b>
     * </p>
     *
     * @return Year of Net Annual Income
     */
    @SerializedName( "BPAnnualNetIncomeYear" )
    @JsonProperty( "BPAnnualNetIncomeYear" )
    @Nullable
    @ODataField( odataName = "BPAnnualNetIncomeYear" )
    private String bPAnnualNetIncomeYear;
    /**
     * Use with available fluent helpers to apply the <b>BPAnnualNetIncomeYear</b> field to query operations.
     *
     */
    public final static BPFinancialServicesExtnField<String> BP_ANNUAL_NET_INCOME_YEAR =
        new BPFinancialServicesExtnField<String>("BPAnnualNetIncomeYear");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BPMonthlyNetIncomeMonth</b>
     * </p>
     *
     * @return Calendar Month of Monthly Net Income
     */
    @SerializedName( "BPMonthlyNetIncomeMonth" )
    @JsonProperty( "BPMonthlyNetIncomeMonth" )
    @Nullable
    @ODataField( odataName = "BPMonthlyNetIncomeMonth" )
    private String bPMonthlyNetIncomeMonth;
    /**
     * Use with available fluent helpers to apply the <b>BPMonthlyNetIncomeMonth</b> field to query operations.
     *
     */
    public final static BPFinancialServicesExtnField<String> BP_MONTHLY_NET_INCOME_MONTH =
        new BPFinancialServicesExtnField<String>("BPMonthlyNetIncomeMonth");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BPMonthlyNetIncomeYear</b>
     * </p>
     *
     * @return Year of Monthly Net Income
     */
    @SerializedName( "BPMonthlyNetIncomeYear" )
    @JsonProperty( "BPMonthlyNetIncomeYear" )
    @Nullable
    @ODataField( odataName = "BPMonthlyNetIncomeYear" )
    private String bPMonthlyNetIncomeYear;
    /**
     * Use with available fluent helpers to apply the <b>BPMonthlyNetIncomeYear</b> field to query operations.
     *
     */
    public final static BPFinancialServicesExtnField<String> BP_MONTHLY_NET_INCOME_YEAR =
        new BPFinancialServicesExtnField<String>("BPMonthlyNetIncomeYear");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BPPlaceOfDeathName</b>
     * </p>
     *
     * @return Name of Place of Death of Natural Person
     */
    @SerializedName( "BPPlaceOfDeathName" )
    @JsonProperty( "BPPlaceOfDeathName" )
    @Nullable
    @ODataField( odataName = "BPPlaceOfDeathName" )
    private String bPPlaceOfDeathName;
    /**
     * Use with available fluent helpers to apply the <b>BPPlaceOfDeathName</b> field to query operations.
     *
     */
    public final static BPFinancialServicesExtnField<String> BP_PLACE_OF_DEATH_NAME =
        new BPFinancialServicesExtnField<String>("BPPlaceOfDeathName");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CustomerIsUnwanted</b>
     * </p>
     *
     * @return Undesirable Customer
     */
    @SerializedName( "CustomerIsUnwanted" )
    @JsonProperty( "CustomerIsUnwanted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CustomerIsUnwanted" )
    private Boolean customerIsUnwanted;
    /**
     * Use with available fluent helpers to apply the <b>CustomerIsUnwanted</b> field to query operations.
     *
     */
    public final static BPFinancialServicesExtnField<Boolean> CUSTOMER_IS_UNWANTED =
        new BPFinancialServicesExtnField<Boolean>("CustomerIsUnwanted");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>UndesirabilityReason</b>
     * </p>
     *
     * @return Reason for Undesirability
     */
    @SerializedName( "UndesirabilityReason" )
    @JsonProperty( "UndesirabilityReason" )
    @Nullable
    @ODataField( odataName = "UndesirabilityReason" )
    private String undesirabilityReason;
    /**
     * Use with available fluent helpers to apply the <b>UndesirabilityReason</b> field to query operations.
     *
     */
    public final static BPFinancialServicesExtnField<String> UNDESIRABILITY_REASON =
        new BPFinancialServicesExtnField<String>("UndesirabilityReason");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>UndesirabilityComment</b>
     * </p>
     *
     * @return Comment on Undesirability
     */
    @SerializedName( "UndesirabilityComment" )
    @JsonProperty( "UndesirabilityComment" )
    @Nullable
    @ODataField( odataName = "UndesirabilityComment" )
    private String undesirabilityComment;
    /**
     * Use with available fluent helpers to apply the <b>UndesirabilityComment</b> field to query operations.
     *
     */
    public final static BPFinancialServicesExtnField<String> UNDESIRABILITY_COMMENT =
        new BPFinancialServicesExtnField<String>("UndesirabilityComment");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastCustomerContactDate</b>
     * </p>
     *
     * @return Date of Last Customer Contact
     */
    @SerializedName( "LastCustomerContactDate" )
    @JsonProperty( "LastCustomerContactDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastCustomerContactDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastCustomerContactDate;
    /**
     * Use with available fluent helpers to apply the <b>LastCustomerContactDate</b> field to query operations.
     *
     */
    public final static BPFinancialServicesExtnField<LocalDateTime> LAST_CUSTOMER_CONTACT_DATE =
        new BPFinancialServicesExtnField<LocalDateTime>("LastCustomerContactDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BPGroupingCharacter</b>
     * </p>
     *
     * @return Grouping Character
     */
    @SerializedName( "BPGroupingCharacter" )
    @JsonProperty( "BPGroupingCharacter" )
    @Nullable
    @ODataField( odataName = "BPGroupingCharacter" )
    private String bPGroupingCharacter;
    /**
     * Use with available fluent helpers to apply the <b>BPGroupingCharacter</b> field to query operations.
     *
     */
    public final static BPFinancialServicesExtnField<String> BP_GROUPING_CHARACTER =
        new BPFinancialServicesExtnField<String>("BPGroupingCharacter");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BPLetterSalutation</b>
     * </p>
     *
     * @return Salutation
     */
    @SerializedName( "BPLetterSalutation" )
    @JsonProperty( "BPLetterSalutation" )
    @Nullable
    @ODataField( odataName = "BPLetterSalutation" )
    private String bPLetterSalutation;
    /**
     * Use with available fluent helpers to apply the <b>BPLetterSalutation</b> field to query operations.
     *
     */
    public final static BPFinancialServicesExtnField<String> BP_LETTER_SALUTATION =
        new BPFinancialServicesExtnField<String>("BPLetterSalutation");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerTargetGroup</b>
     * </p>
     *
     * @return Target Group
     */
    @SerializedName( "BusinessPartnerTargetGroup" )
    @JsonProperty( "BusinessPartnerTargetGroup" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerTargetGroup" )
    private String businessPartnerTargetGroup;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerTargetGroup</b> field to query operations.
     *
     */
    public final static BPFinancialServicesExtnField<String> BUSINESS_PARTNER_TARGET_GROUP =
        new BPFinancialServicesExtnField<String>("BusinessPartnerTargetGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerEmployeeGroup</b>
     * </p>
     *
     * @return Employee Group
     */
    @SerializedName( "BusinessPartnerEmployeeGroup" )
    @JsonProperty( "BusinessPartnerEmployeeGroup" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerEmployeeGroup" )
    private String businessPartnerEmployeeGroup;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerEmployeeGroup</b> field to query operations.
     *
     */
    public final static BPFinancialServicesExtnField<String> BUSINESS_PARTNER_EMPLOYEE_GROUP =
        new BPFinancialServicesExtnField<String>("BusinessPartnerEmployeeGroup");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerIsEmployee</b>
     * </p>
     *
     * @return Employee
     */
    @SerializedName( "BusinessPartnerIsEmployee" )
    @JsonProperty( "BusinessPartnerIsEmployee" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BusinessPartnerIsEmployee" )
    private Boolean businessPartnerIsEmployee;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerIsEmployee</b> field to query operations.
     *
     */
    public final static BPFinancialServicesExtnField<Boolean> BUSINESS_PARTNER_IS_EMPLOYEE =
        new BPFinancialServicesExtnField<Boolean>("BusinessPartnerIsEmployee");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BPTermnBusRelationsBankDate</b>
     * </p>
     *
     * @return Termination Date for Business Relations with the Bank
     */
    @SerializedName( "BPTermnBusRelationsBankDate" )
    @JsonProperty( "BPTermnBusRelationsBankDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BPTermnBusRelationsBankDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime bPTermnBusRelationsBankDate;
    /**
     * Use with available fluent helpers to apply the <b>BPTermnBusRelationsBankDate</b> field to query operations.
     *
     */
    public final static BPFinancialServicesExtnField<LocalDateTime> BP_TERMN_BUS_RELATIONS_BANK_DATE =
        new BPFinancialServicesExtnField<LocalDateTime>("BPTermnBusRelationsBankDate");

    @Nonnull
    @Override
    public Class<BPFinancialServicesExtn> getType()
    {
        return BPFinancialServicesExtn.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     *
     * @param businessPartner
     *            Business Partner Number
     */
    public void setBusinessPartner( @Nullable final String businessPartner )
    {
        rememberChangedField("BusinessPartner", this.businessPartner);
        this.businessPartner = businessPartner;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerIsVIP</b>
     * </p>
     *
     * @param businessPartnerIsVIP
     *            Business Partner Is VIP
     */
    public void setBusinessPartnerIsVIP( @Nullable final Boolean businessPartnerIsVIP )
    {
        rememberChangedField("BusinessPartnerIsVIP", this.businessPartnerIsVIP);
        this.businessPartnerIsVIP = businessPartnerIsVIP;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>TradingPartner</b>
     * </p>
     *
     * @param tradingPartner
     *            Company ID of Trading Partner
     */
    public void setTradingPartner( @Nullable final String tradingPartner )
    {
        rememberChangedField("TradingPartner", this.tradingPartner);
        this.tradingPartner = tradingPartner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FactoryCalendar</b>
     * </p>
     *
     * @param factoryCalendar
     *            Factory calendar
     */
    public void setFactoryCalendar( @Nullable final String factoryCalendar )
    {
        rememberChangedField("FactoryCalendar", this.factoryCalendar);
        this.factoryCalendar = factoryCalendar;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerOfficeCountry</b>
     * </p>
     *
     * @param businessPartnerOfficeCountry
     *            Country/Region of Registered Office
     */
    public void setBusinessPartnerOfficeCountry( @Nullable final String businessPartnerOfficeCountry )
    {
        rememberChangedField("BusinessPartnerOfficeCountry", this.businessPartnerOfficeCountry);
        this.businessPartnerOfficeCountry = businessPartnerOfficeCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerOfficeRegion</b>
     * </p>
     *
     * @param businessPartnerOfficeRegion
     *            Region of Registered Office
     */
    public void setBusinessPartnerOfficeRegion( @Nullable final String businessPartnerOfficeRegion )
    {
        rememberChangedField("BusinessPartnerOfficeRegion", this.businessPartnerOfficeRegion);
        this.businessPartnerOfficeRegion = businessPartnerOfficeRegion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>BPRegisteredOfficeName</b>
     * </p>
     *
     * @param bPRegisteredOfficeName
     *            Registered Office
     */
    public void setBPRegisteredOfficeName( @Nullable final String bPRegisteredOfficeName )
    {
        rememberChangedField("BPRegisteredOfficeName", this.bPRegisteredOfficeName);
        this.bPRegisteredOfficeName = bPRegisteredOfficeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>BPBalanceSheetCurrency</b>
     * </p>
     *
     * @param bPBalanceSheetCurrency
     *            Balance Sheet Currency
     */
    public void setBPBalanceSheetCurrency( @Nullable final String bPBalanceSheetCurrency )
    {
        rememberChangedField("BPBalanceSheetCurrency", this.bPBalanceSheetCurrency);
        this.bPBalanceSheetCurrency = bPBalanceSheetCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPLastCptlIncrAmtInBalShtCrcy</b>
     * </p>
     *
     * @param bPLastCptlIncrAmtInBalShtCrcy
     *            Amount of last capital increase
     */
    public void setBPLastCptlIncrAmtInBalShtCrcy( @Nullable final BigDecimal bPLastCptlIncrAmtInBalShtCrcy )
    {
        rememberChangedField("BPLastCptlIncrAmtInBalShtCrcy", this.bPLastCptlIncrAmtInBalShtCrcy);
        this.bPLastCptlIncrAmtInBalShtCrcy = bPLastCptlIncrAmtInBalShtCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BPLastCapitalIncreaseYear</b>
     * </p>
     *
     * @param bPLastCapitalIncreaseYear
     *            Year of Last Capital Increase
     */
    public void setBPLastCapitalIncreaseYear( @Nullable final String bPLastCapitalIncreaseYear )
    {
        rememberChangedField("BPLastCapitalIncreaseYear", this.bPLastCapitalIncreaseYear);
        this.bPLastCapitalIncreaseYear = bPLastCapitalIncreaseYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BPBalanceSheetDisplayType</b>
     * </p>
     *
     * @param bPBalanceSheetDisplayType
     *            Balance Sheet Display
     */
    public void setBPBalanceSheetDisplayType( @Nullable final String bPBalanceSheetDisplayType )
    {
        rememberChangedField("BPBalanceSheetDisplayType", this.bPBalanceSheetDisplayType);
        this.bPBalanceSheetDisplayType = bPBalanceSheetDisplayType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerCitizenship</b>
     * </p>
     *
     * @param businessPartnerCitizenship
     *            Citizenship
     */
    public void setBusinessPartnerCitizenship( @Nullable final String businessPartnerCitizenship )
    {
        rememberChangedField("BusinessPartnerCitizenship", this.businessPartnerCitizenship);
        this.businessPartnerCitizenship = businessPartnerCitizenship;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BPMaritalPropertyRegime</b>
     * </p>
     *
     * @param bPMaritalPropertyRegime
     *            Marital property regime
     */
    public void setBPMaritalPropertyRegime( @Nullable final String bPMaritalPropertyRegime )
    {
        rememberChangedField("BPMaritalPropertyRegime", this.bPMaritalPropertyRegime);
        this.bPMaritalPropertyRegime = bPMaritalPropertyRegime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerIncomeCurrency</b>
     * </p>
     *
     * @param businessPartnerIncomeCurrency
     *            Currency of Net Income
     */
    public void setBusinessPartnerIncomeCurrency( @Nullable final String businessPartnerIncomeCurrency )
    {
        rememberChangedField("BusinessPartnerIncomeCurrency", this.businessPartnerIncomeCurrency);
        this.businessPartnerIncomeCurrency = businessPartnerIncomeCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 2, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>BPNumberOfChildren</b>
     * </p>
     *
     * @param bPNumberOfChildren
     *            Number of Children Belonging to the Business Partner
     */
    public void setBPNumberOfChildren( @Nullable final BigDecimal bPNumberOfChildren )
    {
        rememberChangedField("BPNumberOfChildren", this.bPNumberOfChildren);
        this.bPNumberOfChildren = bPNumberOfChildren;
    }

    /**
     * Constraints: Not nullable, Precision: 2, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>BPNumberOfHouseholdMembers</b>
     * </p>
     *
     * @param bPNumberOfHouseholdMembers
     *            Number of People Living in the Household
     */
    public void setBPNumberOfHouseholdMembers( @Nullable final BigDecimal bPNumberOfHouseholdMembers )
    {
        rememberChangedField("BPNumberOfHouseholdMembers", this.bPNumberOfHouseholdMembers);
        this.bPNumberOfHouseholdMembers = bPNumberOfHouseholdMembers;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPAnnualNetIncAmtInIncomeCrcy</b>
     * </p>
     *
     * @param bPAnnualNetIncAmtInIncomeCrcy
     *            Net Annual Income
     */
    public void setBPAnnualNetIncAmtInIncomeCrcy( @Nullable final BigDecimal bPAnnualNetIncAmtInIncomeCrcy )
    {
        rememberChangedField("BPAnnualNetIncAmtInIncomeCrcy", this.bPAnnualNetIncAmtInIncomeCrcy);
        this.bPAnnualNetIncAmtInIncomeCrcy = bPAnnualNetIncAmtInIncomeCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPMonthlyNetIncAmtInIncomeCrcy</b>
     * </p>
     *
     * @param bPMonthlyNetIncAmtInIncomeCrcy
     *            Monthly Net Income of Business Partner
     */
    public void setBPMonthlyNetIncAmtInIncomeCrcy( @Nullable final BigDecimal bPMonthlyNetIncAmtInIncomeCrcy )
    {
        rememberChangedField("BPMonthlyNetIncAmtInIncomeCrcy", this.bPMonthlyNetIncAmtInIncomeCrcy);
        this.bPMonthlyNetIncAmtInIncomeCrcy = bPMonthlyNetIncAmtInIncomeCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BPAnnualNetIncomeYear</b>
     * </p>
     *
     * @param bPAnnualNetIncomeYear
     *            Year of Net Annual Income
     */
    public void setBPAnnualNetIncomeYear( @Nullable final String bPAnnualNetIncomeYear )
    {
        rememberChangedField("BPAnnualNetIncomeYear", this.bPAnnualNetIncomeYear);
        this.bPAnnualNetIncomeYear = bPAnnualNetIncomeYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BPMonthlyNetIncomeMonth</b>
     * </p>
     *
     * @param bPMonthlyNetIncomeMonth
     *            Calendar Month of Monthly Net Income
     */
    public void setBPMonthlyNetIncomeMonth( @Nullable final String bPMonthlyNetIncomeMonth )
    {
        rememberChangedField("BPMonthlyNetIncomeMonth", this.bPMonthlyNetIncomeMonth);
        this.bPMonthlyNetIncomeMonth = bPMonthlyNetIncomeMonth;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BPMonthlyNetIncomeYear</b>
     * </p>
     *
     * @param bPMonthlyNetIncomeYear
     *            Year of Monthly Net Income
     */
    public void setBPMonthlyNetIncomeYear( @Nullable final String bPMonthlyNetIncomeYear )
    {
        rememberChangedField("BPMonthlyNetIncomeYear", this.bPMonthlyNetIncomeYear);
        this.bPMonthlyNetIncomeYear = bPMonthlyNetIncomeYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BPPlaceOfDeathName</b>
     * </p>
     *
     * @param bPPlaceOfDeathName
     *            Name of Place of Death of Natural Person
     */
    public void setBPPlaceOfDeathName( @Nullable final String bPPlaceOfDeathName )
    {
        rememberChangedField("BPPlaceOfDeathName", this.bPPlaceOfDeathName);
        this.bPPlaceOfDeathName = bPPlaceOfDeathName;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CustomerIsUnwanted</b>
     * </p>
     *
     * @param customerIsUnwanted
     *            Undesirable Customer
     */
    public void setCustomerIsUnwanted( @Nullable final Boolean customerIsUnwanted )
    {
        rememberChangedField("CustomerIsUnwanted", this.customerIsUnwanted);
        this.customerIsUnwanted = customerIsUnwanted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>UndesirabilityReason</b>
     * </p>
     *
     * @param undesirabilityReason
     *            Reason for Undesirability
     */
    public void setUndesirabilityReason( @Nullable final String undesirabilityReason )
    {
        rememberChangedField("UndesirabilityReason", this.undesirabilityReason);
        this.undesirabilityReason = undesirabilityReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>UndesirabilityComment</b>
     * </p>
     *
     * @param undesirabilityComment
     *            Comment on Undesirability
     */
    public void setUndesirabilityComment( @Nullable final String undesirabilityComment )
    {
        rememberChangedField("UndesirabilityComment", this.undesirabilityComment);
        this.undesirabilityComment = undesirabilityComment;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastCustomerContactDate</b>
     * </p>
     *
     * @param lastCustomerContactDate
     *            Date of Last Customer Contact
     */
    public void setLastCustomerContactDate( @Nullable final LocalDateTime lastCustomerContactDate )
    {
        rememberChangedField("LastCustomerContactDate", this.lastCustomerContactDate);
        this.lastCustomerContactDate = lastCustomerContactDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BPGroupingCharacter</b>
     * </p>
     *
     * @param bPGroupingCharacter
     *            Grouping Character
     */
    public void setBPGroupingCharacter( @Nullable final String bPGroupingCharacter )
    {
        rememberChangedField("BPGroupingCharacter", this.bPGroupingCharacter);
        this.bPGroupingCharacter = bPGroupingCharacter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BPLetterSalutation</b>
     * </p>
     *
     * @param bPLetterSalutation
     *            Salutation
     */
    public void setBPLetterSalutation( @Nullable final String bPLetterSalutation )
    {
        rememberChangedField("BPLetterSalutation", this.bPLetterSalutation);
        this.bPLetterSalutation = bPLetterSalutation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerTargetGroup</b>
     * </p>
     *
     * @param businessPartnerTargetGroup
     *            Target Group
     */
    public void setBusinessPartnerTargetGroup( @Nullable final String businessPartnerTargetGroup )
    {
        rememberChangedField("BusinessPartnerTargetGroup", this.businessPartnerTargetGroup);
        this.businessPartnerTargetGroup = businessPartnerTargetGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerEmployeeGroup</b>
     * </p>
     *
     * @param businessPartnerEmployeeGroup
     *            Employee Group
     */
    public void setBusinessPartnerEmployeeGroup( @Nullable final String businessPartnerEmployeeGroup )
    {
        rememberChangedField("BusinessPartnerEmployeeGroup", this.businessPartnerEmployeeGroup);
        this.businessPartnerEmployeeGroup = businessPartnerEmployeeGroup;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerIsEmployee</b>
     * </p>
     *
     * @param businessPartnerIsEmployee
     *            Employee
     */
    public void setBusinessPartnerIsEmployee( @Nullable final Boolean businessPartnerIsEmployee )
    {
        rememberChangedField("BusinessPartnerIsEmployee", this.businessPartnerIsEmployee);
        this.businessPartnerIsEmployee = businessPartnerIsEmployee;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BPTermnBusRelationsBankDate</b>
     * </p>
     *
     * @param bPTermnBusRelationsBankDate
     *            Termination Date for Business Relations with the Bank
     */
    public void setBPTermnBusRelationsBankDate( @Nullable final LocalDateTime bPTermnBusRelationsBankDate )
    {
        rememberChangedField("BPTermnBusRelationsBankDate", this.bPTermnBusRelationsBankDate);
        this.bPTermnBusRelationsBankDate = bPTermnBusRelationsBankDate;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BPFinancialServicesExtn";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BusinessPartner", getBusinessPartner());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BusinessPartner", getBusinessPartner());
        values.put("BusinessPartnerIsVIP", getBusinessPartnerIsVIP());
        values.put("TradingPartner", getTradingPartner());
        values.put("FactoryCalendar", getFactoryCalendar());
        values.put("BusinessPartnerOfficeCountry", getBusinessPartnerOfficeCountry());
        values.put("BusinessPartnerOfficeRegion", getBusinessPartnerOfficeRegion());
        values.put("BPRegisteredOfficeName", getBPRegisteredOfficeName());
        values.put("BPBalanceSheetCurrency", getBPBalanceSheetCurrency());
        values.put("BPLastCptlIncrAmtInBalShtCrcy", getBPLastCptlIncrAmtInBalShtCrcy());
        values.put("BPLastCapitalIncreaseYear", getBPLastCapitalIncreaseYear());
        values.put("BPBalanceSheetDisplayType", getBPBalanceSheetDisplayType());
        values.put("BusinessPartnerCitizenship", getBusinessPartnerCitizenship());
        values.put("BPMaritalPropertyRegime", getBPMaritalPropertyRegime());
        values.put("BusinessPartnerIncomeCurrency", getBusinessPartnerIncomeCurrency());
        values.put("BPNumberOfChildren", getBPNumberOfChildren());
        values.put("BPNumberOfHouseholdMembers", getBPNumberOfHouseholdMembers());
        values.put("BPAnnualNetIncAmtInIncomeCrcy", getBPAnnualNetIncAmtInIncomeCrcy());
        values.put("BPMonthlyNetIncAmtInIncomeCrcy", getBPMonthlyNetIncAmtInIncomeCrcy());
        values.put("BPAnnualNetIncomeYear", getBPAnnualNetIncomeYear());
        values.put("BPMonthlyNetIncomeMonth", getBPMonthlyNetIncomeMonth());
        values.put("BPMonthlyNetIncomeYear", getBPMonthlyNetIncomeYear());
        values.put("BPPlaceOfDeathName", getBPPlaceOfDeathName());
        values.put("CustomerIsUnwanted", getCustomerIsUnwanted());
        values.put("UndesirabilityReason", getUndesirabilityReason());
        values.put("UndesirabilityComment", getUndesirabilityComment());
        values.put("LastCustomerContactDate", getLastCustomerContactDate());
        values.put("BPGroupingCharacter", getBPGroupingCharacter());
        values.put("BPLetterSalutation", getBPLetterSalutation());
        values.put("BusinessPartnerTargetGroup", getBusinessPartnerTargetGroup());
        values.put("BusinessPartnerEmployeeGroup", getBusinessPartnerEmployeeGroup());
        values.put("BusinessPartnerIsEmployee", getBusinessPartnerIsEmployee());
        values.put("BPTermnBusRelationsBankDate", getBPTermnBusRelationsBankDate());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BusinessPartner") ) {
                final Object value = values.remove("BusinessPartner");
                if( (value == null) || (!value.equals(getBusinessPartner())) ) {
                    setBusinessPartner(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerIsVIP") ) {
                final Object value = values.remove("BusinessPartnerIsVIP");
                if( (value == null) || (!value.equals(getBusinessPartnerIsVIP())) ) {
                    setBusinessPartnerIsVIP(((Boolean) value));
                }
            }
            if( values.containsKey("TradingPartner") ) {
                final Object value = values.remove("TradingPartner");
                if( (value == null) || (!value.equals(getTradingPartner())) ) {
                    setTradingPartner(((String) value));
                }
            }
            if( values.containsKey("FactoryCalendar") ) {
                final Object value = values.remove("FactoryCalendar");
                if( (value == null) || (!value.equals(getFactoryCalendar())) ) {
                    setFactoryCalendar(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerOfficeCountry") ) {
                final Object value = values.remove("BusinessPartnerOfficeCountry");
                if( (value == null) || (!value.equals(getBusinessPartnerOfficeCountry())) ) {
                    setBusinessPartnerOfficeCountry(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerOfficeRegion") ) {
                final Object value = values.remove("BusinessPartnerOfficeRegion");
                if( (value == null) || (!value.equals(getBusinessPartnerOfficeRegion())) ) {
                    setBusinessPartnerOfficeRegion(((String) value));
                }
            }
            if( values.containsKey("BPRegisteredOfficeName") ) {
                final Object value = values.remove("BPRegisteredOfficeName");
                if( (value == null) || (!value.equals(getBPRegisteredOfficeName())) ) {
                    setBPRegisteredOfficeName(((String) value));
                }
            }
            if( values.containsKey("BPBalanceSheetCurrency") ) {
                final Object value = values.remove("BPBalanceSheetCurrency");
                if( (value == null) || (!value.equals(getBPBalanceSheetCurrency())) ) {
                    setBPBalanceSheetCurrency(((String) value));
                }
            }
            if( values.containsKey("BPLastCptlIncrAmtInBalShtCrcy") ) {
                final Object value = values.remove("BPLastCptlIncrAmtInBalShtCrcy");
                if( (value == null) || (!value.equals(getBPLastCptlIncrAmtInBalShtCrcy())) ) {
                    setBPLastCptlIncrAmtInBalShtCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("BPLastCapitalIncreaseYear") ) {
                final Object value = values.remove("BPLastCapitalIncreaseYear");
                if( (value == null) || (!value.equals(getBPLastCapitalIncreaseYear())) ) {
                    setBPLastCapitalIncreaseYear(((String) value));
                }
            }
            if( values.containsKey("BPBalanceSheetDisplayType") ) {
                final Object value = values.remove("BPBalanceSheetDisplayType");
                if( (value == null) || (!value.equals(getBPBalanceSheetDisplayType())) ) {
                    setBPBalanceSheetDisplayType(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerCitizenship") ) {
                final Object value = values.remove("BusinessPartnerCitizenship");
                if( (value == null) || (!value.equals(getBusinessPartnerCitizenship())) ) {
                    setBusinessPartnerCitizenship(((String) value));
                }
            }
            if( values.containsKey("BPMaritalPropertyRegime") ) {
                final Object value = values.remove("BPMaritalPropertyRegime");
                if( (value == null) || (!value.equals(getBPMaritalPropertyRegime())) ) {
                    setBPMaritalPropertyRegime(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerIncomeCurrency") ) {
                final Object value = values.remove("BusinessPartnerIncomeCurrency");
                if( (value == null) || (!value.equals(getBusinessPartnerIncomeCurrency())) ) {
                    setBusinessPartnerIncomeCurrency(((String) value));
                }
            }
            if( values.containsKey("BPNumberOfChildren") ) {
                final Object value = values.remove("BPNumberOfChildren");
                if( (value == null) || (!value.equals(getBPNumberOfChildren())) ) {
                    setBPNumberOfChildren(((BigDecimal) value));
                }
            }
            if( values.containsKey("BPNumberOfHouseholdMembers") ) {
                final Object value = values.remove("BPNumberOfHouseholdMembers");
                if( (value == null) || (!value.equals(getBPNumberOfHouseholdMembers())) ) {
                    setBPNumberOfHouseholdMembers(((BigDecimal) value));
                }
            }
            if( values.containsKey("BPAnnualNetIncAmtInIncomeCrcy") ) {
                final Object value = values.remove("BPAnnualNetIncAmtInIncomeCrcy");
                if( (value == null) || (!value.equals(getBPAnnualNetIncAmtInIncomeCrcy())) ) {
                    setBPAnnualNetIncAmtInIncomeCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("BPMonthlyNetIncAmtInIncomeCrcy") ) {
                final Object value = values.remove("BPMonthlyNetIncAmtInIncomeCrcy");
                if( (value == null) || (!value.equals(getBPMonthlyNetIncAmtInIncomeCrcy())) ) {
                    setBPMonthlyNetIncAmtInIncomeCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("BPAnnualNetIncomeYear") ) {
                final Object value = values.remove("BPAnnualNetIncomeYear");
                if( (value == null) || (!value.equals(getBPAnnualNetIncomeYear())) ) {
                    setBPAnnualNetIncomeYear(((String) value));
                }
            }
            if( values.containsKey("BPMonthlyNetIncomeMonth") ) {
                final Object value = values.remove("BPMonthlyNetIncomeMonth");
                if( (value == null) || (!value.equals(getBPMonthlyNetIncomeMonth())) ) {
                    setBPMonthlyNetIncomeMonth(((String) value));
                }
            }
            if( values.containsKey("BPMonthlyNetIncomeYear") ) {
                final Object value = values.remove("BPMonthlyNetIncomeYear");
                if( (value == null) || (!value.equals(getBPMonthlyNetIncomeYear())) ) {
                    setBPMonthlyNetIncomeYear(((String) value));
                }
            }
            if( values.containsKey("BPPlaceOfDeathName") ) {
                final Object value = values.remove("BPPlaceOfDeathName");
                if( (value == null) || (!value.equals(getBPPlaceOfDeathName())) ) {
                    setBPPlaceOfDeathName(((String) value));
                }
            }
            if( values.containsKey("CustomerIsUnwanted") ) {
                final Object value = values.remove("CustomerIsUnwanted");
                if( (value == null) || (!value.equals(getCustomerIsUnwanted())) ) {
                    setCustomerIsUnwanted(((Boolean) value));
                }
            }
            if( values.containsKey("UndesirabilityReason") ) {
                final Object value = values.remove("UndesirabilityReason");
                if( (value == null) || (!value.equals(getUndesirabilityReason())) ) {
                    setUndesirabilityReason(((String) value));
                }
            }
            if( values.containsKey("UndesirabilityComment") ) {
                final Object value = values.remove("UndesirabilityComment");
                if( (value == null) || (!value.equals(getUndesirabilityComment())) ) {
                    setUndesirabilityComment(((String) value));
                }
            }
            if( values.containsKey("LastCustomerContactDate") ) {
                final Object value = values.remove("LastCustomerContactDate");
                if( (value == null) || (!value.equals(getLastCustomerContactDate())) ) {
                    setLastCustomerContactDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BPGroupingCharacter") ) {
                final Object value = values.remove("BPGroupingCharacter");
                if( (value == null) || (!value.equals(getBPGroupingCharacter())) ) {
                    setBPGroupingCharacter(((String) value));
                }
            }
            if( values.containsKey("BPLetterSalutation") ) {
                final Object value = values.remove("BPLetterSalutation");
                if( (value == null) || (!value.equals(getBPLetterSalutation())) ) {
                    setBPLetterSalutation(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerTargetGroup") ) {
                final Object value = values.remove("BusinessPartnerTargetGroup");
                if( (value == null) || (!value.equals(getBusinessPartnerTargetGroup())) ) {
                    setBusinessPartnerTargetGroup(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerEmployeeGroup") ) {
                final Object value = values.remove("BusinessPartnerEmployeeGroup");
                if( (value == null) || (!value.equals(getBusinessPartnerEmployeeGroup())) ) {
                    setBusinessPartnerEmployeeGroup(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerIsEmployee") ) {
                final Object value = values.remove("BusinessPartnerIsEmployee");
                if( (value == null) || (!value.equals(getBusinessPartnerIsEmployee())) ) {
                    setBusinessPartnerIsEmployee(((Boolean) value));
                }
            }
            if( values.containsKey("BPTermnBusRelationsBankDate") ) {
                final Object value = values.remove("BPTermnBusRelationsBankDate");
                if( (value == null) || (!value.equals(getBPTermnBusRelationsBankDate())) ) {
                    setBPTermnBusRelationsBankDate(((LocalDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BPFinancialServicesExtnField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BPFinancialServicesExtnField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BPFinancialServicesExtnField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BPFinancialServicesExtnField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessPartnerService.DEFAULT_SERVICE_PATH);
    }

}
