/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.field.BPFinancialServicesReportingField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.selectable.BPFinancialServicesReportingSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Financial Services Reporting
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BPFinancialServicesReportingType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BPFinancialServicesReporting extends VdmEntity<BPFinancialServicesReporting>
{

    /**
     * Selector for all available fields of BPFinancialServicesReporting.
     *
     */
    public final static BPFinancialServicesReportingSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     *
     * @return Business Partner Number
     */
    @Key
    @SerializedName( "BusinessPartner" )
    @JsonProperty( "BusinessPartner" )
    @Nullable
    @ODataField( odataName = "BusinessPartner" )
    private String businessPartner;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartner</b> field to query operations.
     *
     */
    public final static BPFinancialServicesReportingField<String> BUSINESS_PARTNER =
        new BPFinancialServicesReportingField<String>("BusinessPartner");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BPIsNonResident</b>
     * </p>
     *
     * @return Non-Resident According to Paragraph 4 AWG
     */
    @SerializedName( "BPIsNonResident" )
    @JsonProperty( "BPIsNonResident" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BPIsNonResident" )
    private Boolean bPIsNonResident;
    /**
     * Use with available fluent helpers to apply the <b>BPIsNonResident</b> field to query operations.
     *
     */
    public final static BPFinancialServicesReportingField<Boolean> BP_IS_NON_RESIDENT =
        new BPFinancialServicesReportingField<Boolean>("BPIsNonResident");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BPNonResidencyStartDate</b>
     * </p>
     *
     * @return Start of Non-Residency According to Paragraph 4 AWG
     */
    @SerializedName( "BPNonResidencyStartDate" )
    @JsonProperty( "BPNonResidencyStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BPNonResidencyStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime bPNonResidencyStartDate;
    /**
     * Use with available fluent helpers to apply the <b>BPNonResidencyStartDate</b> field to query operations.
     *
     */
    public final static BPFinancialServicesReportingField<LocalDateTime> BP_NON_RESIDENCY_START_DATE =
        new BPFinancialServicesReportingField<LocalDateTime>("BPNonResidencyStartDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BPIsMultimillionLoanRecipient</b>
     * </p>
     *
     * @return Recipient of Multimillion Loan According to Paragraph 14 GBA
     */
    @SerializedName( "BPIsMultimillionLoanRecipient" )
    @JsonProperty( "BPIsMultimillionLoanRecipient" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BPIsMultimillionLoanRecipient" )
    private Boolean bPIsMultimillionLoanRecipient;
    /**
     * Use with available fluent helpers to apply the <b>BPIsMultimillionLoanRecipient</b> field to query operations.
     *
     */
    public final static BPFinancialServicesReportingField<Boolean> BP_IS_MULTIMILLION_LOAN_RECIPIENT =
        new BPFinancialServicesReportingField<Boolean>("BPIsMultimillionLoanRecipient");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BPLoanReportingBorrowerNumber</b>
     * </p>
     *
     * @return Borrower Number for Reporting a Loan According to GBA
     */
    @SerializedName( "BPLoanReportingBorrowerNumber" )
    @JsonProperty( "BPLoanReportingBorrowerNumber" )
    @Nullable
    @ODataField( odataName = "BPLoanReportingBorrowerNumber" )
    private String bPLoanReportingBorrowerNumber;
    /**
     * Use with available fluent helpers to apply the <b>BPLoanReportingBorrowerNumber</b> field to query operations.
     *
     */
    public final static BPFinancialServicesReportingField<String> BP_LOAN_REPORTING_BORROWER_NUMBER =
        new BPFinancialServicesReportingField<String>("BPLoanReportingBorrowerNumber");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BPLoanRptgBorrowerEntityNumber</b>
     * </p>
     *
     * @return Borrower Entity Number Used to Report Loan acc. to GBA
     */
    @SerializedName( "BPLoanRptgBorrowerEntityNumber" )
    @JsonProperty( "BPLoanRptgBorrowerEntityNumber" )
    @Nullable
    @ODataField( odataName = "BPLoanRptgBorrowerEntityNumber" )
    private String bPLoanRptgBorrowerEntityNumber;
    /**
     * Use with available fluent helpers to apply the <b>BPLoanRptgBorrowerEntityNumber</b> field to query operations.
     *
     */
    public final static BPFinancialServicesReportingField<String> BP_LOAN_RPTG_BORROWER_ENTITY_NUMBER =
        new BPFinancialServicesReportingField<String>("BPLoanRptgBorrowerEntityNumber");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BPCreditStandingReview</b>
     * </p>
     *
     * @return Credit Standing Review According to Paragraph 18 GBA
     */
    @SerializedName( "BPCreditStandingReview" )
    @JsonProperty( "BPCreditStandingReview" )
    @Nullable
    @ODataField( odataName = "BPCreditStandingReview" )
    private String bPCreditStandingReview;
    /**
     * Use with available fluent helpers to apply the <b>BPCreditStandingReview</b> field to query operations.
     *
     */
    public final static BPFinancialServicesReportingField<String> BP_CREDIT_STANDING_REVIEW =
        new BPFinancialServicesReportingField<String>("BPCreditStandingReview");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BPCreditStandingReviewDate</b>
     * </p>
     *
     * @return Date of Credit Standing Review According to Paragraph 18 GBA
     */
    @SerializedName( "BPCreditStandingReviewDate" )
    @JsonProperty( "BPCreditStandingReviewDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BPCreditStandingReviewDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime bPCreditStandingReviewDate;
    /**
     * Use with available fluent helpers to apply the <b>BPCreditStandingReviewDate</b> field to query operations.
     *
     */
    public final static BPFinancialServicesReportingField<LocalDateTime> BP_CREDIT_STANDING_REVIEW_DATE =
        new BPFinancialServicesReportingField<LocalDateTime>("BPCreditStandingReviewDate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerLoanToManager</b>
     * </p>
     *
     * @return Loan to Manager According to Paragraph 15 German Banking Act
     */
    @SerializedName( "BusinessPartnerLoanToManager" )
    @JsonProperty( "BusinessPartnerLoanToManager" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerLoanToManager" )
    private String businessPartnerLoanToManager;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerLoanToManager</b> field to query operations.
     *
     */
    public final static BPFinancialServicesReportingField<String> BUSINESS_PARTNER_LOAN_TO_MANAGER =
        new BPFinancialServicesReportingField<String>("BusinessPartnerLoanToManager");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BPCompanyRelationship</b>
     * </p>
     *
     * @return Organization Relationship
     */
    @SerializedName( "BPCompanyRelationship" )
    @JsonProperty( "BPCompanyRelationship" )
    @Nullable
    @ODataField( odataName = "BPCompanyRelationship" )
    private String bPCompanyRelationship;
    /**
     * Use with available fluent helpers to apply the <b>BPCompanyRelationship</b> field to query operations.
     *
     */
    public final static BPFinancialServicesReportingField<String> BP_COMPANY_RELATIONSHIP =
        new BPFinancialServicesReportingField<String>("BPCompanyRelationship");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BPLoanReportingCreditorNumber</b>
     * </p>
     *
     * @return Creditor Number for Reporting a Loan According to GBA
     */
    @SerializedName( "BPLoanReportingCreditorNumber" )
    @JsonProperty( "BPLoanReportingCreditorNumber" )
    @Nullable
    @ODataField( odataName = "BPLoanReportingCreditorNumber" )
    private String bPLoanReportingCreditorNumber;
    /**
     * Use with available fluent helpers to apply the <b>BPLoanReportingCreditorNumber</b> field to query operations.
     *
     */
    public final static BPFinancialServicesReportingField<String> BP_LOAN_REPORTING_CREDITOR_NUMBER =
        new BPFinancialServicesReportingField<String>("BPLoanReportingCreditorNumber");
    /**
     * Constraints: Not nullable, Maximum length: 11
     * <p>
     * Original property name from the Odata EDM: <b>BPOeNBIdentNumber</b>
     * </p>
     *
     * @return (OeNB) Ident Number
     */
    @SerializedName( "BPOeNBIdentNumber" )
    @JsonProperty( "BPOeNBIdentNumber" )
    @Nullable
    @ODataField( odataName = "BPOeNBIdentNumber" )
    private String bPOeNBIdentNumber;
    /**
     * Use with available fluent helpers to apply the <b>BPOeNBIdentNumber</b> field to query operations.
     *
     */
    public final static BPFinancialServicesReportingField<String> BP_OE_NB_IDENT_NUMBER =
        new BPFinancialServicesReportingField<String>("BPOeNBIdentNumber");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BPOeNBTargetGroup</b>
     * </p>
     *
     * @return Target Group According to OeNB
     */
    @SerializedName( "BPOeNBTargetGroup" )
    @JsonProperty( "BPOeNBTargetGroup" )
    @Nullable
    @ODataField( odataName = "BPOeNBTargetGroup" )
    private String bPOeNBTargetGroup;
    /**
     * Use with available fluent helpers to apply the <b>BPOeNBTargetGroup</b> field to query operations.
     *
     */
    public final static BPFinancialServicesReportingField<String> BP_OE_NB_TARGET_GROUP =
        new BPFinancialServicesReportingField<String>("BPOeNBTargetGroup");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BPOeNBIdentNumberAssigned</b>
     * </p>
     *
     * @return Assign (OeNB) Ident Number
     */
    @SerializedName( "BPOeNBIdentNumberAssigned" )
    @JsonProperty( "BPOeNBIdentNumberAssigned" )
    @Nullable
    @ODataField( odataName = "BPOeNBIdentNumberAssigned" )
    private String bPOeNBIdentNumberAssigned;
    /**
     * Use with available fluent helpers to apply the <b>BPOeNBIdentNumberAssigned</b> field to query operations.
     *
     */
    public final static BPFinancialServicesReportingField<String> BP_OE_NB_IDENT_NUMBER_ASSIGNED =
        new BPFinancialServicesReportingField<String>("BPOeNBIdentNumberAssigned");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>BPOeNBInstituteNumber</b>
     * </p>
     *
     * @return Institute Number According to OeNB
     */
    @SerializedName( "BPOeNBInstituteNumber" )
    @JsonProperty( "BPOeNBInstituteNumber" )
    @Nullable
    @ODataField( odataName = "BPOeNBInstituteNumber" )
    private String bPOeNBInstituteNumber;
    /**
     * Use with available fluent helpers to apply the <b>BPOeNBInstituteNumber</b> field to query operations.
     *
     */
    public final static BPFinancialServicesReportingField<String> BP_OE_NB_INSTITUTE_NUMBER =
        new BPFinancialServicesReportingField<String>("BPOeNBInstituteNumber");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerIsOeNBInstitute</b>
     * </p>
     *
     * @return Institute Subject to Austrian Reg. Reporting Requirements
     */
    @SerializedName( "BusinessPartnerIsOeNBInstitute" )
    @JsonProperty( "BusinessPartnerIsOeNBInstitute" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BusinessPartnerIsOeNBInstitute" )
    private Boolean businessPartnerIsOeNBInstitute;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerIsOeNBInstitute</b> field to query operations.
     *
     */
    public final static BPFinancialServicesReportingField<Boolean> BUSINESS_PARTNER_IS_OE_NB_INSTITUTE =
        new BPFinancialServicesReportingField<Boolean>("BusinessPartnerIsOeNBInstitute");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerGroup</b>
     * </p>
     *
     * @return Group ID
     */
    @SerializedName( "BusinessPartnerGroup" )
    @JsonProperty( "BusinessPartnerGroup" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerGroup" )
    private String businessPartnerGroup;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerGroup</b> field to query operations.
     *
     */
    public final static BPFinancialServicesReportingField<String> BUSINESS_PARTNER_GROUP =
        new BPFinancialServicesReportingField<String>("BusinessPartnerGroup");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BPGroupAssignmentCategory</b>
     * </p>
     *
     * @return Group Assignment Category
     */
    @SerializedName( "BPGroupAssignmentCategory" )
    @JsonProperty( "BPGroupAssignmentCategory" )
    @Nullable
    @ODataField( odataName = "BPGroupAssignmentCategory" )
    private String bPGroupAssignmentCategory;
    /**
     * Use with available fluent helpers to apply the <b>BPGroupAssignmentCategory</b> field to query operations.
     *
     */
    public final static BPFinancialServicesReportingField<String> BP_GROUP_ASSIGNMENT_CATEGORY =
        new BPFinancialServicesReportingField<String>("BPGroupAssignmentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerGroupName</b>
     * </p>
     *
     * @return Group Name
     */
    @SerializedName( "BusinessPartnerGroupName" )
    @JsonProperty( "BusinessPartnerGroupName" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerGroupName" )
    private String businessPartnerGroupName;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerGroupName</b> field to query operations.
     *
     */
    public final static BPFinancialServicesReportingField<String> BUSINESS_PARTNER_GROUP_NAME =
        new BPFinancialServicesReportingField<String>("BusinessPartnerGroupName");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerLegalEntity</b>
     * </p>
     *
     * @return Legal Entity for Business Partner
     */
    @SerializedName( "BusinessPartnerLegalEntity" )
    @JsonProperty( "BusinessPartnerLegalEntity" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerLegalEntity" )
    private String businessPartnerLegalEntity;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerLegalEntity</b> field to query operations.
     *
     */
    public final static BPFinancialServicesReportingField<String> BUSINESS_PARTNER_LEGAL_ENTITY =
        new BPFinancialServicesReportingField<String>("BusinessPartnerLegalEntity");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BPGerAstRglnRestrictedAstQuota</b>
     * </p>
     *
     * @return Business Partner Acc. to Para. 4, Sec. 2 of Asset Regulation
     */
    @SerializedName( "BPGerAstRglnRestrictedAstQuota" )
    @JsonProperty( "BPGerAstRglnRestrictedAstQuota" )
    @Nullable
    @ODataField( odataName = "BPGerAstRglnRestrictedAstQuota" )
    private String bPGerAstRglnRestrictedAstQuota;
    /**
     * Use with available fluent helpers to apply the <b>BPGerAstRglnRestrictedAstQuota</b> field to query operations.
     *
     */
    public final static BPFinancialServicesReportingField<String> BP_GER_AST_RGLN_RESTRICTED_AST_QUOTA =
        new BPFinancialServicesReportingField<String>("BPGerAstRglnRestrictedAstQuota");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerDebtorGroup</b>
     * </p>
     *
     * @return Debtor Group According to German Law (BerVersV, Template 5)
     */
    @SerializedName( "BusinessPartnerDebtorGroup" )
    @JsonProperty( "BusinessPartnerDebtorGroup" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerDebtorGroup" )
    private String businessPartnerDebtorGroup;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerDebtorGroup</b> field to query operations.
     *
     */
    public final static BPFinancialServicesReportingField<String> BUSINESS_PARTNER_DEBTOR_GROUP =
        new BPFinancialServicesReportingField<String>("BusinessPartnerDebtorGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerBusinessPurpose</b>
     * </p>
     *
     * @return Category of Business Purpose
     */
    @SerializedName( "BusinessPartnerBusinessPurpose" )
    @JsonProperty( "BusinessPartnerBusinessPurpose" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerBusinessPurpose" )
    private String businessPartnerBusinessPurpose;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerBusinessPurpose</b> field to query operations.
     *
     */
    public final static BPFinancialServicesReportingField<String> BUSINESS_PARTNER_BUSINESS_PURPOSE =
        new BPFinancialServicesReportingField<String>("BusinessPartnerBusinessPurpose");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerRiskGroup</b>
     * </p>
     *
     * @return Risk Group
     */
    @SerializedName( "BusinessPartnerRiskGroup" )
    @JsonProperty( "BusinessPartnerRiskGroup" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerRiskGroup" )
    private String businessPartnerRiskGroup;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerRiskGroup</b> field to query operations.
     *
     */
    public final static BPFinancialServicesReportingField<String> BUSINESS_PARTNER_RISK_GROUP =
        new BPFinancialServicesReportingField<String>("BusinessPartnerRiskGroup");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BPRiskGroupingDate</b>
     * </p>
     *
     * @return Date of Risk Grouping
     */
    @SerializedName( "BPRiskGroupingDate" )
    @JsonProperty( "BPRiskGroupingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BPRiskGroupingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime bPRiskGroupingDate;
    /**
     * Use with available fluent helpers to apply the <b>BPRiskGroupingDate</b> field to query operations.
     *
     */
    public final static BPFinancialServicesReportingField<LocalDateTime> BP_RISK_GROUPING_DATE =
        new BPFinancialServicesReportingField<LocalDateTime>("BPRiskGroupingDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BPHasGroupAffiliation</b>
     * </p>
     *
     * @return Group Affiliation Exists
     */
    @SerializedName( "BPHasGroupAffiliation" )
    @JsonProperty( "BPHasGroupAffiliation" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BPHasGroupAffiliation" )
    private Boolean bPHasGroupAffiliation;
    /**
     * Use with available fluent helpers to apply the <b>BPHasGroupAffiliation</b> field to query operations.
     *
     */
    public final static BPFinancialServicesReportingField<Boolean> BP_HAS_GROUP_AFFILIATION =
        new BPFinancialServicesReportingField<Boolean>("BPHasGroupAffiliation");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BPIsMonetaryFinInstitution</b>
     * </p>
     *
     * @return Monetary Financial Institution
     */
    @SerializedName( "BPIsMonetaryFinInstitution" )
    @JsonProperty( "BPIsMonetaryFinInstitution" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BPIsMonetaryFinInstitution" )
    private Boolean bPIsMonetaryFinInstitution;
    /**
     * Use with available fluent helpers to apply the <b>BPIsMonetaryFinInstitution</b> field to query operations.
     *
     */
    public final static BPFinancialServicesReportingField<Boolean> BP_IS_MONETARY_FIN_INSTITUTION =
        new BPFinancialServicesReportingField<Boolean>("BPIsMonetaryFinInstitution");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BPCrdtStandingReviewIsRequired</b>
     * </p>
     *
     * @return Obligation to Submit to Credit Standing Review - Para.18 GBA
     */
    @SerializedName( "BPCrdtStandingReviewIsRequired" )
    @JsonProperty( "BPCrdtStandingReviewIsRequired" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BPCrdtStandingReviewIsRequired" )
    private Boolean bPCrdtStandingReviewIsRequired;
    /**
     * Use with available fluent helpers to apply the <b>BPCrdtStandingReviewIsRequired</b> field to query operations.
     *
     */
    public final static BPFinancialServicesReportingField<Boolean> BP_CRDT_STANDING_REVIEW_IS_REQUIRED =
        new BPFinancialServicesReportingField<Boolean>("BPCrdtStandingReviewIsRequired");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BPLoanMonitoringIsRequired</b>
     * </p>
     *
     * @return Large-Scale Loan Monitoring According to Paragraph 13b GBA
     */
    @SerializedName( "BPLoanMonitoringIsRequired" )
    @JsonProperty( "BPLoanMonitoringIsRequired" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BPLoanMonitoringIsRequired" )
    private Boolean bPLoanMonitoringIsRequired;
    /**
     * Use with available fluent helpers to apply the <b>BPLoanMonitoringIsRequired</b> field to query operations.
     *
     */
    public final static BPFinancialServicesReportingField<Boolean> BP_LOAN_MONITORING_IS_REQUIRED =
        new BPFinancialServicesReportingField<Boolean>("BPLoanMonitoringIsRequired");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BPHasCreditingRelief</b>
     * </p>
     *
     * @return Crediting Relief in Accordance with Paragraph 13/3 GBA
     */
    @SerializedName( "BPHasCreditingRelief" )
    @JsonProperty( "BPHasCreditingRelief" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BPHasCreditingRelief" )
    private Boolean bPHasCreditingRelief;
    /**
     * Use with available fluent helpers to apply the <b>BPHasCreditingRelief</b> field to query operations.
     *
     */
    public final static BPFinancialServicesReportingField<Boolean> BP_HAS_CREDITING_RELIEF =
        new BPFinancialServicesReportingField<Boolean>("BPHasCreditingRelief");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BPInvestInRstrcdAstIsAuthzd</b>
     * </p>
     *
     * @return Authorized Acc. to Para. 2(1)18b of German Asset Regulation
     */
    @SerializedName( "BPInvestInRstrcdAstIsAuthzd" )
    @JsonProperty( "BPInvestInRstrcdAstIsAuthzd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BPInvestInRstrcdAstIsAuthzd" )
    private Boolean bPInvestInRstrcdAstIsAuthzd;
    /**
     * Use with available fluent helpers to apply the <b>BPInvestInRstrcdAstIsAuthzd</b> field to query operations.
     *
     */
    public final static BPFinancialServicesReportingField<Boolean> BP_INVEST_IN_RSTRCD_AST_IS_AUTHZD =
        new BPFinancialServicesReportingField<Boolean>("BPInvestInRstrcdAstIsAuthzd");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BPCentralBankCountryRegion</b>
     * </p>
     *
     * @return Numeric Code for State Central Bank Country/Region Indicator
     */
    @SerializedName( "BPCentralBankCountryRegion" )
    @JsonProperty( "BPCentralBankCountryRegion" )
    @Nullable
    @ODataField( odataName = "BPCentralBankCountryRegion" )
    private String bPCentralBankCountryRegion;
    /**
     * Use with available fluent helpers to apply the <b>BPCentralBankCountryRegion</b> field to query operations.
     *
     */
    public final static BPFinancialServicesReportingField<String> BP_CENTRAL_BANK_COUNTRY_REGION =
        new BPFinancialServicesReportingField<String>("BPCentralBankCountryRegion");

    @Nonnull
    @Override
    public Class<BPFinancialServicesReporting> getType()
    {
        return BPFinancialServicesReporting.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     *
     * @param businessPartner
     *            Business Partner Number
     */
    public void setBusinessPartner( @Nullable final String businessPartner )
    {
        rememberChangedField("BusinessPartner", this.businessPartner);
        this.businessPartner = businessPartner;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BPIsNonResident</b>
     * </p>
     *
     * @param bPIsNonResident
     *            Non-Resident According to Paragraph 4 AWG
     */
    public void setBPIsNonResident( @Nullable final Boolean bPIsNonResident )
    {
        rememberChangedField("BPIsNonResident", this.bPIsNonResident);
        this.bPIsNonResident = bPIsNonResident;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BPNonResidencyStartDate</b>
     * </p>
     *
     * @param bPNonResidencyStartDate
     *            Start of Non-Residency According to Paragraph 4 AWG
     */
    public void setBPNonResidencyStartDate( @Nullable final LocalDateTime bPNonResidencyStartDate )
    {
        rememberChangedField("BPNonResidencyStartDate", this.bPNonResidencyStartDate);
        this.bPNonResidencyStartDate = bPNonResidencyStartDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BPIsMultimillionLoanRecipient</b>
     * </p>
     *
     * @param bPIsMultimillionLoanRecipient
     *            Recipient of Multimillion Loan According to Paragraph 14 GBA
     */
    public void setBPIsMultimillionLoanRecipient( @Nullable final Boolean bPIsMultimillionLoanRecipient )
    {
        rememberChangedField("BPIsMultimillionLoanRecipient", this.bPIsMultimillionLoanRecipient);
        this.bPIsMultimillionLoanRecipient = bPIsMultimillionLoanRecipient;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BPLoanReportingBorrowerNumber</b>
     * </p>
     *
     * @param bPLoanReportingBorrowerNumber
     *            Borrower Number for Reporting a Loan According to GBA
     */
    public void setBPLoanReportingBorrowerNumber( @Nullable final String bPLoanReportingBorrowerNumber )
    {
        rememberChangedField("BPLoanReportingBorrowerNumber", this.bPLoanReportingBorrowerNumber);
        this.bPLoanReportingBorrowerNumber = bPLoanReportingBorrowerNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BPLoanRptgBorrowerEntityNumber</b>
     * </p>
     *
     * @param bPLoanRptgBorrowerEntityNumber
     *            Borrower Entity Number Used to Report Loan acc. to GBA
     */
    public void setBPLoanRptgBorrowerEntityNumber( @Nullable final String bPLoanRptgBorrowerEntityNumber )
    {
        rememberChangedField("BPLoanRptgBorrowerEntityNumber", this.bPLoanRptgBorrowerEntityNumber);
        this.bPLoanRptgBorrowerEntityNumber = bPLoanRptgBorrowerEntityNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BPCreditStandingReview</b>
     * </p>
     *
     * @param bPCreditStandingReview
     *            Credit Standing Review According to Paragraph 18 GBA
     */
    public void setBPCreditStandingReview( @Nullable final String bPCreditStandingReview )
    {
        rememberChangedField("BPCreditStandingReview", this.bPCreditStandingReview);
        this.bPCreditStandingReview = bPCreditStandingReview;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BPCreditStandingReviewDate</b>
     * </p>
     *
     * @param bPCreditStandingReviewDate
     *            Date of Credit Standing Review According to Paragraph 18 GBA
     */
    public void setBPCreditStandingReviewDate( @Nullable final LocalDateTime bPCreditStandingReviewDate )
    {
        rememberChangedField("BPCreditStandingReviewDate", this.bPCreditStandingReviewDate);
        this.bPCreditStandingReviewDate = bPCreditStandingReviewDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerLoanToManager</b>
     * </p>
     *
     * @param businessPartnerLoanToManager
     *            Loan to Manager According to Paragraph 15 German Banking Act
     */
    public void setBusinessPartnerLoanToManager( @Nullable final String businessPartnerLoanToManager )
    {
        rememberChangedField("BusinessPartnerLoanToManager", this.businessPartnerLoanToManager);
        this.businessPartnerLoanToManager = businessPartnerLoanToManager;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BPCompanyRelationship</b>
     * </p>
     *
     * @param bPCompanyRelationship
     *            Organization Relationship
     */
    public void setBPCompanyRelationship( @Nullable final String bPCompanyRelationship )
    {
        rememberChangedField("BPCompanyRelationship", this.bPCompanyRelationship);
        this.bPCompanyRelationship = bPCompanyRelationship;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BPLoanReportingCreditorNumber</b>
     * </p>
     *
     * @param bPLoanReportingCreditorNumber
     *            Creditor Number for Reporting a Loan According to GBA
     */
    public void setBPLoanReportingCreditorNumber( @Nullable final String bPLoanReportingCreditorNumber )
    {
        rememberChangedField("BPLoanReportingCreditorNumber", this.bPLoanReportingCreditorNumber);
        this.bPLoanReportingCreditorNumber = bPLoanReportingCreditorNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 11
     * <p>
     * Original property name from the Odata EDM: <b>BPOeNBIdentNumber</b>
     * </p>
     *
     * @param bPOeNBIdentNumber
     *            (OeNB) Ident Number
     */
    public void setBPOeNBIdentNumber( @Nullable final String bPOeNBIdentNumber )
    {
        rememberChangedField("BPOeNBIdentNumber", this.bPOeNBIdentNumber);
        this.bPOeNBIdentNumber = bPOeNBIdentNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BPOeNBTargetGroup</b>
     * </p>
     *
     * @param bPOeNBTargetGroup
     *            Target Group According to OeNB
     */
    public void setBPOeNBTargetGroup( @Nullable final String bPOeNBTargetGroup )
    {
        rememberChangedField("BPOeNBTargetGroup", this.bPOeNBTargetGroup);
        this.bPOeNBTargetGroup = bPOeNBTargetGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BPOeNBIdentNumberAssigned</b>
     * </p>
     *
     * @param bPOeNBIdentNumberAssigned
     *            Assign (OeNB) Ident Number
     */
    public void setBPOeNBIdentNumberAssigned( @Nullable final String bPOeNBIdentNumberAssigned )
    {
        rememberChangedField("BPOeNBIdentNumberAssigned", this.bPOeNBIdentNumberAssigned);
        this.bPOeNBIdentNumberAssigned = bPOeNBIdentNumberAssigned;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>BPOeNBInstituteNumber</b>
     * </p>
     *
     * @param bPOeNBInstituteNumber
     *            Institute Number According to OeNB
     */
    public void setBPOeNBInstituteNumber( @Nullable final String bPOeNBInstituteNumber )
    {
        rememberChangedField("BPOeNBInstituteNumber", this.bPOeNBInstituteNumber);
        this.bPOeNBInstituteNumber = bPOeNBInstituteNumber;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerIsOeNBInstitute</b>
     * </p>
     *
     * @param businessPartnerIsOeNBInstitute
     *            Institute Subject to Austrian Reg. Reporting Requirements
     */
    public void setBusinessPartnerIsOeNBInstitute( @Nullable final Boolean businessPartnerIsOeNBInstitute )
    {
        rememberChangedField("BusinessPartnerIsOeNBInstitute", this.businessPartnerIsOeNBInstitute);
        this.businessPartnerIsOeNBInstitute = businessPartnerIsOeNBInstitute;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerGroup</b>
     * </p>
     *
     * @param businessPartnerGroup
     *            Group ID
     */
    public void setBusinessPartnerGroup( @Nullable final String businessPartnerGroup )
    {
        rememberChangedField("BusinessPartnerGroup", this.businessPartnerGroup);
        this.businessPartnerGroup = businessPartnerGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BPGroupAssignmentCategory</b>
     * </p>
     *
     * @param bPGroupAssignmentCategory
     *            Group Assignment Category
     */
    public void setBPGroupAssignmentCategory( @Nullable final String bPGroupAssignmentCategory )
    {
        rememberChangedField("BPGroupAssignmentCategory", this.bPGroupAssignmentCategory);
        this.bPGroupAssignmentCategory = bPGroupAssignmentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerGroupName</b>
     * </p>
     *
     * @param businessPartnerGroupName
     *            Group Name
     */
    public void setBusinessPartnerGroupName( @Nullable final String businessPartnerGroupName )
    {
        rememberChangedField("BusinessPartnerGroupName", this.businessPartnerGroupName);
        this.businessPartnerGroupName = businessPartnerGroupName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerLegalEntity</b>
     * </p>
     *
     * @param businessPartnerLegalEntity
     *            Legal Entity for Business Partner
     */
    public void setBusinessPartnerLegalEntity( @Nullable final String businessPartnerLegalEntity )
    {
        rememberChangedField("BusinessPartnerLegalEntity", this.businessPartnerLegalEntity);
        this.businessPartnerLegalEntity = businessPartnerLegalEntity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BPGerAstRglnRestrictedAstQuota</b>
     * </p>
     *
     * @param bPGerAstRglnRestrictedAstQuota
     *            Business Partner Acc. to Para. 4, Sec. 2 of Asset Regulation
     */
    public void setBPGerAstRglnRestrictedAstQuota( @Nullable final String bPGerAstRglnRestrictedAstQuota )
    {
        rememberChangedField("BPGerAstRglnRestrictedAstQuota", this.bPGerAstRglnRestrictedAstQuota);
        this.bPGerAstRglnRestrictedAstQuota = bPGerAstRglnRestrictedAstQuota;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerDebtorGroup</b>
     * </p>
     *
     * @param businessPartnerDebtorGroup
     *            Debtor Group According to German Law (BerVersV, Template 5)
     */
    public void setBusinessPartnerDebtorGroup( @Nullable final String businessPartnerDebtorGroup )
    {
        rememberChangedField("BusinessPartnerDebtorGroup", this.businessPartnerDebtorGroup);
        this.businessPartnerDebtorGroup = businessPartnerDebtorGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerBusinessPurpose</b>
     * </p>
     *
     * @param businessPartnerBusinessPurpose
     *            Category of Business Purpose
     */
    public void setBusinessPartnerBusinessPurpose( @Nullable final String businessPartnerBusinessPurpose )
    {
        rememberChangedField("BusinessPartnerBusinessPurpose", this.businessPartnerBusinessPurpose);
        this.businessPartnerBusinessPurpose = businessPartnerBusinessPurpose;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerRiskGroup</b>
     * </p>
     *
     * @param businessPartnerRiskGroup
     *            Risk Group
     */
    public void setBusinessPartnerRiskGroup( @Nullable final String businessPartnerRiskGroup )
    {
        rememberChangedField("BusinessPartnerRiskGroup", this.businessPartnerRiskGroup);
        this.businessPartnerRiskGroup = businessPartnerRiskGroup;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BPRiskGroupingDate</b>
     * </p>
     *
     * @param bPRiskGroupingDate
     *            Date of Risk Grouping
     */
    public void setBPRiskGroupingDate( @Nullable final LocalDateTime bPRiskGroupingDate )
    {
        rememberChangedField("BPRiskGroupingDate", this.bPRiskGroupingDate);
        this.bPRiskGroupingDate = bPRiskGroupingDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BPHasGroupAffiliation</b>
     * </p>
     *
     * @param bPHasGroupAffiliation
     *            Group Affiliation Exists
     */
    public void setBPHasGroupAffiliation( @Nullable final Boolean bPHasGroupAffiliation )
    {
        rememberChangedField("BPHasGroupAffiliation", this.bPHasGroupAffiliation);
        this.bPHasGroupAffiliation = bPHasGroupAffiliation;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BPIsMonetaryFinInstitution</b>
     * </p>
     *
     * @param bPIsMonetaryFinInstitution
     *            Monetary Financial Institution
     */
    public void setBPIsMonetaryFinInstitution( @Nullable final Boolean bPIsMonetaryFinInstitution )
    {
        rememberChangedField("BPIsMonetaryFinInstitution", this.bPIsMonetaryFinInstitution);
        this.bPIsMonetaryFinInstitution = bPIsMonetaryFinInstitution;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BPCrdtStandingReviewIsRequired</b>
     * </p>
     *
     * @param bPCrdtStandingReviewIsRequired
     *            Obligation to Submit to Credit Standing Review - Para.18 GBA
     */
    public void setBPCrdtStandingReviewIsRequired( @Nullable final Boolean bPCrdtStandingReviewIsRequired )
    {
        rememberChangedField("BPCrdtStandingReviewIsRequired", this.bPCrdtStandingReviewIsRequired);
        this.bPCrdtStandingReviewIsRequired = bPCrdtStandingReviewIsRequired;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BPLoanMonitoringIsRequired</b>
     * </p>
     *
     * @param bPLoanMonitoringIsRequired
     *            Large-Scale Loan Monitoring According to Paragraph 13b GBA
     */
    public void setBPLoanMonitoringIsRequired( @Nullable final Boolean bPLoanMonitoringIsRequired )
    {
        rememberChangedField("BPLoanMonitoringIsRequired", this.bPLoanMonitoringIsRequired);
        this.bPLoanMonitoringIsRequired = bPLoanMonitoringIsRequired;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BPHasCreditingRelief</b>
     * </p>
     *
     * @param bPHasCreditingRelief
     *            Crediting Relief in Accordance with Paragraph 13/3 GBA
     */
    public void setBPHasCreditingRelief( @Nullable final Boolean bPHasCreditingRelief )
    {
        rememberChangedField("BPHasCreditingRelief", this.bPHasCreditingRelief);
        this.bPHasCreditingRelief = bPHasCreditingRelief;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BPInvestInRstrcdAstIsAuthzd</b>
     * </p>
     *
     * @param bPInvestInRstrcdAstIsAuthzd
     *            Authorized Acc. to Para. 2(1)18b of German Asset Regulation
     */
    public void setBPInvestInRstrcdAstIsAuthzd( @Nullable final Boolean bPInvestInRstrcdAstIsAuthzd )
    {
        rememberChangedField("BPInvestInRstrcdAstIsAuthzd", this.bPInvestInRstrcdAstIsAuthzd);
        this.bPInvestInRstrcdAstIsAuthzd = bPInvestInRstrcdAstIsAuthzd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BPCentralBankCountryRegion</b>
     * </p>
     *
     * @param bPCentralBankCountryRegion
     *            Numeric Code for State Central Bank Country/Region Indicator
     */
    public void setBPCentralBankCountryRegion( @Nullable final String bPCentralBankCountryRegion )
    {
        rememberChangedField("BPCentralBankCountryRegion", this.bPCentralBankCountryRegion);
        this.bPCentralBankCountryRegion = bPCentralBankCountryRegion;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BPFinancialServicesReporting";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BusinessPartner", getBusinessPartner());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BusinessPartner", getBusinessPartner());
        values.put("BPIsNonResident", getBPIsNonResident());
        values.put("BPNonResidencyStartDate", getBPNonResidencyStartDate());
        values.put("BPIsMultimillionLoanRecipient", getBPIsMultimillionLoanRecipient());
        values.put("BPLoanReportingBorrowerNumber", getBPLoanReportingBorrowerNumber());
        values.put("BPLoanRptgBorrowerEntityNumber", getBPLoanRptgBorrowerEntityNumber());
        values.put("BPCreditStandingReview", getBPCreditStandingReview());
        values.put("BPCreditStandingReviewDate", getBPCreditStandingReviewDate());
        values.put("BusinessPartnerLoanToManager", getBusinessPartnerLoanToManager());
        values.put("BPCompanyRelationship", getBPCompanyRelationship());
        values.put("BPLoanReportingCreditorNumber", getBPLoanReportingCreditorNumber());
        values.put("BPOeNBIdentNumber", getBPOeNBIdentNumber());
        values.put("BPOeNBTargetGroup", getBPOeNBTargetGroup());
        values.put("BPOeNBIdentNumberAssigned", getBPOeNBIdentNumberAssigned());
        values.put("BPOeNBInstituteNumber", getBPOeNBInstituteNumber());
        values.put("BusinessPartnerIsOeNBInstitute", getBusinessPartnerIsOeNBInstitute());
        values.put("BusinessPartnerGroup", getBusinessPartnerGroup());
        values.put("BPGroupAssignmentCategory", getBPGroupAssignmentCategory());
        values.put("BusinessPartnerGroupName", getBusinessPartnerGroupName());
        values.put("BusinessPartnerLegalEntity", getBusinessPartnerLegalEntity());
        values.put("BPGerAstRglnRestrictedAstQuota", getBPGerAstRglnRestrictedAstQuota());
        values.put("BusinessPartnerDebtorGroup", getBusinessPartnerDebtorGroup());
        values.put("BusinessPartnerBusinessPurpose", getBusinessPartnerBusinessPurpose());
        values.put("BusinessPartnerRiskGroup", getBusinessPartnerRiskGroup());
        values.put("BPRiskGroupingDate", getBPRiskGroupingDate());
        values.put("BPHasGroupAffiliation", getBPHasGroupAffiliation());
        values.put("BPIsMonetaryFinInstitution", getBPIsMonetaryFinInstitution());
        values.put("BPCrdtStandingReviewIsRequired", getBPCrdtStandingReviewIsRequired());
        values.put("BPLoanMonitoringIsRequired", getBPLoanMonitoringIsRequired());
        values.put("BPHasCreditingRelief", getBPHasCreditingRelief());
        values.put("BPInvestInRstrcdAstIsAuthzd", getBPInvestInRstrcdAstIsAuthzd());
        values.put("BPCentralBankCountryRegion", getBPCentralBankCountryRegion());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BusinessPartner") ) {
                final Object value = values.remove("BusinessPartner");
                if( (value == null) || (!value.equals(getBusinessPartner())) ) {
                    setBusinessPartner(((String) value));
                }
            }
            if( values.containsKey("BPIsNonResident") ) {
                final Object value = values.remove("BPIsNonResident");
                if( (value == null) || (!value.equals(getBPIsNonResident())) ) {
                    setBPIsNonResident(((Boolean) value));
                }
            }
            if( values.containsKey("BPNonResidencyStartDate") ) {
                final Object value = values.remove("BPNonResidencyStartDate");
                if( (value == null) || (!value.equals(getBPNonResidencyStartDate())) ) {
                    setBPNonResidencyStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BPIsMultimillionLoanRecipient") ) {
                final Object value = values.remove("BPIsMultimillionLoanRecipient");
                if( (value == null) || (!value.equals(getBPIsMultimillionLoanRecipient())) ) {
                    setBPIsMultimillionLoanRecipient(((Boolean) value));
                }
            }
            if( values.containsKey("BPLoanReportingBorrowerNumber") ) {
                final Object value = values.remove("BPLoanReportingBorrowerNumber");
                if( (value == null) || (!value.equals(getBPLoanReportingBorrowerNumber())) ) {
                    setBPLoanReportingBorrowerNumber(((String) value));
                }
            }
            if( values.containsKey("BPLoanRptgBorrowerEntityNumber") ) {
                final Object value = values.remove("BPLoanRptgBorrowerEntityNumber");
                if( (value == null) || (!value.equals(getBPLoanRptgBorrowerEntityNumber())) ) {
                    setBPLoanRptgBorrowerEntityNumber(((String) value));
                }
            }
            if( values.containsKey("BPCreditStandingReview") ) {
                final Object value = values.remove("BPCreditStandingReview");
                if( (value == null) || (!value.equals(getBPCreditStandingReview())) ) {
                    setBPCreditStandingReview(((String) value));
                }
            }
            if( values.containsKey("BPCreditStandingReviewDate") ) {
                final Object value = values.remove("BPCreditStandingReviewDate");
                if( (value == null) || (!value.equals(getBPCreditStandingReviewDate())) ) {
                    setBPCreditStandingReviewDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BusinessPartnerLoanToManager") ) {
                final Object value = values.remove("BusinessPartnerLoanToManager");
                if( (value == null) || (!value.equals(getBusinessPartnerLoanToManager())) ) {
                    setBusinessPartnerLoanToManager(((String) value));
                }
            }
            if( values.containsKey("BPCompanyRelationship") ) {
                final Object value = values.remove("BPCompanyRelationship");
                if( (value == null) || (!value.equals(getBPCompanyRelationship())) ) {
                    setBPCompanyRelationship(((String) value));
                }
            }
            if( values.containsKey("BPLoanReportingCreditorNumber") ) {
                final Object value = values.remove("BPLoanReportingCreditorNumber");
                if( (value == null) || (!value.equals(getBPLoanReportingCreditorNumber())) ) {
                    setBPLoanReportingCreditorNumber(((String) value));
                }
            }
            if( values.containsKey("BPOeNBIdentNumber") ) {
                final Object value = values.remove("BPOeNBIdentNumber");
                if( (value == null) || (!value.equals(getBPOeNBIdentNumber())) ) {
                    setBPOeNBIdentNumber(((String) value));
                }
            }
            if( values.containsKey("BPOeNBTargetGroup") ) {
                final Object value = values.remove("BPOeNBTargetGroup");
                if( (value == null) || (!value.equals(getBPOeNBTargetGroup())) ) {
                    setBPOeNBTargetGroup(((String) value));
                }
            }
            if( values.containsKey("BPOeNBIdentNumberAssigned") ) {
                final Object value = values.remove("BPOeNBIdentNumberAssigned");
                if( (value == null) || (!value.equals(getBPOeNBIdentNumberAssigned())) ) {
                    setBPOeNBIdentNumberAssigned(((String) value));
                }
            }
            if( values.containsKey("BPOeNBInstituteNumber") ) {
                final Object value = values.remove("BPOeNBInstituteNumber");
                if( (value == null) || (!value.equals(getBPOeNBInstituteNumber())) ) {
                    setBPOeNBInstituteNumber(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerIsOeNBInstitute") ) {
                final Object value = values.remove("BusinessPartnerIsOeNBInstitute");
                if( (value == null) || (!value.equals(getBusinessPartnerIsOeNBInstitute())) ) {
                    setBusinessPartnerIsOeNBInstitute(((Boolean) value));
                }
            }
            if( values.containsKey("BusinessPartnerGroup") ) {
                final Object value = values.remove("BusinessPartnerGroup");
                if( (value == null) || (!value.equals(getBusinessPartnerGroup())) ) {
                    setBusinessPartnerGroup(((String) value));
                }
            }
            if( values.containsKey("BPGroupAssignmentCategory") ) {
                final Object value = values.remove("BPGroupAssignmentCategory");
                if( (value == null) || (!value.equals(getBPGroupAssignmentCategory())) ) {
                    setBPGroupAssignmentCategory(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerGroupName") ) {
                final Object value = values.remove("BusinessPartnerGroupName");
                if( (value == null) || (!value.equals(getBusinessPartnerGroupName())) ) {
                    setBusinessPartnerGroupName(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerLegalEntity") ) {
                final Object value = values.remove("BusinessPartnerLegalEntity");
                if( (value == null) || (!value.equals(getBusinessPartnerLegalEntity())) ) {
                    setBusinessPartnerLegalEntity(((String) value));
                }
            }
            if( values.containsKey("BPGerAstRglnRestrictedAstQuota") ) {
                final Object value = values.remove("BPGerAstRglnRestrictedAstQuota");
                if( (value == null) || (!value.equals(getBPGerAstRglnRestrictedAstQuota())) ) {
                    setBPGerAstRglnRestrictedAstQuota(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerDebtorGroup") ) {
                final Object value = values.remove("BusinessPartnerDebtorGroup");
                if( (value == null) || (!value.equals(getBusinessPartnerDebtorGroup())) ) {
                    setBusinessPartnerDebtorGroup(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerBusinessPurpose") ) {
                final Object value = values.remove("BusinessPartnerBusinessPurpose");
                if( (value == null) || (!value.equals(getBusinessPartnerBusinessPurpose())) ) {
                    setBusinessPartnerBusinessPurpose(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerRiskGroup") ) {
                final Object value = values.remove("BusinessPartnerRiskGroup");
                if( (value == null) || (!value.equals(getBusinessPartnerRiskGroup())) ) {
                    setBusinessPartnerRiskGroup(((String) value));
                }
            }
            if( values.containsKey("BPRiskGroupingDate") ) {
                final Object value = values.remove("BPRiskGroupingDate");
                if( (value == null) || (!value.equals(getBPRiskGroupingDate())) ) {
                    setBPRiskGroupingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BPHasGroupAffiliation") ) {
                final Object value = values.remove("BPHasGroupAffiliation");
                if( (value == null) || (!value.equals(getBPHasGroupAffiliation())) ) {
                    setBPHasGroupAffiliation(((Boolean) value));
                }
            }
            if( values.containsKey("BPIsMonetaryFinInstitution") ) {
                final Object value = values.remove("BPIsMonetaryFinInstitution");
                if( (value == null) || (!value.equals(getBPIsMonetaryFinInstitution())) ) {
                    setBPIsMonetaryFinInstitution(((Boolean) value));
                }
            }
            if( values.containsKey("BPCrdtStandingReviewIsRequired") ) {
                final Object value = values.remove("BPCrdtStandingReviewIsRequired");
                if( (value == null) || (!value.equals(getBPCrdtStandingReviewIsRequired())) ) {
                    setBPCrdtStandingReviewIsRequired(((Boolean) value));
                }
            }
            if( values.containsKey("BPLoanMonitoringIsRequired") ) {
                final Object value = values.remove("BPLoanMonitoringIsRequired");
                if( (value == null) || (!value.equals(getBPLoanMonitoringIsRequired())) ) {
                    setBPLoanMonitoringIsRequired(((Boolean) value));
                }
            }
            if( values.containsKey("BPHasCreditingRelief") ) {
                final Object value = values.remove("BPHasCreditingRelief");
                if( (value == null) || (!value.equals(getBPHasCreditingRelief())) ) {
                    setBPHasCreditingRelief(((Boolean) value));
                }
            }
            if( values.containsKey("BPInvestInRstrcdAstIsAuthzd") ) {
                final Object value = values.remove("BPInvestInRstrcdAstIsAuthzd");
                if( (value == null) || (!value.equals(getBPInvestInRstrcdAstIsAuthzd())) ) {
                    setBPInvestInRstrcdAstIsAuthzd(((Boolean) value));
                }
            }
            if( values.containsKey("BPCentralBankCountryRegion") ) {
                final Object value = values.remove("BPCentralBankCountryRegion");
                if( (value == null) || (!value.equals(getBPCentralBankCountryRegion())) ) {
                    setBPCentralBankCountryRegion(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BPFinancialServicesReportingField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new BPFinancialServicesReportingField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BPFinancialServicesReportingField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BPFinancialServicesReportingField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessPartnerService.DEFAULT_SERVICE_PATH);
    }

}
