/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.field.BPFiscalYearInformationField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.selectable.BPFiscalYearInformationSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Fiscal Year Information
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BPFiscalYearInformationType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BPFiscalYearInformation extends VdmEntity<BPFiscalYearInformation>
{

    /**
     * Selector for all available fields of BPFiscalYearInformation.
     *
     */
    public final static BPFiscalYearInformationSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     *
     * @return Business Partner Number
     */
    @Key
    @SerializedName( "BusinessPartner" )
    @JsonProperty( "BusinessPartner" )
    @Nullable
    @ODataField( odataName = "BusinessPartner" )
    private String businessPartner;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartner</b> field to query operations.
     *
     */
    public final static BPFiscalYearInformationField<String> BUSINESS_PARTNER =
        new BPFiscalYearInformationField<String>("BusinessPartner");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerFiscalYear</b>
     * </p>
     *
     * @return Fiscal year
     */
    @Key
    @SerializedName( "BusinessPartnerFiscalYear" )
    @JsonProperty( "BusinessPartnerFiscalYear" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerFiscalYear" )
    private String businessPartnerFiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerFiscalYear</b> field to query operations.
     *
     */
    public final static BPFiscalYearInformationField<String> BUSINESS_PARTNER_FISCAL_YEAR =
        new BPFiscalYearInformationField<String>("BusinessPartnerFiscalYear");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>BPBalanceSheetCurrency</b>
     * </p>
     *
     * @return Balance Sheet Currency
     */
    @SerializedName( "BPBalanceSheetCurrency" )
    @JsonProperty( "BPBalanceSheetCurrency" )
    @Nullable
    @ODataField( odataName = "BPBalanceSheetCurrency" )
    private String bPBalanceSheetCurrency;
    /**
     * Use with available fluent helpers to apply the <b>BPBalanceSheetCurrency</b> field to query operations.
     *
     */
    public final static BPFiscalYearInformationField<String> BP_BALANCE_SHEET_CURRENCY =
        new BPFiscalYearInformationField<String>("BPBalanceSheetCurrency");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BPAnnualStockholderMeetingDate</b>
     * </p>
     *
     * @return Date of Annual Stockholders Meeting
     */
    @SerializedName( "BPAnnualStockholderMeetingDate" )
    @JsonProperty( "BPAnnualStockholderMeetingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BPAnnualStockholderMeetingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime bPAnnualStockholderMeetingDate;
    /**
     * Use with available fluent helpers to apply the <b>BPAnnualStockholderMeetingDate</b> field to query operations.
     *
     */
    public final static BPFiscalYearInformationField<LocalDateTime> BP_ANNUAL_STOCKHOLDER_MEETING_DATE =
        new BPFiscalYearInformationField<LocalDateTime>("BPAnnualStockholderMeetingDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BPFiscalYearStartDate</b>
     * </p>
     *
     * @return Fiscal Year Start Date
     */
    @SerializedName( "BPFiscalYearStartDate" )
    @JsonProperty( "BPFiscalYearStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BPFiscalYearStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime bPFiscalYearStartDate;
    /**
     * Use with available fluent helpers to apply the <b>BPFiscalYearStartDate</b> field to query operations.
     *
     */
    public final static BPFiscalYearInformationField<LocalDateTime> BP_FISCAL_YEAR_START_DATE =
        new BPFiscalYearInformationField<LocalDateTime>("BPFiscalYearStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BPFiscalYearEndDate</b>
     * </p>
     *
     * @return Fiscal Year End Date
     */
    @SerializedName( "BPFiscalYearEndDate" )
    @JsonProperty( "BPFiscalYearEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BPFiscalYearEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime bPFiscalYearEndDate;
    /**
     * Use with available fluent helpers to apply the <b>BPFiscalYearEndDate</b> field to query operations.
     *
     */
    public final static BPFiscalYearInformationField<LocalDateTime> BP_FISCAL_YEAR_END_DATE =
        new BPFiscalYearInformationField<LocalDateTime>("BPFiscalYearEndDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BPFiscalYearIsClosed</b>
     * </p>
     *
     * @return Year-End Closing
     */
    @SerializedName( "BPFiscalYearIsClosed" )
    @JsonProperty( "BPFiscalYearIsClosed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BPFiscalYearIsClosed" )
    private Boolean bPFiscalYearIsClosed;
    /**
     * Use with available fluent helpers to apply the <b>BPFiscalYearIsClosed</b> field to query operations.
     *
     */
    public final static BPFiscalYearInformationField<Boolean> BP_FISCAL_YEAR_IS_CLOSED =
        new BPFiscalYearInformationField<Boolean>("BPFiscalYearIsClosed");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BPFiscalYearClosingDate</b>
     * </p>
     *
     * @return Year-End Closing Date for Fiscal Year
     */
    @SerializedName( "BPFiscalYearClosingDate" )
    @JsonProperty( "BPFiscalYearClosingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BPFiscalYearClosingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime bPFiscalYearClosingDate;
    /**
     * Use with available fluent helpers to apply the <b>BPFiscalYearClosingDate</b> field to query operations.
     *
     */
    public final static BPFiscalYearInformationField<LocalDateTime> BP_FISCAL_YEAR_CLOSING_DATE =
        new BPFiscalYearInformationField<LocalDateTime>("BPFiscalYearClosingDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BPFsclYrCnsldtdFinStatementDte</b>
     * </p>
     *
     * @return Date of Consolidated Financial Statements of Group Company
     */
    @SerializedName( "BPFsclYrCnsldtdFinStatementDte" )
    @JsonProperty( "BPFsclYrCnsldtdFinStatementDte" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BPFsclYrCnsldtdFinStatementDte",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime bPFsclYrCnsldtdFinStatementDte;
    /**
     * Use with available fluent helpers to apply the <b>BPFsclYrCnsldtdFinStatementDte</b> field to query operations.
     *
     */
    public final static BPFiscalYearInformationField<LocalDateTime> BP_FSCL_YR_CNSLDTD_FIN_STATEMENT_DTE =
        new BPFiscalYearInformationField<LocalDateTime>("BPFsclYrCnsldtdFinStatementDte");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPCapitalStockAmtInBalShtCrcy</b>
     * </p>
     *
     * @return Amount of Authorized Capital Stock for Company
     */
    @SerializedName( "BPCapitalStockAmtInBalShtCrcy" )
    @JsonProperty( "BPCapitalStockAmtInBalShtCrcy" )
    @Nullable
    @ODataField( odataName = "BPCapitalStockAmtInBalShtCrcy" )
    private BigDecimal bPCapitalStockAmtInBalShtCrcy;
    /**
     * Use with available fluent helpers to apply the <b>BPCapitalStockAmtInBalShtCrcy</b> field to query operations.
     *
     */
    public final static BPFiscalYearInformationField<BigDecimal> BP_CAPITAL_STOCK_AMT_IN_BAL_SHT_CRCY =
        new BPFiscalYearInformationField<BigDecimal>("BPCapitalStockAmtInBalShtCrcy");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPIssdStockCptlAmtInBalShtCrcy</b>
     * </p>
     *
     * @return Amount of Issued Stock Capital for Company
     */
    @SerializedName( "BPIssdStockCptlAmtInBalShtCrcy" )
    @JsonProperty( "BPIssdStockCptlAmtInBalShtCrcy" )
    @Nullable
    @ODataField( odataName = "BPIssdStockCptlAmtInBalShtCrcy" )
    private BigDecimal bPIssdStockCptlAmtInBalShtCrcy;
    /**
     * Use with available fluent helpers to apply the <b>BPIssdStockCptlAmtInBalShtCrcy</b> field to query operations.
     *
     */
    public final static BPFiscalYearInformationField<BigDecimal> BP_ISSD_STOCK_CPTL_AMT_IN_BAL_SHT_CRCY =
        new BPFiscalYearInformationField<BigDecimal>("BPIssdStockCptlAmtInBalShtCrcy");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPPartcipnCertAmtInBalShtCrcy</b>
     * </p>
     *
     * @return Amount of Participation Certificates Outstanding for Company
     */
    @SerializedName( "BPPartcipnCertAmtInBalShtCrcy" )
    @JsonProperty( "BPPartcipnCertAmtInBalShtCrcy" )
    @Nullable
    @ODataField( odataName = "BPPartcipnCertAmtInBalShtCrcy" )
    private BigDecimal bPPartcipnCertAmtInBalShtCrcy;
    /**
     * Use with available fluent helpers to apply the <b>BPPartcipnCertAmtInBalShtCrcy</b> field to query operations.
     *
     */
    public final static BPFiscalYearInformationField<BigDecimal> BP_PARTCIPN_CERT_AMT_IN_BAL_SHT_CRCY =
        new BPFiscalYearInformationField<BigDecimal>("BPPartcipnCertAmtInBalShtCrcy");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPEquityCapitalAmtInBalShtCrcy</b>
     * </p>
     *
     * @return Amount of Equity Capital for Company
     */
    @SerializedName( "BPEquityCapitalAmtInBalShtCrcy" )
    @JsonProperty( "BPEquityCapitalAmtInBalShtCrcy" )
    @Nullable
    @ODataField( odataName = "BPEquityCapitalAmtInBalShtCrcy" )
    private BigDecimal bPEquityCapitalAmtInBalShtCrcy;
    /**
     * Use with available fluent helpers to apply the <b>BPEquityCapitalAmtInBalShtCrcy</b> field to query operations.
     *
     */
    public final static BPFiscalYearInformationField<BigDecimal> BP_EQUITY_CAPITAL_AMT_IN_BAL_SHT_CRCY =
        new BPFiscalYearInformationField<BigDecimal>("BPEquityCapitalAmtInBalShtCrcy");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPGrossPremiumAmtInBalShtCrcy</b>
     * </p>
     *
     * @return Gross Premium
     */
    @SerializedName( "BPGrossPremiumAmtInBalShtCrcy" )
    @JsonProperty( "BPGrossPremiumAmtInBalShtCrcy" )
    @Nullable
    @ODataField( odataName = "BPGrossPremiumAmtInBalShtCrcy" )
    private BigDecimal bPGrossPremiumAmtInBalShtCrcy;
    /**
     * Use with available fluent helpers to apply the <b>BPGrossPremiumAmtInBalShtCrcy</b> field to query operations.
     *
     */
    public final static BPFiscalYearInformationField<BigDecimal> BP_GROSS_PREMIUM_AMT_IN_BAL_SHT_CRCY =
        new BPFiscalYearInformationField<BigDecimal>("BPGrossPremiumAmtInBalShtCrcy");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPNetPremiumAmtInBalShtCrcy</b>
     * </p>
     *
     * @return Net Premium
     */
    @SerializedName( "BPNetPremiumAmtInBalShtCrcy" )
    @JsonProperty( "BPNetPremiumAmtInBalShtCrcy" )
    @Nullable
    @ODataField( odataName = "BPNetPremiumAmtInBalShtCrcy" )
    private BigDecimal bPNetPremiumAmtInBalShtCrcy;
    /**
     * Use with available fluent helpers to apply the <b>BPNetPremiumAmtInBalShtCrcy</b> field to query operations.
     *
     */
    public final static BPFiscalYearInformationField<BigDecimal> BP_NET_PREMIUM_AMT_IN_BAL_SHT_CRCY =
        new BPFiscalYearInformationField<BigDecimal>("BPNetPremiumAmtInBalShtCrcy");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPAnnualSalesAmtInBalShtCrcy</b>
     * </p>
     *
     * @return Amount of Annual Sales for Company
     */
    @SerializedName( "BPAnnualSalesAmtInBalShtCrcy" )
    @JsonProperty( "BPAnnualSalesAmtInBalShtCrcy" )
    @Nullable
    @ODataField( odataName = "BPAnnualSalesAmtInBalShtCrcy" )
    private BigDecimal bPAnnualSalesAmtInBalShtCrcy;
    /**
     * Use with available fluent helpers to apply the <b>BPAnnualSalesAmtInBalShtCrcy</b> field to query operations.
     *
     */
    public final static BPFiscalYearInformationField<BigDecimal> BP_ANNUAL_SALES_AMT_IN_BAL_SHT_CRCY =
        new BPFiscalYearInformationField<BigDecimal>("BPAnnualSalesAmtInBalShtCrcy");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPAnnualNetIncAmtInBalShtCrcy</b>
     * </p>
     *
     * @return Amount of Annual Net Income/Net Loss for Company
     */
    @SerializedName( "BPAnnualNetIncAmtInBalShtCrcy" )
    @JsonProperty( "BPAnnualNetIncAmtInBalShtCrcy" )
    @Nullable
    @ODataField( odataName = "BPAnnualNetIncAmtInBalShtCrcy" )
    private BigDecimal bPAnnualNetIncAmtInBalShtCrcy;
    /**
     * Use with available fluent helpers to apply the <b>BPAnnualNetIncAmtInBalShtCrcy</b> field to query operations.
     *
     */
    public final static BPFiscalYearInformationField<BigDecimal> BP_ANNUAL_NET_INC_AMT_IN_BAL_SHT_CRCY =
        new BPFiscalYearInformationField<BigDecimal>("BPAnnualNetIncAmtInBalShtCrcy");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPDividendDistrAmtInBalShtCrcy</b>
     * </p>
     *
     * @return Dividend/Profit Distribution Amount for Company
     */
    @SerializedName( "BPDividendDistrAmtInBalShtCrcy" )
    @JsonProperty( "BPDividendDistrAmtInBalShtCrcy" )
    @Nullable
    @ODataField( odataName = "BPDividendDistrAmtInBalShtCrcy" )
    private BigDecimal bPDividendDistrAmtInBalShtCrcy;
    /**
     * Use with available fluent helpers to apply the <b>BPDividendDistrAmtInBalShtCrcy</b> field to query operations.
     *
     */
    public final static BPFiscalYearInformationField<BigDecimal> BP_DIVIDEND_DISTR_AMT_IN_BAL_SHT_CRCY =
        new BPFiscalYearInformationField<BigDecimal>("BPDividendDistrAmtInBalShtCrcy");
    /**
     * Constraints: Not nullable, Precision: 6, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPDebtRatioInYears</b>
     * </p>
     *
     * @return Debt Ratio in Years
     */
    @SerializedName( "BPDebtRatioInYears" )
    @JsonProperty( "BPDebtRatioInYears" )
    @Nullable
    @ODataField( odataName = "BPDebtRatioInYears" )
    private BigDecimal bPDebtRatioInYears;
    /**
     * Use with available fluent helpers to apply the <b>BPDebtRatioInYears</b> field to query operations.
     *
     */
    public final static BPFiscalYearInformationField<BigDecimal> BP_DEBT_RATIO_IN_YEARS =
        new BPFiscalYearInformationField<BigDecimal>("BPDebtRatioInYears");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPAnnualPnLAmtInBalShtCrcy</b>
     * </p>
     *
     * @return Amount of Annual Profit/Loss for Organization
     */
    @SerializedName( "BPAnnualPnLAmtInBalShtCrcy" )
    @JsonProperty( "BPAnnualPnLAmtInBalShtCrcy" )
    @Nullable
    @ODataField( odataName = "BPAnnualPnLAmtInBalShtCrcy" )
    private BigDecimal bPAnnualPnLAmtInBalShtCrcy;
    /**
     * Use with available fluent helpers to apply the <b>BPAnnualPnLAmtInBalShtCrcy</b> field to query operations.
     *
     */
    public final static BPFiscalYearInformationField<BigDecimal> BP_ANNUAL_PN_L_AMT_IN_BAL_SHT_CRCY =
        new BPFiscalYearInformationField<BigDecimal>("BPAnnualPnLAmtInBalShtCrcy");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPBalSheetTotalAmtInBalShtCrcy</b>
     * </p>
     *
     * @return Amount of Balance Sheet Total for Company
     */
    @SerializedName( "BPBalSheetTotalAmtInBalShtCrcy" )
    @JsonProperty( "BPBalSheetTotalAmtInBalShtCrcy" )
    @Nullable
    @ODataField( odataName = "BPBalSheetTotalAmtInBalShtCrcy" )
    private BigDecimal bPBalSheetTotalAmtInBalShtCrcy;
    /**
     * Use with available fluent helpers to apply the <b>BPBalSheetTotalAmtInBalShtCrcy</b> field to query operations.
     *
     */
    public final static BPFiscalYearInformationField<BigDecimal> BP_BAL_SHEET_TOTAL_AMT_IN_BAL_SHT_CRCY =
        new BPFiscalYearInformationField<BigDecimal>("BPBalSheetTotalAmtInBalShtCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>BPNumberOfEmployees</b>
     * </p>
     *
     * @return Number of Employees in Company
     */
    @SerializedName( "BPNumberOfEmployees" )
    @JsonProperty( "BPNumberOfEmployees" )
    @Nullable
    @ODataField( odataName = "BPNumberOfEmployees" )
    private String bPNumberOfEmployees;
    /**
     * Use with available fluent helpers to apply the <b>BPNumberOfEmployees</b> field to query operations.
     *
     */
    public final static BPFiscalYearInformationField<String> BP_NUMBER_OF_EMPLOYEES =
        new BPFiscalYearInformationField<String>("BPNumberOfEmployees");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPCptlReserveAmtInBalShtCrcy</b>
     * </p>
     *
     * @return Amount of Capital Reserve for Company
     */
    @SerializedName( "BPCptlReserveAmtInBalShtCrcy" )
    @JsonProperty( "BPCptlReserveAmtInBalShtCrcy" )
    @Nullable
    @ODataField( odataName = "BPCptlReserveAmtInBalShtCrcy" )
    private BigDecimal bPCptlReserveAmtInBalShtCrcy;
    /**
     * Use with available fluent helpers to apply the <b>BPCptlReserveAmtInBalShtCrcy</b> field to query operations.
     *
     */
    public final static BPFiscalYearInformationField<BigDecimal> BP_CPTL_RESERVE_AMT_IN_BAL_SHT_CRCY =
        new BPFiscalYearInformationField<BigDecimal>("BPCptlReserveAmtInBalShtCrcy");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPLglRevnRsrvAmtInBalShtCrcy</b>
     * </p>
     *
     * @return Amount of Legal Revenue Reserves for Company
     */
    @SerializedName( "BPLglRevnRsrvAmtInBalShtCrcy" )
    @JsonProperty( "BPLglRevnRsrvAmtInBalShtCrcy" )
    @Nullable
    @ODataField( odataName = "BPLglRevnRsrvAmtInBalShtCrcy" )
    private BigDecimal bPLglRevnRsrvAmtInBalShtCrcy;
    /**
     * Use with available fluent helpers to apply the <b>BPLglRevnRsrvAmtInBalShtCrcy</b> field to query operations.
     *
     */
    public final static BPFiscalYearInformationField<BigDecimal> BP_LGL_REVN_RSRV_AMT_IN_BAL_SHT_CRCY =
        new BPFiscalYearInformationField<BigDecimal>("BPLglRevnRsrvAmtInBalShtCrcy");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RevnRsrvOwnStkAmtInBalShtCrcy</b>
     * </p>
     *
     * @return Revenue Reserves for Own Stock
     */
    @SerializedName( "RevnRsrvOwnStkAmtInBalShtCrcy" )
    @JsonProperty( "RevnRsrvOwnStkAmtInBalShtCrcy" )
    @Nullable
    @ODataField( odataName = "RevnRsrvOwnStkAmtInBalShtCrcy" )
    private BigDecimal revnRsrvOwnStkAmtInBalShtCrcy;
    /**
     * Use with available fluent helpers to apply the <b>RevnRsrvOwnStkAmtInBalShtCrcy</b> field to query operations.
     *
     */
    public final static BPFiscalYearInformationField<BigDecimal> REVN_RSRV_OWN_STK_AMT_IN_BAL_SHT_CRCY =
        new BPFiscalYearInformationField<BigDecimal>("RevnRsrvOwnStkAmtInBalShtCrcy");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPStatryReserveAmtInBalShtCrcy</b>
     * </p>
     *
     * @return Amount of Statutory Revenue Reserve for Company
     */
    @SerializedName( "BPStatryReserveAmtInBalShtCrcy" )
    @JsonProperty( "BPStatryReserveAmtInBalShtCrcy" )
    @Nullable
    @ODataField( odataName = "BPStatryReserveAmtInBalShtCrcy" )
    private BigDecimal bPStatryReserveAmtInBalShtCrcy;
    /**
     * Use with available fluent helpers to apply the <b>BPStatryReserveAmtInBalShtCrcy</b> field to query operations.
     *
     */
    public final static BPFiscalYearInformationField<BigDecimal> BP_STATRY_RESERVE_AMT_IN_BAL_SHT_CRCY =
        new BPFiscalYearInformationField<BigDecimal>("BPStatryReserveAmtInBalShtCrcy");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPOthRevnRsrvAmtInBalShtCrcy</b>
     * </p>
     *
     * @return Amount of Other Revenue Reserves for Company
     */
    @SerializedName( "BPOthRevnRsrvAmtInBalShtCrcy" )
    @JsonProperty( "BPOthRevnRsrvAmtInBalShtCrcy" )
    @Nullable
    @ODataField( odataName = "BPOthRevnRsrvAmtInBalShtCrcy" )
    private BigDecimal bPOthRevnRsrvAmtInBalShtCrcy;
    /**
     * Use with available fluent helpers to apply the <b>BPOthRevnRsrvAmtInBalShtCrcy</b> field to query operations.
     *
     */
    public final static BPFiscalYearInformationField<BigDecimal> BP_OTH_REVN_RSRV_AMT_IN_BAL_SHT_CRCY =
        new BPFiscalYearInformationField<BigDecimal>("BPOthRevnRsrvAmtInBalShtCrcy");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPPnLCarryfwdAmtInBalShtCrcy</b>
     * </p>
     *
     * @return Amount of Profit/Loss Carried Forward for Company
     */
    @SerializedName( "BPPnLCarryfwdAmtInBalShtCrcy" )
    @JsonProperty( "BPPnLCarryfwdAmtInBalShtCrcy" )
    @Nullable
    @ODataField( odataName = "BPPnLCarryfwdAmtInBalShtCrcy" )
    private BigDecimal bPPnLCarryfwdAmtInBalShtCrcy;
    /**
     * Use with available fluent helpers to apply the <b>BPPnLCarryfwdAmtInBalShtCrcy</b> field to query operations.
     *
     */
    public final static BPFiscalYearInformationField<BigDecimal> BP_PN_L_CARRYFWD_AMT_IN_BAL_SHT_CRCY =
        new BPFiscalYearInformationField<BigDecimal>("BPPnLCarryfwdAmtInBalShtCrcy");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPSuborddLbltyAmtInBalShtCrcy</b>
     * </p>
     *
     * @return Amount of Subordinated Liabilities for Company
     */
    @SerializedName( "BPSuborddLbltyAmtInBalShtCrcy" )
    @JsonProperty( "BPSuborddLbltyAmtInBalShtCrcy" )
    @Nullable
    @ODataField( odataName = "BPSuborddLbltyAmtInBalShtCrcy" )
    private BigDecimal bPSuborddLbltyAmtInBalShtCrcy;
    /**
     * Use with available fluent helpers to apply the <b>BPSuborddLbltyAmtInBalShtCrcy</b> field to query operations.
     *
     */
    public final static BPFiscalYearInformationField<BigDecimal> BP_SUBORDD_LBLTY_AMT_IN_BAL_SHT_CRCY =
        new BPFiscalYearInformationField<BigDecimal>("BPSuborddLbltyAmtInBalShtCrcy");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BPRetOnTotalCptlEmpldInPercent</b>
     * </p>
     *
     * @return Return on Total Capital Employed for Company in Percent
     */
    @SerializedName( "BPRetOnTotalCptlEmpldInPercent" )
    @JsonProperty( "BPRetOnTotalCptlEmpldInPercent" )
    @Nullable
    @ODataField( odataName = "BPRetOnTotalCptlEmpldInPercent" )
    private BigDecimal bPRetOnTotalCptlEmpldInPercent;
    /**
     * Use with available fluent helpers to apply the <b>BPRetOnTotalCptlEmpldInPercent</b> field to query operations.
     *
     */
    public final static BPFiscalYearInformationField<BigDecimal> BP_RET_ON_TOTAL_CPTL_EMPLD_IN_PERCENT =
        new BPFiscalYearInformationField<BigDecimal>("BPRetOnTotalCptlEmpldInPercent");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BPDebtClearancePeriodInYears</b>
     * </p>
     *
     * @return Debt Clearance Period in Years
     */
    @SerializedName( "BPDebtClearancePeriodInYears" )
    @JsonProperty( "BPDebtClearancePeriodInYears" )
    @Nullable
    @ODataField( odataName = "BPDebtClearancePeriodInYears" )
    private BigDecimal bPDebtClearancePeriodInYears;
    /**
     * Use with available fluent helpers to apply the <b>BPDebtClearancePeriodInYears</b> field to query operations.
     *
     */
    public final static BPFiscalYearInformationField<BigDecimal> BP_DEBT_CLEARANCE_PERIOD_IN_YEARS =
        new BPFiscalYearInformationField<BigDecimal>("BPDebtClearancePeriodInYears");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BPFinancingCoeffInPercent</b>
     * </p>
     *
     * @return Financing Coefficient for Company in Percent
     */
    @SerializedName( "BPFinancingCoeffInPercent" )
    @JsonProperty( "BPFinancingCoeffInPercent" )
    @Nullable
    @ODataField( odataName = "BPFinancingCoeffInPercent" )
    private BigDecimal bPFinancingCoeffInPercent;
    /**
     * Use with available fluent helpers to apply the <b>BPFinancingCoeffInPercent</b> field to query operations.
     *
     */
    public final static BPFiscalYearInformationField<BigDecimal> BP_FINANCING_COEFF_IN_PERCENT =
        new BPFiscalYearInformationField<BigDecimal>("BPFinancingCoeffInPercent");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BPEquityRatioInPercent</b>
     * </p>
     *
     * @return Equity Ratio of Company in Percent
     */
    @SerializedName( "BPEquityRatioInPercent" )
    @JsonProperty( "BPEquityRatioInPercent" )
    @Nullable
    @ODataField( odataName = "BPEquityRatioInPercent" )
    private BigDecimal bPEquityRatioInPercent;
    /**
     * Use with available fluent helpers to apply the <b>BPEquityRatioInPercent</b> field to query operations.
     *
     */
    public final static BPFiscalYearInformationField<BigDecimal> BP_EQUITY_RATIO_IN_PERCENT =
        new BPFiscalYearInformationField<BigDecimal>("BPEquityRatioInPercent");

    @Nonnull
    @Override
    public Class<BPFiscalYearInformation> getType()
    {
        return BPFiscalYearInformation.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     *
     * @param businessPartner
     *            Business Partner Number
     */
    public void setBusinessPartner( @Nullable final String businessPartner )
    {
        rememberChangedField("BusinessPartner", this.businessPartner);
        this.businessPartner = businessPartner;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerFiscalYear</b>
     * </p>
     *
     * @param businessPartnerFiscalYear
     *            Fiscal year
     */
    public void setBusinessPartnerFiscalYear( @Nullable final String businessPartnerFiscalYear )
    {
        rememberChangedField("BusinessPartnerFiscalYear", this.businessPartnerFiscalYear);
        this.businessPartnerFiscalYear = businessPartnerFiscalYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>BPBalanceSheetCurrency</b>
     * </p>
     *
     * @param bPBalanceSheetCurrency
     *            Balance Sheet Currency
     */
    public void setBPBalanceSheetCurrency( @Nullable final String bPBalanceSheetCurrency )
    {
        rememberChangedField("BPBalanceSheetCurrency", this.bPBalanceSheetCurrency);
        this.bPBalanceSheetCurrency = bPBalanceSheetCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BPAnnualStockholderMeetingDate</b>
     * </p>
     *
     * @param bPAnnualStockholderMeetingDate
     *            Date of Annual Stockholders Meeting
     */
    public void setBPAnnualStockholderMeetingDate( @Nullable final LocalDateTime bPAnnualStockholderMeetingDate )
    {
        rememberChangedField("BPAnnualStockholderMeetingDate", this.bPAnnualStockholderMeetingDate);
        this.bPAnnualStockholderMeetingDate = bPAnnualStockholderMeetingDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BPFiscalYearStartDate</b>
     * </p>
     *
     * @param bPFiscalYearStartDate
     *            Fiscal Year Start Date
     */
    public void setBPFiscalYearStartDate( @Nullable final LocalDateTime bPFiscalYearStartDate )
    {
        rememberChangedField("BPFiscalYearStartDate", this.bPFiscalYearStartDate);
        this.bPFiscalYearStartDate = bPFiscalYearStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BPFiscalYearEndDate</b>
     * </p>
     *
     * @param bPFiscalYearEndDate
     *            Fiscal Year End Date
     */
    public void setBPFiscalYearEndDate( @Nullable final LocalDateTime bPFiscalYearEndDate )
    {
        rememberChangedField("BPFiscalYearEndDate", this.bPFiscalYearEndDate);
        this.bPFiscalYearEndDate = bPFiscalYearEndDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BPFiscalYearIsClosed</b>
     * </p>
     *
     * @param bPFiscalYearIsClosed
     *            Year-End Closing
     */
    public void setBPFiscalYearIsClosed( @Nullable final Boolean bPFiscalYearIsClosed )
    {
        rememberChangedField("BPFiscalYearIsClosed", this.bPFiscalYearIsClosed);
        this.bPFiscalYearIsClosed = bPFiscalYearIsClosed;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BPFiscalYearClosingDate</b>
     * </p>
     *
     * @param bPFiscalYearClosingDate
     *            Year-End Closing Date for Fiscal Year
     */
    public void setBPFiscalYearClosingDate( @Nullable final LocalDateTime bPFiscalYearClosingDate )
    {
        rememberChangedField("BPFiscalYearClosingDate", this.bPFiscalYearClosingDate);
        this.bPFiscalYearClosingDate = bPFiscalYearClosingDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BPFsclYrCnsldtdFinStatementDte</b>
     * </p>
     *
     * @param bPFsclYrCnsldtdFinStatementDte
     *            Date of Consolidated Financial Statements of Group Company
     */
    public void setBPFsclYrCnsldtdFinStatementDte( @Nullable final LocalDateTime bPFsclYrCnsldtdFinStatementDte )
    {
        rememberChangedField("BPFsclYrCnsldtdFinStatementDte", this.bPFsclYrCnsldtdFinStatementDte);
        this.bPFsclYrCnsldtdFinStatementDte = bPFsclYrCnsldtdFinStatementDte;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPCapitalStockAmtInBalShtCrcy</b>
     * </p>
     *
     * @param bPCapitalStockAmtInBalShtCrcy
     *            Amount of Authorized Capital Stock for Company
     */
    public void setBPCapitalStockAmtInBalShtCrcy( @Nullable final BigDecimal bPCapitalStockAmtInBalShtCrcy )
    {
        rememberChangedField("BPCapitalStockAmtInBalShtCrcy", this.bPCapitalStockAmtInBalShtCrcy);
        this.bPCapitalStockAmtInBalShtCrcy = bPCapitalStockAmtInBalShtCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPIssdStockCptlAmtInBalShtCrcy</b>
     * </p>
     *
     * @param bPIssdStockCptlAmtInBalShtCrcy
     *            Amount of Issued Stock Capital for Company
     */
    public void setBPIssdStockCptlAmtInBalShtCrcy( @Nullable final BigDecimal bPIssdStockCptlAmtInBalShtCrcy )
    {
        rememberChangedField("BPIssdStockCptlAmtInBalShtCrcy", this.bPIssdStockCptlAmtInBalShtCrcy);
        this.bPIssdStockCptlAmtInBalShtCrcy = bPIssdStockCptlAmtInBalShtCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPPartcipnCertAmtInBalShtCrcy</b>
     * </p>
     *
     * @param bPPartcipnCertAmtInBalShtCrcy
     *            Amount of Participation Certificates Outstanding for Company
     */
    public void setBPPartcipnCertAmtInBalShtCrcy( @Nullable final BigDecimal bPPartcipnCertAmtInBalShtCrcy )
    {
        rememberChangedField("BPPartcipnCertAmtInBalShtCrcy", this.bPPartcipnCertAmtInBalShtCrcy);
        this.bPPartcipnCertAmtInBalShtCrcy = bPPartcipnCertAmtInBalShtCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPEquityCapitalAmtInBalShtCrcy</b>
     * </p>
     *
     * @param bPEquityCapitalAmtInBalShtCrcy
     *            Amount of Equity Capital for Company
     */
    public void setBPEquityCapitalAmtInBalShtCrcy( @Nullable final BigDecimal bPEquityCapitalAmtInBalShtCrcy )
    {
        rememberChangedField("BPEquityCapitalAmtInBalShtCrcy", this.bPEquityCapitalAmtInBalShtCrcy);
        this.bPEquityCapitalAmtInBalShtCrcy = bPEquityCapitalAmtInBalShtCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPGrossPremiumAmtInBalShtCrcy</b>
     * </p>
     *
     * @param bPGrossPremiumAmtInBalShtCrcy
     *            Gross Premium
     */
    public void setBPGrossPremiumAmtInBalShtCrcy( @Nullable final BigDecimal bPGrossPremiumAmtInBalShtCrcy )
    {
        rememberChangedField("BPGrossPremiumAmtInBalShtCrcy", this.bPGrossPremiumAmtInBalShtCrcy);
        this.bPGrossPremiumAmtInBalShtCrcy = bPGrossPremiumAmtInBalShtCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPNetPremiumAmtInBalShtCrcy</b>
     * </p>
     *
     * @param bPNetPremiumAmtInBalShtCrcy
     *            Net Premium
     */
    public void setBPNetPremiumAmtInBalShtCrcy( @Nullable final BigDecimal bPNetPremiumAmtInBalShtCrcy )
    {
        rememberChangedField("BPNetPremiumAmtInBalShtCrcy", this.bPNetPremiumAmtInBalShtCrcy);
        this.bPNetPremiumAmtInBalShtCrcy = bPNetPremiumAmtInBalShtCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPAnnualSalesAmtInBalShtCrcy</b>
     * </p>
     *
     * @param bPAnnualSalesAmtInBalShtCrcy
     *            Amount of Annual Sales for Company
     */
    public void setBPAnnualSalesAmtInBalShtCrcy( @Nullable final BigDecimal bPAnnualSalesAmtInBalShtCrcy )
    {
        rememberChangedField("BPAnnualSalesAmtInBalShtCrcy", this.bPAnnualSalesAmtInBalShtCrcy);
        this.bPAnnualSalesAmtInBalShtCrcy = bPAnnualSalesAmtInBalShtCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPAnnualNetIncAmtInBalShtCrcy</b>
     * </p>
     *
     * @param bPAnnualNetIncAmtInBalShtCrcy
     *            Amount of Annual Net Income/Net Loss for Company
     */
    public void setBPAnnualNetIncAmtInBalShtCrcy( @Nullable final BigDecimal bPAnnualNetIncAmtInBalShtCrcy )
    {
        rememberChangedField("BPAnnualNetIncAmtInBalShtCrcy", this.bPAnnualNetIncAmtInBalShtCrcy);
        this.bPAnnualNetIncAmtInBalShtCrcy = bPAnnualNetIncAmtInBalShtCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPDividendDistrAmtInBalShtCrcy</b>
     * </p>
     *
     * @param bPDividendDistrAmtInBalShtCrcy
     *            Dividend/Profit Distribution Amount for Company
     */
    public void setBPDividendDistrAmtInBalShtCrcy( @Nullable final BigDecimal bPDividendDistrAmtInBalShtCrcy )
    {
        rememberChangedField("BPDividendDistrAmtInBalShtCrcy", this.bPDividendDistrAmtInBalShtCrcy);
        this.bPDividendDistrAmtInBalShtCrcy = bPDividendDistrAmtInBalShtCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 6, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPDebtRatioInYears</b>
     * </p>
     *
     * @param bPDebtRatioInYears
     *            Debt Ratio in Years
     */
    public void setBPDebtRatioInYears( @Nullable final BigDecimal bPDebtRatioInYears )
    {
        rememberChangedField("BPDebtRatioInYears", this.bPDebtRatioInYears);
        this.bPDebtRatioInYears = bPDebtRatioInYears;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPAnnualPnLAmtInBalShtCrcy</b>
     * </p>
     *
     * @param bPAnnualPnLAmtInBalShtCrcy
     *            Amount of Annual Profit/Loss for Organization
     */
    public void setBPAnnualPnLAmtInBalShtCrcy( @Nullable final BigDecimal bPAnnualPnLAmtInBalShtCrcy )
    {
        rememberChangedField("BPAnnualPnLAmtInBalShtCrcy", this.bPAnnualPnLAmtInBalShtCrcy);
        this.bPAnnualPnLAmtInBalShtCrcy = bPAnnualPnLAmtInBalShtCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPBalSheetTotalAmtInBalShtCrcy</b>
     * </p>
     *
     * @param bPBalSheetTotalAmtInBalShtCrcy
     *            Amount of Balance Sheet Total for Company
     */
    public void setBPBalSheetTotalAmtInBalShtCrcy( @Nullable final BigDecimal bPBalSheetTotalAmtInBalShtCrcy )
    {
        rememberChangedField("BPBalSheetTotalAmtInBalShtCrcy", this.bPBalSheetTotalAmtInBalShtCrcy);
        this.bPBalSheetTotalAmtInBalShtCrcy = bPBalSheetTotalAmtInBalShtCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>BPNumberOfEmployees</b>
     * </p>
     *
     * @param bPNumberOfEmployees
     *            Number of Employees in Company
     */
    public void setBPNumberOfEmployees( @Nullable final String bPNumberOfEmployees )
    {
        rememberChangedField("BPNumberOfEmployees", this.bPNumberOfEmployees);
        this.bPNumberOfEmployees = bPNumberOfEmployees;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPCptlReserveAmtInBalShtCrcy</b>
     * </p>
     *
     * @param bPCptlReserveAmtInBalShtCrcy
     *            Amount of Capital Reserve for Company
     */
    public void setBPCptlReserveAmtInBalShtCrcy( @Nullable final BigDecimal bPCptlReserveAmtInBalShtCrcy )
    {
        rememberChangedField("BPCptlReserveAmtInBalShtCrcy", this.bPCptlReserveAmtInBalShtCrcy);
        this.bPCptlReserveAmtInBalShtCrcy = bPCptlReserveAmtInBalShtCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPLglRevnRsrvAmtInBalShtCrcy</b>
     * </p>
     *
     * @param bPLglRevnRsrvAmtInBalShtCrcy
     *            Amount of Legal Revenue Reserves for Company
     */
    public void setBPLglRevnRsrvAmtInBalShtCrcy( @Nullable final BigDecimal bPLglRevnRsrvAmtInBalShtCrcy )
    {
        rememberChangedField("BPLglRevnRsrvAmtInBalShtCrcy", this.bPLglRevnRsrvAmtInBalShtCrcy);
        this.bPLglRevnRsrvAmtInBalShtCrcy = bPLglRevnRsrvAmtInBalShtCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RevnRsrvOwnStkAmtInBalShtCrcy</b>
     * </p>
     *
     * @param revnRsrvOwnStkAmtInBalShtCrcy
     *            Revenue Reserves for Own Stock
     */
    public void setRevnRsrvOwnStkAmtInBalShtCrcy( @Nullable final BigDecimal revnRsrvOwnStkAmtInBalShtCrcy )
    {
        rememberChangedField("RevnRsrvOwnStkAmtInBalShtCrcy", this.revnRsrvOwnStkAmtInBalShtCrcy);
        this.revnRsrvOwnStkAmtInBalShtCrcy = revnRsrvOwnStkAmtInBalShtCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPStatryReserveAmtInBalShtCrcy</b>
     * </p>
     *
     * @param bPStatryReserveAmtInBalShtCrcy
     *            Amount of Statutory Revenue Reserve for Company
     */
    public void setBPStatryReserveAmtInBalShtCrcy( @Nullable final BigDecimal bPStatryReserveAmtInBalShtCrcy )
    {
        rememberChangedField("BPStatryReserveAmtInBalShtCrcy", this.bPStatryReserveAmtInBalShtCrcy);
        this.bPStatryReserveAmtInBalShtCrcy = bPStatryReserveAmtInBalShtCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPOthRevnRsrvAmtInBalShtCrcy</b>
     * </p>
     *
     * @param bPOthRevnRsrvAmtInBalShtCrcy
     *            Amount of Other Revenue Reserves for Company
     */
    public void setBPOthRevnRsrvAmtInBalShtCrcy( @Nullable final BigDecimal bPOthRevnRsrvAmtInBalShtCrcy )
    {
        rememberChangedField("BPOthRevnRsrvAmtInBalShtCrcy", this.bPOthRevnRsrvAmtInBalShtCrcy);
        this.bPOthRevnRsrvAmtInBalShtCrcy = bPOthRevnRsrvAmtInBalShtCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPPnLCarryfwdAmtInBalShtCrcy</b>
     * </p>
     *
     * @param bPPnLCarryfwdAmtInBalShtCrcy
     *            Amount of Profit/Loss Carried Forward for Company
     */
    public void setBPPnLCarryfwdAmtInBalShtCrcy( @Nullable final BigDecimal bPPnLCarryfwdAmtInBalShtCrcy )
    {
        rememberChangedField("BPPnLCarryfwdAmtInBalShtCrcy", this.bPPnLCarryfwdAmtInBalShtCrcy);
        this.bPPnLCarryfwdAmtInBalShtCrcy = bPPnLCarryfwdAmtInBalShtCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPSuborddLbltyAmtInBalShtCrcy</b>
     * </p>
     *
     * @param bPSuborddLbltyAmtInBalShtCrcy
     *            Amount of Subordinated Liabilities for Company
     */
    public void setBPSuborddLbltyAmtInBalShtCrcy( @Nullable final BigDecimal bPSuborddLbltyAmtInBalShtCrcy )
    {
        rememberChangedField("BPSuborddLbltyAmtInBalShtCrcy", this.bPSuborddLbltyAmtInBalShtCrcy);
        this.bPSuborddLbltyAmtInBalShtCrcy = bPSuborddLbltyAmtInBalShtCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BPRetOnTotalCptlEmpldInPercent</b>
     * </p>
     *
     * @param bPRetOnTotalCptlEmpldInPercent
     *            Return on Total Capital Employed for Company in Percent
     */
    public void setBPRetOnTotalCptlEmpldInPercent( @Nullable final BigDecimal bPRetOnTotalCptlEmpldInPercent )
    {
        rememberChangedField("BPRetOnTotalCptlEmpldInPercent", this.bPRetOnTotalCptlEmpldInPercent);
        this.bPRetOnTotalCptlEmpldInPercent = bPRetOnTotalCptlEmpldInPercent;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BPDebtClearancePeriodInYears</b>
     * </p>
     *
     * @param bPDebtClearancePeriodInYears
     *            Debt Clearance Period in Years
     */
    public void setBPDebtClearancePeriodInYears( @Nullable final BigDecimal bPDebtClearancePeriodInYears )
    {
        rememberChangedField("BPDebtClearancePeriodInYears", this.bPDebtClearancePeriodInYears);
        this.bPDebtClearancePeriodInYears = bPDebtClearancePeriodInYears;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BPFinancingCoeffInPercent</b>
     * </p>
     *
     * @param bPFinancingCoeffInPercent
     *            Financing Coefficient for Company in Percent
     */
    public void setBPFinancingCoeffInPercent( @Nullable final BigDecimal bPFinancingCoeffInPercent )
    {
        rememberChangedField("BPFinancingCoeffInPercent", this.bPFinancingCoeffInPercent);
        this.bPFinancingCoeffInPercent = bPFinancingCoeffInPercent;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BPEquityRatioInPercent</b>
     * </p>
     *
     * @param bPEquityRatioInPercent
     *            Equity Ratio of Company in Percent
     */
    public void setBPEquityRatioInPercent( @Nullable final BigDecimal bPEquityRatioInPercent )
    {
        rememberChangedField("BPEquityRatioInPercent", this.bPEquityRatioInPercent);
        this.bPEquityRatioInPercent = bPEquityRatioInPercent;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BPFiscalYearInformation";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BusinessPartner", getBusinessPartner());
        result.put("BusinessPartnerFiscalYear", getBusinessPartnerFiscalYear());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BusinessPartner", getBusinessPartner());
        values.put("BusinessPartnerFiscalYear", getBusinessPartnerFiscalYear());
        values.put("BPBalanceSheetCurrency", getBPBalanceSheetCurrency());
        values.put("BPAnnualStockholderMeetingDate", getBPAnnualStockholderMeetingDate());
        values.put("BPFiscalYearStartDate", getBPFiscalYearStartDate());
        values.put("BPFiscalYearEndDate", getBPFiscalYearEndDate());
        values.put("BPFiscalYearIsClosed", getBPFiscalYearIsClosed());
        values.put("BPFiscalYearClosingDate", getBPFiscalYearClosingDate());
        values.put("BPFsclYrCnsldtdFinStatementDte", getBPFsclYrCnsldtdFinStatementDte());
        values.put("BPCapitalStockAmtInBalShtCrcy", getBPCapitalStockAmtInBalShtCrcy());
        values.put("BPIssdStockCptlAmtInBalShtCrcy", getBPIssdStockCptlAmtInBalShtCrcy());
        values.put("BPPartcipnCertAmtInBalShtCrcy", getBPPartcipnCertAmtInBalShtCrcy());
        values.put("BPEquityCapitalAmtInBalShtCrcy", getBPEquityCapitalAmtInBalShtCrcy());
        values.put("BPGrossPremiumAmtInBalShtCrcy", getBPGrossPremiumAmtInBalShtCrcy());
        values.put("BPNetPremiumAmtInBalShtCrcy", getBPNetPremiumAmtInBalShtCrcy());
        values.put("BPAnnualSalesAmtInBalShtCrcy", getBPAnnualSalesAmtInBalShtCrcy());
        values.put("BPAnnualNetIncAmtInBalShtCrcy", getBPAnnualNetIncAmtInBalShtCrcy());
        values.put("BPDividendDistrAmtInBalShtCrcy", getBPDividendDistrAmtInBalShtCrcy());
        values.put("BPDebtRatioInYears", getBPDebtRatioInYears());
        values.put("BPAnnualPnLAmtInBalShtCrcy", getBPAnnualPnLAmtInBalShtCrcy());
        values.put("BPBalSheetTotalAmtInBalShtCrcy", getBPBalSheetTotalAmtInBalShtCrcy());
        values.put("BPNumberOfEmployees", getBPNumberOfEmployees());
        values.put("BPCptlReserveAmtInBalShtCrcy", getBPCptlReserveAmtInBalShtCrcy());
        values.put("BPLglRevnRsrvAmtInBalShtCrcy", getBPLglRevnRsrvAmtInBalShtCrcy());
        values.put("RevnRsrvOwnStkAmtInBalShtCrcy", getRevnRsrvOwnStkAmtInBalShtCrcy());
        values.put("BPStatryReserveAmtInBalShtCrcy", getBPStatryReserveAmtInBalShtCrcy());
        values.put("BPOthRevnRsrvAmtInBalShtCrcy", getBPOthRevnRsrvAmtInBalShtCrcy());
        values.put("BPPnLCarryfwdAmtInBalShtCrcy", getBPPnLCarryfwdAmtInBalShtCrcy());
        values.put("BPSuborddLbltyAmtInBalShtCrcy", getBPSuborddLbltyAmtInBalShtCrcy());
        values.put("BPRetOnTotalCptlEmpldInPercent", getBPRetOnTotalCptlEmpldInPercent());
        values.put("BPDebtClearancePeriodInYears", getBPDebtClearancePeriodInYears());
        values.put("BPFinancingCoeffInPercent", getBPFinancingCoeffInPercent());
        values.put("BPEquityRatioInPercent", getBPEquityRatioInPercent());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BusinessPartner") ) {
                final Object value = values.remove("BusinessPartner");
                if( (value == null) || (!value.equals(getBusinessPartner())) ) {
                    setBusinessPartner(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerFiscalYear") ) {
                final Object value = values.remove("BusinessPartnerFiscalYear");
                if( (value == null) || (!value.equals(getBusinessPartnerFiscalYear())) ) {
                    setBusinessPartnerFiscalYear(((String) value));
                }
            }
            if( values.containsKey("BPBalanceSheetCurrency") ) {
                final Object value = values.remove("BPBalanceSheetCurrency");
                if( (value == null) || (!value.equals(getBPBalanceSheetCurrency())) ) {
                    setBPBalanceSheetCurrency(((String) value));
                }
            }
            if( values.containsKey("BPAnnualStockholderMeetingDate") ) {
                final Object value = values.remove("BPAnnualStockholderMeetingDate");
                if( (value == null) || (!value.equals(getBPAnnualStockholderMeetingDate())) ) {
                    setBPAnnualStockholderMeetingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BPFiscalYearStartDate") ) {
                final Object value = values.remove("BPFiscalYearStartDate");
                if( (value == null) || (!value.equals(getBPFiscalYearStartDate())) ) {
                    setBPFiscalYearStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BPFiscalYearEndDate") ) {
                final Object value = values.remove("BPFiscalYearEndDate");
                if( (value == null) || (!value.equals(getBPFiscalYearEndDate())) ) {
                    setBPFiscalYearEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BPFiscalYearIsClosed") ) {
                final Object value = values.remove("BPFiscalYearIsClosed");
                if( (value == null) || (!value.equals(getBPFiscalYearIsClosed())) ) {
                    setBPFiscalYearIsClosed(((Boolean) value));
                }
            }
            if( values.containsKey("BPFiscalYearClosingDate") ) {
                final Object value = values.remove("BPFiscalYearClosingDate");
                if( (value == null) || (!value.equals(getBPFiscalYearClosingDate())) ) {
                    setBPFiscalYearClosingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BPFsclYrCnsldtdFinStatementDte") ) {
                final Object value = values.remove("BPFsclYrCnsldtdFinStatementDte");
                if( (value == null) || (!value.equals(getBPFsclYrCnsldtdFinStatementDte())) ) {
                    setBPFsclYrCnsldtdFinStatementDte(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BPCapitalStockAmtInBalShtCrcy") ) {
                final Object value = values.remove("BPCapitalStockAmtInBalShtCrcy");
                if( (value == null) || (!value.equals(getBPCapitalStockAmtInBalShtCrcy())) ) {
                    setBPCapitalStockAmtInBalShtCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("BPIssdStockCptlAmtInBalShtCrcy") ) {
                final Object value = values.remove("BPIssdStockCptlAmtInBalShtCrcy");
                if( (value == null) || (!value.equals(getBPIssdStockCptlAmtInBalShtCrcy())) ) {
                    setBPIssdStockCptlAmtInBalShtCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("BPPartcipnCertAmtInBalShtCrcy") ) {
                final Object value = values.remove("BPPartcipnCertAmtInBalShtCrcy");
                if( (value == null) || (!value.equals(getBPPartcipnCertAmtInBalShtCrcy())) ) {
                    setBPPartcipnCertAmtInBalShtCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("BPEquityCapitalAmtInBalShtCrcy") ) {
                final Object value = values.remove("BPEquityCapitalAmtInBalShtCrcy");
                if( (value == null) || (!value.equals(getBPEquityCapitalAmtInBalShtCrcy())) ) {
                    setBPEquityCapitalAmtInBalShtCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("BPGrossPremiumAmtInBalShtCrcy") ) {
                final Object value = values.remove("BPGrossPremiumAmtInBalShtCrcy");
                if( (value == null) || (!value.equals(getBPGrossPremiumAmtInBalShtCrcy())) ) {
                    setBPGrossPremiumAmtInBalShtCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("BPNetPremiumAmtInBalShtCrcy") ) {
                final Object value = values.remove("BPNetPremiumAmtInBalShtCrcy");
                if( (value == null) || (!value.equals(getBPNetPremiumAmtInBalShtCrcy())) ) {
                    setBPNetPremiumAmtInBalShtCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("BPAnnualSalesAmtInBalShtCrcy") ) {
                final Object value = values.remove("BPAnnualSalesAmtInBalShtCrcy");
                if( (value == null) || (!value.equals(getBPAnnualSalesAmtInBalShtCrcy())) ) {
                    setBPAnnualSalesAmtInBalShtCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("BPAnnualNetIncAmtInBalShtCrcy") ) {
                final Object value = values.remove("BPAnnualNetIncAmtInBalShtCrcy");
                if( (value == null) || (!value.equals(getBPAnnualNetIncAmtInBalShtCrcy())) ) {
                    setBPAnnualNetIncAmtInBalShtCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("BPDividendDistrAmtInBalShtCrcy") ) {
                final Object value = values.remove("BPDividendDistrAmtInBalShtCrcy");
                if( (value == null) || (!value.equals(getBPDividendDistrAmtInBalShtCrcy())) ) {
                    setBPDividendDistrAmtInBalShtCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("BPDebtRatioInYears") ) {
                final Object value = values.remove("BPDebtRatioInYears");
                if( (value == null) || (!value.equals(getBPDebtRatioInYears())) ) {
                    setBPDebtRatioInYears(((BigDecimal) value));
                }
            }
            if( values.containsKey("BPAnnualPnLAmtInBalShtCrcy") ) {
                final Object value = values.remove("BPAnnualPnLAmtInBalShtCrcy");
                if( (value == null) || (!value.equals(getBPAnnualPnLAmtInBalShtCrcy())) ) {
                    setBPAnnualPnLAmtInBalShtCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("BPBalSheetTotalAmtInBalShtCrcy") ) {
                final Object value = values.remove("BPBalSheetTotalAmtInBalShtCrcy");
                if( (value == null) || (!value.equals(getBPBalSheetTotalAmtInBalShtCrcy())) ) {
                    setBPBalSheetTotalAmtInBalShtCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("BPNumberOfEmployees") ) {
                final Object value = values.remove("BPNumberOfEmployees");
                if( (value == null) || (!value.equals(getBPNumberOfEmployees())) ) {
                    setBPNumberOfEmployees(((String) value));
                }
            }
            if( values.containsKey("BPCptlReserveAmtInBalShtCrcy") ) {
                final Object value = values.remove("BPCptlReserveAmtInBalShtCrcy");
                if( (value == null) || (!value.equals(getBPCptlReserveAmtInBalShtCrcy())) ) {
                    setBPCptlReserveAmtInBalShtCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("BPLglRevnRsrvAmtInBalShtCrcy") ) {
                final Object value = values.remove("BPLglRevnRsrvAmtInBalShtCrcy");
                if( (value == null) || (!value.equals(getBPLglRevnRsrvAmtInBalShtCrcy())) ) {
                    setBPLglRevnRsrvAmtInBalShtCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("RevnRsrvOwnStkAmtInBalShtCrcy") ) {
                final Object value = values.remove("RevnRsrvOwnStkAmtInBalShtCrcy");
                if( (value == null) || (!value.equals(getRevnRsrvOwnStkAmtInBalShtCrcy())) ) {
                    setRevnRsrvOwnStkAmtInBalShtCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("BPStatryReserveAmtInBalShtCrcy") ) {
                final Object value = values.remove("BPStatryReserveAmtInBalShtCrcy");
                if( (value == null) || (!value.equals(getBPStatryReserveAmtInBalShtCrcy())) ) {
                    setBPStatryReserveAmtInBalShtCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("BPOthRevnRsrvAmtInBalShtCrcy") ) {
                final Object value = values.remove("BPOthRevnRsrvAmtInBalShtCrcy");
                if( (value == null) || (!value.equals(getBPOthRevnRsrvAmtInBalShtCrcy())) ) {
                    setBPOthRevnRsrvAmtInBalShtCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("BPPnLCarryfwdAmtInBalShtCrcy") ) {
                final Object value = values.remove("BPPnLCarryfwdAmtInBalShtCrcy");
                if( (value == null) || (!value.equals(getBPPnLCarryfwdAmtInBalShtCrcy())) ) {
                    setBPPnLCarryfwdAmtInBalShtCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("BPSuborddLbltyAmtInBalShtCrcy") ) {
                final Object value = values.remove("BPSuborddLbltyAmtInBalShtCrcy");
                if( (value == null) || (!value.equals(getBPSuborddLbltyAmtInBalShtCrcy())) ) {
                    setBPSuborddLbltyAmtInBalShtCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("BPRetOnTotalCptlEmpldInPercent") ) {
                final Object value = values.remove("BPRetOnTotalCptlEmpldInPercent");
                if( (value == null) || (!value.equals(getBPRetOnTotalCptlEmpldInPercent())) ) {
                    setBPRetOnTotalCptlEmpldInPercent(((BigDecimal) value));
                }
            }
            if( values.containsKey("BPDebtClearancePeriodInYears") ) {
                final Object value = values.remove("BPDebtClearancePeriodInYears");
                if( (value == null) || (!value.equals(getBPDebtClearancePeriodInYears())) ) {
                    setBPDebtClearancePeriodInYears(((BigDecimal) value));
                }
            }
            if( values.containsKey("BPFinancingCoeffInPercent") ) {
                final Object value = values.remove("BPFinancingCoeffInPercent");
                if( (value == null) || (!value.equals(getBPFinancingCoeffInPercent())) ) {
                    setBPFinancingCoeffInPercent(((BigDecimal) value));
                }
            }
            if( values.containsKey("BPEquityRatioInPercent") ) {
                final Object value = values.remove("BPEquityRatioInPercent");
                if( (value == null) || (!value.equals(getBPEquityRatioInPercent())) ) {
                    setBPEquityRatioInPercent(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BPFiscalYearInformationField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BPFiscalYearInformationField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BPFiscalYearInformationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BPFiscalYearInformationField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessPartnerService.DEFAULT_SERVICE_PATH);
    }

}
