/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.field.BusinessPartnerField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.link.BusinessPartnerLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.link.BusinessPartnerOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.selectable.BusinessPartnerSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Business Partner
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BusinessPartnerType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BusinessPartner extends VdmEntity<BusinessPartner>
{

    /**
     * Selector for all available fields of BusinessPartner.
     *
     */
    public final static BusinessPartnerSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     *
     * @return Business Partner Number
     */
    @Key
    @SerializedName( "BusinessPartner" )
    @JsonProperty( "BusinessPartner" )
    @Nullable
    @ODataField( odataName = "BusinessPartner" )
    private String businessPartner;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartner</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> BUSINESS_PARTNER =
        new BusinessPartnerField<String>("BusinessPartner");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Customer Number
     */
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> CUSTOMER = new BusinessPartnerField<String>("Customer");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Account Number of Supplier
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> SUPPLIER = new BusinessPartnerField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AcademicTitle</b>
     * </p>
     *
     * @return Academic Title: Key
     */
    @SerializedName( "AcademicTitle" )
    @JsonProperty( "AcademicTitle" )
    @Nullable
    @ODataField( odataName = "AcademicTitle" )
    private String academicTitle;
    /**
     * Use with available fluent helpers to apply the <b>AcademicTitle</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> ACADEMIC_TITLE = new BusinessPartnerField<String>("AcademicTitle");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationGroup</b>
     * </p>
     *
     * @return Authorization Group
     */
    @SerializedName( "AuthorizationGroup" )
    @JsonProperty( "AuthorizationGroup" )
    @Nullable
    @ODataField( odataName = "AuthorizationGroup" )
    private String authorizationGroup;
    /**
     * Use with available fluent helpers to apply the <b>AuthorizationGroup</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> AUTHORIZATION_GROUP =
        new BusinessPartnerField<String>("AuthorizationGroup");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerCategory</b>
     * </p>
     *
     * @return Business Partner Category
     */
    @SerializedName( "BusinessPartnerCategory" )
    @JsonProperty( "BusinessPartnerCategory" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerCategory" )
    private String businessPartnerCategory;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerCategory</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> BUSINESS_PARTNER_CATEGORY =
        new BusinessPartnerField<String>("BusinessPartnerCategory");
    /**
     * Constraints: Not nullable, Maximum length: 81
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerFullName</b>
     * </p>
     *
     * @return The businessPartnerFullName contained in this entity.
     */
    @SerializedName( "BusinessPartnerFullName" )
    @JsonProperty( "BusinessPartnerFullName" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerFullName" )
    private String businessPartnerFullName;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerFullName</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> BUSINESS_PARTNER_FULL_NAME =
        new BusinessPartnerField<String>("BusinessPartnerFullName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerGrouping</b>
     * </p>
     *
     * @return Business Partner Grouping
     */
    @SerializedName( "BusinessPartnerGrouping" )
    @JsonProperty( "BusinessPartnerGrouping" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerGrouping" )
    private String businessPartnerGrouping;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerGrouping</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> BUSINESS_PARTNER_GROUPING =
        new BusinessPartnerField<String>("BusinessPartnerGrouping");
    /**
     * Constraints: Not nullable, Maximum length: 81
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName</b>
     * </p>
     *
     * @return The businessPartnerName contained in this entity.
     */
    @SerializedName( "BusinessPartnerName" )
    @JsonProperty( "BusinessPartnerName" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerName" )
    private String businessPartnerName;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerName</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> BUSINESS_PARTNER_NAME =
        new BusinessPartnerField<String>("BusinessPartnerName");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerUUID</b>
     * </p>
     *
     * @return Business Partner GUID
     */
    @SerializedName( "BusinessPartnerUUID" )
    @JsonProperty( "BusinessPartnerUUID" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerUUID" )
    private UUID businessPartnerUUID;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerUUID</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<UUID> BUSINESS_PARTNER_UUID =
        new BusinessPartnerField<UUID>("BusinessPartnerUUID");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CorrespondenceLanguage</b>
     * </p>
     *
     * @return Business Partner: Correspondence Language
     */
    @SerializedName( "CorrespondenceLanguage" )
    @JsonProperty( "CorrespondenceLanguage" )
    @Nullable
    @ODataField( odataName = "CorrespondenceLanguage" )
    private String correspondenceLanguage;
    /**
     * Use with available fluent helpers to apply the <b>CorrespondenceLanguage</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> CORRESPONDENCE_LANGUAGE =
        new BusinessPartnerField<String>("CorrespondenceLanguage");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return User who created the object
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> CREATED_BY_USER =
        new BusinessPartnerField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Date on which the object was created
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<LocalDateTime> CREATION_DATE =
        new BusinessPartnerField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @return Time at which the object was created
     */
    @SerializedName( "CreationTime" )
    @JsonProperty( "CreationTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "CreationTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime creationTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationTime</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<LocalTime> CREATION_TIME =
        new BusinessPartnerField<LocalTime>("CreationTime");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FirstName</b>
     * </p>
     *
     * @return First Name of Business Partner (Person)
     */
    @SerializedName( "FirstName" )
    @JsonProperty( "FirstName" )
    @Nullable
    @ODataField( odataName = "FirstName" )
    private String firstName;
    /**
     * Use with available fluent helpers to apply the <b>FirstName</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> FIRST_NAME = new BusinessPartnerField<String>("FirstName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FormOfAddress</b>
     * </p>
     *
     * @return Form-of-Address Key
     */
    @SerializedName( "FormOfAddress" )
    @JsonProperty( "FormOfAddress" )
    @Nullable
    @ODataField( odataName = "FormOfAddress" )
    private String formOfAddress;
    /**
     * Use with available fluent helpers to apply the <b>FormOfAddress</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> FORM_OF_ADDRESS =
        new BusinessPartnerField<String>("FormOfAddress");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Industry</b>
     * </p>
     *
     * @return Industry sector
     */
    @SerializedName( "Industry" )
    @JsonProperty( "Industry" )
    @Nullable
    @ODataField( odataName = "Industry" )
    private String industry;
    /**
     * Use with available fluent helpers to apply the <b>Industry</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> INDUSTRY = new BusinessPartnerField<String>("Industry");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>InternationalLocationNumber1</b>
     * </p>
     *
     * @return International location number (part 1)
     */
    @SerializedName( "InternationalLocationNumber1" )
    @JsonProperty( "InternationalLocationNumber1" )
    @Nullable
    @ODataField( odataName = "InternationalLocationNumber1" )
    private String internationalLocationNumber1;
    /**
     * Use with available fluent helpers to apply the <b>InternationalLocationNumber1</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> INTERNATIONAL_LOCATION_NUMBER1 =
        new BusinessPartnerField<String>("InternationalLocationNumber1");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>InternationalLocationNumber2</b>
     * </p>
     *
     * @return International location number (Part 2)
     */
    @SerializedName( "InternationalLocationNumber2" )
    @JsonProperty( "InternationalLocationNumber2" )
    @Nullable
    @ODataField( odataName = "InternationalLocationNumber2" )
    private String internationalLocationNumber2;
    /**
     * Use with available fluent helpers to apply the <b>InternationalLocationNumber2</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> INTERNATIONAL_LOCATION_NUMBER2 =
        new BusinessPartnerField<String>("InternationalLocationNumber2");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsFemale</b>
     * </p>
     *
     * @return Selection: Business partner is female
     */
    @SerializedName( "IsFemale" )
    @JsonProperty( "IsFemale" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsFemale" )
    private Boolean isFemale;
    /**
     * Use with available fluent helpers to apply the <b>IsFemale</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<Boolean> IS_FEMALE = new BusinessPartnerField<Boolean>("IsFemale");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMale</b>
     * </p>
     *
     * @return Selection: Business partner is male
     */
    @SerializedName( "IsMale" )
    @JsonProperty( "IsMale" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsMale" )
    private Boolean isMale;
    /**
     * Use with available fluent helpers to apply the <b>IsMale</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<Boolean> IS_MALE = new BusinessPartnerField<Boolean>("IsMale");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsNaturalPerson</b>
     * </p>
     *
     * @return Business Partner Is a Natural Person Under the Tax Laws
     */
    @SerializedName( "IsNaturalPerson" )
    @JsonProperty( "IsNaturalPerson" )
    @Nullable
    @ODataField( odataName = "IsNaturalPerson" )
    private String isNaturalPerson;
    /**
     * Use with available fluent helpers to apply the <b>IsNaturalPerson</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> IS_NATURAL_PERSON =
        new BusinessPartnerField<String>("IsNaturalPerson");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsSexUnknown</b>
     * </p>
     *
     * @return Selection: Sex of business partner is not known
     */
    @SerializedName( "IsSexUnknown" )
    @JsonProperty( "IsSexUnknown" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsSexUnknown" )
    private Boolean isSexUnknown;
    /**
     * Use with available fluent helpers to apply the <b>IsSexUnknown</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<Boolean> IS_SEX_UNKNOWN =
        new BusinessPartnerField<Boolean>("IsSexUnknown");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>GenderCodeName</b>
     * </p>
     *
     * @return Gender of Business Partner (Person)
     */
    @SerializedName( "GenderCodeName" )
    @JsonProperty( "GenderCodeName" )
    @Nullable
    @ODataField( odataName = "GenderCodeName" )
    private String genderCodeName;
    /**
     * Use with available fluent helpers to apply the <b>GenderCodeName</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> GENDER_CODE_NAME =
        new BusinessPartnerField<String>("GenderCodeName");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Business partner: Language
     */
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> LANGUAGE = new BusinessPartnerField<String>("Language");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Date when object was last changed
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<LocalDateTime> LAST_CHANGE_DATE =
        new BusinessPartnerField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeTime</b>
     * </p>
     *
     * @return Time at which object was last changed
     */
    @SerializedName( "LastChangeTime" )
    @JsonProperty( "LastChangeTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime lastChangeTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeTime</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<LocalTime> LAST_CHANGE_TIME =
        new BusinessPartnerField<LocalTime>("LastChangeTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Last user to change object
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> LAST_CHANGED_BY_USER =
        new BusinessPartnerField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>LastName</b>
     * </p>
     *
     * @return Last Name of Business Partner (Person)
     */
    @SerializedName( "LastName" )
    @JsonProperty( "LastName" )
    @Nullable
    @ODataField( odataName = "LastName" )
    private String lastName;
    /**
     * Use with available fluent helpers to apply the <b>LastName</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> LAST_NAME = new BusinessPartnerField<String>("LastName");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>LegalForm</b>
     * </p>
     *
     * @return BP: Legal form of organization
     */
    @SerializedName( "LegalForm" )
    @JsonProperty( "LegalForm" )
    @Nullable
    @ODataField( odataName = "LegalForm" )
    private String legalForm;
    /**
     * Use with available fluent helpers to apply the <b>LegalForm</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> LEGAL_FORM = new BusinessPartnerField<String>("LegalForm");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationBPName1</b>
     * </p>
     *
     * @return Name 1 of organization
     */
    @SerializedName( "OrganizationBPName1" )
    @JsonProperty( "OrganizationBPName1" )
    @Nullable
    @ODataField( odataName = "OrganizationBPName1" )
    private String organizationBPName1;
    /**
     * Use with available fluent helpers to apply the <b>OrganizationBPName1</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> ORGANIZATION_BP_NAME1 =
        new BusinessPartnerField<String>("OrganizationBPName1");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationBPName2</b>
     * </p>
     *
     * @return Name 2 of organization
     */
    @SerializedName( "OrganizationBPName2" )
    @JsonProperty( "OrganizationBPName2" )
    @Nullable
    @ODataField( odataName = "OrganizationBPName2" )
    private String organizationBPName2;
    /**
     * Use with available fluent helpers to apply the <b>OrganizationBPName2</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> ORGANIZATION_BP_NAME2 =
        new BusinessPartnerField<String>("OrganizationBPName2");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationBPName3</b>
     * </p>
     *
     * @return Name 3 of organization
     */
    @SerializedName( "OrganizationBPName3" )
    @JsonProperty( "OrganizationBPName3" )
    @Nullable
    @ODataField( odataName = "OrganizationBPName3" )
    private String organizationBPName3;
    /**
     * Use with available fluent helpers to apply the <b>OrganizationBPName3</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> ORGANIZATION_BP_NAME3 =
        new BusinessPartnerField<String>("OrganizationBPName3");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationBPName4</b>
     * </p>
     *
     * @return Name 4 of organization
     */
    @SerializedName( "OrganizationBPName4" )
    @JsonProperty( "OrganizationBPName4" )
    @Nullable
    @ODataField( odataName = "OrganizationBPName4" )
    private String organizationBPName4;
    /**
     * Use with available fluent helpers to apply the <b>OrganizationBPName4</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> ORGANIZATION_BP_NAME4 =
        new BusinessPartnerField<String>("OrganizationBPName4");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationFoundationDate</b>
     * </p>
     *
     * @return Date organization founded
     */
    @SerializedName( "OrganizationFoundationDate" )
    @JsonProperty( "OrganizationFoundationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "OrganizationFoundationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime organizationFoundationDate;
    /**
     * Use with available fluent helpers to apply the <b>OrganizationFoundationDate</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<LocalDateTime> ORGANIZATION_FOUNDATION_DATE =
        new BusinessPartnerField<LocalDateTime>("OrganizationFoundationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationLiquidationDate</b>
     * </p>
     *
     * @return Liquidation date of organization
     */
    @SerializedName( "OrganizationLiquidationDate" )
    @JsonProperty( "OrganizationLiquidationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "OrganizationLiquidationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime organizationLiquidationDate;
    /**
     * Use with available fluent helpers to apply the <b>OrganizationLiquidationDate</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<LocalDateTime> ORGANIZATION_LIQUIDATION_DATE =
        new BusinessPartnerField<LocalDateTime>("OrganizationLiquidationDate");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SearchTerm1</b>
     * </p>
     *
     * @return Search Term 1 for Business Partner
     */
    @SerializedName( "SearchTerm1" )
    @JsonProperty( "SearchTerm1" )
    @Nullable
    @ODataField( odataName = "SearchTerm1" )
    private String searchTerm1;
    /**
     * Use with available fluent helpers to apply the <b>SearchTerm1</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> SEARCH_TERM1 = new BusinessPartnerField<String>("SearchTerm1");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SearchTerm2</b>
     * </p>
     *
     * @return Search Term 2 for Business Partner
     */
    @SerializedName( "SearchTerm2" )
    @JsonProperty( "SearchTerm2" )
    @Nullable
    @ODataField( odataName = "SearchTerm2" )
    private String searchTerm2;
    /**
     * Use with available fluent helpers to apply the <b>SearchTerm2</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> SEARCH_TERM2 = new BusinessPartnerField<String>("SearchTerm2");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalLastName</b>
     * </p>
     *
     * @return Other Last Name of a Person
     */
    @SerializedName( "AdditionalLastName" )
    @JsonProperty( "AdditionalLastName" )
    @Nullable
    @ODataField( odataName = "AdditionalLastName" )
    private String additionalLastName;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalLastName</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> ADDITIONAL_LAST_NAME =
        new BusinessPartnerField<String>("AdditionalLastName");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BirthDate</b>
     * </p>
     *
     * @return Date of Birth of Business Partner
     */
    @SerializedName( "BirthDate" )
    @JsonProperty( "BirthDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BirthDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime birthDate;
    /**
     * Use with available fluent helpers to apply the <b>BirthDate</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<LocalDateTime> BIRTH_DATE =
        new BusinessPartnerField<LocalDateTime>("BirthDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerBirthDateStatus</b>
     * </p>
     *
     * @return Date of Birth: Status
     */
    @SerializedName( "BusinessPartnerBirthDateStatus" )
    @JsonProperty( "BusinessPartnerBirthDateStatus" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerBirthDateStatus" )
    private String businessPartnerBirthDateStatus;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerBirthDateStatus</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> BUSINESS_PARTNER_BIRTH_DATE_STATUS =
        new BusinessPartnerField<String>("BusinessPartnerBirthDateStatus");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerBirthplaceName</b>
     * </p>
     *
     * @return Birthplace of business partner
     */
    @SerializedName( "BusinessPartnerBirthplaceName" )
    @JsonProperty( "BusinessPartnerBirthplaceName" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerBirthplaceName" )
    private String businessPartnerBirthplaceName;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerBirthplaceName</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> BUSINESS_PARTNER_BIRTHPLACE_NAME =
        new BusinessPartnerField<String>("BusinessPartnerBirthplaceName");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerDeathDate</b>
     * </p>
     *
     * @return Date of death of business partner
     */
    @SerializedName( "BusinessPartnerDeathDate" )
    @JsonProperty( "BusinessPartnerDeathDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BusinessPartnerDeathDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime businessPartnerDeathDate;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerDeathDate</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<LocalDateTime> BUSINESS_PARTNER_DEATH_DATE =
        new BusinessPartnerField<LocalDateTime>("BusinessPartnerDeathDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerIsBlocked</b>
     * </p>
     *
     * @return Central Block for Business Partner
     */
    @SerializedName( "BusinessPartnerIsBlocked" )
    @JsonProperty( "BusinessPartnerIsBlocked" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BusinessPartnerIsBlocked" )
    private Boolean businessPartnerIsBlocked;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerIsBlocked</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<Boolean> BUSINESS_PARTNER_IS_BLOCKED =
        new BusinessPartnerField<Boolean>("BusinessPartnerIsBlocked");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerType</b>
     * </p>
     *
     * @return Business Partner Type
     */
    @SerializedName( "BusinessPartnerType" )
    @JsonProperty( "BusinessPartnerType" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerType" )
    private String businessPartnerType;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerType</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> BUSINESS_PARTNER_TYPE =
        new BusinessPartnerField<String>("BusinessPartnerType");
    /**
     * Constraints: Not nullable, Maximum length: 26
     * <p>
     * Original property name from the Odata EDM: <b>ETag</b>
     * </p>
     *
     * @return The eTag contained in this entity.
     */
    @SerializedName( "ETag" )
    @JsonProperty( "ETag" )
    @Nullable
    @ODataField( odataName = "ETag" )
    private String eTag;
    /**
     * Use with available fluent helpers to apply the <b>ETag</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> E_TAG = new BusinessPartnerField<String>("ETag");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>GroupBusinessPartnerName1</b>
     * </p>
     *
     * @return Name 1 (group)
     */
    @SerializedName( "GroupBusinessPartnerName1" )
    @JsonProperty( "GroupBusinessPartnerName1" )
    @Nullable
    @ODataField( odataName = "GroupBusinessPartnerName1" )
    private String groupBusinessPartnerName1;
    /**
     * Use with available fluent helpers to apply the <b>GroupBusinessPartnerName1</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> GROUP_BUSINESS_PARTNER_NAME1 =
        new BusinessPartnerField<String>("GroupBusinessPartnerName1");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>GroupBusinessPartnerName2</b>
     * </p>
     *
     * @return Name 2 (group)
     */
    @SerializedName( "GroupBusinessPartnerName2" )
    @JsonProperty( "GroupBusinessPartnerName2" )
    @Nullable
    @ODataField( odataName = "GroupBusinessPartnerName2" )
    private String groupBusinessPartnerName2;
    /**
     * Use with available fluent helpers to apply the <b>GroupBusinessPartnerName2</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> GROUP_BUSINESS_PARTNER_NAME2 =
        new BusinessPartnerField<String>("GroupBusinessPartnerName2");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>IndependentAddressID</b>
     * </p>
     *
     * @return Address Number
     */
    @SerializedName( "IndependentAddressID" )
    @JsonProperty( "IndependentAddressID" )
    @Nullable
    @ODataField( odataName = "IndependentAddressID" )
    private String independentAddressID;
    /**
     * Use with available fluent helpers to apply the <b>IndependentAddressID</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> INDEPENDENT_ADDRESS_ID =
        new BusinessPartnerField<String>("IndependentAddressID");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InternationalLocationNumber3</b>
     * </p>
     *
     * @return Check digit for the international location number
     */
    @SerializedName( "InternationalLocationNumber3" )
    @JsonProperty( "InternationalLocationNumber3" )
    @Nullable
    @ODataField( odataName = "InternationalLocationNumber3" )
    private String internationalLocationNumber3;
    /**
     * Use with available fluent helpers to apply the <b>InternationalLocationNumber3</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> INTERNATIONAL_LOCATION_NUMBER3 =
        new BusinessPartnerField<String>("InternationalLocationNumber3");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MiddleName</b>
     * </p>
     *
     * @return Middle Name or Second Forename of a Person
     */
    @SerializedName( "MiddleName" )
    @JsonProperty( "MiddleName" )
    @Nullable
    @ODataField( odataName = "MiddleName" )
    private String middleName;
    /**
     * Use with available fluent helpers to apply the <b>MiddleName</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> MIDDLE_NAME = new BusinessPartnerField<String>("MiddleName");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>NameCountry</b>
     * </p>
     *
     * @return Country/Region for Name Format Rule
     */
    @SerializedName( "NameCountry" )
    @JsonProperty( "NameCountry" )
    @Nullable
    @ODataField( odataName = "NameCountry" )
    private String nameCountry;
    /**
     * Use with available fluent helpers to apply the <b>NameCountry</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> NAME_COUNTRY = new BusinessPartnerField<String>("NameCountry");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>NameFormat</b>
     * </p>
     *
     * @return Name format
     */
    @SerializedName( "NameFormat" )
    @JsonProperty( "NameFormat" )
    @Nullable
    @ODataField( odataName = "NameFormat" )
    private String nameFormat;
    /**
     * Use with available fluent helpers to apply the <b>NameFormat</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> NAME_FORMAT = new BusinessPartnerField<String>("NameFormat");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>PersonFullName</b>
     * </p>
     *
     * @return Full Name
     */
    @SerializedName( "PersonFullName" )
    @JsonProperty( "PersonFullName" )
    @Nullable
    @ODataField( odataName = "PersonFullName" )
    private String personFullName;
    /**
     * Use with available fluent helpers to apply the <b>PersonFullName</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> PERSON_FULL_NAME =
        new BusinessPartnerField<String>("PersonFullName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PersonNumber</b>
     * </p>
     *
     * @return Person Number
     */
    @SerializedName( "PersonNumber" )
    @JsonProperty( "PersonNumber" )
    @Nullable
    @ODataField( odataName = "PersonNumber" )
    private String personNumber;
    /**
     * Use with available fluent helpers to apply the <b>PersonNumber</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> PERSON_NUMBER = new BusinessPartnerField<String>("PersonNumber");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMarkedForArchiving</b>
     * </p>
     *
     * @return Central Archiving Flag
     */
    @SerializedName( "IsMarkedForArchiving" )
    @JsonProperty( "IsMarkedForArchiving" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsMarkedForArchiving" )
    private Boolean isMarkedForArchiving;
    /**
     * Use with available fluent helpers to apply the <b>IsMarkedForArchiving</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<Boolean> IS_MARKED_FOR_ARCHIVING =
        new BusinessPartnerField<Boolean>("IsMarkedForArchiving");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerIDByExtSystem</b>
     * </p>
     *
     * @return Business Partner Number in External System
     */
    @SerializedName( "BusinessPartnerIDByExtSystem" )
    @JsonProperty( "BusinessPartnerIDByExtSystem" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerIDByExtSystem" )
    private String businessPartnerIDByExtSystem;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerIDByExtSystem</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> BUSINESS_PARTNER_ID_BY_EXT_SYSTEM =
        new BusinessPartnerField<String>("BusinessPartnerIDByExtSystem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerPrintFormat</b>
     * </p>
     *
     * @return Business Partner Print Format
     */
    @SerializedName( "BusinessPartnerPrintFormat" )
    @JsonProperty( "BusinessPartnerPrintFormat" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerPrintFormat" )
    private String businessPartnerPrintFormat;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerPrintFormat</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> BUSINESS_PARTNER_PRINT_FORMAT =
        new BusinessPartnerField<String>("BusinessPartnerPrintFormat");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerOccupation</b>
     * </p>
     *
     * @return Occupation/group
     */
    @SerializedName( "BusinessPartnerOccupation" )
    @JsonProperty( "BusinessPartnerOccupation" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerOccupation" )
    private String businessPartnerOccupation;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerOccupation</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> BUSINESS_PARTNER_OCCUPATION =
        new BusinessPartnerField<String>("BusinessPartnerOccupation");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusPartMaritalStatus</b>
     * </p>
     *
     * @return Marital Status of Business Partner
     */
    @SerializedName( "BusPartMaritalStatus" )
    @JsonProperty( "BusPartMaritalStatus" )
    @Nullable
    @ODataField( odataName = "BusPartMaritalStatus" )
    private String busPartMaritalStatus;
    /**
     * Use with available fluent helpers to apply the <b>BusPartMaritalStatus</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> BUS_PART_MARITAL_STATUS =
        new BusinessPartnerField<String>("BusPartMaritalStatus");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusPartNationality</b>
     * </p>
     *
     * @return Nationality
     */
    @SerializedName( "BusPartNationality" )
    @JsonProperty( "BusPartNationality" )
    @Nullable
    @ODataField( odataName = "BusPartNationality" )
    private String busPartNationality;
    /**
     * Use with available fluent helpers to apply the <b>BusPartNationality</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> BUS_PART_NATIONALITY =
        new BusinessPartnerField<String>("BusPartNationality");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerBirthName</b>
     * </p>
     *
     * @return Name at birth of business partner
     */
    @SerializedName( "BusinessPartnerBirthName" )
    @JsonProperty( "BusinessPartnerBirthName" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerBirthName" )
    private String businessPartnerBirthName;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerBirthName</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> BUSINESS_PARTNER_BIRTH_NAME =
        new BusinessPartnerField<String>("BusinessPartnerBirthName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerSupplementName</b>
     * </p>
     *
     * @return Name supplement, e.g. noble title (key)
     */
    @SerializedName( "BusinessPartnerSupplementName" )
    @JsonProperty( "BusinessPartnerSupplementName" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerSupplementName" )
    private String businessPartnerSupplementName;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerSupplementName</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> BUSINESS_PARTNER_SUPPLEMENT_NAME =
        new BusinessPartnerField<String>("BusinessPartnerSupplementName");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>NaturalPersonEmployerName</b>
     * </p>
     *
     * @return Name of Employer of a Natural Person
     */
    @SerializedName( "NaturalPersonEmployerName" )
    @JsonProperty( "NaturalPersonEmployerName" )
    @Nullable
    @ODataField( odataName = "NaturalPersonEmployerName" )
    private String naturalPersonEmployerName;
    /**
     * Use with available fluent helpers to apply the <b>NaturalPersonEmployerName</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> NATURAL_PERSON_EMPLOYER_NAME =
        new BusinessPartnerField<String>("NaturalPersonEmployerName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LastNamePrefix</b>
     * </p>
     *
     * @return Name Prefix (Key)
     */
    @SerializedName( "LastNamePrefix" )
    @JsonProperty( "LastNamePrefix" )
    @Nullable
    @ODataField( odataName = "LastNamePrefix" )
    private String lastNamePrefix;
    /**
     * Use with available fluent helpers to apply the <b>LastNamePrefix</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> LAST_NAME_PREFIX =
        new BusinessPartnerField<String>("LastNamePrefix");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LastNameSecondPrefix</b>
     * </p>
     *
     * @return 2nd name prefix (key)
     */
    @SerializedName( "LastNameSecondPrefix" )
    @JsonProperty( "LastNameSecondPrefix" )
    @Nullable
    @ODataField( odataName = "LastNameSecondPrefix" )
    private String lastNameSecondPrefix;
    /**
     * Use with available fluent helpers to apply the <b>LastNameSecondPrefix</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> LAST_NAME_SECOND_PREFIX =
        new BusinessPartnerField<String>("LastNameSecondPrefix");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Initials</b>
     * </p>
     *
     * @return "Middle Initial" or personal initials
     */
    @SerializedName( "Initials" )
    @JsonProperty( "Initials" )
    @Nullable
    @ODataField( odataName = "Initials" )
    private String initials;
    /**
     * Use with available fluent helpers to apply the <b>Initials</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> INITIALS = new BusinessPartnerField<String>("Initials");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>TradingPartner</b>
     * </p>
     *
     * @return Company ID of Trading Partner
     */
    @SerializedName( "TradingPartner" )
    @JsonProperty( "TradingPartner" )
    @Nullable
    @ODataField( odataName = "TradingPartner" )
    private String tradingPartner;
    /**
     * Use with available fluent helpers to apply the <b>TradingPartner</b> field to query operations.
     *
     */
    public final static BusinessPartnerField<String> TRADING_PARTNER =
        new BusinessPartnerField<String>("TradingPartner");
    /**
     * Navigation property <b>to_BPCreditWorthiness</b> for <b>BusinessPartner</b> to single <b>BPCreditWorthiness</b>.
     *
     */
    @SerializedName( "to_BPCreditWorthiness" )
    @JsonProperty( "to_BPCreditWorthiness" )
    @ODataField( odataName = "to_BPCreditWorthiness" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BPCreditWorthiness toBPCreditWorthiness;
    /**
     * Navigation property <b>to_BPFinServicesReporting</b> for <b>BusinessPartner</b> to single
     * <b>BPFinancialServicesReporting</b>.
     *
     */
    @SerializedName( "to_BPFinServicesReporting" )
    @JsonProperty( "to_BPFinServicesReporting" )
    @ODataField( odataName = "to_BPFinServicesReporting" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BPFinancialServicesReporting toBPFinServicesReporting;
    /**
     * Navigation property <b>to_BPFiscalYearInformation</b> for <b>BusinessPartner</b> to multiple
     * <b>BPFiscalYearInformation</b>.
     *
     */
    @SerializedName( "to_BPFiscalYearInformation" )
    @JsonProperty( "to_BPFiscalYearInformation" )
    @ODataField( odataName = "to_BPFiscalYearInformation" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BPFiscalYearInformation> toBPFiscalYearInformation;
    /**
     * Navigation property <b>to_BPRelationship</b> for <b>BusinessPartner</b> to multiple <b>BPRelationship</b>.
     *
     */
    @SerializedName( "to_BPRelationship" )
    @JsonProperty( "to_BPRelationship" )
    @ODataField( odataName = "to_BPRelationship" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BPRelationship> toBPRelationship;
    /**
     * Navigation property <b>to_BuPaIdentification</b> for <b>BusinessPartner</b> to multiple
     * <b>BuPaIdentification</b>.
     *
     */
    @SerializedName( "to_BuPaIdentification" )
    @JsonProperty( "to_BuPaIdentification" )
    @ODataField( odataName = "to_BuPaIdentification" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BuPaIdentification> toBuPaIdentification;
    /**
     * Navigation property <b>to_BuPaIndustry</b> for <b>BusinessPartner</b> to multiple <b>BuPaIndustry</b>.
     *
     */
    @SerializedName( "to_BuPaIndustry" )
    @JsonProperty( "to_BuPaIndustry" )
    @ODataField( odataName = "to_BuPaIndustry" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BuPaIndustry> toBuPaIndustry;
    /**
     * Navigation property <b>to_BusinessPartner</b> for <b>BusinessPartner</b> to single
     * <b>BPFinancialServicesExtn</b>.
     *
     */
    @SerializedName( "to_BusinessPartner" )
    @JsonProperty( "to_BusinessPartner" )
    @ODataField( odataName = "to_BusinessPartner" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BPFinancialServicesExtn toBusinessPartner;
    /**
     * Navigation property <b>to_BusinessPartnerAddress</b> for <b>BusinessPartner</b> to multiple
     * <b>BusinessPartnerAddress</b>.
     *
     */
    @SerializedName( "to_BusinessPartnerAddress" )
    @JsonProperty( "to_BusinessPartnerAddress" )
    @ODataField( odataName = "to_BusinessPartnerAddress" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusinessPartnerAddress> toBusinessPartnerAddress;
    /**
     * Navigation property <b>to_BusinessPartnerBank</b> for <b>BusinessPartner</b> to multiple
     * <b>BusinessPartnerBank</b>.
     *
     */
    @SerializedName( "to_BusinessPartnerBank" )
    @JsonProperty( "to_BusinessPartnerBank" )
    @ODataField( odataName = "to_BusinessPartnerBank" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusinessPartnerBank> toBusinessPartnerBank;
    /**
     * Navigation property <b>to_BusinessPartnerContact</b> for <b>BusinessPartner</b> to multiple
     * <b>BusinessPartnerContact</b>.
     *
     */
    @SerializedName( "to_BusinessPartnerContact" )
    @JsonProperty( "to_BusinessPartnerContact" )
    @ODataField( odataName = "to_BusinessPartnerContact" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusinessPartnerContact> toBusinessPartnerContact;
    /**
     * Navigation property <b>to_BusinessPartnerRating</b> for <b>BusinessPartner</b> to multiple
     * <b>BusinessPartnerRating</b>.
     *
     */
    @SerializedName( "to_BusinessPartnerRating" )
    @JsonProperty( "to_BusinessPartnerRating" )
    @ODataField( odataName = "to_BusinessPartnerRating" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusinessPartnerRating> toBusinessPartnerRating;
    /**
     * Navigation property <b>to_BusinessPartnerRole</b> for <b>BusinessPartner</b> to multiple
     * <b>BusinessPartnerRole</b>.
     *
     */
    @SerializedName( "to_BusinessPartnerRole" )
    @JsonProperty( "to_BusinessPartnerRole" )
    @ODataField( odataName = "to_BusinessPartnerRole" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusinessPartnerRole> toBusinessPartnerRole;
    /**
     * Navigation property <b>to_BusinessPartnerTax</b> for <b>BusinessPartner</b> to multiple
     * <b>BusinessPartnerTaxNumber</b>.
     *
     */
    @SerializedName( "to_BusinessPartnerTax" )
    @JsonProperty( "to_BusinessPartnerTax" )
    @ODataField( odataName = "to_BusinessPartnerTax" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusinessPartnerTaxNumber> toBusinessPartnerTax;
    /**
     * Navigation property <b>to_BusPartAddrDepdntTaxNmbr</b> for <b>BusinessPartner</b> to multiple
     * <b>BusPartAddrDepdntTaxNmbr</b>.
     *
     */
    @SerializedName( "to_BusPartAddrDepdntTaxNmbr" )
    @JsonProperty( "to_BusPartAddrDepdntTaxNmbr" )
    @ODataField( odataName = "to_BusPartAddrDepdntTaxNmbr" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusPartAddrDepdntTaxNmbr> toBusPartAddrDepdntTaxNmbr;
    /**
     * Navigation property <b>to_Customer</b> for <b>BusinessPartner</b> to single <b>Customer</b>.
     *
     */
    @SerializedName( "to_Customer" )
    @JsonProperty( "to_Customer" )
    @ODataField( odataName = "to_Customer" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private Customer toCustomer;
    /**
     * Navigation property <b>to_Supplier</b> for <b>BusinessPartner</b> to single <b>Supplier</b>.
     *
     */
    @SerializedName( "to_Supplier" )
    @JsonProperty( "to_Supplier" )
    @ODataField( odataName = "to_Supplier" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private Supplier toSupplier;
    /**
     * Use with available fluent helpers to apply the <b>to_BPCreditWorthiness</b> navigation property to query
     * operations.
     *
     */
    public final static BusinessPartnerOneToOneLink<BPCreditWorthiness> TO_BP_CREDIT_WORTHINESS =
        new BusinessPartnerOneToOneLink<BPCreditWorthiness>("to_BPCreditWorthiness");
    /**
     * Use with available fluent helpers to apply the <b>to_BPFinServicesReporting</b> navigation property to query
     * operations.
     *
     */
    public final static BusinessPartnerOneToOneLink<BPFinancialServicesReporting> TO_BP_FIN_SERVICES_REPORTING =
        new BusinessPartnerOneToOneLink<BPFinancialServicesReporting>("to_BPFinServicesReporting");
    /**
     * Use with available fluent helpers to apply the <b>to_BPFiscalYearInformation</b> navigation property to query
     * operations.
     *
     */
    public final static BusinessPartnerLink<BPFiscalYearInformation> TO_BP_FISCAL_YEAR_INFORMATION =
        new BusinessPartnerLink<BPFiscalYearInformation>("to_BPFiscalYearInformation");
    /**
     * Use with available fluent helpers to apply the <b>to_BPRelationship</b> navigation property to query operations.
     *
     */
    public final static BusinessPartnerLink<BPRelationship> TO_BP_RELATIONSHIP =
        new BusinessPartnerLink<BPRelationship>("to_BPRelationship");
    /**
     * Use with available fluent helpers to apply the <b>to_BuPaIdentification</b> navigation property to query
     * operations.
     *
     */
    public final static BusinessPartnerLink<BuPaIdentification> TO_BU_PA_IDENTIFICATION =
        new BusinessPartnerLink<BuPaIdentification>("to_BuPaIdentification");
    /**
     * Use with available fluent helpers to apply the <b>to_BuPaIndustry</b> navigation property to query operations.
     *
     */
    public final static BusinessPartnerLink<BuPaIndustry> TO_BU_PA_INDUSTRY =
        new BusinessPartnerLink<BuPaIndustry>("to_BuPaIndustry");
    /**
     * Use with available fluent helpers to apply the <b>to_BusinessPartner</b> navigation property to query operations.
     *
     */
    public final static BusinessPartnerOneToOneLink<BPFinancialServicesExtn> TO_BUSINESS_PARTNER =
        new BusinessPartnerOneToOneLink<BPFinancialServicesExtn>("to_BusinessPartner");
    /**
     * Use with available fluent helpers to apply the <b>to_BusinessPartnerAddress</b> navigation property to query
     * operations.
     *
     */
    public final static BusinessPartnerLink<BusinessPartnerAddress> TO_BUSINESS_PARTNER_ADDRESS =
        new BusinessPartnerLink<BusinessPartnerAddress>("to_BusinessPartnerAddress");
    /**
     * Use with available fluent helpers to apply the <b>to_BusinessPartnerBank</b> navigation property to query
     * operations.
     *
     */
    public final static BusinessPartnerLink<BusinessPartnerBank> TO_BUSINESS_PARTNER_BANK =
        new BusinessPartnerLink<BusinessPartnerBank>("to_BusinessPartnerBank");
    /**
     * Use with available fluent helpers to apply the <b>to_BusinessPartnerContact</b> navigation property to query
     * operations.
     *
     */
    public final static BusinessPartnerLink<BusinessPartnerContact> TO_BUSINESS_PARTNER_CONTACT =
        new BusinessPartnerLink<BusinessPartnerContact>("to_BusinessPartnerContact");
    /**
     * Use with available fluent helpers to apply the <b>to_BusinessPartnerRating</b> navigation property to query
     * operations.
     *
     */
    public final static BusinessPartnerLink<BusinessPartnerRating> TO_BUSINESS_PARTNER_RATING =
        new BusinessPartnerLink<BusinessPartnerRating>("to_BusinessPartnerRating");
    /**
     * Use with available fluent helpers to apply the <b>to_BusinessPartnerRole</b> navigation property to query
     * operations.
     *
     */
    public final static BusinessPartnerLink<BusinessPartnerRole> TO_BUSINESS_PARTNER_ROLE =
        new BusinessPartnerLink<BusinessPartnerRole>("to_BusinessPartnerRole");
    /**
     * Use with available fluent helpers to apply the <b>to_BusinessPartnerTax</b> navigation property to query
     * operations.
     *
     */
    public final static BusinessPartnerLink<BusinessPartnerTaxNumber> TO_BUSINESS_PARTNER_TAX =
        new BusinessPartnerLink<BusinessPartnerTaxNumber>("to_BusinessPartnerTax");
    /**
     * Use with available fluent helpers to apply the <b>to_BusPartAddrDepdntTaxNmbr</b> navigation property to query
     * operations.
     *
     */
    public final static BusinessPartnerLink<BusPartAddrDepdntTaxNmbr> TO_BUS_PART_ADDR_DEPDNT_TAX_NMBR =
        new BusinessPartnerLink<BusPartAddrDepdntTaxNmbr>("to_BusPartAddrDepdntTaxNmbr");
    /**
     * Use with available fluent helpers to apply the <b>to_Customer</b> navigation property to query operations.
     *
     */
    public final static BusinessPartnerOneToOneLink<Customer> TO_CUSTOMER =
        new BusinessPartnerOneToOneLink<Customer>("to_Customer");
    /**
     * Use with available fluent helpers to apply the <b>to_Supplier</b> navigation property to query operations.
     *
     */
    public final static BusinessPartnerOneToOneLink<Supplier> TO_SUPPLIER =
        new BusinessPartnerOneToOneLink<Supplier>("to_Supplier");

    @Nonnull
    @Override
    public Class<BusinessPartner> getType()
    {
        return BusinessPartner.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     *
     * @param businessPartner
     *            Business Partner Number
     */
    public void setBusinessPartner( @Nullable final String businessPartner )
    {
        rememberChangedField("BusinessPartner", this.businessPartner);
        this.businessPartner = businessPartner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Customer Number
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Account Number of Supplier
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AcademicTitle</b>
     * </p>
     *
     * @param academicTitle
     *            Academic Title: Key
     */
    public void setAcademicTitle( @Nullable final String academicTitle )
    {
        rememberChangedField("AcademicTitle", this.academicTitle);
        this.academicTitle = academicTitle;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationGroup</b>
     * </p>
     *
     * @param authorizationGroup
     *            Authorization Group
     */
    public void setAuthorizationGroup( @Nullable final String authorizationGroup )
    {
        rememberChangedField("AuthorizationGroup", this.authorizationGroup);
        this.authorizationGroup = authorizationGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerCategory</b>
     * </p>
     *
     * @param businessPartnerCategory
     *            Business Partner Category
     */
    public void setBusinessPartnerCategory( @Nullable final String businessPartnerCategory )
    {
        rememberChangedField("BusinessPartnerCategory", this.businessPartnerCategory);
        this.businessPartnerCategory = businessPartnerCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 81
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerFullName</b>
     * </p>
     *
     * @param businessPartnerFullName
     *            The businessPartnerFullName to set.
     */
    public void setBusinessPartnerFullName( @Nullable final String businessPartnerFullName )
    {
        rememberChangedField("BusinessPartnerFullName", this.businessPartnerFullName);
        this.businessPartnerFullName = businessPartnerFullName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerGrouping</b>
     * </p>
     *
     * @param businessPartnerGrouping
     *            Business Partner Grouping
     */
    public void setBusinessPartnerGrouping( @Nullable final String businessPartnerGrouping )
    {
        rememberChangedField("BusinessPartnerGrouping", this.businessPartnerGrouping);
        this.businessPartnerGrouping = businessPartnerGrouping;
    }

    /**
     * Constraints: Not nullable, Maximum length: 81
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName</b>
     * </p>
     *
     * @param businessPartnerName
     *            The businessPartnerName to set.
     */
    public void setBusinessPartnerName( @Nullable final String businessPartnerName )
    {
        rememberChangedField("BusinessPartnerName", this.businessPartnerName);
        this.businessPartnerName = businessPartnerName;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerUUID</b>
     * </p>
     *
     * @param businessPartnerUUID
     *            Business Partner GUID
     */
    public void setBusinessPartnerUUID( @Nullable final UUID businessPartnerUUID )
    {
        rememberChangedField("BusinessPartnerUUID", this.businessPartnerUUID);
        this.businessPartnerUUID = businessPartnerUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CorrespondenceLanguage</b>
     * </p>
     *
     * @param correspondenceLanguage
     *            Business Partner: Correspondence Language
     */
    public void setCorrespondenceLanguage( @Nullable final String correspondenceLanguage )
    {
        rememberChangedField("CorrespondenceLanguage", this.correspondenceLanguage);
        this.correspondenceLanguage = correspondenceLanguage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            User who created the object
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Date on which the object was created
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @param creationTime
     *            Time at which the object was created
     */
    public void setCreationTime( @Nullable final LocalTime creationTime )
    {
        rememberChangedField("CreationTime", this.creationTime);
        this.creationTime = creationTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FirstName</b>
     * </p>
     *
     * @param firstName
     *            First Name of Business Partner (Person)
     */
    public void setFirstName( @Nullable final String firstName )
    {
        rememberChangedField("FirstName", this.firstName);
        this.firstName = firstName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FormOfAddress</b>
     * </p>
     *
     * @param formOfAddress
     *            Form-of-Address Key
     */
    public void setFormOfAddress( @Nullable final String formOfAddress )
    {
        rememberChangedField("FormOfAddress", this.formOfAddress);
        this.formOfAddress = formOfAddress;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Industry</b>
     * </p>
     *
     * @param industry
     *            Industry sector
     */
    public void setIndustry( @Nullable final String industry )
    {
        rememberChangedField("Industry", this.industry);
        this.industry = industry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>InternationalLocationNumber1</b>
     * </p>
     *
     * @param internationalLocationNumber1
     *            International location number (part 1)
     */
    public void setInternationalLocationNumber1( @Nullable final String internationalLocationNumber1 )
    {
        rememberChangedField("InternationalLocationNumber1", this.internationalLocationNumber1);
        this.internationalLocationNumber1 = internationalLocationNumber1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>InternationalLocationNumber2</b>
     * </p>
     *
     * @param internationalLocationNumber2
     *            International location number (Part 2)
     */
    public void setInternationalLocationNumber2( @Nullable final String internationalLocationNumber2 )
    {
        rememberChangedField("InternationalLocationNumber2", this.internationalLocationNumber2);
        this.internationalLocationNumber2 = internationalLocationNumber2;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsFemale</b>
     * </p>
     *
     * @param isFemale
     *            Selection: Business partner is female
     */
    public void setIsFemale( @Nullable final Boolean isFemale )
    {
        rememberChangedField("IsFemale", this.isFemale);
        this.isFemale = isFemale;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMale</b>
     * </p>
     *
     * @param isMale
     *            Selection: Business partner is male
     */
    public void setIsMale( @Nullable final Boolean isMale )
    {
        rememberChangedField("IsMale", this.isMale);
        this.isMale = isMale;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsNaturalPerson</b>
     * </p>
     *
     * @param isNaturalPerson
     *            Business Partner Is a Natural Person Under the Tax Laws
     */
    public void setIsNaturalPerson( @Nullable final String isNaturalPerson )
    {
        rememberChangedField("IsNaturalPerson", this.isNaturalPerson);
        this.isNaturalPerson = isNaturalPerson;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsSexUnknown</b>
     * </p>
     *
     * @param isSexUnknown
     *            Selection: Sex of business partner is not known
     */
    public void setIsSexUnknown( @Nullable final Boolean isSexUnknown )
    {
        rememberChangedField("IsSexUnknown", this.isSexUnknown);
        this.isSexUnknown = isSexUnknown;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>GenderCodeName</b>
     * </p>
     *
     * @param genderCodeName
     *            Gender of Business Partner (Person)
     */
    public void setGenderCodeName( @Nullable final String genderCodeName )
    {
        rememberChangedField("GenderCodeName", this.genderCodeName);
        this.genderCodeName = genderCodeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Business partner: Language
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Date when object was last changed
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeTime</b>
     * </p>
     *
     * @param lastChangeTime
     *            Time at which object was last changed
     */
    public void setLastChangeTime( @Nullable final LocalTime lastChangeTime )
    {
        rememberChangedField("LastChangeTime", this.lastChangeTime);
        this.lastChangeTime = lastChangeTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Last user to change object
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>LastName</b>
     * </p>
     *
     * @param lastName
     *            Last Name of Business Partner (Person)
     */
    public void setLastName( @Nullable final String lastName )
    {
        rememberChangedField("LastName", this.lastName);
        this.lastName = lastName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>LegalForm</b>
     * </p>
     *
     * @param legalForm
     *            BP: Legal form of organization
     */
    public void setLegalForm( @Nullable final String legalForm )
    {
        rememberChangedField("LegalForm", this.legalForm);
        this.legalForm = legalForm;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationBPName1</b>
     * </p>
     *
     * @param organizationBPName1
     *            Name 1 of organization
     */
    public void setOrganizationBPName1( @Nullable final String organizationBPName1 )
    {
        rememberChangedField("OrganizationBPName1", this.organizationBPName1);
        this.organizationBPName1 = organizationBPName1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationBPName2</b>
     * </p>
     *
     * @param organizationBPName2
     *            Name 2 of organization
     */
    public void setOrganizationBPName2( @Nullable final String organizationBPName2 )
    {
        rememberChangedField("OrganizationBPName2", this.organizationBPName2);
        this.organizationBPName2 = organizationBPName2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationBPName3</b>
     * </p>
     *
     * @param organizationBPName3
     *            Name 3 of organization
     */
    public void setOrganizationBPName3( @Nullable final String organizationBPName3 )
    {
        rememberChangedField("OrganizationBPName3", this.organizationBPName3);
        this.organizationBPName3 = organizationBPName3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationBPName4</b>
     * </p>
     *
     * @param organizationBPName4
     *            Name 4 of organization
     */
    public void setOrganizationBPName4( @Nullable final String organizationBPName4 )
    {
        rememberChangedField("OrganizationBPName4", this.organizationBPName4);
        this.organizationBPName4 = organizationBPName4;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationFoundationDate</b>
     * </p>
     *
     * @param organizationFoundationDate
     *            Date organization founded
     */
    public void setOrganizationFoundationDate( @Nullable final LocalDateTime organizationFoundationDate )
    {
        rememberChangedField("OrganizationFoundationDate", this.organizationFoundationDate);
        this.organizationFoundationDate = organizationFoundationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationLiquidationDate</b>
     * </p>
     *
     * @param organizationLiquidationDate
     *            Liquidation date of organization
     */
    public void setOrganizationLiquidationDate( @Nullable final LocalDateTime organizationLiquidationDate )
    {
        rememberChangedField("OrganizationLiquidationDate", this.organizationLiquidationDate);
        this.organizationLiquidationDate = organizationLiquidationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SearchTerm1</b>
     * </p>
     *
     * @param searchTerm1
     *            Search Term 1 for Business Partner
     */
    public void setSearchTerm1( @Nullable final String searchTerm1 )
    {
        rememberChangedField("SearchTerm1", this.searchTerm1);
        this.searchTerm1 = searchTerm1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SearchTerm2</b>
     * </p>
     *
     * @param searchTerm2
     *            Search Term 2 for Business Partner
     */
    public void setSearchTerm2( @Nullable final String searchTerm2 )
    {
        rememberChangedField("SearchTerm2", this.searchTerm2);
        this.searchTerm2 = searchTerm2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalLastName</b>
     * </p>
     *
     * @param additionalLastName
     *            Other Last Name of a Person
     */
    public void setAdditionalLastName( @Nullable final String additionalLastName )
    {
        rememberChangedField("AdditionalLastName", this.additionalLastName);
        this.additionalLastName = additionalLastName;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BirthDate</b>
     * </p>
     *
     * @param birthDate
     *            Date of Birth of Business Partner
     */
    public void setBirthDate( @Nullable final LocalDateTime birthDate )
    {
        rememberChangedField("BirthDate", this.birthDate);
        this.birthDate = birthDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerBirthDateStatus</b>
     * </p>
     *
     * @param businessPartnerBirthDateStatus
     *            Date of Birth: Status
     */
    public void setBusinessPartnerBirthDateStatus( @Nullable final String businessPartnerBirthDateStatus )
    {
        rememberChangedField("BusinessPartnerBirthDateStatus", this.businessPartnerBirthDateStatus);
        this.businessPartnerBirthDateStatus = businessPartnerBirthDateStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerBirthplaceName</b>
     * </p>
     *
     * @param businessPartnerBirthplaceName
     *            Birthplace of business partner
     */
    public void setBusinessPartnerBirthplaceName( @Nullable final String businessPartnerBirthplaceName )
    {
        rememberChangedField("BusinessPartnerBirthplaceName", this.businessPartnerBirthplaceName);
        this.businessPartnerBirthplaceName = businessPartnerBirthplaceName;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerDeathDate</b>
     * </p>
     *
     * @param businessPartnerDeathDate
     *            Date of death of business partner
     */
    public void setBusinessPartnerDeathDate( @Nullable final LocalDateTime businessPartnerDeathDate )
    {
        rememberChangedField("BusinessPartnerDeathDate", this.businessPartnerDeathDate);
        this.businessPartnerDeathDate = businessPartnerDeathDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerIsBlocked</b>
     * </p>
     *
     * @param businessPartnerIsBlocked
     *            Central Block for Business Partner
     */
    public void setBusinessPartnerIsBlocked( @Nullable final Boolean businessPartnerIsBlocked )
    {
        rememberChangedField("BusinessPartnerIsBlocked", this.businessPartnerIsBlocked);
        this.businessPartnerIsBlocked = businessPartnerIsBlocked;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerType</b>
     * </p>
     *
     * @param businessPartnerType
     *            Business Partner Type
     */
    public void setBusinessPartnerType( @Nullable final String businessPartnerType )
    {
        rememberChangedField("BusinessPartnerType", this.businessPartnerType);
        this.businessPartnerType = businessPartnerType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 26
     * <p>
     * Original property name from the Odata EDM: <b>ETag</b>
     * </p>
     *
     * @param eTag
     *            The eTag to set.
     */
    public void setETag( @Nullable final String eTag )
    {
        rememberChangedField("ETag", this.eTag);
        this.eTag = eTag;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>GroupBusinessPartnerName1</b>
     * </p>
     *
     * @param groupBusinessPartnerName1
     *            Name 1 (group)
     */
    public void setGroupBusinessPartnerName1( @Nullable final String groupBusinessPartnerName1 )
    {
        rememberChangedField("GroupBusinessPartnerName1", this.groupBusinessPartnerName1);
        this.groupBusinessPartnerName1 = groupBusinessPartnerName1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>GroupBusinessPartnerName2</b>
     * </p>
     *
     * @param groupBusinessPartnerName2
     *            Name 2 (group)
     */
    public void setGroupBusinessPartnerName2( @Nullable final String groupBusinessPartnerName2 )
    {
        rememberChangedField("GroupBusinessPartnerName2", this.groupBusinessPartnerName2);
        this.groupBusinessPartnerName2 = groupBusinessPartnerName2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>IndependentAddressID</b>
     * </p>
     *
     * @param independentAddressID
     *            Address Number
     */
    public void setIndependentAddressID( @Nullable final String independentAddressID )
    {
        rememberChangedField("IndependentAddressID", this.independentAddressID);
        this.independentAddressID = independentAddressID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InternationalLocationNumber3</b>
     * </p>
     *
     * @param internationalLocationNumber3
     *            Check digit for the international location number
     */
    public void setInternationalLocationNumber3( @Nullable final String internationalLocationNumber3 )
    {
        rememberChangedField("InternationalLocationNumber3", this.internationalLocationNumber3);
        this.internationalLocationNumber3 = internationalLocationNumber3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MiddleName</b>
     * </p>
     *
     * @param middleName
     *            Middle Name or Second Forename of a Person
     */
    public void setMiddleName( @Nullable final String middleName )
    {
        rememberChangedField("MiddleName", this.middleName);
        this.middleName = middleName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>NameCountry</b>
     * </p>
     *
     * @param nameCountry
     *            Country/Region for Name Format Rule
     */
    public void setNameCountry( @Nullable final String nameCountry )
    {
        rememberChangedField("NameCountry", this.nameCountry);
        this.nameCountry = nameCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>NameFormat</b>
     * </p>
     *
     * @param nameFormat
     *            Name format
     */
    public void setNameFormat( @Nullable final String nameFormat )
    {
        rememberChangedField("NameFormat", this.nameFormat);
        this.nameFormat = nameFormat;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>PersonFullName</b>
     * </p>
     *
     * @param personFullName
     *            Full Name
     */
    public void setPersonFullName( @Nullable final String personFullName )
    {
        rememberChangedField("PersonFullName", this.personFullName);
        this.personFullName = personFullName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PersonNumber</b>
     * </p>
     *
     * @param personNumber
     *            Person Number
     */
    public void setPersonNumber( @Nullable final String personNumber )
    {
        rememberChangedField("PersonNumber", this.personNumber);
        this.personNumber = personNumber;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMarkedForArchiving</b>
     * </p>
     *
     * @param isMarkedForArchiving
     *            Central Archiving Flag
     */
    public void setIsMarkedForArchiving( @Nullable final Boolean isMarkedForArchiving )
    {
        rememberChangedField("IsMarkedForArchiving", this.isMarkedForArchiving);
        this.isMarkedForArchiving = isMarkedForArchiving;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerIDByExtSystem</b>
     * </p>
     *
     * @param businessPartnerIDByExtSystem
     *            Business Partner Number in External System
     */
    public void setBusinessPartnerIDByExtSystem( @Nullable final String businessPartnerIDByExtSystem )
    {
        rememberChangedField("BusinessPartnerIDByExtSystem", this.businessPartnerIDByExtSystem);
        this.businessPartnerIDByExtSystem = businessPartnerIDByExtSystem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerPrintFormat</b>
     * </p>
     *
     * @param businessPartnerPrintFormat
     *            Business Partner Print Format
     */
    public void setBusinessPartnerPrintFormat( @Nullable final String businessPartnerPrintFormat )
    {
        rememberChangedField("BusinessPartnerPrintFormat", this.businessPartnerPrintFormat);
        this.businessPartnerPrintFormat = businessPartnerPrintFormat;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerOccupation</b>
     * </p>
     *
     * @param businessPartnerOccupation
     *            Occupation/group
     */
    public void setBusinessPartnerOccupation( @Nullable final String businessPartnerOccupation )
    {
        rememberChangedField("BusinessPartnerOccupation", this.businessPartnerOccupation);
        this.businessPartnerOccupation = businessPartnerOccupation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusPartMaritalStatus</b>
     * </p>
     *
     * @param busPartMaritalStatus
     *            Marital Status of Business Partner
     */
    public void setBusPartMaritalStatus( @Nullable final String busPartMaritalStatus )
    {
        rememberChangedField("BusPartMaritalStatus", this.busPartMaritalStatus);
        this.busPartMaritalStatus = busPartMaritalStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusPartNationality</b>
     * </p>
     *
     * @param busPartNationality
     *            Nationality
     */
    public void setBusPartNationality( @Nullable final String busPartNationality )
    {
        rememberChangedField("BusPartNationality", this.busPartNationality);
        this.busPartNationality = busPartNationality;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerBirthName</b>
     * </p>
     *
     * @param businessPartnerBirthName
     *            Name at birth of business partner
     */
    public void setBusinessPartnerBirthName( @Nullable final String businessPartnerBirthName )
    {
        rememberChangedField("BusinessPartnerBirthName", this.businessPartnerBirthName);
        this.businessPartnerBirthName = businessPartnerBirthName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerSupplementName</b>
     * </p>
     *
     * @param businessPartnerSupplementName
     *            Name supplement, e.g. noble title (key)
     */
    public void setBusinessPartnerSupplementName( @Nullable final String businessPartnerSupplementName )
    {
        rememberChangedField("BusinessPartnerSupplementName", this.businessPartnerSupplementName);
        this.businessPartnerSupplementName = businessPartnerSupplementName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>NaturalPersonEmployerName</b>
     * </p>
     *
     * @param naturalPersonEmployerName
     *            Name of Employer of a Natural Person
     */
    public void setNaturalPersonEmployerName( @Nullable final String naturalPersonEmployerName )
    {
        rememberChangedField("NaturalPersonEmployerName", this.naturalPersonEmployerName);
        this.naturalPersonEmployerName = naturalPersonEmployerName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LastNamePrefix</b>
     * </p>
     *
     * @param lastNamePrefix
     *            Name Prefix (Key)
     */
    public void setLastNamePrefix( @Nullable final String lastNamePrefix )
    {
        rememberChangedField("LastNamePrefix", this.lastNamePrefix);
        this.lastNamePrefix = lastNamePrefix;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LastNameSecondPrefix</b>
     * </p>
     *
     * @param lastNameSecondPrefix
     *            2nd name prefix (key)
     */
    public void setLastNameSecondPrefix( @Nullable final String lastNameSecondPrefix )
    {
        rememberChangedField("LastNameSecondPrefix", this.lastNameSecondPrefix);
        this.lastNameSecondPrefix = lastNameSecondPrefix;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Initials</b>
     * </p>
     *
     * @param initials
     *            "Middle Initial" or personal initials
     */
    public void setInitials( @Nullable final String initials )
    {
        rememberChangedField("Initials", this.initials);
        this.initials = initials;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>TradingPartner</b>
     * </p>
     *
     * @param tradingPartner
     *            Company ID of Trading Partner
     */
    public void setTradingPartner( @Nullable final String tradingPartner )
    {
        rememberChangedField("TradingPartner", this.tradingPartner);
        this.tradingPartner = tradingPartner;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BusinessPartner";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BusinessPartner", getBusinessPartner());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BusinessPartner", getBusinessPartner());
        values.put("Customer", getCustomer());
        values.put("Supplier", getSupplier());
        values.put("AcademicTitle", getAcademicTitle());
        values.put("AuthorizationGroup", getAuthorizationGroup());
        values.put("BusinessPartnerCategory", getBusinessPartnerCategory());
        values.put("BusinessPartnerFullName", getBusinessPartnerFullName());
        values.put("BusinessPartnerGrouping", getBusinessPartnerGrouping());
        values.put("BusinessPartnerName", getBusinessPartnerName());
        values.put("BusinessPartnerUUID", getBusinessPartnerUUID());
        values.put("CorrespondenceLanguage", getCorrespondenceLanguage());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDate", getCreationDate());
        values.put("CreationTime", getCreationTime());
        values.put("FirstName", getFirstName());
        values.put("FormOfAddress", getFormOfAddress());
        values.put("Industry", getIndustry());
        values.put("InternationalLocationNumber1", getInternationalLocationNumber1());
        values.put("InternationalLocationNumber2", getInternationalLocationNumber2());
        values.put("IsFemale", getIsFemale());
        values.put("IsMale", getIsMale());
        values.put("IsNaturalPerson", getIsNaturalPerson());
        values.put("IsSexUnknown", getIsSexUnknown());
        values.put("GenderCodeName", getGenderCodeName());
        values.put("Language", getLanguage());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("LastChangeTime", getLastChangeTime());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastName", getLastName());
        values.put("LegalForm", getLegalForm());
        values.put("OrganizationBPName1", getOrganizationBPName1());
        values.put("OrganizationBPName2", getOrganizationBPName2());
        values.put("OrganizationBPName3", getOrganizationBPName3());
        values.put("OrganizationBPName4", getOrganizationBPName4());
        values.put("OrganizationFoundationDate", getOrganizationFoundationDate());
        values.put("OrganizationLiquidationDate", getOrganizationLiquidationDate());
        values.put("SearchTerm1", getSearchTerm1());
        values.put("SearchTerm2", getSearchTerm2());
        values.put("AdditionalLastName", getAdditionalLastName());
        values.put("BirthDate", getBirthDate());
        values.put("BusinessPartnerBirthDateStatus", getBusinessPartnerBirthDateStatus());
        values.put("BusinessPartnerBirthplaceName", getBusinessPartnerBirthplaceName());
        values.put("BusinessPartnerDeathDate", getBusinessPartnerDeathDate());
        values.put("BusinessPartnerIsBlocked", getBusinessPartnerIsBlocked());
        values.put("BusinessPartnerType", getBusinessPartnerType());
        values.put("ETag", getETag());
        values.put("GroupBusinessPartnerName1", getGroupBusinessPartnerName1());
        values.put("GroupBusinessPartnerName2", getGroupBusinessPartnerName2());
        values.put("IndependentAddressID", getIndependentAddressID());
        values.put("InternationalLocationNumber3", getInternationalLocationNumber3());
        values.put("MiddleName", getMiddleName());
        values.put("NameCountry", getNameCountry());
        values.put("NameFormat", getNameFormat());
        values.put("PersonFullName", getPersonFullName());
        values.put("PersonNumber", getPersonNumber());
        values.put("IsMarkedForArchiving", getIsMarkedForArchiving());
        values.put("BusinessPartnerIDByExtSystem", getBusinessPartnerIDByExtSystem());
        values.put("BusinessPartnerPrintFormat", getBusinessPartnerPrintFormat());
        values.put("BusinessPartnerOccupation", getBusinessPartnerOccupation());
        values.put("BusPartMaritalStatus", getBusPartMaritalStatus());
        values.put("BusPartNationality", getBusPartNationality());
        values.put("BusinessPartnerBirthName", getBusinessPartnerBirthName());
        values.put("BusinessPartnerSupplementName", getBusinessPartnerSupplementName());
        values.put("NaturalPersonEmployerName", getNaturalPersonEmployerName());
        values.put("LastNamePrefix", getLastNamePrefix());
        values.put("LastNameSecondPrefix", getLastNameSecondPrefix());
        values.put("Initials", getInitials());
        values.put("TradingPartner", getTradingPartner());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BusinessPartner") ) {
                final Object value = values.remove("BusinessPartner");
                if( (value == null) || (!value.equals(getBusinessPartner())) ) {
                    setBusinessPartner(((String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("AcademicTitle") ) {
                final Object value = values.remove("AcademicTitle");
                if( (value == null) || (!value.equals(getAcademicTitle())) ) {
                    setAcademicTitle(((String) value));
                }
            }
            if( values.containsKey("AuthorizationGroup") ) {
                final Object value = values.remove("AuthorizationGroup");
                if( (value == null) || (!value.equals(getAuthorizationGroup())) ) {
                    setAuthorizationGroup(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerCategory") ) {
                final Object value = values.remove("BusinessPartnerCategory");
                if( (value == null) || (!value.equals(getBusinessPartnerCategory())) ) {
                    setBusinessPartnerCategory(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerFullName") ) {
                final Object value = values.remove("BusinessPartnerFullName");
                if( (value == null) || (!value.equals(getBusinessPartnerFullName())) ) {
                    setBusinessPartnerFullName(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerGrouping") ) {
                final Object value = values.remove("BusinessPartnerGrouping");
                if( (value == null) || (!value.equals(getBusinessPartnerGrouping())) ) {
                    setBusinessPartnerGrouping(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerName") ) {
                final Object value = values.remove("BusinessPartnerName");
                if( (value == null) || (!value.equals(getBusinessPartnerName())) ) {
                    setBusinessPartnerName(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerUUID") ) {
                final Object value = values.remove("BusinessPartnerUUID");
                if( (value == null) || (!value.equals(getBusinessPartnerUUID())) ) {
                    setBusinessPartnerUUID(((UUID) value));
                }
            }
            if( values.containsKey("CorrespondenceLanguage") ) {
                final Object value = values.remove("CorrespondenceLanguage");
                if( (value == null) || (!value.equals(getCorrespondenceLanguage())) ) {
                    setCorrespondenceLanguage(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreationTime") ) {
                final Object value = values.remove("CreationTime");
                if( (value == null) || (!value.equals(getCreationTime())) ) {
                    setCreationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("FirstName") ) {
                final Object value = values.remove("FirstName");
                if( (value == null) || (!value.equals(getFirstName())) ) {
                    setFirstName(((String) value));
                }
            }
            if( values.containsKey("FormOfAddress") ) {
                final Object value = values.remove("FormOfAddress");
                if( (value == null) || (!value.equals(getFormOfAddress())) ) {
                    setFormOfAddress(((String) value));
                }
            }
            if( values.containsKey("Industry") ) {
                final Object value = values.remove("Industry");
                if( (value == null) || (!value.equals(getIndustry())) ) {
                    setIndustry(((String) value));
                }
            }
            if( values.containsKey("InternationalLocationNumber1") ) {
                final Object value = values.remove("InternationalLocationNumber1");
                if( (value == null) || (!value.equals(getInternationalLocationNumber1())) ) {
                    setInternationalLocationNumber1(((String) value));
                }
            }
            if( values.containsKey("InternationalLocationNumber2") ) {
                final Object value = values.remove("InternationalLocationNumber2");
                if( (value == null) || (!value.equals(getInternationalLocationNumber2())) ) {
                    setInternationalLocationNumber2(((String) value));
                }
            }
            if( values.containsKey("IsFemale") ) {
                final Object value = values.remove("IsFemale");
                if( (value == null) || (!value.equals(getIsFemale())) ) {
                    setIsFemale(((Boolean) value));
                }
            }
            if( values.containsKey("IsMale") ) {
                final Object value = values.remove("IsMale");
                if( (value == null) || (!value.equals(getIsMale())) ) {
                    setIsMale(((Boolean) value));
                }
            }
            if( values.containsKey("IsNaturalPerson") ) {
                final Object value = values.remove("IsNaturalPerson");
                if( (value == null) || (!value.equals(getIsNaturalPerson())) ) {
                    setIsNaturalPerson(((String) value));
                }
            }
            if( values.containsKey("IsSexUnknown") ) {
                final Object value = values.remove("IsSexUnknown");
                if( (value == null) || (!value.equals(getIsSexUnknown())) ) {
                    setIsSexUnknown(((Boolean) value));
                }
            }
            if( values.containsKey("GenderCodeName") ) {
                final Object value = values.remove("GenderCodeName");
                if( (value == null) || (!value.equals(getGenderCodeName())) ) {
                    setGenderCodeName(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangeTime") ) {
                final Object value = values.remove("LastChangeTime");
                if( (value == null) || (!value.equals(getLastChangeTime())) ) {
                    setLastChangeTime(((LocalTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastName") ) {
                final Object value = values.remove("LastName");
                if( (value == null) || (!value.equals(getLastName())) ) {
                    setLastName(((String) value));
                }
            }
            if( values.containsKey("LegalForm") ) {
                final Object value = values.remove("LegalForm");
                if( (value == null) || (!value.equals(getLegalForm())) ) {
                    setLegalForm(((String) value));
                }
            }
            if( values.containsKey("OrganizationBPName1") ) {
                final Object value = values.remove("OrganizationBPName1");
                if( (value == null) || (!value.equals(getOrganizationBPName1())) ) {
                    setOrganizationBPName1(((String) value));
                }
            }
            if( values.containsKey("OrganizationBPName2") ) {
                final Object value = values.remove("OrganizationBPName2");
                if( (value == null) || (!value.equals(getOrganizationBPName2())) ) {
                    setOrganizationBPName2(((String) value));
                }
            }
            if( values.containsKey("OrganizationBPName3") ) {
                final Object value = values.remove("OrganizationBPName3");
                if( (value == null) || (!value.equals(getOrganizationBPName3())) ) {
                    setOrganizationBPName3(((String) value));
                }
            }
            if( values.containsKey("OrganizationBPName4") ) {
                final Object value = values.remove("OrganizationBPName4");
                if( (value == null) || (!value.equals(getOrganizationBPName4())) ) {
                    setOrganizationBPName4(((String) value));
                }
            }
            if( values.containsKey("OrganizationFoundationDate") ) {
                final Object value = values.remove("OrganizationFoundationDate");
                if( (value == null) || (!value.equals(getOrganizationFoundationDate())) ) {
                    setOrganizationFoundationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("OrganizationLiquidationDate") ) {
                final Object value = values.remove("OrganizationLiquidationDate");
                if( (value == null) || (!value.equals(getOrganizationLiquidationDate())) ) {
                    setOrganizationLiquidationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SearchTerm1") ) {
                final Object value = values.remove("SearchTerm1");
                if( (value == null) || (!value.equals(getSearchTerm1())) ) {
                    setSearchTerm1(((String) value));
                }
            }
            if( values.containsKey("SearchTerm2") ) {
                final Object value = values.remove("SearchTerm2");
                if( (value == null) || (!value.equals(getSearchTerm2())) ) {
                    setSearchTerm2(((String) value));
                }
            }
            if( values.containsKey("AdditionalLastName") ) {
                final Object value = values.remove("AdditionalLastName");
                if( (value == null) || (!value.equals(getAdditionalLastName())) ) {
                    setAdditionalLastName(((String) value));
                }
            }
            if( values.containsKey("BirthDate") ) {
                final Object value = values.remove("BirthDate");
                if( (value == null) || (!value.equals(getBirthDate())) ) {
                    setBirthDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BusinessPartnerBirthDateStatus") ) {
                final Object value = values.remove("BusinessPartnerBirthDateStatus");
                if( (value == null) || (!value.equals(getBusinessPartnerBirthDateStatus())) ) {
                    setBusinessPartnerBirthDateStatus(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerBirthplaceName") ) {
                final Object value = values.remove("BusinessPartnerBirthplaceName");
                if( (value == null) || (!value.equals(getBusinessPartnerBirthplaceName())) ) {
                    setBusinessPartnerBirthplaceName(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerDeathDate") ) {
                final Object value = values.remove("BusinessPartnerDeathDate");
                if( (value == null) || (!value.equals(getBusinessPartnerDeathDate())) ) {
                    setBusinessPartnerDeathDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BusinessPartnerIsBlocked") ) {
                final Object value = values.remove("BusinessPartnerIsBlocked");
                if( (value == null) || (!value.equals(getBusinessPartnerIsBlocked())) ) {
                    setBusinessPartnerIsBlocked(((Boolean) value));
                }
            }
            if( values.containsKey("BusinessPartnerType") ) {
                final Object value = values.remove("BusinessPartnerType");
                if( (value == null) || (!value.equals(getBusinessPartnerType())) ) {
                    setBusinessPartnerType(((String) value));
                }
            }
            if( values.containsKey("ETag") ) {
                final Object value = values.remove("ETag");
                if( (value == null) || (!value.equals(getETag())) ) {
                    setETag(((String) value));
                }
            }
            if( values.containsKey("GroupBusinessPartnerName1") ) {
                final Object value = values.remove("GroupBusinessPartnerName1");
                if( (value == null) || (!value.equals(getGroupBusinessPartnerName1())) ) {
                    setGroupBusinessPartnerName1(((String) value));
                }
            }
            if( values.containsKey("GroupBusinessPartnerName2") ) {
                final Object value = values.remove("GroupBusinessPartnerName2");
                if( (value == null) || (!value.equals(getGroupBusinessPartnerName2())) ) {
                    setGroupBusinessPartnerName2(((String) value));
                }
            }
            if( values.containsKey("IndependentAddressID") ) {
                final Object value = values.remove("IndependentAddressID");
                if( (value == null) || (!value.equals(getIndependentAddressID())) ) {
                    setIndependentAddressID(((String) value));
                }
            }
            if( values.containsKey("InternationalLocationNumber3") ) {
                final Object value = values.remove("InternationalLocationNumber3");
                if( (value == null) || (!value.equals(getInternationalLocationNumber3())) ) {
                    setInternationalLocationNumber3(((String) value));
                }
            }
            if( values.containsKey("MiddleName") ) {
                final Object value = values.remove("MiddleName");
                if( (value == null) || (!value.equals(getMiddleName())) ) {
                    setMiddleName(((String) value));
                }
            }
            if( values.containsKey("NameCountry") ) {
                final Object value = values.remove("NameCountry");
                if( (value == null) || (!value.equals(getNameCountry())) ) {
                    setNameCountry(((String) value));
                }
            }
            if( values.containsKey("NameFormat") ) {
                final Object value = values.remove("NameFormat");
                if( (value == null) || (!value.equals(getNameFormat())) ) {
                    setNameFormat(((String) value));
                }
            }
            if( values.containsKey("PersonFullName") ) {
                final Object value = values.remove("PersonFullName");
                if( (value == null) || (!value.equals(getPersonFullName())) ) {
                    setPersonFullName(((String) value));
                }
            }
            if( values.containsKey("PersonNumber") ) {
                final Object value = values.remove("PersonNumber");
                if( (value == null) || (!value.equals(getPersonNumber())) ) {
                    setPersonNumber(((String) value));
                }
            }
            if( values.containsKey("IsMarkedForArchiving") ) {
                final Object value = values.remove("IsMarkedForArchiving");
                if( (value == null) || (!value.equals(getIsMarkedForArchiving())) ) {
                    setIsMarkedForArchiving(((Boolean) value));
                }
            }
            if( values.containsKey("BusinessPartnerIDByExtSystem") ) {
                final Object value = values.remove("BusinessPartnerIDByExtSystem");
                if( (value == null) || (!value.equals(getBusinessPartnerIDByExtSystem())) ) {
                    setBusinessPartnerIDByExtSystem(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerPrintFormat") ) {
                final Object value = values.remove("BusinessPartnerPrintFormat");
                if( (value == null) || (!value.equals(getBusinessPartnerPrintFormat())) ) {
                    setBusinessPartnerPrintFormat(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerOccupation") ) {
                final Object value = values.remove("BusinessPartnerOccupation");
                if( (value == null) || (!value.equals(getBusinessPartnerOccupation())) ) {
                    setBusinessPartnerOccupation(((String) value));
                }
            }
            if( values.containsKey("BusPartMaritalStatus") ) {
                final Object value = values.remove("BusPartMaritalStatus");
                if( (value == null) || (!value.equals(getBusPartMaritalStatus())) ) {
                    setBusPartMaritalStatus(((String) value));
                }
            }
            if( values.containsKey("BusPartNationality") ) {
                final Object value = values.remove("BusPartNationality");
                if( (value == null) || (!value.equals(getBusPartNationality())) ) {
                    setBusPartNationality(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerBirthName") ) {
                final Object value = values.remove("BusinessPartnerBirthName");
                if( (value == null) || (!value.equals(getBusinessPartnerBirthName())) ) {
                    setBusinessPartnerBirthName(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerSupplementName") ) {
                final Object value = values.remove("BusinessPartnerSupplementName");
                if( (value == null) || (!value.equals(getBusinessPartnerSupplementName())) ) {
                    setBusinessPartnerSupplementName(((String) value));
                }
            }
            if( values.containsKey("NaturalPersonEmployerName") ) {
                final Object value = values.remove("NaturalPersonEmployerName");
                if( (value == null) || (!value.equals(getNaturalPersonEmployerName())) ) {
                    setNaturalPersonEmployerName(((String) value));
                }
            }
            if( values.containsKey("LastNamePrefix") ) {
                final Object value = values.remove("LastNamePrefix");
                if( (value == null) || (!value.equals(getLastNamePrefix())) ) {
                    setLastNamePrefix(((String) value));
                }
            }
            if( values.containsKey("LastNameSecondPrefix") ) {
                final Object value = values.remove("LastNameSecondPrefix");
                if( (value == null) || (!value.equals(getLastNameSecondPrefix())) ) {
                    setLastNameSecondPrefix(((String) value));
                }
            }
            if( values.containsKey("Initials") ) {
                final Object value = values.remove("Initials");
                if( (value == null) || (!value.equals(getInitials())) ) {
                    setInitials(((String) value));
                }
            }
            if( values.containsKey("TradingPartner") ) {
                final Object value = values.remove("TradingPartner");
                if( (value == null) || (!value.equals(getTradingPartner())) ) {
                    setTradingPartner(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BPCreditWorthiness") ) {
                final Object value = (values).remove("to_BPCreditWorthiness");
                if( value instanceof Map ) {
                    if( toBPCreditWorthiness == null ) {
                        toBPCreditWorthiness = new BPCreditWorthiness();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBPCreditWorthiness.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_BPFinServicesReporting") ) {
                final Object value = (values).remove("to_BPFinServicesReporting");
                if( value instanceof Map ) {
                    if( toBPFinServicesReporting == null ) {
                        toBPFinServicesReporting = new BPFinancialServicesReporting();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBPFinServicesReporting.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_BPFiscalYearInformation") ) {
                final Object value = (values).remove("to_BPFiscalYearInformation");
                if( value instanceof Iterable ) {
                    if( toBPFiscalYearInformation == null ) {
                        toBPFiscalYearInformation = Lists.newArrayList();
                    } else {
                        toBPFiscalYearInformation = Lists.newArrayList(toBPFiscalYearInformation);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BPFiscalYearInformation entity;
                        if( toBPFiscalYearInformation.size() > i ) {
                            entity = toBPFiscalYearInformation.get(i);
                        } else {
                            entity = new BPFiscalYearInformation();
                            toBPFiscalYearInformation.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_BPRelationship") ) {
                final Object value = (values).remove("to_BPRelationship");
                if( value instanceof Iterable ) {
                    if( toBPRelationship == null ) {
                        toBPRelationship = Lists.newArrayList();
                    } else {
                        toBPRelationship = Lists.newArrayList(toBPRelationship);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BPRelationship entity;
                        if( toBPRelationship.size() > i ) {
                            entity = toBPRelationship.get(i);
                        } else {
                            entity = new BPRelationship();
                            toBPRelationship.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_BuPaIdentification") ) {
                final Object value = (values).remove("to_BuPaIdentification");
                if( value instanceof Iterable ) {
                    if( toBuPaIdentification == null ) {
                        toBuPaIdentification = Lists.newArrayList();
                    } else {
                        toBuPaIdentification = Lists.newArrayList(toBuPaIdentification);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BuPaIdentification entity;
                        if( toBuPaIdentification.size() > i ) {
                            entity = toBuPaIdentification.get(i);
                        } else {
                            entity = new BuPaIdentification();
                            toBuPaIdentification.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_BuPaIndustry") ) {
                final Object value = (values).remove("to_BuPaIndustry");
                if( value instanceof Iterable ) {
                    if( toBuPaIndustry == null ) {
                        toBuPaIndustry = Lists.newArrayList();
                    } else {
                        toBuPaIndustry = Lists.newArrayList(toBuPaIndustry);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BuPaIndustry entity;
                        if( toBuPaIndustry.size() > i ) {
                            entity = toBuPaIndustry.get(i);
                        } else {
                            entity = new BuPaIndustry();
                            toBuPaIndustry.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_BusinessPartner") ) {
                final Object value = (values).remove("to_BusinessPartner");
                if( value instanceof Map ) {
                    if( toBusinessPartner == null ) {
                        toBusinessPartner = new BPFinancialServicesExtn();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBusinessPartner.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_BusinessPartnerAddress") ) {
                final Object value = (values).remove("to_BusinessPartnerAddress");
                if( value instanceof Iterable ) {
                    if( toBusinessPartnerAddress == null ) {
                        toBusinessPartnerAddress = Lists.newArrayList();
                    } else {
                        toBusinessPartnerAddress = Lists.newArrayList(toBusinessPartnerAddress);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusinessPartnerAddress entity;
                        if( toBusinessPartnerAddress.size() > i ) {
                            entity = toBusinessPartnerAddress.get(i);
                        } else {
                            entity = new BusinessPartnerAddress();
                            toBusinessPartnerAddress.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_BusinessPartnerBank") ) {
                final Object value = (values).remove("to_BusinessPartnerBank");
                if( value instanceof Iterable ) {
                    if( toBusinessPartnerBank == null ) {
                        toBusinessPartnerBank = Lists.newArrayList();
                    } else {
                        toBusinessPartnerBank = Lists.newArrayList(toBusinessPartnerBank);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusinessPartnerBank entity;
                        if( toBusinessPartnerBank.size() > i ) {
                            entity = toBusinessPartnerBank.get(i);
                        } else {
                            entity = new BusinessPartnerBank();
                            toBusinessPartnerBank.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_BusinessPartnerContact") ) {
                final Object value = (values).remove("to_BusinessPartnerContact");
                if( value instanceof Iterable ) {
                    if( toBusinessPartnerContact == null ) {
                        toBusinessPartnerContact = Lists.newArrayList();
                    } else {
                        toBusinessPartnerContact = Lists.newArrayList(toBusinessPartnerContact);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusinessPartnerContact entity;
                        if( toBusinessPartnerContact.size() > i ) {
                            entity = toBusinessPartnerContact.get(i);
                        } else {
                            entity = new BusinessPartnerContact();
                            toBusinessPartnerContact.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_BusinessPartnerRating") ) {
                final Object value = (values).remove("to_BusinessPartnerRating");
                if( value instanceof Iterable ) {
                    if( toBusinessPartnerRating == null ) {
                        toBusinessPartnerRating = Lists.newArrayList();
                    } else {
                        toBusinessPartnerRating = Lists.newArrayList(toBusinessPartnerRating);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusinessPartnerRating entity;
                        if( toBusinessPartnerRating.size() > i ) {
                            entity = toBusinessPartnerRating.get(i);
                        } else {
                            entity = new BusinessPartnerRating();
                            toBusinessPartnerRating.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_BusinessPartnerRole") ) {
                final Object value = (values).remove("to_BusinessPartnerRole");
                if( value instanceof Iterable ) {
                    if( toBusinessPartnerRole == null ) {
                        toBusinessPartnerRole = Lists.newArrayList();
                    } else {
                        toBusinessPartnerRole = Lists.newArrayList(toBusinessPartnerRole);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusinessPartnerRole entity;
                        if( toBusinessPartnerRole.size() > i ) {
                            entity = toBusinessPartnerRole.get(i);
                        } else {
                            entity = new BusinessPartnerRole();
                            toBusinessPartnerRole.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_BusinessPartnerTax") ) {
                final Object value = (values).remove("to_BusinessPartnerTax");
                if( value instanceof Iterable ) {
                    if( toBusinessPartnerTax == null ) {
                        toBusinessPartnerTax = Lists.newArrayList();
                    } else {
                        toBusinessPartnerTax = Lists.newArrayList(toBusinessPartnerTax);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusinessPartnerTaxNumber entity;
                        if( toBusinessPartnerTax.size() > i ) {
                            entity = toBusinessPartnerTax.get(i);
                        } else {
                            entity = new BusinessPartnerTaxNumber();
                            toBusinessPartnerTax.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_BusPartAddrDepdntTaxNmbr") ) {
                final Object value = (values).remove("to_BusPartAddrDepdntTaxNmbr");
                if( value instanceof Iterable ) {
                    if( toBusPartAddrDepdntTaxNmbr == null ) {
                        toBusPartAddrDepdntTaxNmbr = Lists.newArrayList();
                    } else {
                        toBusPartAddrDepdntTaxNmbr = Lists.newArrayList(toBusPartAddrDepdntTaxNmbr);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusPartAddrDepdntTaxNmbr entity;
                        if( toBusPartAddrDepdntTaxNmbr.size() > i ) {
                            entity = toBusPartAddrDepdntTaxNmbr.get(i);
                        } else {
                            entity = new BusPartAddrDepdntTaxNmbr();
                            toBusPartAddrDepdntTaxNmbr.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Customer") ) {
                final Object value = (values).remove("to_Customer");
                if( value instanceof Map ) {
                    if( toCustomer == null ) {
                        toCustomer = new Customer();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCustomer.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_Supplier") ) {
                final Object value = (values).remove("to_Supplier");
                if( value instanceof Map ) {
                    if( toSupplier == null ) {
                        toSupplier = new Supplier();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSupplier.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BusinessPartnerField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BusinessPartnerField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BusinessPartnerField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BusinessPartnerField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessPartnerService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBPCreditWorthiness != null ) {
            (values).put("to_BPCreditWorthiness", toBPCreditWorthiness);
        }
        if( toBPFinServicesReporting != null ) {
            (values).put("to_BPFinServicesReporting", toBPFinServicesReporting);
        }
        if( toBPFiscalYearInformation != null ) {
            (values).put("to_BPFiscalYearInformation", toBPFiscalYearInformation);
        }
        if( toBPRelationship != null ) {
            (values).put("to_BPRelationship", toBPRelationship);
        }
        if( toBuPaIdentification != null ) {
            (values).put("to_BuPaIdentification", toBuPaIdentification);
        }
        if( toBuPaIndustry != null ) {
            (values).put("to_BuPaIndustry", toBuPaIndustry);
        }
        if( toBusinessPartner != null ) {
            (values).put("to_BusinessPartner", toBusinessPartner);
        }
        if( toBusinessPartnerAddress != null ) {
            (values).put("to_BusinessPartnerAddress", toBusinessPartnerAddress);
        }
        if( toBusinessPartnerBank != null ) {
            (values).put("to_BusinessPartnerBank", toBusinessPartnerBank);
        }
        if( toBusinessPartnerContact != null ) {
            (values).put("to_BusinessPartnerContact", toBusinessPartnerContact);
        }
        if( toBusinessPartnerRating != null ) {
            (values).put("to_BusinessPartnerRating", toBusinessPartnerRating);
        }
        if( toBusinessPartnerRole != null ) {
            (values).put("to_BusinessPartnerRole", toBusinessPartnerRole);
        }
        if( toBusinessPartnerTax != null ) {
            (values).put("to_BusinessPartnerTax", toBusinessPartnerTax);
        }
        if( toBusPartAddrDepdntTaxNmbr != null ) {
            (values).put("to_BusPartAddrDepdntTaxNmbr", toBusPartAddrDepdntTaxNmbr);
        }
        if( toCustomer != null ) {
            (values).put("to_Customer", toCustomer);
        }
        if( toSupplier != null ) {
            (values).put("to_Supplier", toSupplier);
        }
        return values;
    }

    /**
     * Fetches the <b>BPCreditWorthiness</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_BPCreditWorthiness</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BPCreditWorthiness</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BPCreditWorthiness fetchBPCreditWorthiness()
    {
        return fetchFieldAsSingle("to_BPCreditWorthiness", BPCreditWorthiness.class);
    }

    /**
     * Retrieval of associated <b>BPCreditWorthiness</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BPCreditWorthiness</b>.
     * <p>
     * If the navigation property <b>to_BPCreditWorthiness</b> of a queried <b>BusinessPartner</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BPCreditWorthiness</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BPCreditWorthiness getBPCreditWorthinessOrFetch()
    {
        if( toBPCreditWorthiness == null ) {
            toBPCreditWorthiness = fetchBPCreditWorthiness();
        }
        return toBPCreditWorthiness;
    }

    /**
     * Retrieval of associated <b>BPCreditWorthiness</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BPCreditWorthiness</b>.
     * <p>
     * If the navigation property for an entity <b>BusinessPartner</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BPCreditWorthiness</b> is already loaded, the result
     *         will contain the <b>BPCreditWorthiness</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BPCreditWorthiness> getBPCreditWorthinessIfPresent()
    {
        return Option.of(toBPCreditWorthiness);
    }

    /**
     * Overwrites the associated <b>BPCreditWorthiness</b> entity for the loaded navigation property
     * <b>to_BPCreditWorthiness</b>.
     *
     * @param value
     *            New <b>BPCreditWorthiness</b> entity.
     */
    public void setBPCreditWorthiness( final BPCreditWorthiness value )
    {
        toBPCreditWorthiness = value;
    }

    /**
     * Fetches the <b>BPFinancialServicesReporting</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_BPFinServicesReporting</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BPFinancialServicesReporting</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BPFinancialServicesReporting fetchBPFinServicesReporting()
    {
        return fetchFieldAsSingle("to_BPFinServicesReporting", BPFinancialServicesReporting.class);
    }

    /**
     * Retrieval of associated <b>BPFinancialServicesReporting</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_BPFinServicesReporting</b>.
     * <p>
     * If the navigation property <b>to_BPFinServicesReporting</b> of a queried <b>BusinessPartner</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BPFinancialServicesReporting</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BPFinancialServicesReporting getBPFinServicesReportingOrFetch()
    {
        if( toBPFinServicesReporting == null ) {
            toBPFinServicesReporting = fetchBPFinServicesReporting();
        }
        return toBPFinServicesReporting;
    }

    /**
     * Retrieval of associated <b>BPFinancialServicesReporting</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_BPFinServicesReporting</b>.
     * <p>
     * If the navigation property for an entity <b>BusinessPartner</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BPFinServicesReporting</b> is already loaded, the result
     *         will contain the <b>BPFinancialServicesReporting</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BPFinancialServicesReporting> getBPFinServicesReportingIfPresent()
    {
        return Option.of(toBPFinServicesReporting);
    }

    /**
     * Overwrites the associated <b>BPFinancialServicesReporting</b> entity for the loaded navigation property
     * <b>to_BPFinServicesReporting</b>.
     *
     * @param value
     *            New <b>BPFinancialServicesReporting</b> entity.
     */
    public void setBPFinServicesReporting( final BPFinancialServicesReporting value )
    {
        toBPFinServicesReporting = value;
    }

    /**
     * Fetches the <b>BPFiscalYearInformation</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_BPFiscalYearInformation</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BPFiscalYearInformation</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BPFiscalYearInformation> fetchBPFiscalYearInformation()
    {
        return fetchFieldAsList("to_BPFiscalYearInformation", BPFiscalYearInformation.class);
    }

    /**
     * Retrieval of associated <b>BPFiscalYearInformation</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BPFiscalYearInformation</b>.
     * <p>
     * If the navigation property <b>to_BPFiscalYearInformation</b> of a queried <b>BusinessPartner</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BPFiscalYearInformation</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BPFiscalYearInformation> getBPFiscalYearInformationOrFetch()
    {
        if( toBPFiscalYearInformation == null ) {
            toBPFiscalYearInformation = fetchBPFiscalYearInformation();
        }
        return toBPFiscalYearInformation;
    }

    /**
     * Retrieval of associated <b>BPFiscalYearInformation</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BPFiscalYearInformation</b>.
     * <p>
     * If the navigation property for an entity <b>BusinessPartner</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BPFiscalYearInformation</b> is already loaded, the
     *         result will contain the <b>BPFiscalYearInformation</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BPFiscalYearInformation>> getBPFiscalYearInformationIfPresent()
    {
        return Option.of(toBPFiscalYearInformation);
    }

    /**
     * Overwrites the list of associated <b>BPFiscalYearInformation</b> entities for the loaded navigation property
     * <b>to_BPFiscalYearInformation</b>.
     * <p>
     * If the navigation property <b>to_BPFiscalYearInformation</b> of a queried <b>BusinessPartner</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BPFiscalYearInformation</b> entities.
     */
    public void setBPFiscalYearInformation( @Nonnull final List<BPFiscalYearInformation> value )
    {
        if( toBPFiscalYearInformation == null ) {
            toBPFiscalYearInformation = Lists.newArrayList();
        }
        toBPFiscalYearInformation.clear();
        toBPFiscalYearInformation.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BPFiscalYearInformation</b> entities. This corresponds to the OData
     * navigation property <b>to_BPFiscalYearInformation</b>.
     * <p>
     * If the navigation property <b>to_BPFiscalYearInformation</b> of a queried <b>BusinessPartner</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BPFiscalYearInformation</b> entities.
     */
    public void addBPFiscalYearInformation( BPFiscalYearInformation... entity )
    {
        if( toBPFiscalYearInformation == null ) {
            toBPFiscalYearInformation = Lists.newArrayList();
        }
        toBPFiscalYearInformation.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BPRelationship</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_BPRelationship</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BPRelationship</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BPRelationship> fetchBPRelationship()
    {
        return fetchFieldAsList("to_BPRelationship", BPRelationship.class);
    }

    /**
     * Retrieval of associated <b>BPRelationship</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_BPRelationship</b>.
     * <p>
     * If the navigation property <b>to_BPRelationship</b> of a queried <b>BusinessPartner</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BPRelationship</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BPRelationship> getBPRelationshipOrFetch()
    {
        if( toBPRelationship == null ) {
            toBPRelationship = fetchBPRelationship();
        }
        return toBPRelationship;
    }

    /**
     * Retrieval of associated <b>BPRelationship</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_BPRelationship</b>.
     * <p>
     * If the navigation property for an entity <b>BusinessPartner</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BPRelationship</b> is already loaded, the result will
     *         contain the <b>BPRelationship</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BPRelationship>> getBPRelationshipIfPresent()
    {
        return Option.of(toBPRelationship);
    }

    /**
     * Overwrites the list of associated <b>BPRelationship</b> entities for the loaded navigation property
     * <b>to_BPRelationship</b>.
     * <p>
     * If the navigation property <b>to_BPRelationship</b> of a queried <b>BusinessPartner</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BPRelationship</b> entities.
     */
    public void setBPRelationship( @Nonnull final List<BPRelationship> value )
    {
        if( toBPRelationship == null ) {
            toBPRelationship = Lists.newArrayList();
        }
        toBPRelationship.clear();
        toBPRelationship.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BPRelationship</b> entities. This corresponds to the OData navigation
     * property <b>to_BPRelationship</b>.
     * <p>
     * If the navigation property <b>to_BPRelationship</b> of a queried <b>BusinessPartner</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BPRelationship</b> entities.
     */
    public void addBPRelationship( BPRelationship... entity )
    {
        if( toBPRelationship == null ) {
            toBPRelationship = Lists.newArrayList();
        }
        toBPRelationship.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BuPaIdentification</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_BuPaIdentification</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BuPaIdentification</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BuPaIdentification> fetchBuPaIdentification()
    {
        return fetchFieldAsList("to_BuPaIdentification", BuPaIdentification.class);
    }

    /**
     * Retrieval of associated <b>BuPaIdentification</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BuPaIdentification</b>.
     * <p>
     * If the navigation property <b>to_BuPaIdentification</b> of a queried <b>BusinessPartner</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BuPaIdentification</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BuPaIdentification> getBuPaIdentificationOrFetch()
    {
        if( toBuPaIdentification == null ) {
            toBuPaIdentification = fetchBuPaIdentification();
        }
        return toBuPaIdentification;
    }

    /**
     * Retrieval of associated <b>BuPaIdentification</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BuPaIdentification</b>.
     * <p>
     * If the navigation property for an entity <b>BusinessPartner</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BuPaIdentification</b> is already loaded, the result
     *         will contain the <b>BuPaIdentification</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BuPaIdentification>> getBuPaIdentificationIfPresent()
    {
        return Option.of(toBuPaIdentification);
    }

    /**
     * Overwrites the list of associated <b>BuPaIdentification</b> entities for the loaded navigation property
     * <b>to_BuPaIdentification</b>.
     * <p>
     * If the navigation property <b>to_BuPaIdentification</b> of a queried <b>BusinessPartner</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BuPaIdentification</b> entities.
     */
    public void setBuPaIdentification( @Nonnull final List<BuPaIdentification> value )
    {
        if( toBuPaIdentification == null ) {
            toBuPaIdentification = Lists.newArrayList();
        }
        toBuPaIdentification.clear();
        toBuPaIdentification.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BuPaIdentification</b> entities. This corresponds to the OData
     * navigation property <b>to_BuPaIdentification</b>.
     * <p>
     * If the navigation property <b>to_BuPaIdentification</b> of a queried <b>BusinessPartner</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BuPaIdentification</b> entities.
     */
    public void addBuPaIdentification( BuPaIdentification... entity )
    {
        if( toBuPaIdentification == null ) {
            toBuPaIdentification = Lists.newArrayList();
        }
        toBuPaIdentification.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BuPaIndustry</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_BuPaIndustry</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BuPaIndustry</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BuPaIndustry> fetchBuPaIndustry()
    {
        return fetchFieldAsList("to_BuPaIndustry", BuPaIndustry.class);
    }

    /**
     * Retrieval of associated <b>BuPaIndustry</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_BuPaIndustry</b>.
     * <p>
     * If the navigation property <b>to_BuPaIndustry</b> of a queried <b>BusinessPartner</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BuPaIndustry</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BuPaIndustry> getBuPaIndustryOrFetch()
    {
        if( toBuPaIndustry == null ) {
            toBuPaIndustry = fetchBuPaIndustry();
        }
        return toBuPaIndustry;
    }

    /**
     * Retrieval of associated <b>BuPaIndustry</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_BuPaIndustry</b>.
     * <p>
     * If the navigation property for an entity <b>BusinessPartner</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BuPaIndustry</b> is already loaded, the result will
     *         contain the <b>BuPaIndustry</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BuPaIndustry>> getBuPaIndustryIfPresent()
    {
        return Option.of(toBuPaIndustry);
    }

    /**
     * Overwrites the list of associated <b>BuPaIndustry</b> entities for the loaded navigation property
     * <b>to_BuPaIndustry</b>.
     * <p>
     * If the navigation property <b>to_BuPaIndustry</b> of a queried <b>BusinessPartner</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BuPaIndustry</b> entities.
     */
    public void setBuPaIndustry( @Nonnull final List<BuPaIndustry> value )
    {
        if( toBuPaIndustry == null ) {
            toBuPaIndustry = Lists.newArrayList();
        }
        toBuPaIndustry.clear();
        toBuPaIndustry.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BuPaIndustry</b> entities. This corresponds to the OData navigation
     * property <b>to_BuPaIndustry</b>.
     * <p>
     * If the navigation property <b>to_BuPaIndustry</b> of a queried <b>BusinessPartner</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BuPaIndustry</b> entities.
     */
    public void addBuPaIndustry( BuPaIndustry... entity )
    {
        if( toBuPaIndustry == null ) {
            toBuPaIndustry = Lists.newArrayList();
        }
        toBuPaIndustry.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BPFinancialServicesExtn</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_BusinessPartner</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BPFinancialServicesExtn</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BPFinancialServicesExtn fetchBusinessPartner()
    {
        return fetchFieldAsSingle("to_BusinessPartner", BPFinancialServicesExtn.class);
    }

    /**
     * Retrieval of associated <b>BPFinancialServicesExtn</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_BusinessPartner</b>.
     * <p>
     * If the navigation property <b>to_BusinessPartner</b> of a queried <b>BusinessPartner</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BPFinancialServicesExtn</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BPFinancialServicesExtn getBusinessPartnerOrFetch()
    {
        if( toBusinessPartner == null ) {
            toBusinessPartner = fetchBusinessPartner();
        }
        return toBusinessPartner;
    }

    /**
     * Retrieval of associated <b>BPFinancialServicesExtn</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_BusinessPartner</b>.
     * <p>
     * If the navigation property for an entity <b>BusinessPartner</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BusinessPartner</b> is already loaded, the result will
     *         contain the <b>BPFinancialServicesExtn</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BPFinancialServicesExtn> getBusinessPartnerIfPresent()
    {
        return Option.of(toBusinessPartner);
    }

    /**
     * Overwrites the associated <b>BPFinancialServicesExtn</b> entity for the loaded navigation property
     * <b>to_BusinessPartner</b>.
     *
     * @param value
     *            New <b>BPFinancialServicesExtn</b> entity.
     */
    public void setBusinessPartner( final BPFinancialServicesExtn value )
    {
        toBusinessPartner = value;
    }

    /**
     * Fetches the <b>BusinessPartnerAddress</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_BusinessPartnerAddress</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusinessPartnerAddress</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusinessPartnerAddress> fetchBusinessPartnerAddress()
    {
        return fetchFieldAsList("to_BusinessPartnerAddress", BusinessPartnerAddress.class);
    }

    /**
     * Retrieval of associated <b>BusinessPartnerAddress</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BusinessPartnerAddress</b>.
     * <p>
     * If the navigation property <b>to_BusinessPartnerAddress</b> of a queried <b>BusinessPartner</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusinessPartnerAddress</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusinessPartnerAddress> getBusinessPartnerAddressOrFetch()
    {
        if( toBusinessPartnerAddress == null ) {
            toBusinessPartnerAddress = fetchBusinessPartnerAddress();
        }
        return toBusinessPartnerAddress;
    }

    /**
     * Retrieval of associated <b>BusinessPartnerAddress</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BusinessPartnerAddress</b>.
     * <p>
     * If the navigation property for an entity <b>BusinessPartner</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BusinessPartnerAddress</b> is already loaded, the result
     *         will contain the <b>BusinessPartnerAddress</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusinessPartnerAddress>> getBusinessPartnerAddressIfPresent()
    {
        return Option.of(toBusinessPartnerAddress);
    }

    /**
     * Overwrites the list of associated <b>BusinessPartnerAddress</b> entities for the loaded navigation property
     * <b>to_BusinessPartnerAddress</b>.
     * <p>
     * If the navigation property <b>to_BusinessPartnerAddress</b> of a queried <b>BusinessPartner</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusinessPartnerAddress</b> entities.
     */
    public void setBusinessPartnerAddress( @Nonnull final List<BusinessPartnerAddress> value )
    {
        if( toBusinessPartnerAddress == null ) {
            toBusinessPartnerAddress = Lists.newArrayList();
        }
        toBusinessPartnerAddress.clear();
        toBusinessPartnerAddress.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusinessPartnerAddress</b> entities. This corresponds to the OData
     * navigation property <b>to_BusinessPartnerAddress</b>.
     * <p>
     * If the navigation property <b>to_BusinessPartnerAddress</b> of a queried <b>BusinessPartner</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusinessPartnerAddress</b> entities.
     */
    public void addBusinessPartnerAddress( BusinessPartnerAddress... entity )
    {
        if( toBusinessPartnerAddress == null ) {
            toBusinessPartnerAddress = Lists.newArrayList();
        }
        toBusinessPartnerAddress.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusinessPartnerBank</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_BusinessPartnerBank</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusinessPartnerBank</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusinessPartnerBank> fetchBusinessPartnerBank()
    {
        return fetchFieldAsList("to_BusinessPartnerBank", BusinessPartnerBank.class);
    }

    /**
     * Retrieval of associated <b>BusinessPartnerBank</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BusinessPartnerBank</b>.
     * <p>
     * If the navigation property <b>to_BusinessPartnerBank</b> of a queried <b>BusinessPartner</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusinessPartnerBank</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusinessPartnerBank> getBusinessPartnerBankOrFetch()
    {
        if( toBusinessPartnerBank == null ) {
            toBusinessPartnerBank = fetchBusinessPartnerBank();
        }
        return toBusinessPartnerBank;
    }

    /**
     * Retrieval of associated <b>BusinessPartnerBank</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BusinessPartnerBank</b>.
     * <p>
     * If the navigation property for an entity <b>BusinessPartner</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BusinessPartnerBank</b> is already loaded, the result
     *         will contain the <b>BusinessPartnerBank</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusinessPartnerBank>> getBusinessPartnerBankIfPresent()
    {
        return Option.of(toBusinessPartnerBank);
    }

    /**
     * Overwrites the list of associated <b>BusinessPartnerBank</b> entities for the loaded navigation property
     * <b>to_BusinessPartnerBank</b>.
     * <p>
     * If the navigation property <b>to_BusinessPartnerBank</b> of a queried <b>BusinessPartner</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusinessPartnerBank</b> entities.
     */
    public void setBusinessPartnerBank( @Nonnull final List<BusinessPartnerBank> value )
    {
        if( toBusinessPartnerBank == null ) {
            toBusinessPartnerBank = Lists.newArrayList();
        }
        toBusinessPartnerBank.clear();
        toBusinessPartnerBank.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusinessPartnerBank</b> entities. This corresponds to the OData
     * navigation property <b>to_BusinessPartnerBank</b>.
     * <p>
     * If the navigation property <b>to_BusinessPartnerBank</b> of a queried <b>BusinessPartner</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusinessPartnerBank</b> entities.
     */
    public void addBusinessPartnerBank( BusinessPartnerBank... entity )
    {
        if( toBusinessPartnerBank == null ) {
            toBusinessPartnerBank = Lists.newArrayList();
        }
        toBusinessPartnerBank.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusinessPartnerContact</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_BusinessPartnerContact</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusinessPartnerContact</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusinessPartnerContact> fetchBusinessPartnerContact()
    {
        return fetchFieldAsList("to_BusinessPartnerContact", BusinessPartnerContact.class);
    }

    /**
     * Retrieval of associated <b>BusinessPartnerContact</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BusinessPartnerContact</b>.
     * <p>
     * If the navigation property <b>to_BusinessPartnerContact</b> of a queried <b>BusinessPartner</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusinessPartnerContact</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusinessPartnerContact> getBusinessPartnerContactOrFetch()
    {
        if( toBusinessPartnerContact == null ) {
            toBusinessPartnerContact = fetchBusinessPartnerContact();
        }
        return toBusinessPartnerContact;
    }

    /**
     * Retrieval of associated <b>BusinessPartnerContact</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BusinessPartnerContact</b>.
     * <p>
     * If the navigation property for an entity <b>BusinessPartner</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BusinessPartnerContact</b> is already loaded, the result
     *         will contain the <b>BusinessPartnerContact</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusinessPartnerContact>> getBusinessPartnerContactIfPresent()
    {
        return Option.of(toBusinessPartnerContact);
    }

    /**
     * Overwrites the list of associated <b>BusinessPartnerContact</b> entities for the loaded navigation property
     * <b>to_BusinessPartnerContact</b>.
     * <p>
     * If the navigation property <b>to_BusinessPartnerContact</b> of a queried <b>BusinessPartner</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusinessPartnerContact</b> entities.
     */
    public void setBusinessPartnerContact( @Nonnull final List<BusinessPartnerContact> value )
    {
        if( toBusinessPartnerContact == null ) {
            toBusinessPartnerContact = Lists.newArrayList();
        }
        toBusinessPartnerContact.clear();
        toBusinessPartnerContact.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusinessPartnerContact</b> entities. This corresponds to the OData
     * navigation property <b>to_BusinessPartnerContact</b>.
     * <p>
     * If the navigation property <b>to_BusinessPartnerContact</b> of a queried <b>BusinessPartner</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusinessPartnerContact</b> entities.
     */
    public void addBusinessPartnerContact( BusinessPartnerContact... entity )
    {
        if( toBusinessPartnerContact == null ) {
            toBusinessPartnerContact = Lists.newArrayList();
        }
        toBusinessPartnerContact.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusinessPartnerRating</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_BusinessPartnerRating</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusinessPartnerRating</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusinessPartnerRating> fetchBusinessPartnerRating()
    {
        return fetchFieldAsList("to_BusinessPartnerRating", BusinessPartnerRating.class);
    }

    /**
     * Retrieval of associated <b>BusinessPartnerRating</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BusinessPartnerRating</b>.
     * <p>
     * If the navigation property <b>to_BusinessPartnerRating</b> of a queried <b>BusinessPartner</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusinessPartnerRating</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusinessPartnerRating> getBusinessPartnerRatingOrFetch()
    {
        if( toBusinessPartnerRating == null ) {
            toBusinessPartnerRating = fetchBusinessPartnerRating();
        }
        return toBusinessPartnerRating;
    }

    /**
     * Retrieval of associated <b>BusinessPartnerRating</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BusinessPartnerRating</b>.
     * <p>
     * If the navigation property for an entity <b>BusinessPartner</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BusinessPartnerRating</b> is already loaded, the result
     *         will contain the <b>BusinessPartnerRating</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusinessPartnerRating>> getBusinessPartnerRatingIfPresent()
    {
        return Option.of(toBusinessPartnerRating);
    }

    /**
     * Overwrites the list of associated <b>BusinessPartnerRating</b> entities for the loaded navigation property
     * <b>to_BusinessPartnerRating</b>.
     * <p>
     * If the navigation property <b>to_BusinessPartnerRating</b> of a queried <b>BusinessPartner</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusinessPartnerRating</b> entities.
     */
    public void setBusinessPartnerRating( @Nonnull final List<BusinessPartnerRating> value )
    {
        if( toBusinessPartnerRating == null ) {
            toBusinessPartnerRating = Lists.newArrayList();
        }
        toBusinessPartnerRating.clear();
        toBusinessPartnerRating.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusinessPartnerRating</b> entities. This corresponds to the OData
     * navigation property <b>to_BusinessPartnerRating</b>.
     * <p>
     * If the navigation property <b>to_BusinessPartnerRating</b> of a queried <b>BusinessPartner</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusinessPartnerRating</b> entities.
     */
    public void addBusinessPartnerRating( BusinessPartnerRating... entity )
    {
        if( toBusinessPartnerRating == null ) {
            toBusinessPartnerRating = Lists.newArrayList();
        }
        toBusinessPartnerRating.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusinessPartnerRole</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_BusinessPartnerRole</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusinessPartnerRole</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusinessPartnerRole> fetchBusinessPartnerRole()
    {
        return fetchFieldAsList("to_BusinessPartnerRole", BusinessPartnerRole.class);
    }

    /**
     * Retrieval of associated <b>BusinessPartnerRole</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BusinessPartnerRole</b>.
     * <p>
     * If the navigation property <b>to_BusinessPartnerRole</b> of a queried <b>BusinessPartner</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusinessPartnerRole</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusinessPartnerRole> getBusinessPartnerRoleOrFetch()
    {
        if( toBusinessPartnerRole == null ) {
            toBusinessPartnerRole = fetchBusinessPartnerRole();
        }
        return toBusinessPartnerRole;
    }

    /**
     * Retrieval of associated <b>BusinessPartnerRole</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BusinessPartnerRole</b>.
     * <p>
     * If the navigation property for an entity <b>BusinessPartner</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BusinessPartnerRole</b> is already loaded, the result
     *         will contain the <b>BusinessPartnerRole</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusinessPartnerRole>> getBusinessPartnerRoleIfPresent()
    {
        return Option.of(toBusinessPartnerRole);
    }

    /**
     * Overwrites the list of associated <b>BusinessPartnerRole</b> entities for the loaded navigation property
     * <b>to_BusinessPartnerRole</b>.
     * <p>
     * If the navigation property <b>to_BusinessPartnerRole</b> of a queried <b>BusinessPartner</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusinessPartnerRole</b> entities.
     */
    public void setBusinessPartnerRole( @Nonnull final List<BusinessPartnerRole> value )
    {
        if( toBusinessPartnerRole == null ) {
            toBusinessPartnerRole = Lists.newArrayList();
        }
        toBusinessPartnerRole.clear();
        toBusinessPartnerRole.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusinessPartnerRole</b> entities. This corresponds to the OData
     * navigation property <b>to_BusinessPartnerRole</b>.
     * <p>
     * If the navigation property <b>to_BusinessPartnerRole</b> of a queried <b>BusinessPartner</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusinessPartnerRole</b> entities.
     */
    public void addBusinessPartnerRole( BusinessPartnerRole... entity )
    {
        if( toBusinessPartnerRole == null ) {
            toBusinessPartnerRole = Lists.newArrayList();
        }
        toBusinessPartnerRole.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusinessPartnerTaxNumber</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_BusinessPartnerTax</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusinessPartnerTaxNumber</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusinessPartnerTaxNumber> fetchBusinessPartnerTax()
    {
        return fetchFieldAsList("to_BusinessPartnerTax", BusinessPartnerTaxNumber.class);
    }

    /**
     * Retrieval of associated <b>BusinessPartnerTaxNumber</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BusinessPartnerTax</b>.
     * <p>
     * If the navigation property <b>to_BusinessPartnerTax</b> of a queried <b>BusinessPartner</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusinessPartnerTaxNumber</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusinessPartnerTaxNumber> getBusinessPartnerTaxOrFetch()
    {
        if( toBusinessPartnerTax == null ) {
            toBusinessPartnerTax = fetchBusinessPartnerTax();
        }
        return toBusinessPartnerTax;
    }

    /**
     * Retrieval of associated <b>BusinessPartnerTaxNumber</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BusinessPartnerTax</b>.
     * <p>
     * If the navigation property for an entity <b>BusinessPartner</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BusinessPartnerTax</b> is already loaded, the result
     *         will contain the <b>BusinessPartnerTaxNumber</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusinessPartnerTaxNumber>> getBusinessPartnerTaxIfPresent()
    {
        return Option.of(toBusinessPartnerTax);
    }

    /**
     * Overwrites the list of associated <b>BusinessPartnerTaxNumber</b> entities for the loaded navigation property
     * <b>to_BusinessPartnerTax</b>.
     * <p>
     * If the navigation property <b>to_BusinessPartnerTax</b> of a queried <b>BusinessPartner</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusinessPartnerTaxNumber</b> entities.
     */
    public void setBusinessPartnerTax( @Nonnull final List<BusinessPartnerTaxNumber> value )
    {
        if( toBusinessPartnerTax == null ) {
            toBusinessPartnerTax = Lists.newArrayList();
        }
        toBusinessPartnerTax.clear();
        toBusinessPartnerTax.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusinessPartnerTaxNumber</b> entities. This corresponds to the OData
     * navigation property <b>to_BusinessPartnerTax</b>.
     * <p>
     * If the navigation property <b>to_BusinessPartnerTax</b> of a queried <b>BusinessPartner</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusinessPartnerTaxNumber</b> entities.
     */
    public void addBusinessPartnerTax( BusinessPartnerTaxNumber... entity )
    {
        if( toBusinessPartnerTax == null ) {
            toBusinessPartnerTax = Lists.newArrayList();
        }
        toBusinessPartnerTax.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusPartAddrDepdntTaxNmbr</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_BusPartAddrDepdntTaxNmbr</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusPartAddrDepdntTaxNmbr</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusPartAddrDepdntTaxNmbr> fetchBusPartAddrDepdntTaxNmbr()
    {
        return fetchFieldAsList("to_BusPartAddrDepdntTaxNmbr", BusPartAddrDepdntTaxNmbr.class);
    }

    /**
     * Retrieval of associated <b>BusPartAddrDepdntTaxNmbr</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BusPartAddrDepdntTaxNmbr</b>.
     * <p>
     * If the navigation property <b>to_BusPartAddrDepdntTaxNmbr</b> of a queried <b>BusinessPartner</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusPartAddrDepdntTaxNmbr</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusPartAddrDepdntTaxNmbr> getBusPartAddrDepdntTaxNmbrOrFetch()
    {
        if( toBusPartAddrDepdntTaxNmbr == null ) {
            toBusPartAddrDepdntTaxNmbr = fetchBusPartAddrDepdntTaxNmbr();
        }
        return toBusPartAddrDepdntTaxNmbr;
    }

    /**
     * Retrieval of associated <b>BusPartAddrDepdntTaxNmbr</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BusPartAddrDepdntTaxNmbr</b>.
     * <p>
     * If the navigation property for an entity <b>BusinessPartner</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BusPartAddrDepdntTaxNmbr</b> is already loaded, the
     *         result will contain the <b>BusPartAddrDepdntTaxNmbr</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusPartAddrDepdntTaxNmbr>> getBusPartAddrDepdntTaxNmbrIfPresent()
    {
        return Option.of(toBusPartAddrDepdntTaxNmbr);
    }

    /**
     * Overwrites the list of associated <b>BusPartAddrDepdntTaxNmbr</b> entities for the loaded navigation property
     * <b>to_BusPartAddrDepdntTaxNmbr</b>.
     * <p>
     * If the navigation property <b>to_BusPartAddrDepdntTaxNmbr</b> of a queried <b>BusinessPartner</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusPartAddrDepdntTaxNmbr</b> entities.
     */
    public void setBusPartAddrDepdntTaxNmbr( @Nonnull final List<BusPartAddrDepdntTaxNmbr> value )
    {
        if( toBusPartAddrDepdntTaxNmbr == null ) {
            toBusPartAddrDepdntTaxNmbr = Lists.newArrayList();
        }
        toBusPartAddrDepdntTaxNmbr.clear();
        toBusPartAddrDepdntTaxNmbr.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusPartAddrDepdntTaxNmbr</b> entities. This corresponds to the OData
     * navigation property <b>to_BusPartAddrDepdntTaxNmbr</b>.
     * <p>
     * If the navigation property <b>to_BusPartAddrDepdntTaxNmbr</b> of a queried <b>BusinessPartner</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusPartAddrDepdntTaxNmbr</b> entities.
     */
    public void addBusPartAddrDepdntTaxNmbr( BusPartAddrDepdntTaxNmbr... entity )
    {
        if( toBusPartAddrDepdntTaxNmbr == null ) {
            toBusPartAddrDepdntTaxNmbr = Lists.newArrayList();
        }
        toBusPartAddrDepdntTaxNmbr.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>Customer</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Customer</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>Customer</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Customer fetchCustomer()
    {
        return fetchFieldAsSingle("to_Customer", Customer.class);
    }

    /**
     * Retrieval of associated <b>Customer</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Customer</b>.
     * <p>
     * If the navigation property <b>to_Customer</b> of a queried <b>BusinessPartner</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>Customer</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Customer getCustomerOrFetch()
    {
        if( toCustomer == null ) {
            toCustomer = fetchCustomer();
        }
        return toCustomer;
    }

    /**
     * Retrieval of associated <b>Customer</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Customer</b>.
     * <p>
     * If the navigation property for an entity <b>BusinessPartner</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Customer</b> is already loaded, the result will contain
     *         the <b>Customer</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<Customer> getCustomerIfPresent()
    {
        return Option.of(toCustomer);
    }

    /**
     * Overwrites the associated <b>Customer</b> entity for the loaded navigation property <b>to_Customer</b>.
     *
     * @param value
     *            New <b>Customer</b> entity.
     */
    public void setCustomer( final Customer value )
    {
        toCustomer = value;
    }

    /**
     * Fetches the <b>Supplier</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Supplier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>Supplier</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Supplier fetchSupplier()
    {
        return fetchFieldAsSingle("to_Supplier", Supplier.class);
    }

    /**
     * Retrieval of associated <b>Supplier</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Supplier</b>.
     * <p>
     * If the navigation property <b>to_Supplier</b> of a queried <b>BusinessPartner</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>Supplier</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Supplier getSupplierOrFetch()
    {
        if( toSupplier == null ) {
            toSupplier = fetchSupplier();
        }
        return toSupplier;
    }

    /**
     * Retrieval of associated <b>Supplier</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Supplier</b>.
     * <p>
     * If the navigation property for an entity <b>BusinessPartner</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Supplier</b> is already loaded, the result will contain
     *         the <b>Supplier</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<Supplier> getSupplierIfPresent()
    {
        return Option.of(toSupplier);
    }

    /**
     * Overwrites the associated <b>Supplier</b> entity for the loaded navigation property <b>to_Supplier</b>.
     *
     * @param value
     *            New <b>Supplier</b> entity.
     */
    public void setSupplier( final Supplier value )
    {
        toSupplier = value;
    }

    /**
     * Helper class to allow for fluent creation of BusinessPartner instances.
     *
     */
    public final static class BusinessPartnerBuilder
    {

        private BPCreditWorthiness toBPCreditWorthiness;
        private BPFinancialServicesReporting toBPFinServicesReporting;
        private List<BPFiscalYearInformation> toBPFiscalYearInformation = Lists.newArrayList();
        private List<BPRelationship> toBPRelationship = Lists.newArrayList();
        private List<BuPaIdentification> toBuPaIdentification = Lists.newArrayList();
        private List<BuPaIndustry> toBuPaIndustry = Lists.newArrayList();
        private BPFinancialServicesExtn toBusinessPartner;
        private String businessPartner = null;
        private List<BusinessPartnerAddress> toBusinessPartnerAddress = Lists.newArrayList();
        private List<BusinessPartnerBank> toBusinessPartnerBank = Lists.newArrayList();
        private List<BusinessPartnerContact> toBusinessPartnerContact = Lists.newArrayList();
        private List<BusinessPartnerRating> toBusinessPartnerRating = Lists.newArrayList();
        private List<BusinessPartnerRole> toBusinessPartnerRole = Lists.newArrayList();
        private List<BusinessPartnerTaxNumber> toBusinessPartnerTax = Lists.newArrayList();
        private List<BusPartAddrDepdntTaxNmbr> toBusPartAddrDepdntTaxNmbr = Lists.newArrayList();
        private Customer toCustomer;
        private String customer = null;
        private Supplier toSupplier;
        private String supplier = null;

        private BusinessPartner.BusinessPartnerBuilder toBPCreditWorthiness( final BPCreditWorthiness value )
        {
            toBPCreditWorthiness = value;
            return this;
        }

        /**
         * Navigation property <b>to_BPCreditWorthiness</b> for <b>BusinessPartner</b> to single
         * <b>BPCreditWorthiness</b>.
         *
         * @param value
         *            The BPCreditWorthiness to build this BusinessPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessPartner.BusinessPartnerBuilder bpCreditWorthiness( final BPCreditWorthiness value )
        {
            return toBPCreditWorthiness(value);
        }

        private BusinessPartner.BusinessPartnerBuilder toBPFinServicesReporting(
            final BPFinancialServicesReporting value )
        {
            toBPFinServicesReporting = value;
            return this;
        }

        /**
         * Navigation property <b>to_BPFinServicesReporting</b> for <b>BusinessPartner</b> to single
         * <b>BPFinancialServicesReporting</b>.
         *
         * @param value
         *            The BPFinancialServicesReporting to build this BusinessPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessPartner.BusinessPartnerBuilder bpFinServicesReporting( final BPFinancialServicesReporting value )
        {
            return toBPFinServicesReporting(value);
        }

        private BusinessPartner.BusinessPartnerBuilder toBPFiscalYearInformation(
            final List<BPFiscalYearInformation> value )
        {
            toBPFiscalYearInformation.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BPFiscalYearInformation</b> for <b>BusinessPartner</b> to multiple
         * <b>BPFiscalYearInformation</b>.
         *
         * @param value
         *            The BPFiscalYearInformations to build this BusinessPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessPartner.BusinessPartnerBuilder bpFiscalYearInformation( BPFiscalYearInformation... value )
        {
            return toBPFiscalYearInformation(Lists.newArrayList(value));
        }

        private BusinessPartner.BusinessPartnerBuilder toBPRelationship( final List<BPRelationship> value )
        {
            toBPRelationship.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BPRelationship</b> for <b>BusinessPartner</b> to multiple <b>BPRelationship</b>.
         *
         * @param value
         *            The BPRelationships to build this BusinessPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessPartner.BusinessPartnerBuilder bpRelationship( BPRelationship... value )
        {
            return toBPRelationship(Lists.newArrayList(value));
        }

        private BusinessPartner.BusinessPartnerBuilder toBuPaIdentification( final List<BuPaIdentification> value )
        {
            toBuPaIdentification.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BuPaIdentification</b> for <b>BusinessPartner</b> to multiple
         * <b>BuPaIdentification</b>.
         *
         * @param value
         *            The BuPaIdentifications to build this BusinessPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessPartner.BusinessPartnerBuilder buPaIdentification( BuPaIdentification... value )
        {
            return toBuPaIdentification(Lists.newArrayList(value));
        }

        private BusinessPartner.BusinessPartnerBuilder toBuPaIndustry( final List<BuPaIndustry> value )
        {
            toBuPaIndustry.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BuPaIndustry</b> for <b>BusinessPartner</b> to multiple <b>BuPaIndustry</b>.
         *
         * @param value
         *            The BuPaIndustrys to build this BusinessPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessPartner.BusinessPartnerBuilder buPaIndustry( BuPaIndustry... value )
        {
            return toBuPaIndustry(Lists.newArrayList(value));
        }

        private BusinessPartner.BusinessPartnerBuilder toBusinessPartner( final BPFinancialServicesExtn value )
        {
            toBusinessPartner = value;
            return this;
        }

        /**
         * Navigation property <b>to_BusinessPartner</b> for <b>BusinessPartner</b> to single
         * <b>BPFinancialServicesExtn</b>.
         *
         * @param value
         *            The BPFinancialServicesExtn to build this BusinessPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessPartner.BusinessPartnerBuilder businessPartner( final BPFinancialServicesExtn value )
        {
            return toBusinessPartner(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>BusinessPartner</b>
         * </p>
         *
         * @param value
         *            The businessPartner to build this BusinessPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessPartner.BusinessPartnerBuilder businessPartner( final String value )
        {
            businessPartner = value;
            return this;
        }

        private BusinessPartner.BusinessPartnerBuilder toBusinessPartnerAddress(
            final List<BusinessPartnerAddress> value )
        {
            toBusinessPartnerAddress.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BusinessPartnerAddress</b> for <b>BusinessPartner</b> to multiple
         * <b>BusinessPartnerAddress</b>.
         *
         * @param value
         *            The BusinessPartnerAddresss to build this BusinessPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessPartner.BusinessPartnerBuilder businessPartnerAddress( BusinessPartnerAddress... value )
        {
            return toBusinessPartnerAddress(Lists.newArrayList(value));
        }

        private BusinessPartner.BusinessPartnerBuilder toBusinessPartnerBank( final List<BusinessPartnerBank> value )
        {
            toBusinessPartnerBank.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BusinessPartnerBank</b> for <b>BusinessPartner</b> to multiple
         * <b>BusinessPartnerBank</b>.
         *
         * @param value
         *            The BusinessPartnerBanks to build this BusinessPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessPartner.BusinessPartnerBuilder businessPartnerBank( BusinessPartnerBank... value )
        {
            return toBusinessPartnerBank(Lists.newArrayList(value));
        }

        private BusinessPartner.BusinessPartnerBuilder toBusinessPartnerContact(
            final List<BusinessPartnerContact> value )
        {
            toBusinessPartnerContact.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BusinessPartnerContact</b> for <b>BusinessPartner</b> to multiple
         * <b>BusinessPartnerContact</b>.
         *
         * @param value
         *            The BusinessPartnerContacts to build this BusinessPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessPartner.BusinessPartnerBuilder businessPartnerContact( BusinessPartnerContact... value )
        {
            return toBusinessPartnerContact(Lists.newArrayList(value));
        }

        private BusinessPartner.BusinessPartnerBuilder toBusinessPartnerRating(
            final List<BusinessPartnerRating> value )
        {
            toBusinessPartnerRating.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BusinessPartnerRating</b> for <b>BusinessPartner</b> to multiple
         * <b>BusinessPartnerRating</b>.
         *
         * @param value
         *            The BusinessPartnerRatings to build this BusinessPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessPartner.BusinessPartnerBuilder businessPartnerRating( BusinessPartnerRating... value )
        {
            return toBusinessPartnerRating(Lists.newArrayList(value));
        }

        private BusinessPartner.BusinessPartnerBuilder toBusinessPartnerRole( final List<BusinessPartnerRole> value )
        {
            toBusinessPartnerRole.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BusinessPartnerRole</b> for <b>BusinessPartner</b> to multiple
         * <b>BusinessPartnerRole</b>.
         *
         * @param value
         *            The BusinessPartnerRoles to build this BusinessPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessPartner.BusinessPartnerBuilder businessPartnerRole( BusinessPartnerRole... value )
        {
            return toBusinessPartnerRole(Lists.newArrayList(value));
        }

        private BusinessPartner.BusinessPartnerBuilder toBusinessPartnerTax(
            final List<BusinessPartnerTaxNumber> value )
        {
            toBusinessPartnerTax.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BusinessPartnerTax</b> for <b>BusinessPartner</b> to multiple
         * <b>BusinessPartnerTaxNumber</b>.
         *
         * @param value
         *            The BusinessPartnerTaxNumbers to build this BusinessPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessPartner.BusinessPartnerBuilder businessPartnerTax( BusinessPartnerTaxNumber... value )
        {
            return toBusinessPartnerTax(Lists.newArrayList(value));
        }

        private BusinessPartner.BusinessPartnerBuilder toBusPartAddrDepdntTaxNmbr(
            final List<BusPartAddrDepdntTaxNmbr> value )
        {
            toBusPartAddrDepdntTaxNmbr.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BusPartAddrDepdntTaxNmbr</b> for <b>BusinessPartner</b> to multiple
         * <b>BusPartAddrDepdntTaxNmbr</b>.
         *
         * @param value
         *            The BusPartAddrDepdntTaxNmbrs to build this BusinessPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessPartner.BusinessPartnerBuilder busPartAddrDepdntTaxNmbr( BusPartAddrDepdntTaxNmbr... value )
        {
            return toBusPartAddrDepdntTaxNmbr(Lists.newArrayList(value));
        }

        private BusinessPartner.BusinessPartnerBuilder toCustomer( final Customer value )
        {
            toCustomer = value;
            return this;
        }

        /**
         * Navigation property <b>to_Customer</b> for <b>BusinessPartner</b> to single <b>Customer</b>.
         *
         * @param value
         *            The Customer to build this BusinessPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessPartner.BusinessPartnerBuilder customer( final Customer value )
        {
            return toCustomer(value);
        }

        /**
         * Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>Customer</b>
         * </p>
         *
         * @param value
         *            The customer to build this BusinessPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessPartner.BusinessPartnerBuilder customer( final String value )
        {
            customer = value;
            return this;
        }

        private BusinessPartner.BusinessPartnerBuilder toSupplier( final Supplier value )
        {
            toSupplier = value;
            return this;
        }

        /**
         * Navigation property <b>to_Supplier</b> for <b>BusinessPartner</b> to single <b>Supplier</b>.
         *
         * @param value
         *            The Supplier to build this BusinessPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessPartner.BusinessPartnerBuilder supplier( final Supplier value )
        {
            return toSupplier(value);
        }

        /**
         * Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>Supplier</b>
         * </p>
         *
         * @param value
         *            The supplier to build this BusinessPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessPartner.BusinessPartnerBuilder supplier( final String value )
        {
            supplier = value;
            return this;
        }

    }

}
