/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.field.CustAddrDepdntInformationField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.selectable.CustAddrDepdntInformationSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Customer Address Dependent Infomation
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CustAddrDepdntInformationType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CustAddrDepdntInformation extends VdmEntity<CustAddrDepdntInformation>
{

    /**
     * Selector for all available fields of CustAddrDepdntInformation.
     *
     */
    public final static CustAddrDepdntInformationSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Customer Number
     */
    @Key
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static CustAddrDepdntInformationField<String> CUSTOMER =
        new CustAddrDepdntInformationField<String>("Customer");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AddressID</b>
     * </p>
     *
     * @return Business Partner Address Number (from BUT020)
     */
    @Key
    @SerializedName( "AddressID" )
    @JsonProperty( "AddressID" )
    @Nullable
    @ODataField( odataName = "AddressID" )
    private String addressID;
    /**
     * Use with available fluent helpers to apply the <b>AddressID</b> field to query operations.
     *
     */
    public final static CustAddrDepdntInformationField<String> ADDRESS_ID =
        new CustAddrDepdntInformationField<String>("AddressID");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>ExpressTrainStationName</b>
     * </p>
     *
     * @return Express train station
     */
    @SerializedName( "ExpressTrainStationName" )
    @JsonProperty( "ExpressTrainStationName" )
    @Nullable
    @ODataField( odataName = "ExpressTrainStationName" )
    private String expressTrainStationName;
    /**
     * Use with available fluent helpers to apply the <b>ExpressTrainStationName</b> field to query operations.
     *
     */
    public final static CustAddrDepdntInformationField<String> EXPRESS_TRAIN_STATION_NAME =
        new CustAddrDepdntInformationField<String>("ExpressTrainStationName");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>TrainStationName</b>
     * </p>
     *
     * @return Train station
     */
    @SerializedName( "TrainStationName" )
    @JsonProperty( "TrainStationName" )
    @Nullable
    @ODataField( odataName = "TrainStationName" )
    private String trainStationName;
    /**
     * Use with available fluent helpers to apply the <b>TrainStationName</b> field to query operations.
     *
     */
    public final static CustAddrDepdntInformationField<String> TRAIN_STATION_NAME =
        new CustAddrDepdntInformationField<String>("TrainStationName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CityCode</b>
     * </p>
     *
     * @return City Code
     */
    @SerializedName( "CityCode" )
    @JsonProperty( "CityCode" )
    @Nullable
    @ODataField( odataName = "CityCode" )
    private String cityCode;
    /**
     * Use with available fluent helpers to apply the <b>CityCode</b> field to query operations.
     *
     */
    public final static CustAddrDepdntInformationField<String> CITY_CODE =
        new CustAddrDepdntInformationField<String>("CityCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>County</b>
     * </p>
     *
     * @return County Code
     */
    @SerializedName( "County" )
    @JsonProperty( "County" )
    @Nullable
    @ODataField( odataName = "County" )
    private String county;
    /**
     * Use with available fluent helpers to apply the <b>County</b> field to query operations.
     *
     */
    public final static CustAddrDepdntInformationField<String> COUNTY =
        new CustAddrDepdntInformationField<String>("County");

    @Nonnull
    @Override
    public Class<CustAddrDepdntInformation> getType()
    {
        return CustAddrDepdntInformation.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Customer Number
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AddressID</b>
     * </p>
     *
     * @param addressID
     *            Business Partner Address Number (from BUT020)
     */
    public void setAddressID( @Nullable final String addressID )
    {
        rememberChangedField("AddressID", this.addressID);
        this.addressID = addressID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>ExpressTrainStationName</b>
     * </p>
     *
     * @param expressTrainStationName
     *            Express train station
     */
    public void setExpressTrainStationName( @Nullable final String expressTrainStationName )
    {
        rememberChangedField("ExpressTrainStationName", this.expressTrainStationName);
        this.expressTrainStationName = expressTrainStationName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>TrainStationName</b>
     * </p>
     *
     * @param trainStationName
     *            Train station
     */
    public void setTrainStationName( @Nullable final String trainStationName )
    {
        rememberChangedField("TrainStationName", this.trainStationName);
        this.trainStationName = trainStationName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CityCode</b>
     * </p>
     *
     * @param cityCode
     *            City Code
     */
    public void setCityCode( @Nullable final String cityCode )
    {
        rememberChangedField("CityCode", this.cityCode);
        this.cityCode = cityCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>County</b>
     * </p>
     *
     * @param county
     *            County Code
     */
    public void setCounty( @Nullable final String county )
    {
        rememberChangedField("County", this.county);
        this.county = county;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CustAddrDepdntInformation";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Customer", getCustomer());
        result.put("AddressID", getAddressID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Customer", getCustomer());
        values.put("AddressID", getAddressID());
        values.put("ExpressTrainStationName", getExpressTrainStationName());
        values.put("TrainStationName", getTrainStationName());
        values.put("CityCode", getCityCode());
        values.put("County", getCounty());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("AddressID") ) {
                final Object value = values.remove("AddressID");
                if( (value == null) || (!value.equals(getAddressID())) ) {
                    setAddressID(((String) value));
                }
            }
            if( values.containsKey("ExpressTrainStationName") ) {
                final Object value = values.remove("ExpressTrainStationName");
                if( (value == null) || (!value.equals(getExpressTrainStationName())) ) {
                    setExpressTrainStationName(((String) value));
                }
            }
            if( values.containsKey("TrainStationName") ) {
                final Object value = values.remove("TrainStationName");
                if( (value == null) || (!value.equals(getTrainStationName())) ) {
                    setTrainStationName(((String) value));
                }
            }
            if( values.containsKey("CityCode") ) {
                final Object value = values.remove("CityCode");
                if( (value == null) || (!value.equals(getCityCode())) ) {
                    setCityCode(((String) value));
                }
            }
            if( values.containsKey("County") ) {
                final Object value = values.remove("County");
                if( (value == null) || (!value.equals(getCounty())) ) {
                    setCounty(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CustAddrDepdntInformationField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CustAddrDepdntInformationField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CustAddrDepdntInformationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CustAddrDepdntInformationField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessPartnerService.DEFAULT_SERVICE_PATH);
    }

}
