/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.field.CustSlsAreaAddrDepdntInfoField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.selectable.CustSlsAreaAddrDepdntInfoSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Customer Sales Area Address Dependent Information
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CustSlsAreaAddrDepdntInfoType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CustSlsAreaAddrDepdntInfo extends VdmEntity<CustSlsAreaAddrDepdntInfo>
{

    /**
     * Selector for all available fields of CustSlsAreaAddrDepdntInfo.
     *
     */
    public final static CustSlsAreaAddrDepdntInfoSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Customer Number
     */
    @Key
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static CustSlsAreaAddrDepdntInfoField<String> CUSTOMER =
        new CustSlsAreaAddrDepdntInfoField<String>("Customer");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @return Sales Organization
     */
    @Key
    @SerializedName( "SalesOrganization" )
    @JsonProperty( "SalesOrganization" )
    @Nullable
    @ODataField( odataName = "SalesOrganization" )
    private String salesOrganization;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganization</b> field to query operations.
     *
     */
    public final static CustSlsAreaAddrDepdntInfoField<String> SALES_ORGANIZATION =
        new CustSlsAreaAddrDepdntInfoField<String>("SalesOrganization");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @return Distribution Channel
     */
    @Key
    @SerializedName( "DistributionChannel" )
    @JsonProperty( "DistributionChannel" )
    @Nullable
    @ODataField( odataName = "DistributionChannel" )
    private String distributionChannel;
    /**
     * Use with available fluent helpers to apply the <b>DistributionChannel</b> field to query operations.
     *
     */
    public final static CustSlsAreaAddrDepdntInfoField<String> DISTRIBUTION_CHANNEL =
        new CustSlsAreaAddrDepdntInfoField<String>("DistributionChannel");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @return Division
     */
    @Key
    @SerializedName( "Division" )
    @JsonProperty( "Division" )
    @Nullable
    @ODataField( odataName = "Division" )
    private String division;
    /**
     * Use with available fluent helpers to apply the <b>Division</b> field to query operations.
     *
     */
    public final static CustSlsAreaAddrDepdntInfoField<String> DIVISION =
        new CustSlsAreaAddrDepdntInfoField<String>("Division");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AddressID</b>
     * </p>
     *
     * @return Business Partner Address Number (from BUT020)
     */
    @Key
    @SerializedName( "AddressID" )
    @JsonProperty( "AddressID" )
    @Nullable
    @ODataField( odataName = "AddressID" )
    private String addressID;
    /**
     * Use with available fluent helpers to apply the <b>AddressID</b> field to query operations.
     *
     */
    public final static CustSlsAreaAddrDepdntInfoField<String> ADDRESS_ID =
        new CustSlsAreaAddrDepdntInfoField<String>("AddressID");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @return Incoterms (Part 1)
     */
    @SerializedName( "IncotermsClassification" )
    @JsonProperty( "IncotermsClassification" )
    @Nullable
    @ODataField( odataName = "IncotermsClassification" )
    private String incotermsClassification;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsClassification</b> field to query operations.
     *
     */
    public final static CustSlsAreaAddrDepdntInfoField<String> INCOTERMS_CLASSIFICATION =
        new CustSlsAreaAddrDepdntInfoField<String>("IncotermsClassification");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @return Incoterms Location 1
     */
    @SerializedName( "IncotermsLocation1" )
    @JsonProperty( "IncotermsLocation1" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation1" )
    private String incotermsLocation1;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation1</b> field to query operations.
     *
     */
    public final static CustSlsAreaAddrDepdntInfoField<String> INCOTERMS_LOCATION1 =
        new CustSlsAreaAddrDepdntInfoField<String>("IncotermsLocation1");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @return Incoterms Location 2
     */
    @SerializedName( "IncotermsLocation2" )
    @JsonProperty( "IncotermsLocation2" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation2" )
    private String incotermsLocation2;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation2</b> field to query operations.
     *
     */
    public final static CustSlsAreaAddrDepdntInfoField<String> INCOTERMS_LOCATION2 =
        new CustSlsAreaAddrDepdntInfoField<String>("IncotermsLocation2");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsSupChnLoc1AddlUUID</b>
     * </p>
     *
     * @return Location UUID
     */
    @SerializedName( "IncotermsSupChnLoc1AddlUUID" )
    @JsonProperty( "IncotermsSupChnLoc1AddlUUID" )
    @Nullable
    @ODataField( odataName = "IncotermsSupChnLoc1AddlUUID" )
    private UUID incotermsSupChnLoc1AddlUUID;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsSupChnLoc1AddlUUID</b> field to query operations.
     *
     */
    public final static CustSlsAreaAddrDepdntInfoField<UUID> INCOTERMS_SUP_CHN_LOC1_ADDL_UUID =
        new CustSlsAreaAddrDepdntInfoField<UUID>("IncotermsSupChnLoc1AddlUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsSupChnLoc2AddlUUID</b>
     * </p>
     *
     * @return Location UUID
     */
    @SerializedName( "IncotermsSupChnLoc2AddlUUID" )
    @JsonProperty( "IncotermsSupChnLoc2AddlUUID" )
    @Nullable
    @ODataField( odataName = "IncotermsSupChnLoc2AddlUUID" )
    private UUID incotermsSupChnLoc2AddlUUID;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsSupChnLoc2AddlUUID</b> field to query operations.
     *
     */
    public final static CustSlsAreaAddrDepdntInfoField<UUID> INCOTERMS_SUP_CHN_LOC2_ADDL_UUID =
        new CustSlsAreaAddrDepdntInfoField<UUID>("IncotermsSupChnLoc2AddlUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsSupChnDvtgLocAddlUUID</b>
     * </p>
     *
     * @return Location UUID
     */
    @SerializedName( "IncotermsSupChnDvtgLocAddlUUID" )
    @JsonProperty( "IncotermsSupChnDvtgLocAddlUUID" )
    @Nullable
    @ODataField( odataName = "IncotermsSupChnDvtgLocAddlUUID" )
    private UUID incotermsSupChnDvtgLocAddlUUID;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsSupChnDvtgLocAddlUUID</b> field to query operations.
     *
     */
    public final static CustSlsAreaAddrDepdntInfoField<UUID> INCOTERMS_SUP_CHN_DVTG_LOC_ADDL_UUID =
        new CustSlsAreaAddrDepdntInfoField<UUID>("IncotermsSupChnDvtgLocAddlUUID");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryIsBlocked</b>
     * </p>
     *
     * @return Customer delivery block (sales area)
     */
    @SerializedName( "DeliveryIsBlocked" )
    @JsonProperty( "DeliveryIsBlocked" )
    @Nullable
    @ODataField( odataName = "DeliveryIsBlocked" )
    private String deliveryIsBlocked;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryIsBlocked</b> field to query operations.
     *
     */
    public final static CustSlsAreaAddrDepdntInfoField<String> DELIVERY_IS_BLOCKED =
        new CustSlsAreaAddrDepdntInfoField<String>("DeliveryIsBlocked");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     *
     * @return Sales Office
     */
    @SerializedName( "SalesOffice" )
    @JsonProperty( "SalesOffice" )
    @Nullable
    @ODataField( odataName = "SalesOffice" )
    private String salesOffice;
    /**
     * Use with available fluent helpers to apply the <b>SalesOffice</b> field to query operations.
     *
     */
    public final static CustSlsAreaAddrDepdntInfoField<String> SALES_OFFICE =
        new CustSlsAreaAddrDepdntInfoField<String>("SalesOffice");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     *
     * @return Sales Group
     */
    @SerializedName( "SalesGroup" )
    @JsonProperty( "SalesGroup" )
    @Nullable
    @ODataField( odataName = "SalesGroup" )
    private String salesGroup;
    /**
     * Use with available fluent helpers to apply the <b>SalesGroup</b> field to query operations.
     *
     */
    public final static CustSlsAreaAddrDepdntInfoField<String> SALES_GROUP =
        new CustSlsAreaAddrDepdntInfoField<String>("SalesGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingCondition</b>
     * </p>
     *
     * @return Shipping Conditions
     */
    @SerializedName( "ShippingCondition" )
    @JsonProperty( "ShippingCondition" )
    @Nullable
    @ODataField( odataName = "ShippingCondition" )
    private String shippingCondition;
    /**
     * Use with available fluent helpers to apply the <b>ShippingCondition</b> field to query operations.
     *
     */
    public final static CustSlsAreaAddrDepdntInfoField<String> SHIPPING_CONDITION =
        new CustSlsAreaAddrDepdntInfoField<String>("ShippingCondition");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SupplyingPlant</b>
     * </p>
     *
     * @return Delivering Plant (Own or External)
     */
    @SerializedName( "SupplyingPlant" )
    @JsonProperty( "SupplyingPlant" )
    @Nullable
    @ODataField( odataName = "SupplyingPlant" )
    private String supplyingPlant;
    /**
     * Use with available fluent helpers to apply the <b>SupplyingPlant</b> field to query operations.
     *
     */
    public final static CustSlsAreaAddrDepdntInfoField<String> SUPPLYING_PLANT =
        new CustSlsAreaAddrDepdntInfoField<String>("SupplyingPlant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsVersion</b>
     * </p>
     *
     * @return Incoterms Version
     */
    @SerializedName( "IncotermsVersion" )
    @JsonProperty( "IncotermsVersion" )
    @Nullable
    @ODataField( odataName = "IncotermsVersion" )
    private String incotermsVersion;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsVersion</b> field to query operations.
     *
     */
    public final static CustSlsAreaAddrDepdntInfoField<String> INCOTERMS_VERSION =
        new CustSlsAreaAddrDepdntInfoField<String>("IncotermsVersion");

    @Nonnull
    @Override
    public Class<CustSlsAreaAddrDepdntInfo> getType()
    {
        return CustSlsAreaAddrDepdntInfo.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Customer Number
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @param salesOrganization
     *            Sales Organization
     */
    public void setSalesOrganization( @Nullable final String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @param distributionChannel
     *            Distribution Channel
     */
    public void setDistributionChannel( @Nullable final String distributionChannel )
    {
        rememberChangedField("DistributionChannel", this.distributionChannel);
        this.distributionChannel = distributionChannel;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @param division
     *            Division
     */
    public void setDivision( @Nullable final String division )
    {
        rememberChangedField("Division", this.division);
        this.division = division;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AddressID</b>
     * </p>
     *
     * @param addressID
     *            Business Partner Address Number (from BUT020)
     */
    public void setAddressID( @Nullable final String addressID )
    {
        rememberChangedField("AddressID", this.addressID);
        this.addressID = addressID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @param incotermsClassification
     *            Incoterms (Part 1)
     */
    public void setIncotermsClassification( @Nullable final String incotermsClassification )
    {
        rememberChangedField("IncotermsClassification", this.incotermsClassification);
        this.incotermsClassification = incotermsClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @param incotermsLocation1
     *            Incoterms Location 1
     */
    public void setIncotermsLocation1( @Nullable final String incotermsLocation1 )
    {
        rememberChangedField("IncotermsLocation1", this.incotermsLocation1);
        this.incotermsLocation1 = incotermsLocation1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @param incotermsLocation2
     *            Incoterms Location 2
     */
    public void setIncotermsLocation2( @Nullable final String incotermsLocation2 )
    {
        rememberChangedField("IncotermsLocation2", this.incotermsLocation2);
        this.incotermsLocation2 = incotermsLocation2;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsSupChnLoc1AddlUUID</b>
     * </p>
     *
     * @param incotermsSupChnLoc1AddlUUID
     *            Location UUID
     */
    public void setIncotermsSupChnLoc1AddlUUID( @Nullable final UUID incotermsSupChnLoc1AddlUUID )
    {
        rememberChangedField("IncotermsSupChnLoc1AddlUUID", this.incotermsSupChnLoc1AddlUUID);
        this.incotermsSupChnLoc1AddlUUID = incotermsSupChnLoc1AddlUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsSupChnLoc2AddlUUID</b>
     * </p>
     *
     * @param incotermsSupChnLoc2AddlUUID
     *            Location UUID
     */
    public void setIncotermsSupChnLoc2AddlUUID( @Nullable final UUID incotermsSupChnLoc2AddlUUID )
    {
        rememberChangedField("IncotermsSupChnLoc2AddlUUID", this.incotermsSupChnLoc2AddlUUID);
        this.incotermsSupChnLoc2AddlUUID = incotermsSupChnLoc2AddlUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsSupChnDvtgLocAddlUUID</b>
     * </p>
     *
     * @param incotermsSupChnDvtgLocAddlUUID
     *            Location UUID
     */
    public void setIncotermsSupChnDvtgLocAddlUUID( @Nullable final UUID incotermsSupChnDvtgLocAddlUUID )
    {
        rememberChangedField("IncotermsSupChnDvtgLocAddlUUID", this.incotermsSupChnDvtgLocAddlUUID);
        this.incotermsSupChnDvtgLocAddlUUID = incotermsSupChnDvtgLocAddlUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryIsBlocked</b>
     * </p>
     *
     * @param deliveryIsBlocked
     *            Customer delivery block (sales area)
     */
    public void setDeliveryIsBlocked( @Nullable final String deliveryIsBlocked )
    {
        rememberChangedField("DeliveryIsBlocked", this.deliveryIsBlocked);
        this.deliveryIsBlocked = deliveryIsBlocked;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     *
     * @param salesOffice
     *            Sales Office
     */
    public void setSalesOffice( @Nullable final String salesOffice )
    {
        rememberChangedField("SalesOffice", this.salesOffice);
        this.salesOffice = salesOffice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     *
     * @param salesGroup
     *            Sales Group
     */
    public void setSalesGroup( @Nullable final String salesGroup )
    {
        rememberChangedField("SalesGroup", this.salesGroup);
        this.salesGroup = salesGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingCondition</b>
     * </p>
     *
     * @param shippingCondition
     *            Shipping Conditions
     */
    public void setShippingCondition( @Nullable final String shippingCondition )
    {
        rememberChangedField("ShippingCondition", this.shippingCondition);
        this.shippingCondition = shippingCondition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SupplyingPlant</b>
     * </p>
     *
     * @param supplyingPlant
     *            Delivering Plant (Own or External)
     */
    public void setSupplyingPlant( @Nullable final String supplyingPlant )
    {
        rememberChangedField("SupplyingPlant", this.supplyingPlant);
        this.supplyingPlant = supplyingPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsVersion</b>
     * </p>
     *
     * @param incotermsVersion
     *            Incoterms Version
     */
    public void setIncotermsVersion( @Nullable final String incotermsVersion )
    {
        rememberChangedField("IncotermsVersion", this.incotermsVersion);
        this.incotermsVersion = incotermsVersion;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CustSlsAreaAddrDepdntInfo";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Customer", getCustomer());
        result.put("SalesOrganization", getSalesOrganization());
        result.put("DistributionChannel", getDistributionChannel());
        result.put("Division", getDivision());
        result.put("AddressID", getAddressID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Customer", getCustomer());
        values.put("SalesOrganization", getSalesOrganization());
        values.put("DistributionChannel", getDistributionChannel());
        values.put("Division", getDivision());
        values.put("AddressID", getAddressID());
        values.put("IncotermsClassification", getIncotermsClassification());
        values.put("IncotermsLocation1", getIncotermsLocation1());
        values.put("IncotermsLocation2", getIncotermsLocation2());
        values.put("IncotermsSupChnLoc1AddlUUID", getIncotermsSupChnLoc1AddlUUID());
        values.put("IncotermsSupChnLoc2AddlUUID", getIncotermsSupChnLoc2AddlUUID());
        values.put("IncotermsSupChnDvtgLocAddlUUID", getIncotermsSupChnDvtgLocAddlUUID());
        values.put("DeliveryIsBlocked", getDeliveryIsBlocked());
        values.put("SalesOffice", getSalesOffice());
        values.put("SalesGroup", getSalesGroup());
        values.put("ShippingCondition", getShippingCondition());
        values.put("SupplyingPlant", getSupplyingPlant());
        values.put("IncotermsVersion", getIncotermsVersion());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((String) value));
                }
            }
            if( values.containsKey("DistributionChannel") ) {
                final Object value = values.remove("DistributionChannel");
                if( (value == null) || (!value.equals(getDistributionChannel())) ) {
                    setDistributionChannel(((String) value));
                }
            }
            if( values.containsKey("Division") ) {
                final Object value = values.remove("Division");
                if( (value == null) || (!value.equals(getDivision())) ) {
                    setDivision(((String) value));
                }
            }
            if( values.containsKey("AddressID") ) {
                final Object value = values.remove("AddressID");
                if( (value == null) || (!value.equals(getAddressID())) ) {
                    setAddressID(((String) value));
                }
            }
            if( values.containsKey("IncotermsClassification") ) {
                final Object value = values.remove("IncotermsClassification");
                if( (value == null) || (!value.equals(getIncotermsClassification())) ) {
                    setIncotermsClassification(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation1") ) {
                final Object value = values.remove("IncotermsLocation1");
                if( (value == null) || (!value.equals(getIncotermsLocation1())) ) {
                    setIncotermsLocation1(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation2") ) {
                final Object value = values.remove("IncotermsLocation2");
                if( (value == null) || (!value.equals(getIncotermsLocation2())) ) {
                    setIncotermsLocation2(((String) value));
                }
            }
            if( values.containsKey("IncotermsSupChnLoc1AddlUUID") ) {
                final Object value = values.remove("IncotermsSupChnLoc1AddlUUID");
                if( (value == null) || (!value.equals(getIncotermsSupChnLoc1AddlUUID())) ) {
                    setIncotermsSupChnLoc1AddlUUID(((UUID) value));
                }
            }
            if( values.containsKey("IncotermsSupChnLoc2AddlUUID") ) {
                final Object value = values.remove("IncotermsSupChnLoc2AddlUUID");
                if( (value == null) || (!value.equals(getIncotermsSupChnLoc2AddlUUID())) ) {
                    setIncotermsSupChnLoc2AddlUUID(((UUID) value));
                }
            }
            if( values.containsKey("IncotermsSupChnDvtgLocAddlUUID") ) {
                final Object value = values.remove("IncotermsSupChnDvtgLocAddlUUID");
                if( (value == null) || (!value.equals(getIncotermsSupChnDvtgLocAddlUUID())) ) {
                    setIncotermsSupChnDvtgLocAddlUUID(((UUID) value));
                }
            }
            if( values.containsKey("DeliveryIsBlocked") ) {
                final Object value = values.remove("DeliveryIsBlocked");
                if( (value == null) || (!value.equals(getDeliveryIsBlocked())) ) {
                    setDeliveryIsBlocked(((String) value));
                }
            }
            if( values.containsKey("SalesOffice") ) {
                final Object value = values.remove("SalesOffice");
                if( (value == null) || (!value.equals(getSalesOffice())) ) {
                    setSalesOffice(((String) value));
                }
            }
            if( values.containsKey("SalesGroup") ) {
                final Object value = values.remove("SalesGroup");
                if( (value == null) || (!value.equals(getSalesGroup())) ) {
                    setSalesGroup(((String) value));
                }
            }
            if( values.containsKey("ShippingCondition") ) {
                final Object value = values.remove("ShippingCondition");
                if( (value == null) || (!value.equals(getShippingCondition())) ) {
                    setShippingCondition(((String) value));
                }
            }
            if( values.containsKey("SupplyingPlant") ) {
                final Object value = values.remove("SupplyingPlant");
                if( (value == null) || (!value.equals(getSupplyingPlant())) ) {
                    setSupplyingPlant(((String) value));
                }
            }
            if( values.containsKey("IncotermsVersion") ) {
                final Object value = values.remove("IncotermsVersion");
                if( (value == null) || (!value.equals(getIncotermsVersion())) ) {
                    setIncotermsVersion(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CustSlsAreaAddrDepdntInfoField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CustSlsAreaAddrDepdntInfoField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CustSlsAreaAddrDepdntInfoField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CustSlsAreaAddrDepdntInfoField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessPartnerService.DEFAULT_SERVICE_PATH);
    }

}
