/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.field.CustSlsAreaAddrDepdntTaxInfoField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.selectable.CustSlsAreaAddrDepdntTaxInfoSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Customer Sales Area Address Dependent Tax Info
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CustSlsAreaAddrDepdntTaxInfoType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CustSlsAreaAddrDepdntTaxInfo extends VdmEntity<CustSlsAreaAddrDepdntTaxInfo>
{

    /**
     * Selector for all available fields of CustSlsAreaAddrDepdntTaxInfo.
     *
     */
    public final static CustSlsAreaAddrDepdntTaxInfoSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Customer Number
     */
    @Key
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static CustSlsAreaAddrDepdntTaxInfoField<String> CUSTOMER =
        new CustSlsAreaAddrDepdntTaxInfoField<String>("Customer");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @return Sales Organization
     */
    @Key
    @SerializedName( "SalesOrganization" )
    @JsonProperty( "SalesOrganization" )
    @Nullable
    @ODataField( odataName = "SalesOrganization" )
    private String salesOrganization;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganization</b> field to query operations.
     *
     */
    public final static CustSlsAreaAddrDepdntTaxInfoField<String> SALES_ORGANIZATION =
        new CustSlsAreaAddrDepdntTaxInfoField<String>("SalesOrganization");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @return Reference distrib.channel for cust.and material masters
     */
    @Key
    @SerializedName( "DistributionChannel" )
    @JsonProperty( "DistributionChannel" )
    @Nullable
    @ODataField( odataName = "DistributionChannel" )
    private String distributionChannel;
    /**
     * Use with available fluent helpers to apply the <b>DistributionChannel</b> field to query operations.
     *
     */
    public final static CustSlsAreaAddrDepdntTaxInfoField<String> DISTRIBUTION_CHANNEL =
        new CustSlsAreaAddrDepdntTaxInfoField<String>("DistributionChannel");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @return Division
     */
    @Key
    @SerializedName( "Division" )
    @JsonProperty( "Division" )
    @Nullable
    @ODataField( odataName = "Division" )
    private String division;
    /**
     * Use with available fluent helpers to apply the <b>Division</b> field to query operations.
     *
     */
    public final static CustSlsAreaAddrDepdntTaxInfoField<String> DIVISION =
        new CustSlsAreaAddrDepdntTaxInfoField<String>("Division");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AddressID</b>
     * </p>
     *
     * @return Business Partner Address Number (from BUT020)
     */
    @Key
    @SerializedName( "AddressID" )
    @JsonProperty( "AddressID" )
    @Nullable
    @ODataField( odataName = "AddressID" )
    private String addressID;
    /**
     * Use with available fluent helpers to apply the <b>AddressID</b> field to query operations.
     *
     */
    public final static CustSlsAreaAddrDepdntTaxInfoField<String> ADDRESS_ID =
        new CustSlsAreaAddrDepdntTaxInfoField<String>("AddressID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DepartureCountry</b>
     * </p>
     *
     * @return Departure Country/Region (from which the goods are sent)
     */
    @Key
    @SerializedName( "DepartureCountry" )
    @JsonProperty( "DepartureCountry" )
    @Nullable
    @ODataField( odataName = "DepartureCountry" )
    private String departureCountry;
    /**
     * Use with available fluent helpers to apply the <b>DepartureCountry</b> field to query operations.
     *
     */
    public final static CustSlsAreaAddrDepdntTaxInfoField<String> DEPARTURE_COUNTRY =
        new CustSlsAreaAddrDepdntTaxInfoField<String>("DepartureCountry");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxCategory</b>
     * </p>
     *
     * @return Tax Condition Type (Sales Tax, Value-Added Tax,...)
     */
    @Key
    @SerializedName( "CustomerTaxCategory" )
    @JsonProperty( "CustomerTaxCategory" )
    @Nullable
    @ODataField( odataName = "CustomerTaxCategory" )
    private String customerTaxCategory;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxCategory</b> field to query operations.
     *
     */
    public final static CustSlsAreaAddrDepdntTaxInfoField<String> CUSTOMER_TAX_CATEGORY =
        new CustSlsAreaAddrDepdntTaxInfoField<String>("CustomerTaxCategory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification</b>
     * </p>
     *
     * @return Tax classification for customer
     */
    @SerializedName( "CustomerTaxClassification" )
    @JsonProperty( "CustomerTaxClassification" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification" )
    private String customerTaxClassification;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification</b> field to query operations.
     *
     */
    public final static CustSlsAreaAddrDepdntTaxInfoField<String> CUSTOMER_TAX_CLASSIFICATION =
        new CustSlsAreaAddrDepdntTaxInfoField<String>("CustomerTaxClassification");

    @Nonnull
    @Override
    public Class<CustSlsAreaAddrDepdntTaxInfo> getType()
    {
        return CustSlsAreaAddrDepdntTaxInfo.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Customer Number
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @param salesOrganization
     *            Sales Organization
     */
    public void setSalesOrganization( @Nullable final String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @param distributionChannel
     *            Reference distrib.channel for cust.and material masters
     */
    public void setDistributionChannel( @Nullable final String distributionChannel )
    {
        rememberChangedField("DistributionChannel", this.distributionChannel);
        this.distributionChannel = distributionChannel;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @param division
     *            Division
     */
    public void setDivision( @Nullable final String division )
    {
        rememberChangedField("Division", this.division);
        this.division = division;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AddressID</b>
     * </p>
     *
     * @param addressID
     *            Business Partner Address Number (from BUT020)
     */
    public void setAddressID( @Nullable final String addressID )
    {
        rememberChangedField("AddressID", this.addressID);
        this.addressID = addressID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DepartureCountry</b>
     * </p>
     *
     * @param departureCountry
     *            Departure Country/Region (from which the goods are sent)
     */
    public void setDepartureCountry( @Nullable final String departureCountry )
    {
        rememberChangedField("DepartureCountry", this.departureCountry);
        this.departureCountry = departureCountry;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxCategory</b>
     * </p>
     *
     * @param customerTaxCategory
     *            Tax Condition Type (Sales Tax, Value-Added Tax,...)
     */
    public void setCustomerTaxCategory( @Nullable final String customerTaxCategory )
    {
        rememberChangedField("CustomerTaxCategory", this.customerTaxCategory);
        this.customerTaxCategory = customerTaxCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification</b>
     * </p>
     *
     * @param customerTaxClassification
     *            Tax classification for customer
     */
    public void setCustomerTaxClassification( @Nullable final String customerTaxClassification )
    {
        rememberChangedField("CustomerTaxClassification", this.customerTaxClassification);
        this.customerTaxClassification = customerTaxClassification;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CustSlsAreaAddrDepdntTaxInfo";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Customer", getCustomer());
        result.put("SalesOrganization", getSalesOrganization());
        result.put("DistributionChannel", getDistributionChannel());
        result.put("Division", getDivision());
        result.put("AddressID", getAddressID());
        result.put("DepartureCountry", getDepartureCountry());
        result.put("CustomerTaxCategory", getCustomerTaxCategory());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Customer", getCustomer());
        values.put("SalesOrganization", getSalesOrganization());
        values.put("DistributionChannel", getDistributionChannel());
        values.put("Division", getDivision());
        values.put("AddressID", getAddressID());
        values.put("DepartureCountry", getDepartureCountry());
        values.put("CustomerTaxCategory", getCustomerTaxCategory());
        values.put("CustomerTaxClassification", getCustomerTaxClassification());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((String) value));
                }
            }
            if( values.containsKey("DistributionChannel") ) {
                final Object value = values.remove("DistributionChannel");
                if( (value == null) || (!value.equals(getDistributionChannel())) ) {
                    setDistributionChannel(((String) value));
                }
            }
            if( values.containsKey("Division") ) {
                final Object value = values.remove("Division");
                if( (value == null) || (!value.equals(getDivision())) ) {
                    setDivision(((String) value));
                }
            }
            if( values.containsKey("AddressID") ) {
                final Object value = values.remove("AddressID");
                if( (value == null) || (!value.equals(getAddressID())) ) {
                    setAddressID(((String) value));
                }
            }
            if( values.containsKey("DepartureCountry") ) {
                final Object value = values.remove("DepartureCountry");
                if( (value == null) || (!value.equals(getDepartureCountry())) ) {
                    setDepartureCountry(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxCategory") ) {
                final Object value = values.remove("CustomerTaxCategory");
                if( (value == null) || (!value.equals(getCustomerTaxCategory())) ) {
                    setCustomerTaxCategory(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification") ) {
                final Object value = values.remove("CustomerTaxClassification");
                if( (value == null) || (!value.equals(getCustomerTaxClassification())) ) {
                    setCustomerTaxClassification(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CustSlsAreaAddrDepdntTaxInfoField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new CustSlsAreaAddrDepdntTaxInfoField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CustSlsAreaAddrDepdntTaxInfoField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CustSlsAreaAddrDepdntTaxInfoField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessPartnerService.DEFAULT_SERVICE_PATH);
    }

}
