/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.selectable.CustUnldgPtAddrDepdntInfoSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo
 * CustUnldgPtAddrDepdntInfo} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class CustUnldgPtAddrDepdntInfoByKeyFluentHelper
    extends
    FluentHelperByKey<CustUnldgPtAddrDepdntInfoByKeyFluentHelper, CustUnldgPtAddrDepdntInfo, CustUnldgPtAddrDepdntInfoSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo
     * CustUnldgPtAddrDepdntInfo} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code CustUnldgPtAddrDepdntInfo}
     * @param unloadingPointName
     *            Unloading Point
     *            <p>
     *            Constraints: Not nullable, Maximum length: 25
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code CustUnldgPtAddrDepdntInfo}
     * @param customer
     *            Customer Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param addressID
     *            Business Partner Address Number (from BUT020)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public CustUnldgPtAddrDepdntInfoByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String customer,
        final String addressID,
        final String unloadingPointName )
    {
        super(servicePath, entityCollection);
        this.key.put("Customer", customer);
        this.key.put("AddressID", addressID);
        this.key.put("UnloadingPointName", unloadingPointName);
    }

    @Override
    @Nonnull
    protected Class<CustUnldgPtAddrDepdntInfo> getEntityClass()
    {
        return CustUnldgPtAddrDepdntInfo.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
