/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.field.CustomerSalesAreaTaxField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.link.CustomerSalesAreaTaxLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.selectable.CustomerSalesAreaTaxSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Sales Area Tax
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CustomerSalesAreaTaxType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CustomerSalesAreaTax extends VdmEntity<CustomerSalesAreaTax>
{

    /**
     * Selector for all available fields of CustomerSalesAreaTax.
     *
     */
    public final static CustomerSalesAreaTaxSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Customer Number
     */
    @Key
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static CustomerSalesAreaTaxField<String> CUSTOMER = new CustomerSalesAreaTaxField<String>("Customer");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @return Sales Organization
     */
    @Key
    @SerializedName( "SalesOrganization" )
    @JsonProperty( "SalesOrganization" )
    @Nullable
    @ODataField( odataName = "SalesOrganization" )
    private String salesOrganization;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganization</b> field to query operations.
     *
     */
    public final static CustomerSalesAreaTaxField<String> SALES_ORGANIZATION =
        new CustomerSalesAreaTaxField<String>("SalesOrganization");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @return Reference distrib.channel for cust.and material masters
     */
    @Key
    @SerializedName( "DistributionChannel" )
    @JsonProperty( "DistributionChannel" )
    @Nullable
    @ODataField( odataName = "DistributionChannel" )
    private String distributionChannel;
    /**
     * Use with available fluent helpers to apply the <b>DistributionChannel</b> field to query operations.
     *
     */
    public final static CustomerSalesAreaTaxField<String> DISTRIBUTION_CHANNEL =
        new CustomerSalesAreaTaxField<String>("DistributionChannel");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @return Division
     */
    @Key
    @SerializedName( "Division" )
    @JsonProperty( "Division" )
    @Nullable
    @ODataField( odataName = "Division" )
    private String division;
    /**
     * Use with available fluent helpers to apply the <b>Division</b> field to query operations.
     *
     */
    public final static CustomerSalesAreaTaxField<String> DIVISION = new CustomerSalesAreaTaxField<String>("Division");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DepartureCountry</b>
     * </p>
     *
     * @return Departure Country/Region (from which the goods are sent)
     */
    @Key
    @SerializedName( "DepartureCountry" )
    @JsonProperty( "DepartureCountry" )
    @Nullable
    @ODataField( odataName = "DepartureCountry" )
    private String departureCountry;
    /**
     * Use with available fluent helpers to apply the <b>DepartureCountry</b> field to query operations.
     *
     */
    public final static CustomerSalesAreaTaxField<String> DEPARTURE_COUNTRY =
        new CustomerSalesAreaTaxField<String>("DepartureCountry");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxCategory</b>
     * </p>
     *
     * @return Tax Condition Type (Sales Tax, Value-Added Tax,...)
     */
    @Key
    @SerializedName( "CustomerTaxCategory" )
    @JsonProperty( "CustomerTaxCategory" )
    @Nullable
    @ODataField( odataName = "CustomerTaxCategory" )
    private String customerTaxCategory;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxCategory</b> field to query operations.
     *
     */
    public final static CustomerSalesAreaTaxField<String> CUSTOMER_TAX_CATEGORY =
        new CustomerSalesAreaTaxField<String>("CustomerTaxCategory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification</b>
     * </p>
     *
     * @return Tax classification for customer
     */
    @SerializedName( "CustomerTaxClassification" )
    @JsonProperty( "CustomerTaxClassification" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification" )
    private String customerTaxClassification;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification</b> field to query operations.
     *
     */
    public final static CustomerSalesAreaTaxField<String> CUSTOMER_TAX_CLASSIFICATION =
        new CustomerSalesAreaTaxField<String>("CustomerTaxClassification");
    /**
     * Navigation property <b>to_SlsAreaAddrDepdntTax</b> for <b>CustomerSalesAreaTax</b> to multiple
     * <b>CustSlsAreaAddrDepdntTaxInfo</b>.
     *
     */
    @SerializedName( "to_SlsAreaAddrDepdntTax" )
    @JsonProperty( "to_SlsAreaAddrDepdntTax" )
    @ODataField( odataName = "to_SlsAreaAddrDepdntTax" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CustSlsAreaAddrDepdntTaxInfo> toSlsAreaAddrDepdntTax;
    /**
     * Use with available fluent helpers to apply the <b>to_SlsAreaAddrDepdntTax</b> navigation property to query
     * operations.
     *
     */
    public final static CustomerSalesAreaTaxLink<CustSlsAreaAddrDepdntTaxInfo> TO_SLS_AREA_ADDR_DEPDNT_TAX =
        new CustomerSalesAreaTaxLink<CustSlsAreaAddrDepdntTaxInfo>("to_SlsAreaAddrDepdntTax");

    @Nonnull
    @Override
    public Class<CustomerSalesAreaTax> getType()
    {
        return CustomerSalesAreaTax.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Customer Number
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @param salesOrganization
     *            Sales Organization
     */
    public void setSalesOrganization( @Nullable final String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @param distributionChannel
     *            Reference distrib.channel for cust.and material masters
     */
    public void setDistributionChannel( @Nullable final String distributionChannel )
    {
        rememberChangedField("DistributionChannel", this.distributionChannel);
        this.distributionChannel = distributionChannel;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @param division
     *            Division
     */
    public void setDivision( @Nullable final String division )
    {
        rememberChangedField("Division", this.division);
        this.division = division;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DepartureCountry</b>
     * </p>
     *
     * @param departureCountry
     *            Departure Country/Region (from which the goods are sent)
     */
    public void setDepartureCountry( @Nullable final String departureCountry )
    {
        rememberChangedField("DepartureCountry", this.departureCountry);
        this.departureCountry = departureCountry;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxCategory</b>
     * </p>
     *
     * @param customerTaxCategory
     *            Tax Condition Type (Sales Tax, Value-Added Tax,...)
     */
    public void setCustomerTaxCategory( @Nullable final String customerTaxCategory )
    {
        rememberChangedField("CustomerTaxCategory", this.customerTaxCategory);
        this.customerTaxCategory = customerTaxCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification</b>
     * </p>
     *
     * @param customerTaxClassification
     *            Tax classification for customer
     */
    public void setCustomerTaxClassification( @Nullable final String customerTaxClassification )
    {
        rememberChangedField("CustomerTaxClassification", this.customerTaxClassification);
        this.customerTaxClassification = customerTaxClassification;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CustomerSalesAreaTax";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Customer", getCustomer());
        result.put("SalesOrganization", getSalesOrganization());
        result.put("DistributionChannel", getDistributionChannel());
        result.put("Division", getDivision());
        result.put("DepartureCountry", getDepartureCountry());
        result.put("CustomerTaxCategory", getCustomerTaxCategory());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Customer", getCustomer());
        values.put("SalesOrganization", getSalesOrganization());
        values.put("DistributionChannel", getDistributionChannel());
        values.put("Division", getDivision());
        values.put("DepartureCountry", getDepartureCountry());
        values.put("CustomerTaxCategory", getCustomerTaxCategory());
        values.put("CustomerTaxClassification", getCustomerTaxClassification());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((String) value));
                }
            }
            if( values.containsKey("DistributionChannel") ) {
                final Object value = values.remove("DistributionChannel");
                if( (value == null) || (!value.equals(getDistributionChannel())) ) {
                    setDistributionChannel(((String) value));
                }
            }
            if( values.containsKey("Division") ) {
                final Object value = values.remove("Division");
                if( (value == null) || (!value.equals(getDivision())) ) {
                    setDivision(((String) value));
                }
            }
            if( values.containsKey("DepartureCountry") ) {
                final Object value = values.remove("DepartureCountry");
                if( (value == null) || (!value.equals(getDepartureCountry())) ) {
                    setDepartureCountry(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxCategory") ) {
                final Object value = values.remove("CustomerTaxCategory");
                if( (value == null) || (!value.equals(getCustomerTaxCategory())) ) {
                    setCustomerTaxCategory(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification") ) {
                final Object value = values.remove("CustomerTaxClassification");
                if( (value == null) || (!value.equals(getCustomerTaxClassification())) ) {
                    setCustomerTaxClassification(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SlsAreaAddrDepdntTax") ) {
                final Object value = (values).remove("to_SlsAreaAddrDepdntTax");
                if( value instanceof Iterable ) {
                    if( toSlsAreaAddrDepdntTax == null ) {
                        toSlsAreaAddrDepdntTax = Lists.newArrayList();
                    } else {
                        toSlsAreaAddrDepdntTax = Lists.newArrayList(toSlsAreaAddrDepdntTax);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CustSlsAreaAddrDepdntTaxInfo entity;
                        if( toSlsAreaAddrDepdntTax.size() > i ) {
                            entity = toSlsAreaAddrDepdntTax.get(i);
                        } else {
                            entity = new CustSlsAreaAddrDepdntTaxInfo();
                            toSlsAreaAddrDepdntTax.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CustomerSalesAreaTaxField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CustomerSalesAreaTaxField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CustomerSalesAreaTaxField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CustomerSalesAreaTaxField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessPartnerService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSlsAreaAddrDepdntTax != null ) {
            (values).put("to_SlsAreaAddrDepdntTax", toSlsAreaAddrDepdntTax);
        }
        return values;
    }

    /**
     * Fetches the <b>CustSlsAreaAddrDepdntTaxInfo</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_SlsAreaAddrDepdntTax</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CustSlsAreaAddrDepdntTaxInfo</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustSlsAreaAddrDepdntTaxInfo> fetchSlsAreaAddrDepdntTax()
    {
        return fetchFieldAsList("to_SlsAreaAddrDepdntTax", CustSlsAreaAddrDepdntTaxInfo.class);
    }

    /**
     * Retrieval of associated <b>CustSlsAreaAddrDepdntTaxInfo</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SlsAreaAddrDepdntTax</b>.
     * <p>
     * If the navigation property <b>to_SlsAreaAddrDepdntTax</b> of a queried <b>CustomerSalesAreaTax</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CustSlsAreaAddrDepdntTaxInfo</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CustSlsAreaAddrDepdntTaxInfo> getSlsAreaAddrDepdntTaxOrFetch()
    {
        if( toSlsAreaAddrDepdntTax == null ) {
            toSlsAreaAddrDepdntTax = fetchSlsAreaAddrDepdntTax();
        }
        return toSlsAreaAddrDepdntTax;
    }

    /**
     * Retrieval of associated <b>CustSlsAreaAddrDepdntTaxInfo</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SlsAreaAddrDepdntTax</b>.
     * <p>
     * If the navigation property for an entity <b>CustomerSalesAreaTax</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SlsAreaAddrDepdntTax</b> is already loaded, the result
     *         will contain the <b>CustSlsAreaAddrDepdntTaxInfo</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CustSlsAreaAddrDepdntTaxInfo>> getSlsAreaAddrDepdntTaxIfPresent()
    {
        return Option.of(toSlsAreaAddrDepdntTax);
    }

    /**
     * Overwrites the list of associated <b>CustSlsAreaAddrDepdntTaxInfo</b> entities for the loaded navigation property
     * <b>to_SlsAreaAddrDepdntTax</b>.
     * <p>
     * If the navigation property <b>to_SlsAreaAddrDepdntTax</b> of a queried <b>CustomerSalesAreaTax</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CustSlsAreaAddrDepdntTaxInfo</b> entities.
     */
    public void setSlsAreaAddrDepdntTax( @Nonnull final List<CustSlsAreaAddrDepdntTaxInfo> value )
    {
        if( toSlsAreaAddrDepdntTax == null ) {
            toSlsAreaAddrDepdntTax = Lists.newArrayList();
        }
        toSlsAreaAddrDepdntTax.clear();
        toSlsAreaAddrDepdntTax.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CustSlsAreaAddrDepdntTaxInfo</b> entities. This corresponds to the
     * OData navigation property <b>to_SlsAreaAddrDepdntTax</b>.
     * <p>
     * If the navigation property <b>to_SlsAreaAddrDepdntTax</b> of a queried <b>CustomerSalesAreaTax</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CustSlsAreaAddrDepdntTaxInfo</b> entities.
     */
    public void addSlsAreaAddrDepdntTax( CustSlsAreaAddrDepdntTaxInfo... entity )
    {
        if( toSlsAreaAddrDepdntTax == null ) {
            toSlsAreaAddrDepdntTax = Lists.newArrayList();
        }
        toSlsAreaAddrDepdntTax.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of CustomerSalesAreaTax instances.
     *
     */
    public final static class CustomerSalesAreaTaxBuilder
    {

        private List<CustSlsAreaAddrDepdntTaxInfo> toSlsAreaAddrDepdntTax = Lists.newArrayList();

        private CustomerSalesAreaTax.CustomerSalesAreaTaxBuilder toSlsAreaAddrDepdntTax(
            final List<CustSlsAreaAddrDepdntTaxInfo> value )
        {
            toSlsAreaAddrDepdntTax.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SlsAreaAddrDepdntTax</b> for <b>CustomerSalesAreaTax</b> to multiple
         * <b>CustSlsAreaAddrDepdntTaxInfo</b>.
         *
         * @param value
         *            The CustSlsAreaAddrDepdntTaxInfos to build this CustomerSalesAreaTax with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustomerSalesAreaTax.CustomerSalesAreaTaxBuilder slsAreaAddrDepdntTax(
            CustSlsAreaAddrDepdntTaxInfo... value )
        {
            return toSlsAreaAddrDepdntTax(Lists.newArrayList(value));
        }

    }

}
