/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner;

import java.time.LocalTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.field.CustomerUnloadingPointField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.selectable.CustomerUnloadingPointSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Customer Unloading Point
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CustomerUnloadingPointType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CustomerUnloadingPoint extends VdmEntity<CustomerUnloadingPoint>
{

    /**
     * Selector for all available fields of CustomerUnloadingPoint.
     *
     */
    public final static CustomerUnloadingPointSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Customer Number
     */
    @Key
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static CustomerUnloadingPointField<String> CUSTOMER =
        new CustomerUnloadingPointField<String>("Customer");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>UnloadingPointName</b>
     * </p>
     *
     * @return Unloading Point
     */
    @Key
    @SerializedName( "UnloadingPointName" )
    @JsonProperty( "UnloadingPointName" )
    @Nullable
    @ODataField( odataName = "UnloadingPointName" )
    private String unloadingPointName;
    /**
     * Use with available fluent helpers to apply the <b>UnloadingPointName</b> field to query operations.
     *
     */
    public final static CustomerUnloadingPointField<String> UNLOADING_POINT_NAME =
        new CustomerUnloadingPointField<String>("UnloadingPointName");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerFactoryCalenderCode</b>
     * </p>
     *
     * @return Customer's factory calendar
     */
    @SerializedName( "CustomerFactoryCalenderCode" )
    @JsonProperty( "CustomerFactoryCalenderCode" )
    @Nullable
    @ODataField( odataName = "CustomerFactoryCalenderCode" )
    private String customerFactoryCalenderCode;
    /**
     * Use with available fluent helpers to apply the <b>CustomerFactoryCalenderCode</b> field to query operations.
     *
     */
    public final static CustomerUnloadingPointField<String> CUSTOMER_FACTORY_CALENDER_CODE =
        new CustomerUnloadingPointField<String>("CustomerFactoryCalenderCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPGoodsReceivingHoursCode</b>
     * </p>
     *
     * @return Goods receiving hours ID (default value)
     */
    @SerializedName( "BPGoodsReceivingHoursCode" )
    @JsonProperty( "BPGoodsReceivingHoursCode" )
    @Nullable
    @ODataField( odataName = "BPGoodsReceivingHoursCode" )
    private String bPGoodsReceivingHoursCode;
    /**
     * Use with available fluent helpers to apply the <b>BPGoodsReceivingHoursCode</b> field to query operations.
     *
     */
    public final static CustomerUnloadingPointField<String> BP_GOODS_RECEIVING_HOURS_CODE =
        new CustomerUnloadingPointField<String>("BPGoodsReceivingHoursCode");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDfltBPUnloadingPoint</b>
     * </p>
     *
     * @return Default unloading point
     */
    @SerializedName( "IsDfltBPUnloadingPoint" )
    @JsonProperty( "IsDfltBPUnloadingPoint" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsDfltBPUnloadingPoint" )
    private Boolean isDfltBPUnloadingPoint;
    /**
     * Use with available fluent helpers to apply the <b>IsDfltBPUnloadingPoint</b> field to query operations.
     *
     */
    public final static CustomerUnloadingPointField<Boolean> IS_DFLT_BP_UNLOADING_POINT =
        new CustomerUnloadingPointField<Boolean>("IsDfltBPUnloadingPoint");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MondayMorningOpeningTime</b>
     * </p>
     *
     * @return Goods receipt times: Monday morning from ...
     */
    @SerializedName( "MondayMorningOpeningTime" )
    @JsonProperty( "MondayMorningOpeningTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "MondayMorningOpeningTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime mondayMorningOpeningTime;
    /**
     * Use with available fluent helpers to apply the <b>MondayMorningOpeningTime</b> field to query operations.
     *
     */
    public final static CustomerUnloadingPointField<LocalTime> MONDAY_MORNING_OPENING_TIME =
        new CustomerUnloadingPointField<LocalTime>("MondayMorningOpeningTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MondayMorningClosingTime</b>
     * </p>
     *
     * @return Goods receiving hours: Monday morning until ...
     */
    @SerializedName( "MondayMorningClosingTime" )
    @JsonProperty( "MondayMorningClosingTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "MondayMorningClosingTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime mondayMorningClosingTime;
    /**
     * Use with available fluent helpers to apply the <b>MondayMorningClosingTime</b> field to query operations.
     *
     */
    public final static CustomerUnloadingPointField<LocalTime> MONDAY_MORNING_CLOSING_TIME =
        new CustomerUnloadingPointField<LocalTime>("MondayMorningClosingTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MondayAfternoonOpeningTime</b>
     * </p>
     *
     * @return Goods receiving hours: Monday afternoon from ...
     */
    @SerializedName( "MondayAfternoonOpeningTime" )
    @JsonProperty( "MondayAfternoonOpeningTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "MondayAfternoonOpeningTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime mondayAfternoonOpeningTime;
    /**
     * Use with available fluent helpers to apply the <b>MondayAfternoonOpeningTime</b> field to query operations.
     *
     */
    public final static CustomerUnloadingPointField<LocalTime> MONDAY_AFTERNOON_OPENING_TIME =
        new CustomerUnloadingPointField<LocalTime>("MondayAfternoonOpeningTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MondayAfternoonClosingTime</b>
     * </p>
     *
     * @return Goods receiving hours: Monday afternoon until ...
     */
    @SerializedName( "MondayAfternoonClosingTime" )
    @JsonProperty( "MondayAfternoonClosingTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "MondayAfternoonClosingTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime mondayAfternoonClosingTime;
    /**
     * Use with available fluent helpers to apply the <b>MondayAfternoonClosingTime</b> field to query operations.
     *
     */
    public final static CustomerUnloadingPointField<LocalTime> MONDAY_AFTERNOON_CLOSING_TIME =
        new CustomerUnloadingPointField<LocalTime>("MondayAfternoonClosingTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TuesdayMorningOpeningTime</b>
     * </p>
     *
     * @return Goods receiving hours: Tuesday morning from...
     */
    @SerializedName( "TuesdayMorningOpeningTime" )
    @JsonProperty( "TuesdayMorningOpeningTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "TuesdayMorningOpeningTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime tuesdayMorningOpeningTime;
    /**
     * Use with available fluent helpers to apply the <b>TuesdayMorningOpeningTime</b> field to query operations.
     *
     */
    public final static CustomerUnloadingPointField<LocalTime> TUESDAY_MORNING_OPENING_TIME =
        new CustomerUnloadingPointField<LocalTime>("TuesdayMorningOpeningTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TuesdayMorningClosingTime</b>
     * </p>
     *
     * @return Goods receipt times: Tuesday morning until ...
     */
    @SerializedName( "TuesdayMorningClosingTime" )
    @JsonProperty( "TuesdayMorningClosingTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "TuesdayMorningClosingTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime tuesdayMorningClosingTime;
    /**
     * Use with available fluent helpers to apply the <b>TuesdayMorningClosingTime</b> field to query operations.
     *
     */
    public final static CustomerUnloadingPointField<LocalTime> TUESDAY_MORNING_CLOSING_TIME =
        new CustomerUnloadingPointField<LocalTime>("TuesdayMorningClosingTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TuesdayAfternoonOpeningTime</b>
     * </p>
     *
     * @return Goods receiving hours: Tuesday afternoon from ...
     */
    @SerializedName( "TuesdayAfternoonOpeningTime" )
    @JsonProperty( "TuesdayAfternoonOpeningTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "TuesdayAfternoonOpeningTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime tuesdayAfternoonOpeningTime;
    /**
     * Use with available fluent helpers to apply the <b>TuesdayAfternoonOpeningTime</b> field to query operations.
     *
     */
    public final static CustomerUnloadingPointField<LocalTime> TUESDAY_AFTERNOON_OPENING_TIME =
        new CustomerUnloadingPointField<LocalTime>("TuesdayAfternoonOpeningTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TuesdayAfternoonClosingTime</b>
     * </p>
     *
     * @return Goods receiving hours: Tuesday afternoon until ...
     */
    @SerializedName( "TuesdayAfternoonClosingTime" )
    @JsonProperty( "TuesdayAfternoonClosingTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "TuesdayAfternoonClosingTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime tuesdayAfternoonClosingTime;
    /**
     * Use with available fluent helpers to apply the <b>TuesdayAfternoonClosingTime</b> field to query operations.
     *
     */
    public final static CustomerUnloadingPointField<LocalTime> TUESDAY_AFTERNOON_CLOSING_TIME =
        new CustomerUnloadingPointField<LocalTime>("TuesdayAfternoonClosingTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>WednesdayMorningOpeningTime</b>
     * </p>
     *
     * @return Goods receiving hours: Wednesday morning from ...
     */
    @SerializedName( "WednesdayMorningOpeningTime" )
    @JsonProperty( "WednesdayMorningOpeningTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "WednesdayMorningOpeningTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime wednesdayMorningOpeningTime;
    /**
     * Use with available fluent helpers to apply the <b>WednesdayMorningOpeningTime</b> field to query operations.
     *
     */
    public final static CustomerUnloadingPointField<LocalTime> WEDNESDAY_MORNING_OPENING_TIME =
        new CustomerUnloadingPointField<LocalTime>("WednesdayMorningOpeningTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>WednesdayMorningClosingTime</b>
     * </p>
     *
     * @return Goods receiving hours: Wednesday morning until ...
     */
    @SerializedName( "WednesdayMorningClosingTime" )
    @JsonProperty( "WednesdayMorningClosingTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "WednesdayMorningClosingTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime wednesdayMorningClosingTime;
    /**
     * Use with available fluent helpers to apply the <b>WednesdayMorningClosingTime</b> field to query operations.
     *
     */
    public final static CustomerUnloadingPointField<LocalTime> WEDNESDAY_MORNING_CLOSING_TIME =
        new CustomerUnloadingPointField<LocalTime>("WednesdayMorningClosingTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>WednesdayAfternoonOpeningTime</b>
     * </p>
     *
     * @return Goods receiving hours: Wednesday afternoon from ...
     */
    @SerializedName( "WednesdayAfternoonOpeningTime" )
    @JsonProperty( "WednesdayAfternoonOpeningTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "WednesdayAfternoonOpeningTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime wednesdayAfternoonOpeningTime;
    /**
     * Use with available fluent helpers to apply the <b>WednesdayAfternoonOpeningTime</b> field to query operations.
     *
     */
    public final static CustomerUnloadingPointField<LocalTime> WEDNESDAY_AFTERNOON_OPENING_TIME =
        new CustomerUnloadingPointField<LocalTime>("WednesdayAfternoonOpeningTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>WednesdayAfternoonClosingTime</b>
     * </p>
     *
     * @return Goods receiving hours: Wednesday afternoon until ...
     */
    @SerializedName( "WednesdayAfternoonClosingTime" )
    @JsonProperty( "WednesdayAfternoonClosingTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "WednesdayAfternoonClosingTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime wednesdayAfternoonClosingTime;
    /**
     * Use with available fluent helpers to apply the <b>WednesdayAfternoonClosingTime</b> field to query operations.
     *
     */
    public final static CustomerUnloadingPointField<LocalTime> WEDNESDAY_AFTERNOON_CLOSING_TIME =
        new CustomerUnloadingPointField<LocalTime>("WednesdayAfternoonClosingTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ThursdayMorningOpeningTime</b>
     * </p>
     *
     * @return Goods receiving hours: Thursday morning from ...
     */
    @SerializedName( "ThursdayMorningOpeningTime" )
    @JsonProperty( "ThursdayMorningOpeningTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ThursdayMorningOpeningTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime thursdayMorningOpeningTime;
    /**
     * Use with available fluent helpers to apply the <b>ThursdayMorningOpeningTime</b> field to query operations.
     *
     */
    public final static CustomerUnloadingPointField<LocalTime> THURSDAY_MORNING_OPENING_TIME =
        new CustomerUnloadingPointField<LocalTime>("ThursdayMorningOpeningTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ThursdayMorningClosingTime</b>
     * </p>
     *
     * @return Goods receiving hours: Thursday morning until ...
     */
    @SerializedName( "ThursdayMorningClosingTime" )
    @JsonProperty( "ThursdayMorningClosingTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ThursdayMorningClosingTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime thursdayMorningClosingTime;
    /**
     * Use with available fluent helpers to apply the <b>ThursdayMorningClosingTime</b> field to query operations.
     *
     */
    public final static CustomerUnloadingPointField<LocalTime> THURSDAY_MORNING_CLOSING_TIME =
        new CustomerUnloadingPointField<LocalTime>("ThursdayMorningClosingTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ThursdayAfternoonOpeningTime</b>
     * </p>
     *
     * @return Goods receiving hours: Thursday afternoon from ...
     */
    @SerializedName( "ThursdayAfternoonOpeningTime" )
    @JsonProperty( "ThursdayAfternoonOpeningTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ThursdayAfternoonOpeningTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime thursdayAfternoonOpeningTime;
    /**
     * Use with available fluent helpers to apply the <b>ThursdayAfternoonOpeningTime</b> field to query operations.
     *
     */
    public final static CustomerUnloadingPointField<LocalTime> THURSDAY_AFTERNOON_OPENING_TIME =
        new CustomerUnloadingPointField<LocalTime>("ThursdayAfternoonOpeningTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ThursdayAfternoonClosingTime</b>
     * </p>
     *
     * @return Goods receiving hours: Thursday afternoon until...
     */
    @SerializedName( "ThursdayAfternoonClosingTime" )
    @JsonProperty( "ThursdayAfternoonClosingTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ThursdayAfternoonClosingTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime thursdayAfternoonClosingTime;
    /**
     * Use with available fluent helpers to apply the <b>ThursdayAfternoonClosingTime</b> field to query operations.
     *
     */
    public final static CustomerUnloadingPointField<LocalTime> THURSDAY_AFTERNOON_CLOSING_TIME =
        new CustomerUnloadingPointField<LocalTime>("ThursdayAfternoonClosingTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FridayMorningOpeningTime</b>
     * </p>
     *
     * @return Goods receiving hours: Friday morning from ...
     */
    @SerializedName( "FridayMorningOpeningTime" )
    @JsonProperty( "FridayMorningOpeningTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "FridayMorningOpeningTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime fridayMorningOpeningTime;
    /**
     * Use with available fluent helpers to apply the <b>FridayMorningOpeningTime</b> field to query operations.
     *
     */
    public final static CustomerUnloadingPointField<LocalTime> FRIDAY_MORNING_OPENING_TIME =
        new CustomerUnloadingPointField<LocalTime>("FridayMorningOpeningTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FridayMorningClosingTime</b>
     * </p>
     *
     * @return Goods receiving hours: Friday morning until ...
     */
    @SerializedName( "FridayMorningClosingTime" )
    @JsonProperty( "FridayMorningClosingTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "FridayMorningClosingTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime fridayMorningClosingTime;
    /**
     * Use with available fluent helpers to apply the <b>FridayMorningClosingTime</b> field to query operations.
     *
     */
    public final static CustomerUnloadingPointField<LocalTime> FRIDAY_MORNING_CLOSING_TIME =
        new CustomerUnloadingPointField<LocalTime>("FridayMorningClosingTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FridayAfternoonOpeningTime</b>
     * </p>
     *
     * @return Goods receiving hours: Friday afternoon from ...
     */
    @SerializedName( "FridayAfternoonOpeningTime" )
    @JsonProperty( "FridayAfternoonOpeningTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "FridayAfternoonOpeningTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime fridayAfternoonOpeningTime;
    /**
     * Use with available fluent helpers to apply the <b>FridayAfternoonOpeningTime</b> field to query operations.
     *
     */
    public final static CustomerUnloadingPointField<LocalTime> FRIDAY_AFTERNOON_OPENING_TIME =
        new CustomerUnloadingPointField<LocalTime>("FridayAfternoonOpeningTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FridayAfternoonClosingTime</b>
     * </p>
     *
     * @return Goods receiving hours: Friday afternoon until ...
     */
    @SerializedName( "FridayAfternoonClosingTime" )
    @JsonProperty( "FridayAfternoonClosingTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "FridayAfternoonClosingTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime fridayAfternoonClosingTime;
    /**
     * Use with available fluent helpers to apply the <b>FridayAfternoonClosingTime</b> field to query operations.
     *
     */
    public final static CustomerUnloadingPointField<LocalTime> FRIDAY_AFTERNOON_CLOSING_TIME =
        new CustomerUnloadingPointField<LocalTime>("FridayAfternoonClosingTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SaturdayMorningOpeningTime</b>
     * </p>
     *
     * @return Goods receiving hours: Saturday morning from ...
     */
    @SerializedName( "SaturdayMorningOpeningTime" )
    @JsonProperty( "SaturdayMorningOpeningTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "SaturdayMorningOpeningTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime saturdayMorningOpeningTime;
    /**
     * Use with available fluent helpers to apply the <b>SaturdayMorningOpeningTime</b> field to query operations.
     *
     */
    public final static CustomerUnloadingPointField<LocalTime> SATURDAY_MORNING_OPENING_TIME =
        new CustomerUnloadingPointField<LocalTime>("SaturdayMorningOpeningTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SaturdayMorningClosingTime</b>
     * </p>
     *
     * @return Goods receiving hours: Saturday morning from ...
     */
    @SerializedName( "SaturdayMorningClosingTime" )
    @JsonProperty( "SaturdayMorningClosingTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "SaturdayMorningClosingTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime saturdayMorningClosingTime;
    /**
     * Use with available fluent helpers to apply the <b>SaturdayMorningClosingTime</b> field to query operations.
     *
     */
    public final static CustomerUnloadingPointField<LocalTime> SATURDAY_MORNING_CLOSING_TIME =
        new CustomerUnloadingPointField<LocalTime>("SaturdayMorningClosingTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SaturdayAfternoonOpeningTime</b>
     * </p>
     *
     * @return Goods receiving hours: Saturday afternoon from ...
     */
    @SerializedName( "SaturdayAfternoonOpeningTime" )
    @JsonProperty( "SaturdayAfternoonOpeningTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "SaturdayAfternoonOpeningTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime saturdayAfternoonOpeningTime;
    /**
     * Use with available fluent helpers to apply the <b>SaturdayAfternoonOpeningTime</b> field to query operations.
     *
     */
    public final static CustomerUnloadingPointField<LocalTime> SATURDAY_AFTERNOON_OPENING_TIME =
        new CustomerUnloadingPointField<LocalTime>("SaturdayAfternoonOpeningTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SaturdayAfternoonClosingTime</b>
     * </p>
     *
     * @return Goods receiving hours: Saturday afternoon until ...
     */
    @SerializedName( "SaturdayAfternoonClosingTime" )
    @JsonProperty( "SaturdayAfternoonClosingTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "SaturdayAfternoonClosingTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime saturdayAfternoonClosingTime;
    /**
     * Use with available fluent helpers to apply the <b>SaturdayAfternoonClosingTime</b> field to query operations.
     *
     */
    public final static CustomerUnloadingPointField<LocalTime> SATURDAY_AFTERNOON_CLOSING_TIME =
        new CustomerUnloadingPointField<LocalTime>("SaturdayAfternoonClosingTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SundayMorningOpeningTime</b>
     * </p>
     *
     * @return Goods receiving hours: Sunday morning from ...
     */
    @SerializedName( "SundayMorningOpeningTime" )
    @JsonProperty( "SundayMorningOpeningTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "SundayMorningOpeningTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime sundayMorningOpeningTime;
    /**
     * Use with available fluent helpers to apply the <b>SundayMorningOpeningTime</b> field to query operations.
     *
     */
    public final static CustomerUnloadingPointField<LocalTime> SUNDAY_MORNING_OPENING_TIME =
        new CustomerUnloadingPointField<LocalTime>("SundayMorningOpeningTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SundayMorningClosingTime</b>
     * </p>
     *
     * @return Goods receiving hours: Sunday morning until ...
     */
    @SerializedName( "SundayMorningClosingTime" )
    @JsonProperty( "SundayMorningClosingTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "SundayMorningClosingTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime sundayMorningClosingTime;
    /**
     * Use with available fluent helpers to apply the <b>SundayMorningClosingTime</b> field to query operations.
     *
     */
    public final static CustomerUnloadingPointField<LocalTime> SUNDAY_MORNING_CLOSING_TIME =
        new CustomerUnloadingPointField<LocalTime>("SundayMorningClosingTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SundayAfternoonOpeningTime</b>
     * </p>
     *
     * @return Goods receiving hours: Sunday afternoon from ...
     */
    @SerializedName( "SundayAfternoonOpeningTime" )
    @JsonProperty( "SundayAfternoonOpeningTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "SundayAfternoonOpeningTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime sundayAfternoonOpeningTime;
    /**
     * Use with available fluent helpers to apply the <b>SundayAfternoonOpeningTime</b> field to query operations.
     *
     */
    public final static CustomerUnloadingPointField<LocalTime> SUNDAY_AFTERNOON_OPENING_TIME =
        new CustomerUnloadingPointField<LocalTime>("SundayAfternoonOpeningTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SundayAfternoonClosingTime</b>
     * </p>
     *
     * @return Goods receiving hours: Sunday afternoon until ...
     */
    @SerializedName( "SundayAfternoonClosingTime" )
    @JsonProperty( "SundayAfternoonClosingTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "SundayAfternoonClosingTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime sundayAfternoonClosingTime;
    /**
     * Use with available fluent helpers to apply the <b>SundayAfternoonClosingTime</b> field to query operations.
     *
     */
    public final static CustomerUnloadingPointField<LocalTime> SUNDAY_AFTERNOON_CLOSING_TIME =
        new CustomerUnloadingPointField<LocalTime>("SundayAfternoonClosingTime");

    @Nonnull
    @Override
    public Class<CustomerUnloadingPoint> getType()
    {
        return CustomerUnloadingPoint.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Customer Number
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>UnloadingPointName</b>
     * </p>
     *
     * @param unloadingPointName
     *            Unloading Point
     */
    public void setUnloadingPointName( @Nullable final String unloadingPointName )
    {
        rememberChangedField("UnloadingPointName", this.unloadingPointName);
        this.unloadingPointName = unloadingPointName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerFactoryCalenderCode</b>
     * </p>
     *
     * @param customerFactoryCalenderCode
     *            Customer's factory calendar
     */
    public void setCustomerFactoryCalenderCode( @Nullable final String customerFactoryCalenderCode )
    {
        rememberChangedField("CustomerFactoryCalenderCode", this.customerFactoryCalenderCode);
        this.customerFactoryCalenderCode = customerFactoryCalenderCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BPGoodsReceivingHoursCode</b>
     * </p>
     *
     * @param bPGoodsReceivingHoursCode
     *            Goods receiving hours ID (default value)
     */
    public void setBPGoodsReceivingHoursCode( @Nullable final String bPGoodsReceivingHoursCode )
    {
        rememberChangedField("BPGoodsReceivingHoursCode", this.bPGoodsReceivingHoursCode);
        this.bPGoodsReceivingHoursCode = bPGoodsReceivingHoursCode;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDfltBPUnloadingPoint</b>
     * </p>
     *
     * @param isDfltBPUnloadingPoint
     *            Default unloading point
     */
    public void setIsDfltBPUnloadingPoint( @Nullable final Boolean isDfltBPUnloadingPoint )
    {
        rememberChangedField("IsDfltBPUnloadingPoint", this.isDfltBPUnloadingPoint);
        this.isDfltBPUnloadingPoint = isDfltBPUnloadingPoint;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MondayMorningOpeningTime</b>
     * </p>
     *
     * @param mondayMorningOpeningTime
     *            Goods receipt times: Monday morning from ...
     */
    public void setMondayMorningOpeningTime( @Nullable final LocalTime mondayMorningOpeningTime )
    {
        rememberChangedField("MondayMorningOpeningTime", this.mondayMorningOpeningTime);
        this.mondayMorningOpeningTime = mondayMorningOpeningTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MondayMorningClosingTime</b>
     * </p>
     *
     * @param mondayMorningClosingTime
     *            Goods receiving hours: Monday morning until ...
     */
    public void setMondayMorningClosingTime( @Nullable final LocalTime mondayMorningClosingTime )
    {
        rememberChangedField("MondayMorningClosingTime", this.mondayMorningClosingTime);
        this.mondayMorningClosingTime = mondayMorningClosingTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MondayAfternoonOpeningTime</b>
     * </p>
     *
     * @param mondayAfternoonOpeningTime
     *            Goods receiving hours: Monday afternoon from ...
     */
    public void setMondayAfternoonOpeningTime( @Nullable final LocalTime mondayAfternoonOpeningTime )
    {
        rememberChangedField("MondayAfternoonOpeningTime", this.mondayAfternoonOpeningTime);
        this.mondayAfternoonOpeningTime = mondayAfternoonOpeningTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MondayAfternoonClosingTime</b>
     * </p>
     *
     * @param mondayAfternoonClosingTime
     *            Goods receiving hours: Monday afternoon until ...
     */
    public void setMondayAfternoonClosingTime( @Nullable final LocalTime mondayAfternoonClosingTime )
    {
        rememberChangedField("MondayAfternoonClosingTime", this.mondayAfternoonClosingTime);
        this.mondayAfternoonClosingTime = mondayAfternoonClosingTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TuesdayMorningOpeningTime</b>
     * </p>
     *
     * @param tuesdayMorningOpeningTime
     *            Goods receiving hours: Tuesday morning from...
     */
    public void setTuesdayMorningOpeningTime( @Nullable final LocalTime tuesdayMorningOpeningTime )
    {
        rememberChangedField("TuesdayMorningOpeningTime", this.tuesdayMorningOpeningTime);
        this.tuesdayMorningOpeningTime = tuesdayMorningOpeningTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TuesdayMorningClosingTime</b>
     * </p>
     *
     * @param tuesdayMorningClosingTime
     *            Goods receipt times: Tuesday morning until ...
     */
    public void setTuesdayMorningClosingTime( @Nullable final LocalTime tuesdayMorningClosingTime )
    {
        rememberChangedField("TuesdayMorningClosingTime", this.tuesdayMorningClosingTime);
        this.tuesdayMorningClosingTime = tuesdayMorningClosingTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TuesdayAfternoonOpeningTime</b>
     * </p>
     *
     * @param tuesdayAfternoonOpeningTime
     *            Goods receiving hours: Tuesday afternoon from ...
     */
    public void setTuesdayAfternoonOpeningTime( @Nullable final LocalTime tuesdayAfternoonOpeningTime )
    {
        rememberChangedField("TuesdayAfternoonOpeningTime", this.tuesdayAfternoonOpeningTime);
        this.tuesdayAfternoonOpeningTime = tuesdayAfternoonOpeningTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TuesdayAfternoonClosingTime</b>
     * </p>
     *
     * @param tuesdayAfternoonClosingTime
     *            Goods receiving hours: Tuesday afternoon until ...
     */
    public void setTuesdayAfternoonClosingTime( @Nullable final LocalTime tuesdayAfternoonClosingTime )
    {
        rememberChangedField("TuesdayAfternoonClosingTime", this.tuesdayAfternoonClosingTime);
        this.tuesdayAfternoonClosingTime = tuesdayAfternoonClosingTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>WednesdayMorningOpeningTime</b>
     * </p>
     *
     * @param wednesdayMorningOpeningTime
     *            Goods receiving hours: Wednesday morning from ...
     */
    public void setWednesdayMorningOpeningTime( @Nullable final LocalTime wednesdayMorningOpeningTime )
    {
        rememberChangedField("WednesdayMorningOpeningTime", this.wednesdayMorningOpeningTime);
        this.wednesdayMorningOpeningTime = wednesdayMorningOpeningTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>WednesdayMorningClosingTime</b>
     * </p>
     *
     * @param wednesdayMorningClosingTime
     *            Goods receiving hours: Wednesday morning until ...
     */
    public void setWednesdayMorningClosingTime( @Nullable final LocalTime wednesdayMorningClosingTime )
    {
        rememberChangedField("WednesdayMorningClosingTime", this.wednesdayMorningClosingTime);
        this.wednesdayMorningClosingTime = wednesdayMorningClosingTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>WednesdayAfternoonOpeningTime</b>
     * </p>
     *
     * @param wednesdayAfternoonOpeningTime
     *            Goods receiving hours: Wednesday afternoon from ...
     */
    public void setWednesdayAfternoonOpeningTime( @Nullable final LocalTime wednesdayAfternoonOpeningTime )
    {
        rememberChangedField("WednesdayAfternoonOpeningTime", this.wednesdayAfternoonOpeningTime);
        this.wednesdayAfternoonOpeningTime = wednesdayAfternoonOpeningTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>WednesdayAfternoonClosingTime</b>
     * </p>
     *
     * @param wednesdayAfternoonClosingTime
     *            Goods receiving hours: Wednesday afternoon until ...
     */
    public void setWednesdayAfternoonClosingTime( @Nullable final LocalTime wednesdayAfternoonClosingTime )
    {
        rememberChangedField("WednesdayAfternoonClosingTime", this.wednesdayAfternoonClosingTime);
        this.wednesdayAfternoonClosingTime = wednesdayAfternoonClosingTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ThursdayMorningOpeningTime</b>
     * </p>
     *
     * @param thursdayMorningOpeningTime
     *            Goods receiving hours: Thursday morning from ...
     */
    public void setThursdayMorningOpeningTime( @Nullable final LocalTime thursdayMorningOpeningTime )
    {
        rememberChangedField("ThursdayMorningOpeningTime", this.thursdayMorningOpeningTime);
        this.thursdayMorningOpeningTime = thursdayMorningOpeningTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ThursdayMorningClosingTime</b>
     * </p>
     *
     * @param thursdayMorningClosingTime
     *            Goods receiving hours: Thursday morning until ...
     */
    public void setThursdayMorningClosingTime( @Nullable final LocalTime thursdayMorningClosingTime )
    {
        rememberChangedField("ThursdayMorningClosingTime", this.thursdayMorningClosingTime);
        this.thursdayMorningClosingTime = thursdayMorningClosingTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ThursdayAfternoonOpeningTime</b>
     * </p>
     *
     * @param thursdayAfternoonOpeningTime
     *            Goods receiving hours: Thursday afternoon from ...
     */
    public void setThursdayAfternoonOpeningTime( @Nullable final LocalTime thursdayAfternoonOpeningTime )
    {
        rememberChangedField("ThursdayAfternoonOpeningTime", this.thursdayAfternoonOpeningTime);
        this.thursdayAfternoonOpeningTime = thursdayAfternoonOpeningTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ThursdayAfternoonClosingTime</b>
     * </p>
     *
     * @param thursdayAfternoonClosingTime
     *            Goods receiving hours: Thursday afternoon until...
     */
    public void setThursdayAfternoonClosingTime( @Nullable final LocalTime thursdayAfternoonClosingTime )
    {
        rememberChangedField("ThursdayAfternoonClosingTime", this.thursdayAfternoonClosingTime);
        this.thursdayAfternoonClosingTime = thursdayAfternoonClosingTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FridayMorningOpeningTime</b>
     * </p>
     *
     * @param fridayMorningOpeningTime
     *            Goods receiving hours: Friday morning from ...
     */
    public void setFridayMorningOpeningTime( @Nullable final LocalTime fridayMorningOpeningTime )
    {
        rememberChangedField("FridayMorningOpeningTime", this.fridayMorningOpeningTime);
        this.fridayMorningOpeningTime = fridayMorningOpeningTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FridayMorningClosingTime</b>
     * </p>
     *
     * @param fridayMorningClosingTime
     *            Goods receiving hours: Friday morning until ...
     */
    public void setFridayMorningClosingTime( @Nullable final LocalTime fridayMorningClosingTime )
    {
        rememberChangedField("FridayMorningClosingTime", this.fridayMorningClosingTime);
        this.fridayMorningClosingTime = fridayMorningClosingTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FridayAfternoonOpeningTime</b>
     * </p>
     *
     * @param fridayAfternoonOpeningTime
     *            Goods receiving hours: Friday afternoon from ...
     */
    public void setFridayAfternoonOpeningTime( @Nullable final LocalTime fridayAfternoonOpeningTime )
    {
        rememberChangedField("FridayAfternoonOpeningTime", this.fridayAfternoonOpeningTime);
        this.fridayAfternoonOpeningTime = fridayAfternoonOpeningTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FridayAfternoonClosingTime</b>
     * </p>
     *
     * @param fridayAfternoonClosingTime
     *            Goods receiving hours: Friday afternoon until ...
     */
    public void setFridayAfternoonClosingTime( @Nullable final LocalTime fridayAfternoonClosingTime )
    {
        rememberChangedField("FridayAfternoonClosingTime", this.fridayAfternoonClosingTime);
        this.fridayAfternoonClosingTime = fridayAfternoonClosingTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SaturdayMorningOpeningTime</b>
     * </p>
     *
     * @param saturdayMorningOpeningTime
     *            Goods receiving hours: Saturday morning from ...
     */
    public void setSaturdayMorningOpeningTime( @Nullable final LocalTime saturdayMorningOpeningTime )
    {
        rememberChangedField("SaturdayMorningOpeningTime", this.saturdayMorningOpeningTime);
        this.saturdayMorningOpeningTime = saturdayMorningOpeningTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SaturdayMorningClosingTime</b>
     * </p>
     *
     * @param saturdayMorningClosingTime
     *            Goods receiving hours: Saturday morning from ...
     */
    public void setSaturdayMorningClosingTime( @Nullable final LocalTime saturdayMorningClosingTime )
    {
        rememberChangedField("SaturdayMorningClosingTime", this.saturdayMorningClosingTime);
        this.saturdayMorningClosingTime = saturdayMorningClosingTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SaturdayAfternoonOpeningTime</b>
     * </p>
     *
     * @param saturdayAfternoonOpeningTime
     *            Goods receiving hours: Saturday afternoon from ...
     */
    public void setSaturdayAfternoonOpeningTime( @Nullable final LocalTime saturdayAfternoonOpeningTime )
    {
        rememberChangedField("SaturdayAfternoonOpeningTime", this.saturdayAfternoonOpeningTime);
        this.saturdayAfternoonOpeningTime = saturdayAfternoonOpeningTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SaturdayAfternoonClosingTime</b>
     * </p>
     *
     * @param saturdayAfternoonClosingTime
     *            Goods receiving hours: Saturday afternoon until ...
     */
    public void setSaturdayAfternoonClosingTime( @Nullable final LocalTime saturdayAfternoonClosingTime )
    {
        rememberChangedField("SaturdayAfternoonClosingTime", this.saturdayAfternoonClosingTime);
        this.saturdayAfternoonClosingTime = saturdayAfternoonClosingTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SundayMorningOpeningTime</b>
     * </p>
     *
     * @param sundayMorningOpeningTime
     *            Goods receiving hours: Sunday morning from ...
     */
    public void setSundayMorningOpeningTime( @Nullable final LocalTime sundayMorningOpeningTime )
    {
        rememberChangedField("SundayMorningOpeningTime", this.sundayMorningOpeningTime);
        this.sundayMorningOpeningTime = sundayMorningOpeningTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SundayMorningClosingTime</b>
     * </p>
     *
     * @param sundayMorningClosingTime
     *            Goods receiving hours: Sunday morning until ...
     */
    public void setSundayMorningClosingTime( @Nullable final LocalTime sundayMorningClosingTime )
    {
        rememberChangedField("SundayMorningClosingTime", this.sundayMorningClosingTime);
        this.sundayMorningClosingTime = sundayMorningClosingTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SundayAfternoonOpeningTime</b>
     * </p>
     *
     * @param sundayAfternoonOpeningTime
     *            Goods receiving hours: Sunday afternoon from ...
     */
    public void setSundayAfternoonOpeningTime( @Nullable final LocalTime sundayAfternoonOpeningTime )
    {
        rememberChangedField("SundayAfternoonOpeningTime", this.sundayAfternoonOpeningTime);
        this.sundayAfternoonOpeningTime = sundayAfternoonOpeningTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SundayAfternoonClosingTime</b>
     * </p>
     *
     * @param sundayAfternoonClosingTime
     *            Goods receiving hours: Sunday afternoon until ...
     */
    public void setSundayAfternoonClosingTime( @Nullable final LocalTime sundayAfternoonClosingTime )
    {
        rememberChangedField("SundayAfternoonClosingTime", this.sundayAfternoonClosingTime);
        this.sundayAfternoonClosingTime = sundayAfternoonClosingTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CustomerUnloadingPoint";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Customer", getCustomer());
        result.put("UnloadingPointName", getUnloadingPointName());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Customer", getCustomer());
        values.put("UnloadingPointName", getUnloadingPointName());
        values.put("CustomerFactoryCalenderCode", getCustomerFactoryCalenderCode());
        values.put("BPGoodsReceivingHoursCode", getBPGoodsReceivingHoursCode());
        values.put("IsDfltBPUnloadingPoint", getIsDfltBPUnloadingPoint());
        values.put("MondayMorningOpeningTime", getMondayMorningOpeningTime());
        values.put("MondayMorningClosingTime", getMondayMorningClosingTime());
        values.put("MondayAfternoonOpeningTime", getMondayAfternoonOpeningTime());
        values.put("MondayAfternoonClosingTime", getMondayAfternoonClosingTime());
        values.put("TuesdayMorningOpeningTime", getTuesdayMorningOpeningTime());
        values.put("TuesdayMorningClosingTime", getTuesdayMorningClosingTime());
        values.put("TuesdayAfternoonOpeningTime", getTuesdayAfternoonOpeningTime());
        values.put("TuesdayAfternoonClosingTime", getTuesdayAfternoonClosingTime());
        values.put("WednesdayMorningOpeningTime", getWednesdayMorningOpeningTime());
        values.put("WednesdayMorningClosingTime", getWednesdayMorningClosingTime());
        values.put("WednesdayAfternoonOpeningTime", getWednesdayAfternoonOpeningTime());
        values.put("WednesdayAfternoonClosingTime", getWednesdayAfternoonClosingTime());
        values.put("ThursdayMorningOpeningTime", getThursdayMorningOpeningTime());
        values.put("ThursdayMorningClosingTime", getThursdayMorningClosingTime());
        values.put("ThursdayAfternoonOpeningTime", getThursdayAfternoonOpeningTime());
        values.put("ThursdayAfternoonClosingTime", getThursdayAfternoonClosingTime());
        values.put("FridayMorningOpeningTime", getFridayMorningOpeningTime());
        values.put("FridayMorningClosingTime", getFridayMorningClosingTime());
        values.put("FridayAfternoonOpeningTime", getFridayAfternoonOpeningTime());
        values.put("FridayAfternoonClosingTime", getFridayAfternoonClosingTime());
        values.put("SaturdayMorningOpeningTime", getSaturdayMorningOpeningTime());
        values.put("SaturdayMorningClosingTime", getSaturdayMorningClosingTime());
        values.put("SaturdayAfternoonOpeningTime", getSaturdayAfternoonOpeningTime());
        values.put("SaturdayAfternoonClosingTime", getSaturdayAfternoonClosingTime());
        values.put("SundayMorningOpeningTime", getSundayMorningOpeningTime());
        values.put("SundayMorningClosingTime", getSundayMorningClosingTime());
        values.put("SundayAfternoonOpeningTime", getSundayAfternoonOpeningTime());
        values.put("SundayAfternoonClosingTime", getSundayAfternoonClosingTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("UnloadingPointName") ) {
                final Object value = values.remove("UnloadingPointName");
                if( (value == null) || (!value.equals(getUnloadingPointName())) ) {
                    setUnloadingPointName(((String) value));
                }
            }
            if( values.containsKey("CustomerFactoryCalenderCode") ) {
                final Object value = values.remove("CustomerFactoryCalenderCode");
                if( (value == null) || (!value.equals(getCustomerFactoryCalenderCode())) ) {
                    setCustomerFactoryCalenderCode(((String) value));
                }
            }
            if( values.containsKey("BPGoodsReceivingHoursCode") ) {
                final Object value = values.remove("BPGoodsReceivingHoursCode");
                if( (value == null) || (!value.equals(getBPGoodsReceivingHoursCode())) ) {
                    setBPGoodsReceivingHoursCode(((String) value));
                }
            }
            if( values.containsKey("IsDfltBPUnloadingPoint") ) {
                final Object value = values.remove("IsDfltBPUnloadingPoint");
                if( (value == null) || (!value.equals(getIsDfltBPUnloadingPoint())) ) {
                    setIsDfltBPUnloadingPoint(((Boolean) value));
                }
            }
            if( values.containsKey("MondayMorningOpeningTime") ) {
                final Object value = values.remove("MondayMorningOpeningTime");
                if( (value == null) || (!value.equals(getMondayMorningOpeningTime())) ) {
                    setMondayMorningOpeningTime(((LocalTime) value));
                }
            }
            if( values.containsKey("MondayMorningClosingTime") ) {
                final Object value = values.remove("MondayMorningClosingTime");
                if( (value == null) || (!value.equals(getMondayMorningClosingTime())) ) {
                    setMondayMorningClosingTime(((LocalTime) value));
                }
            }
            if( values.containsKey("MondayAfternoonOpeningTime") ) {
                final Object value = values.remove("MondayAfternoonOpeningTime");
                if( (value == null) || (!value.equals(getMondayAfternoonOpeningTime())) ) {
                    setMondayAfternoonOpeningTime(((LocalTime) value));
                }
            }
            if( values.containsKey("MondayAfternoonClosingTime") ) {
                final Object value = values.remove("MondayAfternoonClosingTime");
                if( (value == null) || (!value.equals(getMondayAfternoonClosingTime())) ) {
                    setMondayAfternoonClosingTime(((LocalTime) value));
                }
            }
            if( values.containsKey("TuesdayMorningOpeningTime") ) {
                final Object value = values.remove("TuesdayMorningOpeningTime");
                if( (value == null) || (!value.equals(getTuesdayMorningOpeningTime())) ) {
                    setTuesdayMorningOpeningTime(((LocalTime) value));
                }
            }
            if( values.containsKey("TuesdayMorningClosingTime") ) {
                final Object value = values.remove("TuesdayMorningClosingTime");
                if( (value == null) || (!value.equals(getTuesdayMorningClosingTime())) ) {
                    setTuesdayMorningClosingTime(((LocalTime) value));
                }
            }
            if( values.containsKey("TuesdayAfternoonOpeningTime") ) {
                final Object value = values.remove("TuesdayAfternoonOpeningTime");
                if( (value == null) || (!value.equals(getTuesdayAfternoonOpeningTime())) ) {
                    setTuesdayAfternoonOpeningTime(((LocalTime) value));
                }
            }
            if( values.containsKey("TuesdayAfternoonClosingTime") ) {
                final Object value = values.remove("TuesdayAfternoonClosingTime");
                if( (value == null) || (!value.equals(getTuesdayAfternoonClosingTime())) ) {
                    setTuesdayAfternoonClosingTime(((LocalTime) value));
                }
            }
            if( values.containsKey("WednesdayMorningOpeningTime") ) {
                final Object value = values.remove("WednesdayMorningOpeningTime");
                if( (value == null) || (!value.equals(getWednesdayMorningOpeningTime())) ) {
                    setWednesdayMorningOpeningTime(((LocalTime) value));
                }
            }
            if( values.containsKey("WednesdayMorningClosingTime") ) {
                final Object value = values.remove("WednesdayMorningClosingTime");
                if( (value == null) || (!value.equals(getWednesdayMorningClosingTime())) ) {
                    setWednesdayMorningClosingTime(((LocalTime) value));
                }
            }
            if( values.containsKey("WednesdayAfternoonOpeningTime") ) {
                final Object value = values.remove("WednesdayAfternoonOpeningTime");
                if( (value == null) || (!value.equals(getWednesdayAfternoonOpeningTime())) ) {
                    setWednesdayAfternoonOpeningTime(((LocalTime) value));
                }
            }
            if( values.containsKey("WednesdayAfternoonClosingTime") ) {
                final Object value = values.remove("WednesdayAfternoonClosingTime");
                if( (value == null) || (!value.equals(getWednesdayAfternoonClosingTime())) ) {
                    setWednesdayAfternoonClosingTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ThursdayMorningOpeningTime") ) {
                final Object value = values.remove("ThursdayMorningOpeningTime");
                if( (value == null) || (!value.equals(getThursdayMorningOpeningTime())) ) {
                    setThursdayMorningOpeningTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ThursdayMorningClosingTime") ) {
                final Object value = values.remove("ThursdayMorningClosingTime");
                if( (value == null) || (!value.equals(getThursdayMorningClosingTime())) ) {
                    setThursdayMorningClosingTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ThursdayAfternoonOpeningTime") ) {
                final Object value = values.remove("ThursdayAfternoonOpeningTime");
                if( (value == null) || (!value.equals(getThursdayAfternoonOpeningTime())) ) {
                    setThursdayAfternoonOpeningTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ThursdayAfternoonClosingTime") ) {
                final Object value = values.remove("ThursdayAfternoonClosingTime");
                if( (value == null) || (!value.equals(getThursdayAfternoonClosingTime())) ) {
                    setThursdayAfternoonClosingTime(((LocalTime) value));
                }
            }
            if( values.containsKey("FridayMorningOpeningTime") ) {
                final Object value = values.remove("FridayMorningOpeningTime");
                if( (value == null) || (!value.equals(getFridayMorningOpeningTime())) ) {
                    setFridayMorningOpeningTime(((LocalTime) value));
                }
            }
            if( values.containsKey("FridayMorningClosingTime") ) {
                final Object value = values.remove("FridayMorningClosingTime");
                if( (value == null) || (!value.equals(getFridayMorningClosingTime())) ) {
                    setFridayMorningClosingTime(((LocalTime) value));
                }
            }
            if( values.containsKey("FridayAfternoonOpeningTime") ) {
                final Object value = values.remove("FridayAfternoonOpeningTime");
                if( (value == null) || (!value.equals(getFridayAfternoonOpeningTime())) ) {
                    setFridayAfternoonOpeningTime(((LocalTime) value));
                }
            }
            if( values.containsKey("FridayAfternoonClosingTime") ) {
                final Object value = values.remove("FridayAfternoonClosingTime");
                if( (value == null) || (!value.equals(getFridayAfternoonClosingTime())) ) {
                    setFridayAfternoonClosingTime(((LocalTime) value));
                }
            }
            if( values.containsKey("SaturdayMorningOpeningTime") ) {
                final Object value = values.remove("SaturdayMorningOpeningTime");
                if( (value == null) || (!value.equals(getSaturdayMorningOpeningTime())) ) {
                    setSaturdayMorningOpeningTime(((LocalTime) value));
                }
            }
            if( values.containsKey("SaturdayMorningClosingTime") ) {
                final Object value = values.remove("SaturdayMorningClosingTime");
                if( (value == null) || (!value.equals(getSaturdayMorningClosingTime())) ) {
                    setSaturdayMorningClosingTime(((LocalTime) value));
                }
            }
            if( values.containsKey("SaturdayAfternoonOpeningTime") ) {
                final Object value = values.remove("SaturdayAfternoonOpeningTime");
                if( (value == null) || (!value.equals(getSaturdayAfternoonOpeningTime())) ) {
                    setSaturdayAfternoonOpeningTime(((LocalTime) value));
                }
            }
            if( values.containsKey("SaturdayAfternoonClosingTime") ) {
                final Object value = values.remove("SaturdayAfternoonClosingTime");
                if( (value == null) || (!value.equals(getSaturdayAfternoonClosingTime())) ) {
                    setSaturdayAfternoonClosingTime(((LocalTime) value));
                }
            }
            if( values.containsKey("SundayMorningOpeningTime") ) {
                final Object value = values.remove("SundayMorningOpeningTime");
                if( (value == null) || (!value.equals(getSundayMorningOpeningTime())) ) {
                    setSundayMorningOpeningTime(((LocalTime) value));
                }
            }
            if( values.containsKey("SundayMorningClosingTime") ) {
                final Object value = values.remove("SundayMorningClosingTime");
                if( (value == null) || (!value.equals(getSundayMorningClosingTime())) ) {
                    setSundayMorningClosingTime(((LocalTime) value));
                }
            }
            if( values.containsKey("SundayAfternoonOpeningTime") ) {
                final Object value = values.remove("SundayAfternoonOpeningTime");
                if( (value == null) || (!value.equals(getSundayAfternoonOpeningTime())) ) {
                    setSundayAfternoonOpeningTime(((LocalTime) value));
                }
            }
            if( values.containsKey("SundayAfternoonClosingTime") ) {
                final Object value = values.remove("SundayAfternoonClosingTime");
                if( (value == null) || (!value.equals(getSundayAfternoonClosingTime())) ) {
                    setSundayAfternoonClosingTime(((LocalTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CustomerUnloadingPointField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CustomerUnloadingPointField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CustomerUnloadingPointField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CustomerUnloadingPointField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessPartnerService.DEFAULT_SERVICE_PATH);
    }

}
