/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.selectable.SupplierPurchasingOrgSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrg
 * SupplierPurchasingOrg} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class SupplierPurchasingOrgByKeyFluentHelper
    extends
    FluentHelperByKey<SupplierPurchasingOrgByKeyFluentHelper, SupplierPurchasingOrg, SupplierPurchasingOrgSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrg
     * SupplierPurchasingOrg} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SupplierPurchasingOrg}
     * @param servicePath
     *            Service path to be used to fetch a single {@code SupplierPurchasingOrg}
     * @param supplier
     *            Supplier's Account Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param purchasingOrganization
     *            Purchasing Organization
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     */
    public SupplierPurchasingOrgByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String supplier,
        final String purchasingOrganization )
    {
        super(servicePath, entityCollection);
        this.key.put("Supplier", supplier);
        this.key.put("PurchasingOrganization", purchasingOrganization);
    }

    @Override
    @Nonnull
    protected Class<SupplierPurchasingOrg> getEntityClass()
    {
        return SupplierPurchasingOrg.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
