/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressEmailAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumber;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressHomePageURL;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumber;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumber;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToFuncAndDept;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthiness;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPRelationship;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaAddressUsage;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIdentification;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustry;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbr;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerBank;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerContact;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRating;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRole;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumber;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntExtIdentifier;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSalesPartnerFunc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntInfo;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfo;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerDunning;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesArea;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTax;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGrouping;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTax;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompany;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunning;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPartnerFunc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrg;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTax;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessPartnerService BusinessPartnerService}.
 *
 */
public interface BusinessPartnerServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<BusinessPartnerServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<BusinessPartnerServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressEmailAddress
     * AddressEmailAddress} entity and save it to the S/4HANA system.
     *
     * @param addressEmailAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressEmailAddress
     *            AddressEmailAddress} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        createAddressEmailAddress( @Nonnull final AddressEmailAddress addressEmailAddress );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressEmailAddress
     * AddressEmailAddress} entity and save it to the S/4HANA system.
     *
     * @param addressEmailAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressEmailAddress
     *            AddressEmailAddress} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        updateAddressEmailAddress( @Nonnull final AddressEmailAddress addressEmailAddress );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressEmailAddress
     * AddressEmailAddress} entity in the S/4HANA system.
     *
     * @param addressEmailAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressEmailAddress
     *            AddressEmailAddress} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        deleteAddressEmailAddress( @Nonnull final AddressEmailAddress addressEmailAddress );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumber
     * AddressFaxNumber} entity and save it to the S/4HANA system.
     *
     * @param addressFaxNumber
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumber
     *            AddressFaxNumber} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet createAddressFaxNumber( @Nonnull final AddressFaxNumber addressFaxNumber );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumber
     * AddressFaxNumber} entity and save it to the S/4HANA system.
     *
     * @param addressFaxNumber
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumber
     *            AddressFaxNumber} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet updateAddressFaxNumber( @Nonnull final AddressFaxNumber addressFaxNumber );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumber
     * AddressFaxNumber} entity in the S/4HANA system.
     *
     * @param addressFaxNumber
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumber
     *            AddressFaxNumber} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet deleteAddressFaxNumber( @Nonnull final AddressFaxNumber addressFaxNumber );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressHomePageURL
     * AddressHomePageURL} entity and save it to the S/4HANA system.
     *
     * @param addressHomePageURL
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressHomePageURL
     *            AddressHomePageURL} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        createAddressHomePageURL( @Nonnull final AddressHomePageURL addressHomePageURL );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressHomePageURL
     * AddressHomePageURL} entity and save it to the S/4HANA system.
     *
     * @param addressHomePageURL
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressHomePageURL
     *            AddressHomePageURL} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        updateAddressHomePageURL( @Nonnull final AddressHomePageURL addressHomePageURL );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressHomePageURL
     * AddressHomePageURL} entity in the S/4HANA system.
     *
     * @param addressHomePageURL
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressHomePageURL
     *            AddressHomePageURL} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        deleteAddressHomePageURL( @Nonnull final AddressHomePageURL addressHomePageURL );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumber
     * AddressPhoneNumber} entity and save it to the S/4HANA system.
     *
     * @param addressPhoneNumber
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumber
     *            AddressPhoneNumber} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        createAddressPhoneNumber( @Nonnull final AddressPhoneNumber addressPhoneNumber );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumber
     * AddressPhoneNumber} entity and save it to the S/4HANA system.
     *
     * @param addressPhoneNumber
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumber
     *            AddressPhoneNumber} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        updateAddressPhoneNumber( @Nonnull final AddressPhoneNumber addressPhoneNumber );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumber
     * AddressPhoneNumber} entity in the S/4HANA system.
     *
     * @param addressPhoneNumber
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumber
     *            AddressPhoneNumber} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        deleteAddressPhoneNumber( @Nonnull final AddressPhoneNumber addressPhoneNumber );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumber
     * BPAddrDepdntIntlLocNumber} entity and save it to the S/4HANA system.
     *
     * @param bPAddrDepdntIntlLocNumber
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumber
     *            BPAddrDepdntIntlLocNumber} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        createBPAddrDepdntIntlLocNumber( @Nonnull final BPAddrDepdntIntlLocNumber bPAddrDepdntIntlLocNumber );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumber
     * BPAddrDepdntIntlLocNumber} entity and save it to the S/4HANA system.
     *
     * @param bPAddrDepdntIntlLocNumber
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumber
     *            BPAddrDepdntIntlLocNumber} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        updateBPAddrDepdntIntlLocNumber( @Nonnull final BPAddrDepdntIntlLocNumber bPAddrDepdntIntlLocNumber );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumber
     * BPAddrDepdntIntlLocNumber} entity in the S/4HANA system.
     *
     * @param bPAddrDepdntIntlLocNumber
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumber
     *            BPAddrDepdntIntlLocNumber} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        deleteBPAddrDepdntIntlLocNumber( @Nonnull final BPAddrDepdntIntlLocNumber bPAddrDepdntIntlLocNumber );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress
     * BPContactToAddress} entity and save it to the S/4HANA system.
     *
     * @param bPContactToAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress
     *            BPContactToAddress} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        createBPContactToAddress( @Nonnull final BPContactToAddress bPContactToAddress );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToFuncAndDept
     * BPContactToFuncAndDept} entity and save it to the S/4HANA system.
     *
     * @param bPContactToFuncAndDept
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToFuncAndDept
     *            BPContactToFuncAndDept} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        updateBPContactToFuncAndDept( @Nonnull final BPContactToFuncAndDept bPContactToFuncAndDept );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthiness
     * BPCreditWorthiness} entity and save it to the S/4HANA system.
     *
     * @param bPCreditWorthiness
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthiness
     *            BPCreditWorthiness} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        createBPCreditWorthiness( @Nonnull final BPCreditWorthiness bPCreditWorthiness );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthiness
     * BPCreditWorthiness} entity and save it to the S/4HANA system.
     *
     * @param bPCreditWorthiness
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthiness
     *            BPCreditWorthiness} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        updateBPCreditWorthiness( @Nonnull final BPCreditWorthiness bPCreditWorthiness );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn
     * BPFinancialServicesExtn} entity and save it to the S/4HANA system.
     *
     * @param bPFinancialServicesExtn
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn
     *            BPFinancialServicesExtn} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        createBPFinancialServicesExtn( @Nonnull final BPFinancialServicesExtn bPFinancialServicesExtn );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn
     * BPFinancialServicesExtn} entity and save it to the S/4HANA system.
     *
     * @param bPFinancialServicesExtn
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn
     *            BPFinancialServicesExtn} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        updateBPFinancialServicesExtn( @Nonnull final BPFinancialServicesExtn bPFinancialServicesExtn );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting
     * BPFinancialServicesReporting} entity and save it to the S/4HANA system.
     *
     * @param bPFinancialServicesReporting
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting
     *            BPFinancialServicesReporting} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        createBPFinancialServicesReporting( @Nonnull final BPFinancialServicesReporting bPFinancialServicesReporting );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting
     * BPFinancialServicesReporting} entity and save it to the S/4HANA system.
     *
     * @param bPFinancialServicesReporting
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting
     *            BPFinancialServicesReporting} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        updateBPFinancialServicesReporting( @Nonnull final BPFinancialServicesReporting bPFinancialServicesReporting );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation
     * BPFiscalYearInformation} entity and save it to the S/4HANA system.
     *
     * @param bPFiscalYearInformation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation
     *            BPFiscalYearInformation} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        createBPFiscalYearInformation( @Nonnull final BPFiscalYearInformation bPFiscalYearInformation );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation
     * BPFiscalYearInformation} entity and save it to the S/4HANA system.
     *
     * @param bPFiscalYearInformation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation
     *            BPFiscalYearInformation} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        updateBPFiscalYearInformation( @Nonnull final BPFiscalYearInformation bPFiscalYearInformation );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation
     * BPFiscalYearInformation} entity in the S/4HANA system.
     *
     * @param bPFiscalYearInformation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation
     *            BPFiscalYearInformation} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        deleteBPFiscalYearInformation( @Nonnull final BPFiscalYearInformation bPFiscalYearInformation );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPRelationship
     * BPRelationship} entity and save it to the S/4HANA system.
     *
     * @param bPRelationship
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPRelationship
     *            BPRelationship} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet createBPRelationship( @Nonnull final BPRelationship bPRelationship );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPRelationship
     * BPRelationship} entity and save it to the S/4HANA system.
     *
     * @param bPRelationship
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPRelationship
     *            BPRelationship} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet updateBPRelationship( @Nonnull final BPRelationship bPRelationship );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPRelationship
     * BPRelationship} entity in the S/4HANA system.
     *
     * @param bPRelationship
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPRelationship
     *            BPRelationship} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet deleteBPRelationship( @Nonnull final BPRelationship bPRelationship );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaAddressUsage
     * BuPaAddressUsage} entity and save it to the S/4HANA system.
     *
     * @param buPaAddressUsage
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaAddressUsage
     *            BuPaAddressUsage} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet createBuPaAddressUsage( @Nonnull final BuPaAddressUsage buPaAddressUsage );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaAddressUsage
     * BuPaAddressUsage} entity and save it to the S/4HANA system.
     *
     * @param buPaAddressUsage
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaAddressUsage
     *            BuPaAddressUsage} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet updateBuPaAddressUsage( @Nonnull final BuPaAddressUsage buPaAddressUsage );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaAddressUsage
     * BuPaAddressUsage} entity in the S/4HANA system.
     *
     * @param buPaAddressUsage
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaAddressUsage
     *            BuPaAddressUsage} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet deleteBuPaAddressUsage( @Nonnull final BuPaAddressUsage buPaAddressUsage );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIdentification
     * BuPaIdentification} entity and save it to the S/4HANA system.
     *
     * @param buPaIdentification
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIdentification
     *            BuPaIdentification} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        createBuPaIdentification( @Nonnull final BuPaIdentification buPaIdentification );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIdentification
     * BuPaIdentification} entity and save it to the S/4HANA system.
     *
     * @param buPaIdentification
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIdentification
     *            BuPaIdentification} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        updateBuPaIdentification( @Nonnull final BuPaIdentification buPaIdentification );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIdentification
     * BuPaIdentification} entity in the S/4HANA system.
     *
     * @param buPaIdentification
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIdentification
     *            BuPaIdentification} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        deleteBuPaIdentification( @Nonnull final BuPaIdentification buPaIdentification );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustry
     * BuPaIndustry} entity and save it to the S/4HANA system.
     *
     * @param buPaIndustry
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustry BuPaIndustry}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet createBuPaIndustry( @Nonnull final BuPaIndustry buPaIndustry );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustry
     * BuPaIndustry} entity and save it to the S/4HANA system.
     *
     * @param buPaIndustry
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustry BuPaIndustry}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet updateBuPaIndustry( @Nonnull final BuPaIndustry buPaIndustry );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustry
     * BuPaIndustry} entity in the S/4HANA system.
     *
     * @param buPaIndustry
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustry BuPaIndustry}
     *            entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet deleteBuPaIndustry( @Nonnull final BuPaIndustry buPaIndustry );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartner
     * BusinessPartner} entity and save it to the S/4HANA system.
     *
     * @param businessPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartner
     *            BusinessPartner} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet createBusinessPartner( @Nonnull final BusinessPartner businessPartner );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartner
     * BusinessPartner} entity and save it to the S/4HANA system.
     *
     * @param businessPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartner
     *            BusinessPartner} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet updateBusinessPartner( @Nonnull final BusinessPartner businessPartner );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerAddress
     * BusinessPartnerAddress} entity and save it to the S/4HANA system.
     *
     * @param businessPartnerAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerAddress
     *            BusinessPartnerAddress} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        createBusinessPartnerAddress( @Nonnull final BusinessPartnerAddress businessPartnerAddress );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerAddress
     * BusinessPartnerAddress} entity and save it to the S/4HANA system.
     *
     * @param businessPartnerAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerAddress
     *            BusinessPartnerAddress} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        updateBusinessPartnerAddress( @Nonnull final BusinessPartnerAddress businessPartnerAddress );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerAddress
     * BusinessPartnerAddress} entity in the S/4HANA system.
     *
     * @param businessPartnerAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerAddress
     *            BusinessPartnerAddress} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        deleteBusinessPartnerAddress( @Nonnull final BusinessPartnerAddress businessPartnerAddress );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerBank
     * BusinessPartnerBank} entity and save it to the S/4HANA system.
     *
     * @param businessPartnerBank
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerBank
     *            BusinessPartnerBank} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        createBusinessPartnerBank( @Nonnull final BusinessPartnerBank businessPartnerBank );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerBank
     * BusinessPartnerBank} entity and save it to the S/4HANA system.
     *
     * @param businessPartnerBank
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerBank
     *            BusinessPartnerBank} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        updateBusinessPartnerBank( @Nonnull final BusinessPartnerBank businessPartnerBank );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerBank
     * BusinessPartnerBank} entity in the S/4HANA system.
     *
     * @param businessPartnerBank
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerBank
     *            BusinessPartnerBank} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        deleteBusinessPartnerBank( @Nonnull final BusinessPartnerBank businessPartnerBank );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerContact
     * BusinessPartnerContact} entity and save it to the S/4HANA system.
     *
     * @param businessPartnerContact
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerContact
     *            BusinessPartnerContact} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        createBusinessPartnerContact( @Nonnull final BusinessPartnerContact businessPartnerContact );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerContact
     * BusinessPartnerContact} entity and save it to the S/4HANA system.
     *
     * @param businessPartnerContact
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerContact
     *            BusinessPartnerContact} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        updateBusinessPartnerContact( @Nonnull final BusinessPartnerContact businessPartnerContact );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerContact
     * BusinessPartnerContact} entity in the S/4HANA system.
     *
     * @param businessPartnerContact
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerContact
     *            BusinessPartnerContact} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        deleteBusinessPartnerContact( @Nonnull final BusinessPartnerContact businessPartnerContact );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRating
     * BusinessPartnerRating} entity and save it to the S/4HANA system.
     *
     * @param businessPartnerRating
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRating
     *            BusinessPartnerRating} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        createBusinessPartnerRating( @Nonnull final BusinessPartnerRating businessPartnerRating );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRating
     * BusinessPartnerRating} entity and save it to the S/4HANA system.
     *
     * @param businessPartnerRating
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRating
     *            BusinessPartnerRating} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        updateBusinessPartnerRating( @Nonnull final BusinessPartnerRating businessPartnerRating );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRating
     * BusinessPartnerRating} entity in the S/4HANA system.
     *
     * @param businessPartnerRating
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRating
     *            BusinessPartnerRating} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        deleteBusinessPartnerRating( @Nonnull final BusinessPartnerRating businessPartnerRating );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRole
     * BusinessPartnerRole} entity and save it to the S/4HANA system.
     *
     * @param businessPartnerRole
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRole
     *            BusinessPartnerRole} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        createBusinessPartnerRole( @Nonnull final BusinessPartnerRole businessPartnerRole );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRole
     * BusinessPartnerRole} entity and save it to the S/4HANA system.
     *
     * @param businessPartnerRole
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRole
     *            BusinessPartnerRole} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        updateBusinessPartnerRole( @Nonnull final BusinessPartnerRole businessPartnerRole );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumber
     * BusinessPartnerTaxNumber} entity and save it to the S/4HANA system.
     *
     * @param businessPartnerTaxNumber
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumber
     *            BusinessPartnerTaxNumber} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        createBusinessPartnerTaxNumber( @Nonnull final BusinessPartnerTaxNumber businessPartnerTaxNumber );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumber
     * BusinessPartnerTaxNumber} entity and save it to the S/4HANA system.
     *
     * @param businessPartnerTaxNumber
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumber
     *            BusinessPartnerTaxNumber} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        updateBusinessPartnerTaxNumber( @Nonnull final BusinessPartnerTaxNumber businessPartnerTaxNumber );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumber
     * BusinessPartnerTaxNumber} entity in the S/4HANA system.
     *
     * @param businessPartnerTaxNumber
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumber
     *            BusinessPartnerTaxNumber} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        deleteBusinessPartnerTaxNumber( @Nonnull final BusinessPartnerTaxNumber businessPartnerTaxNumber );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbr
     * BusPartAddrDepdntTaxNmbr} entity and save it to the S/4HANA system.
     *
     * @param busPartAddrDepdntTaxNmbr
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbr
     *            BusPartAddrDepdntTaxNmbr} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        createBusPartAddrDepdntTaxNmbr( @Nonnull final BusPartAddrDepdntTaxNmbr busPartAddrDepdntTaxNmbr );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbr
     * BusPartAddrDepdntTaxNmbr} entity and save it to the S/4HANA system.
     *
     * @param busPartAddrDepdntTaxNmbr
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbr
     *            BusPartAddrDepdntTaxNmbr} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        updateBusPartAddrDepdntTaxNmbr( @Nonnull final BusPartAddrDepdntTaxNmbr busPartAddrDepdntTaxNmbr );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbr
     * BusPartAddrDepdntTaxNmbr} entity in the S/4HANA system.
     *
     * @param busPartAddrDepdntTaxNmbr
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbr
     *            BusPartAddrDepdntTaxNmbr} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        deleteBusPartAddrDepdntTaxNmbr( @Nonnull final BusPartAddrDepdntTaxNmbr busPartAddrDepdntTaxNmbr );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntExtIdentifier
     * CustAddrDepdntExtIdentifier} entity and save it to the S/4HANA system.
     *
     * @param custAddrDepdntExtIdentifier
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntExtIdentifier
     *            CustAddrDepdntExtIdentifier} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        createCustAddrDepdntExtIdentifier( @Nonnull final CustAddrDepdntExtIdentifier custAddrDepdntExtIdentifier );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntExtIdentifier
     * CustAddrDepdntExtIdentifier} entity and save it to the S/4HANA system.
     *
     * @param custAddrDepdntExtIdentifier
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntExtIdentifier
     *            CustAddrDepdntExtIdentifier} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        updateCustAddrDepdntExtIdentifier( @Nonnull final CustAddrDepdntExtIdentifier custAddrDepdntExtIdentifier );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntExtIdentifier
     * CustAddrDepdntExtIdentifier} entity in the S/4HANA system.
     *
     * @param custAddrDepdntExtIdentifier
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntExtIdentifier
     *            CustAddrDepdntExtIdentifier} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        deleteCustAddrDepdntExtIdentifier( @Nonnull final CustAddrDepdntExtIdentifier custAddrDepdntExtIdentifier );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformation
     * CustAddrDepdntInformation} entity and save it to the S/4HANA system.
     *
     * @param custAddrDepdntInformation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformation
     *            CustAddrDepdntInformation} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        createCustAddrDepdntInformation( @Nonnull final CustAddrDepdntInformation custAddrDepdntInformation );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformation
     * CustAddrDepdntInformation} entity and save it to the S/4HANA system.
     *
     * @param custAddrDepdntInformation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformation
     *            CustAddrDepdntInformation} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        updateCustAddrDepdntInformation( @Nonnull final CustAddrDepdntInformation custAddrDepdntInformation );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformation
     * CustAddrDepdntInformation} entity in the S/4HANA system.
     *
     * @param custAddrDepdntInformation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformation
     *            CustAddrDepdntInformation} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        deleteCustAddrDepdntInformation( @Nonnull final CustAddrDepdntInformation custAddrDepdntInformation );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer Customer} entity
     * and save it to the S/4HANA system.
     *
     * @param customer
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer Customer} entity
     *            object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet createCustomer( @Nonnull final Customer customer );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer Customer}
     * entity and save it to the S/4HANA system.
     *
     * @param customer
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer Customer} entity
     *            object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet updateCustomer( @Nonnull final Customer customer );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany
     * CustomerCompany} entity and save it to the S/4HANA system.
     *
     * @param customerCompany
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany
     *            CustomerCompany} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet createCustomerCompany( @Nonnull final CustomerCompany customerCompany );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany
     * CustomerCompany} entity and save it to the S/4HANA system.
     *
     * @param customerCompany
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany
     *            CustomerCompany} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet updateCustomerCompany( @Nonnull final CustomerCompany customerCompany );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyText
     * CustomerCompanyText} entity and save it to the S/4HANA system.
     *
     * @param customerCompanyText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyText
     *            CustomerCompanyText} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        createCustomerCompanyText( @Nonnull final CustomerCompanyText customerCompanyText );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyText
     * CustomerCompanyText} entity and save it to the S/4HANA system.
     *
     * @param customerCompanyText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyText
     *            CustomerCompanyText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        updateCustomerCompanyText( @Nonnull final CustomerCompanyText customerCompanyText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyText
     * CustomerCompanyText} entity in the S/4HANA system.
     *
     * @param customerCompanyText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyText
     *            CustomerCompanyText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        deleteCustomerCompanyText( @Nonnull final CustomerCompanyText customerCompanyText );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerDunning
     * CustomerDunning} entity and save it to the S/4HANA system.
     *
     * @param customerDunning
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerDunning
     *            CustomerDunning} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet createCustomerDunning( @Nonnull final CustomerDunning customerDunning );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerDunning
     * CustomerDunning} entity and save it to the S/4HANA system.
     *
     * @param customerDunning
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerDunning
     *            CustomerDunning} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet updateCustomerDunning( @Nonnull final CustomerDunning customerDunning );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerDunning
     * CustomerDunning} entity in the S/4HANA system.
     *
     * @param customerDunning
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerDunning
     *            CustomerDunning} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet deleteCustomerDunning( @Nonnull final CustomerDunning customerDunning );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesArea
     * CustomerSalesArea} entity and save it to the S/4HANA system.
     *
     * @param customerSalesArea
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesArea
     *            CustomerSalesArea} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet createCustomerSalesArea( @Nonnull final CustomerSalesArea customerSalesArea );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesArea
     * CustomerSalesArea} entity and save it to the S/4HANA system.
     *
     * @param customerSalesArea
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesArea
     *            CustomerSalesArea} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet updateCustomerSalesArea( @Nonnull final CustomerSalesArea customerSalesArea );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTax
     * CustomerSalesAreaTax} entity and save it to the S/4HANA system.
     *
     * @param customerSalesAreaTax
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTax
     *            CustomerSalesAreaTax} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        createCustomerSalesAreaTax( @Nonnull final CustomerSalesAreaTax customerSalesAreaTax );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTax
     * CustomerSalesAreaTax} entity and save it to the S/4HANA system.
     *
     * @param customerSalesAreaTax
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTax
     *            CustomerSalesAreaTax} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        updateCustomerSalesAreaTax( @Nonnull final CustomerSalesAreaTax customerSalesAreaTax );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaText
     * CustomerSalesAreaText} entity and save it to the S/4HANA system.
     *
     * @param customerSalesAreaText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaText
     *            CustomerSalesAreaText} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        createCustomerSalesAreaText( @Nonnull final CustomerSalesAreaText customerSalesAreaText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaText
     * CustomerSalesAreaText} entity and save it to the S/4HANA system.
     *
     * @param customerSalesAreaText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaText
     *            CustomerSalesAreaText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        updateCustomerSalesAreaText( @Nonnull final CustomerSalesAreaText customerSalesAreaText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaText
     * CustomerSalesAreaText} entity in the S/4HANA system.
     *
     * @param customerSalesAreaText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaText
     *            CustomerSalesAreaText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        deleteCustomerSalesAreaText( @Nonnull final CustomerSalesAreaText customerSalesAreaText );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGrouping
     * CustomerTaxGrouping} entity and save it to the S/4HANA system.
     *
     * @param customerTaxGrouping
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGrouping
     *            CustomerTaxGrouping} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        updateCustomerTaxGrouping( @Nonnull final CustomerTaxGrouping customerTaxGrouping );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGrouping
     * CustomerTaxGrouping} entity in the S/4HANA system.
     *
     * @param customerTaxGrouping
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGrouping
     *            CustomerTaxGrouping} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        deleteCustomerTaxGrouping( @Nonnull final CustomerTaxGrouping customerTaxGrouping );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerText
     * CustomerText} entity and save it to the S/4HANA system.
     *
     * @param customerText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerText CustomerText}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet createCustomerText( @Nonnull final CustomerText customerText );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerText
     * CustomerText} entity and save it to the S/4HANA system.
     *
     * @param customerText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerText CustomerText}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet updateCustomerText( @Nonnull final CustomerText customerText );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerText
     * CustomerText} entity in the S/4HANA system.
     *
     * @param customerText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerText CustomerText}
     *            entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet deleteCustomerText( @Nonnull final CustomerText customerText );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint
     * CustomerUnloadingPoint} entity and save it to the S/4HANA system.
     *
     * @param customerUnloadingPoint
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint
     *            CustomerUnloadingPoint} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        createCustomerUnloadingPoint( @Nonnull final CustomerUnloadingPoint customerUnloadingPoint );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint
     * CustomerUnloadingPoint} entity and save it to the S/4HANA system.
     *
     * @param customerUnloadingPoint
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint
     *            CustomerUnloadingPoint} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        updateCustomerUnloadingPoint( @Nonnull final CustomerUnloadingPoint customerUnloadingPoint );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint
     * CustomerUnloadingPoint} entity in the S/4HANA system.
     *
     * @param customerUnloadingPoint
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint
     *            CustomerUnloadingPoint} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        deleteCustomerUnloadingPoint( @Nonnull final CustomerUnloadingPoint customerUnloadingPoint );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTax
     * CustomerWithHoldingTax} entity and save it to the S/4HANA system.
     *
     * @param customerWithHoldingTax
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTax
     *            CustomerWithHoldingTax} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        createCustomerWithHoldingTax( @Nonnull final CustomerWithHoldingTax customerWithHoldingTax );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTax
     * CustomerWithHoldingTax} entity and save it to the S/4HANA system.
     *
     * @param customerWithHoldingTax
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTax
     *            CustomerWithHoldingTax} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        updateCustomerWithHoldingTax( @Nonnull final CustomerWithHoldingTax customerWithHoldingTax );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTax
     * CustomerWithHoldingTax} entity in the S/4HANA system.
     *
     * @param customerWithHoldingTax
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTax
     *            CustomerWithHoldingTax} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        deleteCustomerWithHoldingTax( @Nonnull final CustomerWithHoldingTax customerWithHoldingTax );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSalesPartnerFunc
     * CustSalesPartnerFunc} entity and save it to the S/4HANA system.
     *
     * @param custSalesPartnerFunc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSalesPartnerFunc
     *            CustSalesPartnerFunc} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        createCustSalesPartnerFunc( @Nonnull final CustSalesPartnerFunc custSalesPartnerFunc );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSalesPartnerFunc
     * CustSalesPartnerFunc} entity and save it to the S/4HANA system.
     *
     * @param custSalesPartnerFunc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSalesPartnerFunc
     *            CustSalesPartnerFunc} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        updateCustSalesPartnerFunc( @Nonnull final CustSalesPartnerFunc custSalesPartnerFunc );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSalesPartnerFunc
     * CustSalesPartnerFunc} entity in the S/4HANA system.
     *
     * @param custSalesPartnerFunc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSalesPartnerFunc
     *            CustSalesPartnerFunc} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        deleteCustSalesPartnerFunc( @Nonnull final CustSalesPartnerFunc custSalesPartnerFunc );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntInfo
     * CustSlsAreaAddrDepdntInfo} entity and save it to the S/4HANA system.
     *
     * @param custSlsAreaAddrDepdntInfo
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntInfo
     *            CustSlsAreaAddrDepdntInfo} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        createCustSlsAreaAddrDepdntInfo( @Nonnull final CustSlsAreaAddrDepdntInfo custSlsAreaAddrDepdntInfo );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntInfo
     * CustSlsAreaAddrDepdntInfo} entity and save it to the S/4HANA system.
     *
     * @param custSlsAreaAddrDepdntInfo
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntInfo
     *            CustSlsAreaAddrDepdntInfo} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        updateCustSlsAreaAddrDepdntInfo( @Nonnull final CustSlsAreaAddrDepdntInfo custSlsAreaAddrDepdntInfo );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntInfo
     * CustSlsAreaAddrDepdntInfo} entity in the S/4HANA system.
     *
     * @param custSlsAreaAddrDepdntInfo
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntInfo
     *            CustSlsAreaAddrDepdntInfo} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        deleteCustSlsAreaAddrDepdntInfo( @Nonnull final CustSlsAreaAddrDepdntInfo custSlsAreaAddrDepdntInfo );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfo
     * CustSlsAreaAddrDepdntTaxInfo} entity and save it to the S/4HANA system.
     *
     * @param custSlsAreaAddrDepdntTaxInfo
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfo
     *            CustSlsAreaAddrDepdntTaxInfo} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        createCustSlsAreaAddrDepdntTaxInfo( @Nonnull final CustSlsAreaAddrDepdntTaxInfo custSlsAreaAddrDepdntTaxInfo );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfo
     * CustSlsAreaAddrDepdntTaxInfo} entity and save it to the S/4HANA system.
     *
     * @param custSlsAreaAddrDepdntTaxInfo
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfo
     *            CustSlsAreaAddrDepdntTaxInfo} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        updateCustSlsAreaAddrDepdntTaxInfo( @Nonnull final CustSlsAreaAddrDepdntTaxInfo custSlsAreaAddrDepdntTaxInfo );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfo
     * CustSlsAreaAddrDepdntTaxInfo} entity in the S/4HANA system.
     *
     * @param custSlsAreaAddrDepdntTaxInfo
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfo
     *            CustSlsAreaAddrDepdntTaxInfo} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        deleteCustSlsAreaAddrDepdntTaxInfo( @Nonnull final CustSlsAreaAddrDepdntTaxInfo custSlsAreaAddrDepdntTaxInfo );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo
     * CustUnldgPtAddrDepdntInfo} entity and save it to the S/4HANA system.
     *
     * @param custUnldgPtAddrDepdntInfo
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo
     *            CustUnldgPtAddrDepdntInfo} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        createCustUnldgPtAddrDepdntInfo( @Nonnull final CustUnldgPtAddrDepdntInfo custUnldgPtAddrDepdntInfo );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo
     * CustUnldgPtAddrDepdntInfo} entity and save it to the S/4HANA system.
     *
     * @param custUnldgPtAddrDepdntInfo
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo
     *            CustUnldgPtAddrDepdntInfo} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        updateCustUnldgPtAddrDepdntInfo( @Nonnull final CustUnldgPtAddrDepdntInfo custUnldgPtAddrDepdntInfo );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo
     * CustUnldgPtAddrDepdntInfo} entity in the S/4HANA system.
     *
     * @param custUnldgPtAddrDepdntInfo
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo
     *            CustUnldgPtAddrDepdntInfo} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        deleteCustUnldgPtAddrDepdntInfo( @Nonnull final CustUnldgPtAddrDepdntInfo custUnldgPtAddrDepdntInfo );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier Supplier} entity
     * and save it to the S/4HANA system.
     *
     * @param supplier
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier Supplier} entity
     *            object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet createSupplier( @Nonnull final Supplier supplier );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier Supplier}
     * entity and save it to the S/4HANA system.
     *
     * @param supplier
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier Supplier} entity
     *            object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet updateSupplier( @Nonnull final Supplier supplier );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompany
     * SupplierCompany} entity and save it to the S/4HANA system.
     *
     * @param supplierCompany
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompany
     *            SupplierCompany} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet createSupplierCompany( @Nonnull final SupplierCompany supplierCompany );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompany
     * SupplierCompany} entity and save it to the S/4HANA system.
     *
     * @param supplierCompany
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompany
     *            SupplierCompany} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet updateSupplierCompany( @Nonnull final SupplierCompany supplierCompany );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyText
     * SupplierCompanyText} entity and save it to the S/4HANA system.
     *
     * @param supplierCompanyText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyText
     *            SupplierCompanyText} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        createSupplierCompanyText( @Nonnull final SupplierCompanyText supplierCompanyText );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyText
     * SupplierCompanyText} entity and save it to the S/4HANA system.
     *
     * @param supplierCompanyText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyText
     *            SupplierCompanyText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        updateSupplierCompanyText( @Nonnull final SupplierCompanyText supplierCompanyText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyText
     * SupplierCompanyText} entity in the S/4HANA system.
     *
     * @param supplierCompanyText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyText
     *            SupplierCompanyText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        deleteSupplierCompanyText( @Nonnull final SupplierCompanyText supplierCompanyText );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunning
     * SupplierDunning} entity and save it to the S/4HANA system.
     *
     * @param supplierDunning
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunning
     *            SupplierDunning} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet createSupplierDunning( @Nonnull final SupplierDunning supplierDunning );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunning
     * SupplierDunning} entity and save it to the S/4HANA system.
     *
     * @param supplierDunning
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunning
     *            SupplierDunning} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet updateSupplierDunning( @Nonnull final SupplierDunning supplierDunning );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunning
     * SupplierDunning} entity in the S/4HANA system.
     *
     * @param supplierDunning
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunning
     *            SupplierDunning} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet deleteSupplierDunning( @Nonnull final SupplierDunning supplierDunning );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPartnerFunc
     * SupplierPartnerFunc} entity and save it to the S/4HANA system.
     *
     * @param supplierPartnerFunc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPartnerFunc
     *            SupplierPartnerFunc} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        createSupplierPartnerFunc( @Nonnull final SupplierPartnerFunc supplierPartnerFunc );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPartnerFunc
     * SupplierPartnerFunc} entity and save it to the S/4HANA system.
     *
     * @param supplierPartnerFunc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPartnerFunc
     *            SupplierPartnerFunc} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        updateSupplierPartnerFunc( @Nonnull final SupplierPartnerFunc supplierPartnerFunc );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPartnerFunc
     * SupplierPartnerFunc} entity in the S/4HANA system.
     *
     * @param supplierPartnerFunc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPartnerFunc
     *            SupplierPartnerFunc} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        deleteSupplierPartnerFunc( @Nonnull final SupplierPartnerFunc supplierPartnerFunc );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrg
     * SupplierPurchasingOrg} entity and save it to the S/4HANA system.
     *
     * @param supplierPurchasingOrg
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrg
     *            SupplierPurchasingOrg} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        createSupplierPurchasingOrg( @Nonnull final SupplierPurchasingOrg supplierPurchasingOrg );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrg
     * SupplierPurchasingOrg} entity and save it to the S/4HANA system.
     *
     * @param supplierPurchasingOrg
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrg
     *            SupplierPurchasingOrg} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        updateSupplierPurchasingOrg( @Nonnull final SupplierPurchasingOrg supplierPurchasingOrg );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgText
     * SupplierPurchasingOrgText} entity and save it to the S/4HANA system.
     *
     * @param supplierPurchasingOrgText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgText
     *            SupplierPurchasingOrgText} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        createSupplierPurchasingOrgText( @Nonnull final SupplierPurchasingOrgText supplierPurchasingOrgText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgText
     * SupplierPurchasingOrgText} entity and save it to the S/4HANA system.
     *
     * @param supplierPurchasingOrgText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgText
     *            SupplierPurchasingOrgText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        updateSupplierPurchasingOrgText( @Nonnull final SupplierPurchasingOrgText supplierPurchasingOrgText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgText
     * SupplierPurchasingOrgText} entity in the S/4HANA system.
     *
     * @param supplierPurchasingOrgText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgText
     *            SupplierPurchasingOrgText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        deleteSupplierPurchasingOrgText( @Nonnull final SupplierPurchasingOrgText supplierPurchasingOrgText );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierText
     * SupplierText} entity and save it to the S/4HANA system.
     *
     * @param supplierText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierText SupplierText}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet createSupplierText( @Nonnull final SupplierText supplierText );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierText
     * SupplierText} entity and save it to the S/4HANA system.
     *
     * @param supplierText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierText SupplierText}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet updateSupplierText( @Nonnull final SupplierText supplierText );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierText
     * SupplierText} entity in the S/4HANA system.
     *
     * @param supplierText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierText SupplierText}
     *            entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet deleteSupplierText( @Nonnull final SupplierText supplierText );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTax
     * SupplierWithHoldingTax} entity and save it to the S/4HANA system.
     *
     * @param supplierWithHoldingTax
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTax
     *            SupplierWithHoldingTax} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        createSupplierWithHoldingTax( @Nonnull final SupplierWithHoldingTax supplierWithHoldingTax );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTax
     * SupplierWithHoldingTax} entity and save it to the S/4HANA system.
     *
     * @param supplierWithHoldingTax
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTax
     *            SupplierWithHoldingTax} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        updateSupplierWithHoldingTax( @Nonnull final SupplierWithHoldingTax supplierWithHoldingTax );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTax
     * SupplierWithHoldingTax} entity in the S/4HANA system.
     *
     * @param supplierWithHoldingTax
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTax
     *            SupplierWithHoldingTax} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessPartnerServiceBatchChangeSet
        deleteSupplierWithHoldingTax( @Nonnull final SupplierWithHoldingTax supplierWithHoldingTax );

}
