/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressEmailAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumber;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressHomePageURL;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumber;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumber;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToFuncAndDept;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthiness;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPRelationship;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaAddressUsage;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIdentification;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustry;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbr;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerBank;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerContact;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRating;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRole;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumber;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntExtIdentifier;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSalesPartnerFunc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntInfo;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfo;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompanyText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerDunning;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesArea;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaTax;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerSalesAreaText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGrouping;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTax;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Supplier;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompany;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierCompanyText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierDunning;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPartnerFunc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrg;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierPurchasingOrgText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.SupplierWithHoldingTax;

/**
 * Implementation of the {@link BusinessPartnerServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessPartnerService BusinessPartnerService}.
 *
 */
public class DefaultBusinessPartnerServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<BusinessPartnerServiceBatch, BusinessPartnerServiceBatchChangeSet>
    implements
    BusinessPartnerServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessPartnerService service;

    @SuppressWarnings( "deprecation" )
    DefaultBusinessPartnerServiceBatchChangeSet(
        @Nonnull final DefaultBusinessPartnerServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessPartnerService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultBusinessPartnerServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createAddressEmailAddress(
        @Nonnull final AddressEmailAddress addressEmailAddress )
    {
        return addRequestCreate(service::createAddressEmailAddress, addressEmailAddress);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateAddressEmailAddress(
        @Nonnull final AddressEmailAddress addressEmailAddress )
    {
        return addRequestUpdate(service::updateAddressEmailAddress, addressEmailAddress);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet deleteAddressEmailAddress(
        @Nonnull final AddressEmailAddress addressEmailAddress )
    {
        return addRequestDelete(service::deleteAddressEmailAddress, addressEmailAddress);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createAddressFaxNumber(
        @Nonnull final AddressFaxNumber addressFaxNumber )
    {
        return addRequestCreate(service::createAddressFaxNumber, addressFaxNumber);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateAddressFaxNumber(
        @Nonnull final AddressFaxNumber addressFaxNumber )
    {
        return addRequestUpdate(service::updateAddressFaxNumber, addressFaxNumber);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet deleteAddressFaxNumber(
        @Nonnull final AddressFaxNumber addressFaxNumber )
    {
        return addRequestDelete(service::deleteAddressFaxNumber, addressFaxNumber);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createAddressHomePageURL(
        @Nonnull final AddressHomePageURL addressHomePageURL )
    {
        return addRequestCreate(service::createAddressHomePageURL, addressHomePageURL);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateAddressHomePageURL(
        @Nonnull final AddressHomePageURL addressHomePageURL )
    {
        return addRequestUpdate(service::updateAddressHomePageURL, addressHomePageURL);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet deleteAddressHomePageURL(
        @Nonnull final AddressHomePageURL addressHomePageURL )
    {
        return addRequestDelete(service::deleteAddressHomePageURL, addressHomePageURL);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createAddressPhoneNumber(
        @Nonnull final AddressPhoneNumber addressPhoneNumber )
    {
        return addRequestCreate(service::createAddressPhoneNumber, addressPhoneNumber);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateAddressPhoneNumber(
        @Nonnull final AddressPhoneNumber addressPhoneNumber )
    {
        return addRequestUpdate(service::updateAddressPhoneNumber, addressPhoneNumber);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet deleteAddressPhoneNumber(
        @Nonnull final AddressPhoneNumber addressPhoneNumber )
    {
        return addRequestDelete(service::deleteAddressPhoneNumber, addressPhoneNumber);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createBPAddrDepdntIntlLocNumber(
        @Nonnull final BPAddrDepdntIntlLocNumber bPAddrDepdntIntlLocNumber )
    {
        return addRequestCreate(service::createBPAddrDepdntIntlLocNumber, bPAddrDepdntIntlLocNumber);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateBPAddrDepdntIntlLocNumber(
        @Nonnull final BPAddrDepdntIntlLocNumber bPAddrDepdntIntlLocNumber )
    {
        return addRequestUpdate(service::updateBPAddrDepdntIntlLocNumber, bPAddrDepdntIntlLocNumber);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet deleteBPAddrDepdntIntlLocNumber(
        @Nonnull final BPAddrDepdntIntlLocNumber bPAddrDepdntIntlLocNumber )
    {
        return addRequestDelete(service::deleteBPAddrDepdntIntlLocNumber, bPAddrDepdntIntlLocNumber);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createBPContactToAddress(
        @Nonnull final BPContactToAddress bPContactToAddress )
    {
        return addRequestCreate(service::createBPContactToAddress, bPContactToAddress);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateBPContactToFuncAndDept(
        @Nonnull final BPContactToFuncAndDept bPContactToFuncAndDept )
    {
        return addRequestUpdate(service::updateBPContactToFuncAndDept, bPContactToFuncAndDept);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createBPCreditWorthiness(
        @Nonnull final BPCreditWorthiness bPCreditWorthiness )
    {
        return addRequestCreate(service::createBPCreditWorthiness, bPCreditWorthiness);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateBPCreditWorthiness(
        @Nonnull final BPCreditWorthiness bPCreditWorthiness )
    {
        return addRequestUpdate(service::updateBPCreditWorthiness, bPCreditWorthiness);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createBPFinancialServicesExtn(
        @Nonnull final BPFinancialServicesExtn bPFinancialServicesExtn )
    {
        return addRequestCreate(service::createBPFinancialServicesExtn, bPFinancialServicesExtn);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateBPFinancialServicesExtn(
        @Nonnull final BPFinancialServicesExtn bPFinancialServicesExtn )
    {
        return addRequestUpdate(service::updateBPFinancialServicesExtn, bPFinancialServicesExtn);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createBPFinancialServicesReporting(
        @Nonnull final BPFinancialServicesReporting bPFinancialServicesReporting )
    {
        return addRequestCreate(service::createBPFinancialServicesReporting, bPFinancialServicesReporting);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateBPFinancialServicesReporting(
        @Nonnull final BPFinancialServicesReporting bPFinancialServicesReporting )
    {
        return addRequestUpdate(service::updateBPFinancialServicesReporting, bPFinancialServicesReporting);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createBPFiscalYearInformation(
        @Nonnull final BPFiscalYearInformation bPFiscalYearInformation )
    {
        return addRequestCreate(service::createBPFiscalYearInformation, bPFiscalYearInformation);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateBPFiscalYearInformation(
        @Nonnull final BPFiscalYearInformation bPFiscalYearInformation )
    {
        return addRequestUpdate(service::updateBPFiscalYearInformation, bPFiscalYearInformation);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet deleteBPFiscalYearInformation(
        @Nonnull final BPFiscalYearInformation bPFiscalYearInformation )
    {
        return addRequestDelete(service::deleteBPFiscalYearInformation, bPFiscalYearInformation);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createBPRelationship( @Nonnull final BPRelationship bPRelationship )
    {
        return addRequestCreate(service::createBPRelationship, bPRelationship);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateBPRelationship( @Nonnull final BPRelationship bPRelationship )
    {
        return addRequestUpdate(service::updateBPRelationship, bPRelationship);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet deleteBPRelationship( @Nonnull final BPRelationship bPRelationship )
    {
        return addRequestDelete(service::deleteBPRelationship, bPRelationship);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createBuPaAddressUsage(
        @Nonnull final BuPaAddressUsage buPaAddressUsage )
    {
        return addRequestCreate(service::createBuPaAddressUsage, buPaAddressUsage);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateBuPaAddressUsage(
        @Nonnull final BuPaAddressUsage buPaAddressUsage )
    {
        return addRequestUpdate(service::updateBuPaAddressUsage, buPaAddressUsage);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet deleteBuPaAddressUsage(
        @Nonnull final BuPaAddressUsage buPaAddressUsage )
    {
        return addRequestDelete(service::deleteBuPaAddressUsage, buPaAddressUsage);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createBuPaIdentification(
        @Nonnull final BuPaIdentification buPaIdentification )
    {
        return addRequestCreate(service::createBuPaIdentification, buPaIdentification);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateBuPaIdentification(
        @Nonnull final BuPaIdentification buPaIdentification )
    {
        return addRequestUpdate(service::updateBuPaIdentification, buPaIdentification);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet deleteBuPaIdentification(
        @Nonnull final BuPaIdentification buPaIdentification )
    {
        return addRequestDelete(service::deleteBuPaIdentification, buPaIdentification);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createBuPaIndustry( @Nonnull final BuPaIndustry buPaIndustry )
    {
        return addRequestCreate(service::createBuPaIndustry, buPaIndustry);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateBuPaIndustry( @Nonnull final BuPaIndustry buPaIndustry )
    {
        return addRequestUpdate(service::updateBuPaIndustry, buPaIndustry);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet deleteBuPaIndustry( @Nonnull final BuPaIndustry buPaIndustry )
    {
        return addRequestDelete(service::deleteBuPaIndustry, buPaIndustry);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createBusinessPartner( @Nonnull final BusinessPartner businessPartner )
    {
        return addRequestCreate(service::createBusinessPartner, businessPartner);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateBusinessPartner( @Nonnull final BusinessPartner businessPartner )
    {
        return addRequestUpdate(service::updateBusinessPartner, businessPartner);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createBusinessPartnerAddress(
        @Nonnull final BusinessPartnerAddress businessPartnerAddress )
    {
        return addRequestCreate(service::createBusinessPartnerAddress, businessPartnerAddress);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateBusinessPartnerAddress(
        @Nonnull final BusinessPartnerAddress businessPartnerAddress )
    {
        return addRequestUpdate(service::updateBusinessPartnerAddress, businessPartnerAddress);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet deleteBusinessPartnerAddress(
        @Nonnull final BusinessPartnerAddress businessPartnerAddress )
    {
        return addRequestDelete(service::deleteBusinessPartnerAddress, businessPartnerAddress);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createBusinessPartnerBank(
        @Nonnull final BusinessPartnerBank businessPartnerBank )
    {
        return addRequestCreate(service::createBusinessPartnerBank, businessPartnerBank);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateBusinessPartnerBank(
        @Nonnull final BusinessPartnerBank businessPartnerBank )
    {
        return addRequestUpdate(service::updateBusinessPartnerBank, businessPartnerBank);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet deleteBusinessPartnerBank(
        @Nonnull final BusinessPartnerBank businessPartnerBank )
    {
        return addRequestDelete(service::deleteBusinessPartnerBank, businessPartnerBank);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createBusinessPartnerContact(
        @Nonnull final BusinessPartnerContact businessPartnerContact )
    {
        return addRequestCreate(service::createBusinessPartnerContact, businessPartnerContact);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateBusinessPartnerContact(
        @Nonnull final BusinessPartnerContact businessPartnerContact )
    {
        return addRequestUpdate(service::updateBusinessPartnerContact, businessPartnerContact);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet deleteBusinessPartnerContact(
        @Nonnull final BusinessPartnerContact businessPartnerContact )
    {
        return addRequestDelete(service::deleteBusinessPartnerContact, businessPartnerContact);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createBusinessPartnerRating(
        @Nonnull final BusinessPartnerRating businessPartnerRating )
    {
        return addRequestCreate(service::createBusinessPartnerRating, businessPartnerRating);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateBusinessPartnerRating(
        @Nonnull final BusinessPartnerRating businessPartnerRating )
    {
        return addRequestUpdate(service::updateBusinessPartnerRating, businessPartnerRating);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet deleteBusinessPartnerRating(
        @Nonnull final BusinessPartnerRating businessPartnerRating )
    {
        return addRequestDelete(service::deleteBusinessPartnerRating, businessPartnerRating);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createBusinessPartnerRole(
        @Nonnull final BusinessPartnerRole businessPartnerRole )
    {
        return addRequestCreate(service::createBusinessPartnerRole, businessPartnerRole);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateBusinessPartnerRole(
        @Nonnull final BusinessPartnerRole businessPartnerRole )
    {
        return addRequestUpdate(service::updateBusinessPartnerRole, businessPartnerRole);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createBusinessPartnerTaxNumber(
        @Nonnull final BusinessPartnerTaxNumber businessPartnerTaxNumber )
    {
        return addRequestCreate(service::createBusinessPartnerTaxNumber, businessPartnerTaxNumber);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateBusinessPartnerTaxNumber(
        @Nonnull final BusinessPartnerTaxNumber businessPartnerTaxNumber )
    {
        return addRequestUpdate(service::updateBusinessPartnerTaxNumber, businessPartnerTaxNumber);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet deleteBusinessPartnerTaxNumber(
        @Nonnull final BusinessPartnerTaxNumber businessPartnerTaxNumber )
    {
        return addRequestDelete(service::deleteBusinessPartnerTaxNumber, businessPartnerTaxNumber);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createBusPartAddrDepdntTaxNmbr(
        @Nonnull final BusPartAddrDepdntTaxNmbr busPartAddrDepdntTaxNmbr )
    {
        return addRequestCreate(service::createBusPartAddrDepdntTaxNmbr, busPartAddrDepdntTaxNmbr);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateBusPartAddrDepdntTaxNmbr(
        @Nonnull final BusPartAddrDepdntTaxNmbr busPartAddrDepdntTaxNmbr )
    {
        return addRequestUpdate(service::updateBusPartAddrDepdntTaxNmbr, busPartAddrDepdntTaxNmbr);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet deleteBusPartAddrDepdntTaxNmbr(
        @Nonnull final BusPartAddrDepdntTaxNmbr busPartAddrDepdntTaxNmbr )
    {
        return addRequestDelete(service::deleteBusPartAddrDepdntTaxNmbr, busPartAddrDepdntTaxNmbr);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createCustAddrDepdntExtIdentifier(
        @Nonnull final CustAddrDepdntExtIdentifier custAddrDepdntExtIdentifier )
    {
        return addRequestCreate(service::createCustAddrDepdntExtIdentifier, custAddrDepdntExtIdentifier);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateCustAddrDepdntExtIdentifier(
        @Nonnull final CustAddrDepdntExtIdentifier custAddrDepdntExtIdentifier )
    {
        return addRequestUpdate(service::updateCustAddrDepdntExtIdentifier, custAddrDepdntExtIdentifier);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet deleteCustAddrDepdntExtIdentifier(
        @Nonnull final CustAddrDepdntExtIdentifier custAddrDepdntExtIdentifier )
    {
        return addRequestDelete(service::deleteCustAddrDepdntExtIdentifier, custAddrDepdntExtIdentifier);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createCustAddrDepdntInformation(
        @Nonnull final CustAddrDepdntInformation custAddrDepdntInformation )
    {
        return addRequestCreate(service::createCustAddrDepdntInformation, custAddrDepdntInformation);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateCustAddrDepdntInformation(
        @Nonnull final CustAddrDepdntInformation custAddrDepdntInformation )
    {
        return addRequestUpdate(service::updateCustAddrDepdntInformation, custAddrDepdntInformation);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet deleteCustAddrDepdntInformation(
        @Nonnull final CustAddrDepdntInformation custAddrDepdntInformation )
    {
        return addRequestDelete(service::deleteCustAddrDepdntInformation, custAddrDepdntInformation);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createCustomer( @Nonnull final Customer customer )
    {
        return addRequestCreate(service::createCustomer, customer);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateCustomer( @Nonnull final Customer customer )
    {
        return addRequestUpdate(service::updateCustomer, customer);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createCustomerCompany( @Nonnull final CustomerCompany customerCompany )
    {
        return addRequestCreate(service::createCustomerCompany, customerCompany);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateCustomerCompany( @Nonnull final CustomerCompany customerCompany )
    {
        return addRequestUpdate(service::updateCustomerCompany, customerCompany);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createCustomerCompanyText(
        @Nonnull final CustomerCompanyText customerCompanyText )
    {
        return addRequestCreate(service::createCustomerCompanyText, customerCompanyText);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateCustomerCompanyText(
        @Nonnull final CustomerCompanyText customerCompanyText )
    {
        return addRequestUpdate(service::updateCustomerCompanyText, customerCompanyText);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet deleteCustomerCompanyText(
        @Nonnull final CustomerCompanyText customerCompanyText )
    {
        return addRequestDelete(service::deleteCustomerCompanyText, customerCompanyText);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createCustomerDunning( @Nonnull final CustomerDunning customerDunning )
    {
        return addRequestCreate(service::createCustomerDunning, customerDunning);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateCustomerDunning( @Nonnull final CustomerDunning customerDunning )
    {
        return addRequestUpdate(service::updateCustomerDunning, customerDunning);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet deleteCustomerDunning( @Nonnull final CustomerDunning customerDunning )
    {
        return addRequestDelete(service::deleteCustomerDunning, customerDunning);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createCustomerSalesArea(
        @Nonnull final CustomerSalesArea customerSalesArea )
    {
        return addRequestCreate(service::createCustomerSalesArea, customerSalesArea);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateCustomerSalesArea(
        @Nonnull final CustomerSalesArea customerSalesArea )
    {
        return addRequestUpdate(service::updateCustomerSalesArea, customerSalesArea);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createCustomerSalesAreaTax(
        @Nonnull final CustomerSalesAreaTax customerSalesAreaTax )
    {
        return addRequestCreate(service::createCustomerSalesAreaTax, customerSalesAreaTax);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateCustomerSalesAreaTax(
        @Nonnull final CustomerSalesAreaTax customerSalesAreaTax )
    {
        return addRequestUpdate(service::updateCustomerSalesAreaTax, customerSalesAreaTax);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createCustomerSalesAreaText(
        @Nonnull final CustomerSalesAreaText customerSalesAreaText )
    {
        return addRequestCreate(service::createCustomerSalesAreaText, customerSalesAreaText);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateCustomerSalesAreaText(
        @Nonnull final CustomerSalesAreaText customerSalesAreaText )
    {
        return addRequestUpdate(service::updateCustomerSalesAreaText, customerSalesAreaText);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet deleteCustomerSalesAreaText(
        @Nonnull final CustomerSalesAreaText customerSalesAreaText )
    {
        return addRequestDelete(service::deleteCustomerSalesAreaText, customerSalesAreaText);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateCustomerTaxGrouping(
        @Nonnull final CustomerTaxGrouping customerTaxGrouping )
    {
        return addRequestUpdate(service::updateCustomerTaxGrouping, customerTaxGrouping);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet deleteCustomerTaxGrouping(
        @Nonnull final CustomerTaxGrouping customerTaxGrouping )
    {
        return addRequestDelete(service::deleteCustomerTaxGrouping, customerTaxGrouping);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createCustomerText( @Nonnull final CustomerText customerText )
    {
        return addRequestCreate(service::createCustomerText, customerText);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateCustomerText( @Nonnull final CustomerText customerText )
    {
        return addRequestUpdate(service::updateCustomerText, customerText);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet deleteCustomerText( @Nonnull final CustomerText customerText )
    {
        return addRequestDelete(service::deleteCustomerText, customerText);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createCustomerUnloadingPoint(
        @Nonnull final CustomerUnloadingPoint customerUnloadingPoint )
    {
        return addRequestCreate(service::createCustomerUnloadingPoint, customerUnloadingPoint);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateCustomerUnloadingPoint(
        @Nonnull final CustomerUnloadingPoint customerUnloadingPoint )
    {
        return addRequestUpdate(service::updateCustomerUnloadingPoint, customerUnloadingPoint);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet deleteCustomerUnloadingPoint(
        @Nonnull final CustomerUnloadingPoint customerUnloadingPoint )
    {
        return addRequestDelete(service::deleteCustomerUnloadingPoint, customerUnloadingPoint);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createCustomerWithHoldingTax(
        @Nonnull final CustomerWithHoldingTax customerWithHoldingTax )
    {
        return addRequestCreate(service::createCustomerWithHoldingTax, customerWithHoldingTax);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateCustomerWithHoldingTax(
        @Nonnull final CustomerWithHoldingTax customerWithHoldingTax )
    {
        return addRequestUpdate(service::updateCustomerWithHoldingTax, customerWithHoldingTax);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet deleteCustomerWithHoldingTax(
        @Nonnull final CustomerWithHoldingTax customerWithHoldingTax )
    {
        return addRequestDelete(service::deleteCustomerWithHoldingTax, customerWithHoldingTax);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createCustSalesPartnerFunc(
        @Nonnull final CustSalesPartnerFunc custSalesPartnerFunc )
    {
        return addRequestCreate(service::createCustSalesPartnerFunc, custSalesPartnerFunc);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateCustSalesPartnerFunc(
        @Nonnull final CustSalesPartnerFunc custSalesPartnerFunc )
    {
        return addRequestUpdate(service::updateCustSalesPartnerFunc, custSalesPartnerFunc);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet deleteCustSalesPartnerFunc(
        @Nonnull final CustSalesPartnerFunc custSalesPartnerFunc )
    {
        return addRequestDelete(service::deleteCustSalesPartnerFunc, custSalesPartnerFunc);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createCustSlsAreaAddrDepdntInfo(
        @Nonnull final CustSlsAreaAddrDepdntInfo custSlsAreaAddrDepdntInfo )
    {
        return addRequestCreate(service::createCustSlsAreaAddrDepdntInfo, custSlsAreaAddrDepdntInfo);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateCustSlsAreaAddrDepdntInfo(
        @Nonnull final CustSlsAreaAddrDepdntInfo custSlsAreaAddrDepdntInfo )
    {
        return addRequestUpdate(service::updateCustSlsAreaAddrDepdntInfo, custSlsAreaAddrDepdntInfo);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet deleteCustSlsAreaAddrDepdntInfo(
        @Nonnull final CustSlsAreaAddrDepdntInfo custSlsAreaAddrDepdntInfo )
    {
        return addRequestDelete(service::deleteCustSlsAreaAddrDepdntInfo, custSlsAreaAddrDepdntInfo);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createCustSlsAreaAddrDepdntTaxInfo(
        @Nonnull final CustSlsAreaAddrDepdntTaxInfo custSlsAreaAddrDepdntTaxInfo )
    {
        return addRequestCreate(service::createCustSlsAreaAddrDepdntTaxInfo, custSlsAreaAddrDepdntTaxInfo);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateCustSlsAreaAddrDepdntTaxInfo(
        @Nonnull final CustSlsAreaAddrDepdntTaxInfo custSlsAreaAddrDepdntTaxInfo )
    {
        return addRequestUpdate(service::updateCustSlsAreaAddrDepdntTaxInfo, custSlsAreaAddrDepdntTaxInfo);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet deleteCustSlsAreaAddrDepdntTaxInfo(
        @Nonnull final CustSlsAreaAddrDepdntTaxInfo custSlsAreaAddrDepdntTaxInfo )
    {
        return addRequestDelete(service::deleteCustSlsAreaAddrDepdntTaxInfo, custSlsAreaAddrDepdntTaxInfo);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createCustUnldgPtAddrDepdntInfo(
        @Nonnull final CustUnldgPtAddrDepdntInfo custUnldgPtAddrDepdntInfo )
    {
        return addRequestCreate(service::createCustUnldgPtAddrDepdntInfo, custUnldgPtAddrDepdntInfo);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateCustUnldgPtAddrDepdntInfo(
        @Nonnull final CustUnldgPtAddrDepdntInfo custUnldgPtAddrDepdntInfo )
    {
        return addRequestUpdate(service::updateCustUnldgPtAddrDepdntInfo, custUnldgPtAddrDepdntInfo);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet deleteCustUnldgPtAddrDepdntInfo(
        @Nonnull final CustUnldgPtAddrDepdntInfo custUnldgPtAddrDepdntInfo )
    {
        return addRequestDelete(service::deleteCustUnldgPtAddrDepdntInfo, custUnldgPtAddrDepdntInfo);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createSupplier( @Nonnull final Supplier supplier )
    {
        return addRequestCreate(service::createSupplier, supplier);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateSupplier( @Nonnull final Supplier supplier )
    {
        return addRequestUpdate(service::updateSupplier, supplier);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createSupplierCompany( @Nonnull final SupplierCompany supplierCompany )
    {
        return addRequestCreate(service::createSupplierCompany, supplierCompany);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateSupplierCompany( @Nonnull final SupplierCompany supplierCompany )
    {
        return addRequestUpdate(service::updateSupplierCompany, supplierCompany);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createSupplierCompanyText(
        @Nonnull final SupplierCompanyText supplierCompanyText )
    {
        return addRequestCreate(service::createSupplierCompanyText, supplierCompanyText);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateSupplierCompanyText(
        @Nonnull final SupplierCompanyText supplierCompanyText )
    {
        return addRequestUpdate(service::updateSupplierCompanyText, supplierCompanyText);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet deleteSupplierCompanyText(
        @Nonnull final SupplierCompanyText supplierCompanyText )
    {
        return addRequestDelete(service::deleteSupplierCompanyText, supplierCompanyText);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createSupplierDunning( @Nonnull final SupplierDunning supplierDunning )
    {
        return addRequestCreate(service::createSupplierDunning, supplierDunning);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateSupplierDunning( @Nonnull final SupplierDunning supplierDunning )
    {
        return addRequestUpdate(service::updateSupplierDunning, supplierDunning);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet deleteSupplierDunning( @Nonnull final SupplierDunning supplierDunning )
    {
        return addRequestDelete(service::deleteSupplierDunning, supplierDunning);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createSupplierPartnerFunc(
        @Nonnull final SupplierPartnerFunc supplierPartnerFunc )
    {
        return addRequestCreate(service::createSupplierPartnerFunc, supplierPartnerFunc);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateSupplierPartnerFunc(
        @Nonnull final SupplierPartnerFunc supplierPartnerFunc )
    {
        return addRequestUpdate(service::updateSupplierPartnerFunc, supplierPartnerFunc);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet deleteSupplierPartnerFunc(
        @Nonnull final SupplierPartnerFunc supplierPartnerFunc )
    {
        return addRequestDelete(service::deleteSupplierPartnerFunc, supplierPartnerFunc);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createSupplierPurchasingOrg(
        @Nonnull final SupplierPurchasingOrg supplierPurchasingOrg )
    {
        return addRequestCreate(service::createSupplierPurchasingOrg, supplierPurchasingOrg);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateSupplierPurchasingOrg(
        @Nonnull final SupplierPurchasingOrg supplierPurchasingOrg )
    {
        return addRequestUpdate(service::updateSupplierPurchasingOrg, supplierPurchasingOrg);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createSupplierPurchasingOrgText(
        @Nonnull final SupplierPurchasingOrgText supplierPurchasingOrgText )
    {
        return addRequestCreate(service::createSupplierPurchasingOrgText, supplierPurchasingOrgText);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateSupplierPurchasingOrgText(
        @Nonnull final SupplierPurchasingOrgText supplierPurchasingOrgText )
    {
        return addRequestUpdate(service::updateSupplierPurchasingOrgText, supplierPurchasingOrgText);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet deleteSupplierPurchasingOrgText(
        @Nonnull final SupplierPurchasingOrgText supplierPurchasingOrgText )
    {
        return addRequestDelete(service::deleteSupplierPurchasingOrgText, supplierPurchasingOrgText);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createSupplierText( @Nonnull final SupplierText supplierText )
    {
        return addRequestCreate(service::createSupplierText, supplierText);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateSupplierText( @Nonnull final SupplierText supplierText )
    {
        return addRequestUpdate(service::updateSupplierText, supplierText);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet deleteSupplierText( @Nonnull final SupplierText supplierText )
    {
        return addRequestDelete(service::deleteSupplierText, supplierText);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet createSupplierWithHoldingTax(
        @Nonnull final SupplierWithHoldingTax supplierWithHoldingTax )
    {
        return addRequestCreate(service::createSupplierWithHoldingTax, supplierWithHoldingTax);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet updateSupplierWithHoldingTax(
        @Nonnull final SupplierWithHoldingTax supplierWithHoldingTax )
    {
        return addRequestUpdate(service::updateSupplierWithHoldingTax, supplierWithHoldingTax);
    }

    @Nonnull
    @Override
    public BusinessPartnerServiceBatchChangeSet deleteSupplierWithHoldingTax(
        @Nonnull final SupplierWithHoldingTax supplierWithHoldingTax )
    {
        return addRequestDelete(service::deleteSupplierWithHoldingTax, supplierWithHoldingTax);
    }

}
