/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumber;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumber AddressFaxNumber}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.field.AddressFaxNumberField
 * AddressFaxNumberField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.link.AddressFaxNumberLink
 * AddressFaxNumberLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumber#ADDRESS_ID
 * ADDRESS_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumber#PERSON PERSON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumber#ORDINAL_NUMBER
 * ORDINAL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumber#IS_DEFAULT_FAX_NUMBER
 * IS_DEFAULT_FAX_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumber#FAX_COUNTRY
 * FAX_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumber#FAX_NUMBER
 * FAX_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumber#FAX_NUMBER_EXTENSION
 * FAX_NUMBER_EXTENSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumber#INTERNATIONAL_FAX_NUMBER
 * INTERNATIONAL_FAX_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressFaxNumber#ADDRESS_COMMUNICATION_REMARK_TEXT
 * ADDRESS_COMMUNICATION_REMARK_TEXT}</li>
 * </ul>
 *
 */
public interface AddressFaxNumberSelectable extends EntitySelectable<AddressFaxNumber>
{

}
