/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumber;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumber AddressPhoneNumber}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.field.AddressPhoneNumberField
 * AddressPhoneNumberField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.link.AddressPhoneNumberLink
 * AddressPhoneNumberLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumber#ADDRESS_ID
 * ADDRESS_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumber#PERSON PERSON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumber#ORDINAL_NUMBER
 * ORDINAL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumber#DESTINATION_LOCATION_COUNTRY
 * DESTINATION_LOCATION_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumber#IS_DEFAULT_PHONE_NUMBER
 * IS_DEFAULT_PHONE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumber#PHONE_NUMBER
 * PHONE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumber#PHONE_NUMBER_EXTENSION
 * PHONE_NUMBER_EXTENSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumber#INTERNATIONAL_PHONE_NUMBER
 * INTERNATIONAL_PHONE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumber#PHONE_NUMBER_TYPE
 * PHONE_NUMBER_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.AddressPhoneNumber#ADDRESS_COMMUNICATION_REMARK_TEXT
 * ADDRESS_COMMUNICATION_REMARK_TEXT}</li>
 * </ul>
 *
 */
public interface AddressPhoneNumberSelectable extends EntitySelectable<AddressPhoneNumber>
{

}
