/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumber;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumber
 * BPAddrDepdntIntlLocNumber}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.field.BPAddrDepdntIntlLocNumberField
 * BPAddrDepdntIntlLocNumberField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.link.BPAddrDepdntIntlLocNumberLink
 * BPAddrDepdntIntlLocNumberLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumber#BUSINESS_PARTNER
 * BUSINESS_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumber#ADDRESS_ID
 * ADDRESS_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumber#INTERNATIONAL_LOCATION_NUMBER1
 * INTERNATIONAL_LOCATION_NUMBER1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumber#INTERNATIONAL_LOCATION_NUMBER2
 * INTERNATIONAL_LOCATION_NUMBER2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPAddrDepdntIntlLocNumber#INTERNATIONAL_LOCATION_NUMBER3
 * INTERNATIONAL_LOCATION_NUMBER3}</li>
 * </ul>
 *
 */
public interface BPAddrDepdntIntlLocNumberSelectable extends EntitySelectable<BPAddrDepdntIntlLocNumber>
{

}
