/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress BPContactToAddress}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.field.BPContactToAddressField
 * BPContactToAddressField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.link.BPContactToAddressLink
 * BPContactToAddressLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#RELATIONSHIP_NUMBER
 * RELATIONSHIP_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#BUSINESS_PARTNER_COMPANY
 * BUSINESS_PARTNER_COMPANY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#BUSINESS_PARTNER_PERSON
 * BUSINESS_PARTNER_PERSON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#ADDRESS_ID
 * ADDRESS_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#ADDRESS_NUMBER
 * ADDRESS_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#ADDITIONAL_STREET_PREFIX_NAME
 * ADDITIONAL_STREET_PREFIX_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#ADDITIONAL_STREET_SUFFIX_NAME
 * ADDITIONAL_STREET_SUFFIX_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#ADDRESS_TIME_ZONE
 * ADDRESS_TIME_ZONE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#CARE_OF_NAME
 * CARE_OF_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#CITY_CODE
 * CITY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#CITY_NAME
 * CITY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#COMPANY_POSTAL_CODE
 * COMPANY_POSTAL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#COUNTRY
 * COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#COUNTY COUNTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#DELIVERY_SERVICE_NUMBER
 * DELIVERY_SERVICE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#DELIVERY_SERVICE_TYPE_CODE
 * DELIVERY_SERVICE_TYPE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#DISTRICT
 * DISTRICT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#FORM_OF_ADDRESS
 * FORM_OF_ADDRESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#FULL_NAME
 * FULL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#HOME_CITY_NAME
 * HOME_CITY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#HOUSE_NUMBER
 * HOUSE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#HOUSE_NUMBER_SUPPLEMENT_TEXT
 * HOUSE_NUMBER_SUPPLEMENT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#PO_BOX PO_BOX}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#PO_BOX_DEVIATING_CITY_NAME
 * PO_BOX_DEVIATING_CITY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#PO_BOX_DEVIATING_COUNTRY
 * PO_BOX_DEVIATING_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#PO_BOX_DEVIATING_REGION
 * PO_BOX_DEVIATING_REGION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#PO_BOX_IS_WITHOUT_NUMBER
 * PO_BOX_IS_WITHOUT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#PO_BOX_LOBBY_NAME
 * PO_BOX_LOBBY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#PO_BOX_POSTAL_CODE
 * PO_BOX_POSTAL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#PERSON PERSON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#POSTAL_CODE
 * POSTAL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#PRFRD_COMM_MEDIUM_TYPE
 * PRFRD_COMM_MEDIUM_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#REGION REGION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#STREET_NAME
 * STREET_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#STREET_PREFIX_NAME
 * STREET_PREFIX_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#STREET_SUFFIX_NAME
 * STREET_SUFFIX_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#TAX_JURISDICTION
 * TAX_JURISDICTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#TRANSPORT_ZONE
 * TRANSPORT_ZONE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#ADDRESS_REPRESENTATION_CODE
 * ADDRESS_REPRESENTATION_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#CONTACT_RELATIONSHIP_FUNCTION
 * CONTACT_RELATIONSHIP_FUNCTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#CONTACT_RELATIONSHIP_DEPARTMENT
 * CONTACT_RELATIONSHIP_DEPARTMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#FLOOR FLOOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#CONTACT_PERSON_BUILDING
 * CONTACT_PERSON_BUILDING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#ROOM_NUMBER
 * ROOM_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#CONTACT_PERSON_PRFRD_COMM_MEDIUM
 * CONTACT_PERSON_PRFRD_COMM_MEDIUM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#CORRESPONDENCE_SHORT_NAME
 * CORRESPONDENCE_SHORT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#INHOUSE_MAIL
 * INHOUSE_MAIL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#TO_EMAIL_ADDRESS
 * TO_EMAIL_ADDRESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#TO_FAX_NUMBER
 * TO_FAX_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#TO_MOBILE_PHONE_NUMBER
 * TO_MOBILE_PHONE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#TO_PHONE_NUMBER
 * TO_PHONE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPContactToAddress#TO_URL_ADDRESS
 * TO_URL_ADDRESS}</li>
 * </ul>
 *
 */
public interface BPContactToAddressSelectable extends EntitySelectable<BPContactToAddress>
{

}
