/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthiness;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthiness BPCreditWorthiness}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.field.BPCreditWorthinessField
 * BPCreditWorthinessField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.link.BPCreditWorthinessLink
 * BPCreditWorthinessLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthiness#BUSINESS_PARTNER
 * BUSINESS_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthiness#BUS_PART_CREDIT_STANDING
 * BUS_PART_CREDIT_STANDING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthiness#BP_CREDIT_STANDING_STATUS
 * BP_CREDIT_STANDING_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthiness#CREDIT_RATING_AGENCY
 * CREDIT_RATING_AGENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthiness#BP_CREDIT_STANDING_COMMENT
 * BP_CREDIT_STANDING_COMMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthiness#BP_CREDIT_STANDING_DATE
 * BP_CREDIT_STANDING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthiness#BP_CREDIT_STANDING_RATING
 * BP_CREDIT_STANDING_RATING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthiness#BP_LEGAL_PROCEEDING_STATUS
 * BP_LEGAL_PROCEEDING_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthiness#BP_LGL_PROCEEDING_INITIATION_DATE
 * BP_LGL_PROCEEDING_INITIATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthiness#BUSINESS_PARTNER_IS_UNDER_OATH
 * BUSINESS_PARTNER_IS_UNDER_OATH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthiness#BUSINESS_PARTNER_OATH_DATE
 * BUSINESS_PARTNER_OATH_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthiness#BUSINESS_PARTNER_IS_BANKRUPT
 * BUSINESS_PARTNER_IS_BANKRUPT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthiness#BUSINESS_PARTNER_BANKRUPTCY_DATE
 * BUSINESS_PARTNER_BANKRUPTCY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthiness#BP_FORECLOSURE_IS_INITIATED
 * BP_FORECLOSURE_IS_INITIATED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthiness#BP_FORECLOSURE_DATE
 * BP_FORECLOSURE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPCreditWorthiness#BP_CRDT_WRTHNSS_ACCESS_CHK_IS_ACTIVE
 * BP_CRDT_WRTHNSS_ACCESS_CHK_IS_ACTIVE}</li>
 * </ul>
 *
 */
public interface BPCreditWorthinessSelectable extends EntitySelectable<BPCreditWorthiness>
{

}
