/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn
 * BPFinancialServicesExtn}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.field.BPFinancialServicesExtnField
 * BPFinancialServicesExtnField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.link.BPFinancialServicesExtnLink
 * BPFinancialServicesExtnLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn#BUSINESS_PARTNER
 * BUSINESS_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn#BUSINESS_PARTNER_IS_VIP
 * BUSINESS_PARTNER_IS_VIP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn#TRADING_PARTNER
 * TRADING_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn#FACTORY_CALENDAR
 * FACTORY_CALENDAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn#BUSINESS_PARTNER_OFFICE_COUNTRY
 * BUSINESS_PARTNER_OFFICE_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn#BUSINESS_PARTNER_OFFICE_REGION
 * BUSINESS_PARTNER_OFFICE_REGION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn#BP_REGISTERED_OFFICE_NAME
 * BP_REGISTERED_OFFICE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn#BP_BALANCE_SHEET_CURRENCY
 * BP_BALANCE_SHEET_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn#BP_LAST_CPTL_INCR_AMT_IN_BAL_SHT_CRCY
 * BP_LAST_CPTL_INCR_AMT_IN_BAL_SHT_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn#BP_LAST_CAPITAL_INCREASE_YEAR
 * BP_LAST_CAPITAL_INCREASE_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn#BP_BALANCE_SHEET_DISPLAY_TYPE
 * BP_BALANCE_SHEET_DISPLAY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn#BUSINESS_PARTNER_CITIZENSHIP
 * BUSINESS_PARTNER_CITIZENSHIP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn#BP_MARITAL_PROPERTY_REGIME
 * BP_MARITAL_PROPERTY_REGIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn#BUSINESS_PARTNER_INCOME_CURRENCY
 * BUSINESS_PARTNER_INCOME_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn#BP_NUMBER_OF_CHILDREN
 * BP_NUMBER_OF_CHILDREN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn#BP_NUMBER_OF_HOUSEHOLD_MEMBERS
 * BP_NUMBER_OF_HOUSEHOLD_MEMBERS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn#BP_ANNUAL_NET_INC_AMT_IN_INCOME_CRCY
 * BP_ANNUAL_NET_INC_AMT_IN_INCOME_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn#BP_MONTHLY_NET_INC_AMT_IN_INCOME_CRCY
 * BP_MONTHLY_NET_INC_AMT_IN_INCOME_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn#BP_ANNUAL_NET_INCOME_YEAR
 * BP_ANNUAL_NET_INCOME_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn#BP_MONTHLY_NET_INCOME_MONTH
 * BP_MONTHLY_NET_INCOME_MONTH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn#BP_MONTHLY_NET_INCOME_YEAR
 * BP_MONTHLY_NET_INCOME_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn#BP_PLACE_OF_DEATH_NAME
 * BP_PLACE_OF_DEATH_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn#CUSTOMER_IS_UNWANTED
 * CUSTOMER_IS_UNWANTED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn#UNDESIRABILITY_REASON
 * UNDESIRABILITY_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn#UNDESIRABILITY_COMMENT
 * UNDESIRABILITY_COMMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn#LAST_CUSTOMER_CONTACT_DATE
 * LAST_CUSTOMER_CONTACT_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn#BP_GROUPING_CHARACTER
 * BP_GROUPING_CHARACTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn#BP_LETTER_SALUTATION
 * BP_LETTER_SALUTATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn#BUSINESS_PARTNER_TARGET_GROUP
 * BUSINESS_PARTNER_TARGET_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn#BUSINESS_PARTNER_EMPLOYEE_GROUP
 * BUSINESS_PARTNER_EMPLOYEE_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn#BUSINESS_PARTNER_IS_EMPLOYEE
 * BUSINESS_PARTNER_IS_EMPLOYEE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesExtn#BP_TERMN_BUS_RELATIONS_BANK_DATE
 * BP_TERMN_BUS_RELATIONS_BANK_DATE}</li>
 * </ul>
 *
 */
public interface BPFinancialServicesExtnSelectable extends EntitySelectable<BPFinancialServicesExtn>
{

}
