/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting
 * BPFinancialServicesReporting}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.field.BPFinancialServicesReportingField
 * BPFinancialServicesReportingField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.link.BPFinancialServicesReportingLink
 * BPFinancialServicesReportingLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting#BUSINESS_PARTNER
 * BUSINESS_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting#BP_IS_NON_RESIDENT
 * BP_IS_NON_RESIDENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting#BP_NON_RESIDENCY_START_DATE
 * BP_NON_RESIDENCY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting#BP_IS_MULTIMILLION_LOAN_RECIPIENT
 * BP_IS_MULTIMILLION_LOAN_RECIPIENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting#BP_LOAN_REPORTING_BORROWER_NUMBER
 * BP_LOAN_REPORTING_BORROWER_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting#BP_LOAN_RPTG_BORROWER_ENTITY_NUMBER
 * BP_LOAN_RPTG_BORROWER_ENTITY_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting#BP_CREDIT_STANDING_REVIEW
 * BP_CREDIT_STANDING_REVIEW}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting#BP_CREDIT_STANDING_REVIEW_DATE
 * BP_CREDIT_STANDING_REVIEW_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting#BUSINESS_PARTNER_LOAN_TO_MANAGER
 * BUSINESS_PARTNER_LOAN_TO_MANAGER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting#BP_COMPANY_RELATIONSHIP
 * BP_COMPANY_RELATIONSHIP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting#BP_LOAN_REPORTING_CREDITOR_NUMBER
 * BP_LOAN_REPORTING_CREDITOR_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting#BP_OE_NB_IDENT_NUMBER
 * BP_OE_NB_IDENT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting#BP_OE_NB_TARGET_GROUP
 * BP_OE_NB_TARGET_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting#BP_OE_NB_IDENT_NUMBER_ASSIGNED
 * BP_OE_NB_IDENT_NUMBER_ASSIGNED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting#BP_OE_NB_INSTITUTE_NUMBER
 * BP_OE_NB_INSTITUTE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting#BUSINESS_PARTNER_IS_OE_NB_INSTITUTE
 * BUSINESS_PARTNER_IS_OE_NB_INSTITUTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting#BUSINESS_PARTNER_GROUP
 * BUSINESS_PARTNER_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting#BP_GROUP_ASSIGNMENT_CATEGORY
 * BP_GROUP_ASSIGNMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting#BUSINESS_PARTNER_GROUP_NAME
 * BUSINESS_PARTNER_GROUP_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting#BUSINESS_PARTNER_LEGAL_ENTITY
 * BUSINESS_PARTNER_LEGAL_ENTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting#BP_GER_AST_RGLN_RESTRICTED_AST_QUOTA
 * BP_GER_AST_RGLN_RESTRICTED_AST_QUOTA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting#BUSINESS_PARTNER_DEBTOR_GROUP
 * BUSINESS_PARTNER_DEBTOR_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting#BUSINESS_PARTNER_BUSINESS_PURPOSE
 * BUSINESS_PARTNER_BUSINESS_PURPOSE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting#BUSINESS_PARTNER_RISK_GROUP
 * BUSINESS_PARTNER_RISK_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting#BP_RISK_GROUPING_DATE
 * BP_RISK_GROUPING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting#BP_HAS_GROUP_AFFILIATION
 * BP_HAS_GROUP_AFFILIATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting#BP_IS_MONETARY_FIN_INSTITUTION
 * BP_IS_MONETARY_FIN_INSTITUTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting#BP_CRDT_STANDING_REVIEW_IS_REQUIRED
 * BP_CRDT_STANDING_REVIEW_IS_REQUIRED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting#BP_LOAN_MONITORING_IS_REQUIRED
 * BP_LOAN_MONITORING_IS_REQUIRED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting#BP_HAS_CREDITING_RELIEF
 * BP_HAS_CREDITING_RELIEF}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting#BP_INVEST_IN_RSTRCD_AST_IS_AUTHZD
 * BP_INVEST_IN_RSTRCD_AST_IS_AUTHZD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFinancialServicesReporting#BP_CENTRAL_BANK_COUNTRY_REGION
 * BP_CENTRAL_BANK_COUNTRY_REGION}</li>
 * </ul>
 *
 */
public interface BPFinancialServicesReportingSelectable extends EntitySelectable<BPFinancialServicesReporting>
{

}
