/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation
 * BPFiscalYearInformation}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.field.BPFiscalYearInformationField
 * BPFiscalYearInformationField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.link.BPFiscalYearInformationLink
 * BPFiscalYearInformationLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation#BUSINESS_PARTNER
 * BUSINESS_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation#BUSINESS_PARTNER_FISCAL_YEAR
 * BUSINESS_PARTNER_FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation#BP_BALANCE_SHEET_CURRENCY
 * BP_BALANCE_SHEET_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation#BP_ANNUAL_STOCKHOLDER_MEETING_DATE
 * BP_ANNUAL_STOCKHOLDER_MEETING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation#BP_FISCAL_YEAR_START_DATE
 * BP_FISCAL_YEAR_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation#BP_FISCAL_YEAR_END_DATE
 * BP_FISCAL_YEAR_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation#BP_FISCAL_YEAR_IS_CLOSED
 * BP_FISCAL_YEAR_IS_CLOSED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation#BP_FISCAL_YEAR_CLOSING_DATE
 * BP_FISCAL_YEAR_CLOSING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation#BP_FSCL_YR_CNSLDTD_FIN_STATEMENT_DTE
 * BP_FSCL_YR_CNSLDTD_FIN_STATEMENT_DTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation#BP_CAPITAL_STOCK_AMT_IN_BAL_SHT_CRCY
 * BP_CAPITAL_STOCK_AMT_IN_BAL_SHT_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation#BP_ISSD_STOCK_CPTL_AMT_IN_BAL_SHT_CRCY
 * BP_ISSD_STOCK_CPTL_AMT_IN_BAL_SHT_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation#BP_PARTCIPN_CERT_AMT_IN_BAL_SHT_CRCY
 * BP_PARTCIPN_CERT_AMT_IN_BAL_SHT_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation#BP_EQUITY_CAPITAL_AMT_IN_BAL_SHT_CRCY
 * BP_EQUITY_CAPITAL_AMT_IN_BAL_SHT_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation#BP_GROSS_PREMIUM_AMT_IN_BAL_SHT_CRCY
 * BP_GROSS_PREMIUM_AMT_IN_BAL_SHT_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation#BP_NET_PREMIUM_AMT_IN_BAL_SHT_CRCY
 * BP_NET_PREMIUM_AMT_IN_BAL_SHT_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation#BP_ANNUAL_SALES_AMT_IN_BAL_SHT_CRCY
 * BP_ANNUAL_SALES_AMT_IN_BAL_SHT_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation#BP_ANNUAL_NET_INC_AMT_IN_BAL_SHT_CRCY
 * BP_ANNUAL_NET_INC_AMT_IN_BAL_SHT_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation#BP_DIVIDEND_DISTR_AMT_IN_BAL_SHT_CRCY
 * BP_DIVIDEND_DISTR_AMT_IN_BAL_SHT_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation#BP_DEBT_RATIO_IN_YEARS
 * BP_DEBT_RATIO_IN_YEARS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation#BP_ANNUAL_PN_L_AMT_IN_BAL_SHT_CRCY
 * BP_ANNUAL_PN_L_AMT_IN_BAL_SHT_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation#BP_BAL_SHEET_TOTAL_AMT_IN_BAL_SHT_CRCY
 * BP_BAL_SHEET_TOTAL_AMT_IN_BAL_SHT_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation#BP_NUMBER_OF_EMPLOYEES
 * BP_NUMBER_OF_EMPLOYEES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation#BP_CPTL_RESERVE_AMT_IN_BAL_SHT_CRCY
 * BP_CPTL_RESERVE_AMT_IN_BAL_SHT_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation#BP_LGL_REVN_RSRV_AMT_IN_BAL_SHT_CRCY
 * BP_LGL_REVN_RSRV_AMT_IN_BAL_SHT_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation#REVN_RSRV_OWN_STK_AMT_IN_BAL_SHT_CRCY
 * REVN_RSRV_OWN_STK_AMT_IN_BAL_SHT_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation#BP_STATRY_RESERVE_AMT_IN_BAL_SHT_CRCY
 * BP_STATRY_RESERVE_AMT_IN_BAL_SHT_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation#BP_OTH_REVN_RSRV_AMT_IN_BAL_SHT_CRCY
 * BP_OTH_REVN_RSRV_AMT_IN_BAL_SHT_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation#BP_PN_L_CARRYFWD_AMT_IN_BAL_SHT_CRCY
 * BP_PN_L_CARRYFWD_AMT_IN_BAL_SHT_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation#BP_SUBORDD_LBLTY_AMT_IN_BAL_SHT_CRCY
 * BP_SUBORDD_LBLTY_AMT_IN_BAL_SHT_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation#BP_RET_ON_TOTAL_CPTL_EMPLD_IN_PERCENT
 * BP_RET_ON_TOTAL_CPTL_EMPLD_IN_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation#BP_DEBT_CLEARANCE_PERIOD_IN_YEARS
 * BP_DEBT_CLEARANCE_PERIOD_IN_YEARS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation#BP_FINANCING_COEFF_IN_PERCENT
 * BP_FINANCING_COEFF_IN_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BPFiscalYearInformation#BP_EQUITY_RATIO_IN_PERCENT
 * BP_EQUITY_RATIO_IN_PERCENT}</li>
 * </ul>
 *
 */
public interface BPFiscalYearInformationSelectable extends EntitySelectable<BPFiscalYearInformation>
{

}
