/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustry;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustry BuPaIndustry}. This interface
 * is used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.field.BuPaIndustryField
 * BuPaIndustryField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.link.BuPaIndustryLink BuPaIndustryLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustry#INDUSTRY_SECTOR
 * INDUSTRY_SECTOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustry#INDUSTRY_SYSTEM_TYPE
 * INDUSTRY_SYSTEM_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustry#BUSINESS_PARTNER
 * BUSINESS_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustry#IS_STANDARD_INDUSTRY
 * IS_STANDARD_INDUSTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BuPaIndustry#INDUSTRY_KEY_DESCRIPTION
 * INDUSTRY_KEY_DESCRIPTION}</li>
 * </ul>
 *
 */
public interface BuPaIndustrySelectable extends EntitySelectable<BuPaIndustry>
{

}
