/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbr;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbr
 * BusPartAddrDepdntTaxNmbr}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.field.BusPartAddrDepdntTaxNmbrField
 * BusPartAddrDepdntTaxNmbrField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.link.BusPartAddrDepdntTaxNmbrLink
 * BusPartAddrDepdntTaxNmbrLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbr#BUSINESS_PARTNER
 * BUSINESS_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbr#ADDRESS_ID
 * ADDRESS_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbr#BP_TAX_TYPE
 * BP_TAX_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbr#BP_TAX_NUMBER
 * BP_TAX_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbr#BP_TAX_LONG_NUMBER
 * BP_TAX_LONG_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusPartAddrDepdntTaxNmbr#AUTHORIZATION_GROUP
 * AUTHORIZATION_GROUP}</li>
 * </ul>
 *
 */
public interface BusPartAddrDepdntTaxNmbrSelectable extends EntitySelectable<BusPartAddrDepdntTaxNmbr>
{

}
