/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRating;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRating
 * BusinessPartnerRating}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.field.BusinessPartnerRatingField
 * BusinessPartnerRatingField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.link.BusinessPartnerRatingLink
 * BusinessPartnerRatingLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRating#BUSINESS_PARTNER
 * BUSINESS_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRating#BUSINESS_PARTNER_RATING_PROCEDURE
 * BUSINESS_PARTNER_RATING_PROCEDURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRating#BP_RATING_VALIDITY_END_DATE
 * BP_RATING_VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRating#BUSINESS_PARTNER_RATING_GRADE
 * BUSINESS_PARTNER_RATING_GRADE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRating#BUSINESS_PARTNER_RATING_TREND
 * BUSINESS_PARTNER_RATING_TREND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRating#BP_RATING_VALIDITY_START_DATE
 * BP_RATING_VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRating#BP_RATING_CREATION_DATE
 * BP_RATING_CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRating#BUSINESS_PARTNER_RATING_COMMENT
 * BUSINESS_PARTNER_RATING_COMMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRating#BUSINESS_PARTNER_RATING_IS_ALLOWED
 * BUSINESS_PARTNER_RATING_IS_ALLOWED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRating#BP_RATING_IS_VALID_ON_KEY_DATE
 * BP_RATING_IS_VALID_ON_KEY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRating#BUSINESS_PARTNER_RATING_KEY_DATE
 * BUSINESS_PARTNER_RATING_KEY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerRating#BUSINESS_PARTNER_RATING_IS_EXPIRED
 * BUSINESS_PARTNER_RATING_IS_EXPIRED}</li>
 * </ul>
 *
 */
public interface BusinessPartnerRatingSelectable extends EntitySelectable<BusinessPartnerRating>
{

}
