/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumber;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumber
 * BusinessPartnerTaxNumber}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.field.BusinessPartnerTaxNumberField
 * BusinessPartnerTaxNumberField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.link.BusinessPartnerTaxNumberLink
 * BusinessPartnerTaxNumberLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumber#BUSINESS_PARTNER
 * BUSINESS_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumber#BP_TAX_TYPE
 * BP_TAX_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumber#BP_TAX_NUMBER
 * BP_TAX_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumber#BP_TAX_LONG_NUMBER
 * BP_TAX_LONG_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.BusinessPartnerTaxNumber#AUTHORIZATION_GROUP
 * AUTHORIZATION_GROUP}</li>
 * </ul>
 *
 */
public interface BusinessPartnerTaxNumberSelectable extends EntitySelectable<BusinessPartnerTaxNumber>
{

}
