/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformation;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformation
 * CustAddrDepdntInformation}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.field.CustAddrDepdntInformationField
 * CustAddrDepdntInformationField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.link.CustAddrDepdntInformationLink
 * CustAddrDepdntInformationLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformation#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformation#ADDRESS_ID
 * ADDRESS_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformation#EXPRESS_TRAIN_STATION_NAME
 * EXPRESS_TRAIN_STATION_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformation#TRAIN_STATION_NAME
 * TRAIN_STATION_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformation#CITY_CODE
 * CITY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustAddrDepdntInformation#COUNTY
 * COUNTY}</li>
 * </ul>
 *
 */
public interface CustAddrDepdntInformationSelectable extends EntitySelectable<CustAddrDepdntInformation>
{

}
