/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfo;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfo
 * CustSlsAreaAddrDepdntTaxInfo}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.field.CustSlsAreaAddrDepdntTaxInfoField
 * CustSlsAreaAddrDepdntTaxInfoField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.link.CustSlsAreaAddrDepdntTaxInfoLink
 * CustSlsAreaAddrDepdntTaxInfoLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfo#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfo#SALES_ORGANIZATION
 * SALES_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfo#DISTRIBUTION_CHANNEL
 * DISTRIBUTION_CHANNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfo#DIVISION
 * DIVISION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfo#ADDRESS_ID
 * ADDRESS_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfo#DEPARTURE_COUNTRY
 * DEPARTURE_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfo#CUSTOMER_TAX_CATEGORY
 * CUSTOMER_TAX_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustSlsAreaAddrDepdntTaxInfo#CUSTOMER_TAX_CLASSIFICATION
 * CUSTOMER_TAX_CLASSIFICATION}</li>
 * </ul>
 *
 */
public interface CustSlsAreaAddrDepdntTaxInfoSelectable extends EntitySelectable<CustSlsAreaAddrDepdntTaxInfo>
{

}
