/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo
 * CustUnldgPtAddrDepdntInfo}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.field.CustUnldgPtAddrDepdntInfoField
 * CustUnldgPtAddrDepdntInfoField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.link.CustUnldgPtAddrDepdntInfoLink
 * CustUnldgPtAddrDepdntInfoLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo#ADDRESS_ID
 * ADDRESS_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo#UNLOADING_POINT_NAME
 * UNLOADING_POINT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo#CUSTOMER_FACTORY_CALENDER_CODE
 * CUSTOMER_FACTORY_CALENDER_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo#BP_GOODS_RECEIVING_HOURS_CODE
 * BP_GOODS_RECEIVING_HOURS_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo#IS_DFLT_BP_UNLOADING_POINT
 * IS_DFLT_BP_UNLOADING_POINT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo#MONDAY_MORNING_OPENING_TIME
 * MONDAY_MORNING_OPENING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo#MONDAY_MORNING_CLOSING_TIME
 * MONDAY_MORNING_CLOSING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo#MONDAY_AFTERNOON_OPENING_TIME
 * MONDAY_AFTERNOON_OPENING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo#MONDAY_AFTERNOON_CLOSING_TIME
 * MONDAY_AFTERNOON_CLOSING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo#TUESDAY_MORNING_OPENING_TIME
 * TUESDAY_MORNING_OPENING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo#TUESDAY_MORNING_CLOSING_TIME
 * TUESDAY_MORNING_CLOSING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo#TUESDAY_AFTERNOON_OPENING_TIME
 * TUESDAY_AFTERNOON_OPENING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo#TUESDAY_AFTERNOON_CLOSING_TIME
 * TUESDAY_AFTERNOON_CLOSING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo#WEDNESDAY_MORNING_OPENING_TIME
 * WEDNESDAY_MORNING_OPENING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo#WEDNESDAY_MORNING_CLOSING_TIME
 * WEDNESDAY_MORNING_CLOSING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo#WEDNESDAY_AFTERNOON_OPENING_TIME
 * WEDNESDAY_AFTERNOON_OPENING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo#WEDNESDAY_AFTERNOON_CLOSING_TIME
 * WEDNESDAY_AFTERNOON_CLOSING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo#THURSDAY_MORNING_OPENING_TIME
 * THURSDAY_MORNING_OPENING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo#THURSDAY_MORNING_CLOSING_TIME
 * THURSDAY_MORNING_CLOSING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo#THURSDAY_AFTERNOON_OPENING_TIME
 * THURSDAY_AFTERNOON_OPENING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo#THURSDAY_AFTERNOON_CLOSING_TIME
 * THURSDAY_AFTERNOON_CLOSING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo#FRIDAY_MORNING_OPENING_TIME
 * FRIDAY_MORNING_OPENING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo#FRIDAY_MORNING_CLOSING_TIME
 * FRIDAY_MORNING_CLOSING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo#FRIDAY_AFTERNOON_OPENING_TIME
 * FRIDAY_AFTERNOON_OPENING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo#FRIDAY_AFTERNOON_CLOSING_TIME
 * FRIDAY_AFTERNOON_CLOSING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo#SATURDAY_MORNING_OPENING_TIME
 * SATURDAY_MORNING_OPENING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo#SATURDAY_MORNING_CLOSING_TIME
 * SATURDAY_MORNING_CLOSING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo#SATURDAY_AFTERNOON_OPENING_TIME
 * SATURDAY_AFTERNOON_OPENING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo#SATURDAY_AFTERNOON_CLOSING_TIME
 * SATURDAY_AFTERNOON_CLOSING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo#SUNDAY_MORNING_OPENING_TIME
 * SUNDAY_MORNING_OPENING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo#SUNDAY_MORNING_CLOSING_TIME
 * SUNDAY_MORNING_CLOSING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo#SUNDAY_AFTERNOON_OPENING_TIME
 * SUNDAY_AFTERNOON_OPENING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustUnldgPtAddrDepdntInfo#SUNDAY_AFTERNOON_CLOSING_TIME
 * SUNDAY_AFTERNOON_CLOSING_TIME}</li>
 * </ul>
 *
 */
public interface CustUnldgPtAddrDepdntInfoSelectable extends EntitySelectable<CustUnldgPtAddrDepdntInfo>
{

}
