/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany CustomerCompany}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.field.CustomerCompanyField
 * CustomerCompanyField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.link.CustomerCompanyLink
 * CustomerCompanyLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany#APAR_TOLERANCE_GROUP
 * APAR_TOLERANCE_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany#ACCOUNT_BY_CUSTOMER
 * ACCOUNT_BY_CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany#ACCOUNTING_CLERK
 * ACCOUNTING_CLERK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany#ACCOUNTING_CLERK_FAX_NUMBER
 * ACCOUNTING_CLERK_FAX_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany#ACCOUNTING_CLERK_INTERNET_ADDRESS
 * ACCOUNTING_CLERK_INTERNET_ADDRESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany#ACCOUNTING_CLERK_PHONE_NUMBER
 * ACCOUNTING_CLERK_PHONE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany#ALTERNATIVE_PAYER_ACCOUNT
 * ALTERNATIVE_PAYER_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany#AUTHORIZATION_GROUP
 * AUTHORIZATION_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany#COLLECTIVE_INVOICE_VARIANT
 * COLLECTIVE_INVOICE_VARIANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany#CUSTOMER_ACCOUNT_NOTE
 * CUSTOMER_ACCOUNT_NOTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany#CUSTOMER_HEAD_OFFICE
 * CUSTOMER_HEAD_OFFICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany#CUSTOMER_SUPPLIER_CLEARING_IS_USED
 * CUSTOMER_SUPPLIER_CLEARING_IS_USED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany#HOUSE_BANK
 * HOUSE_BANK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany#INTEREST_CALCULATION_CODE
 * INTEREST_CALCULATION_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany#INTEREST_CALCULATION_DATE
 * INTEREST_CALCULATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany#INTRST_CALC_FREQUENCY_IN_MONTHS
 * INTRST_CALC_FREQUENCY_IN_MONTHS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany#IS_TO_BE_LOCALLY_PROCESSED
 * IS_TO_BE_LOCALLY_PROCESSED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany#ITEM_IS_TO_BE_PAID_SEPARATELY
 * ITEM_IS_TO_BE_PAID_SEPARATELY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany#LAYOUT_SORTING_RULE
 * LAYOUT_SORTING_RULE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany#PAYMENT_BLOCKING_REASON
 * PAYMENT_BLOCKING_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany#PAYMENT_METHODS_LIST
 * PAYMENT_METHODS_LIST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany#PAYMENT_TERMS
 * PAYMENT_TERMS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany#PAYT_ADVICE_IS_SENTBY_EDI
 * PAYT_ADVICE_IS_SENTBY_EDI}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany#PHYSICAL_INVENTORY_BLOCK_IND
 * PHYSICAL_INVENTORY_BLOCK_IND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany#RECONCILIATION_ACCOUNT
 * RECONCILIATION_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany#RECORD_PAYMENT_HISTORY_INDICATOR
 * RECORD_PAYMENT_HISTORY_INDICATOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany#USER_AT_CUSTOMER
 * USER_AT_CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany#DELETION_INDICATOR
 * DELETION_INDICATOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany#CASH_PLANNING_GROUP
 * CASH_PLANNING_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany#KNOWN_OR_NEGOTIATED_LEAVE
 * KNOWN_OR_NEGOTIATED_LEAVE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany#VALUE_ADJUSTMENT_KEY
 * VALUE_ADJUSTMENT_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany#CUSTOMER_ACCOUNT_GROUP
 * CUSTOMER_ACCOUNT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany#TO_COMPANY_TEXT
 * TO_COMPANY_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany#TO_CUSTOMER_DUNNING
 * TO_CUSTOMER_DUNNING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerCompany#TO_WITH_HOLDING_TAX
 * TO_WITH_HOLDING_TAX}</li>
 * </ul>
 *
 */
public interface CustomerCompanySelectable extends EntitySelectable<CustomerCompany>
{

}
