/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer Customer}. This interface is used
 * by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.field.CustomerField CustomerField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.link.CustomerLink CustomerLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#CUSTOMER CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#AUTHORIZATION_GROUP
 * AUTHORIZATION_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#BILLING_IS_BLOCKED_FOR_CUSTOMER
 * BILLING_IS_BLOCKED_FOR_CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#CUSTOMER_ACCOUNT_GROUP
 * CUSTOMER_ACCOUNT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#CUSTOMER_CLASSIFICATION
 * CUSTOMER_CLASSIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#CUSTOMER_FULL_NAME
 * CUSTOMER_FULL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#CUSTOMER_NAME
 * CUSTOMER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#DELIVERY_IS_BLOCKED
 * DELIVERY_IS_BLOCKED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#FREE_DEFINED_ATTRIBUTE01
 * FREE_DEFINED_ATTRIBUTE01}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#FREE_DEFINED_ATTRIBUTE02
 * FREE_DEFINED_ATTRIBUTE02}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#FREE_DEFINED_ATTRIBUTE03
 * FREE_DEFINED_ATTRIBUTE03}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#FREE_DEFINED_ATTRIBUTE04
 * FREE_DEFINED_ATTRIBUTE04}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#FREE_DEFINED_ATTRIBUTE05
 * FREE_DEFINED_ATTRIBUTE05}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#FREE_DEFINED_ATTRIBUTE06
 * FREE_DEFINED_ATTRIBUTE06}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#FREE_DEFINED_ATTRIBUTE07
 * FREE_DEFINED_ATTRIBUTE07}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#FREE_DEFINED_ATTRIBUTE08
 * FREE_DEFINED_ATTRIBUTE08}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#FREE_DEFINED_ATTRIBUTE09
 * FREE_DEFINED_ATTRIBUTE09}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#FREE_DEFINED_ATTRIBUTE10
 * FREE_DEFINED_ATTRIBUTE10}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#NF_PARTNER_IS_NATURAL_PERSON
 * NF_PARTNER_IS_NATURAL_PERSON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#ORDER_IS_BLOCKED_FOR_CUSTOMER
 * ORDER_IS_BLOCKED_FOR_CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#POSTING_IS_BLOCKED
 * POSTING_IS_BLOCKED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#SUPPLIER SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#CUSTOMER_CORPORATE_GROUP
 * CUSTOMER_CORPORATE_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#FISCAL_ADDRESS
 * FISCAL_ADDRESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#INDUSTRY INDUSTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#INDUSTRY_CODE1
 * INDUSTRY_CODE1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#INDUSTRY_CODE2
 * INDUSTRY_CODE2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#INDUSTRY_CODE3
 * INDUSTRY_CODE3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#INDUSTRY_CODE4
 * INDUSTRY_CODE4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#INDUSTRY_CODE5
 * INDUSTRY_CODE5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#INTERNATIONAL_LOCATION_NUMBER1
 * INTERNATIONAL_LOCATION_NUMBER1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#INTERNATIONAL_LOCATION_NUMBER2
 * INTERNATIONAL_LOCATION_NUMBER2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#INTERNATIONAL_LOCATION_NUMBER3
 * INTERNATIONAL_LOCATION_NUMBER3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#NIELSEN_REGION
 * NIELSEN_REGION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#RESPONSIBLE_TYPE
 * RESPONSIBLE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#TAX_NUMBER1 TAX_NUMBER1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#TAX_NUMBER2 TAX_NUMBER2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#TAX_NUMBER3 TAX_NUMBER3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#TAX_NUMBER4 TAX_NUMBER4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#TAX_NUMBER5 TAX_NUMBER5}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#TAX_NUMBER_TYPE
 * TAX_NUMBER_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#VAT_REGISTRATION
 * VAT_REGISTRATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#DELETION_INDICATOR
 * DELETION_INDICATOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#EXPRESS_TRAIN_STATION_NAME
 * EXPRESS_TRAIN_STATION_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#TRAIN_STATION_NAME
 * TRAIN_STATION_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#CITY_CODE CITY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#COUNTY COUNTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#TO_CUST_ADDR_DEPDNT_EXT_IDENTIFIER
 * TO_CUST_ADDR_DEPDNT_EXT_IDENTIFIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#TO_CUST_ADDR_DEPDNT_INFORMATION
 * TO_CUST_ADDR_DEPDNT_INFORMATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#TO_CUSTOMER_COMPANY
 * TO_CUSTOMER_COMPANY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#TO_CUSTOMER_SALES_AREA
 * TO_CUSTOMER_SALES_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#TO_CUSTOMER_TAX_GROUPING
 * TO_CUSTOMER_TAX_GROUPING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#TO_CUSTOMER_TEXT
 * TO_CUSTOMER_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#TO_CUSTOMER_UNLOADING_POINT
 * TO_CUSTOMER_UNLOADING_POINT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.Customer#TO_CUST_UNLDG_PT_ADDR_DEPDNT_INFO
 * TO_CUST_UNLDG_PT_ADDR_DEPDNT_INFO}</li>
 * </ul>
 *
 */
public interface CustomerSelectable extends EntitySelectable<Customer>
{

}
