/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGrouping;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGrouping CustomerTaxGrouping}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.field.CustomerTaxGroupingField
 * CustomerTaxGroupingField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.link.CustomerTaxGroupingLink
 * CustomerTaxGroupingLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGrouping#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGrouping#CUSTOMER_TAX_GROUPING_CODE
 * CUSTOMER_TAX_GROUPING_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGrouping#CUST_TAX_GRP_EXEMPTION_CERTIFICATE
 * CUST_TAX_GRP_EXEMPTION_CERTIFICATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGrouping#CUST_TAX_GROUP_EXEMPTION_RATE
 * CUST_TAX_GROUP_EXEMPTION_RATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGrouping#CUST_TAX_GROUP_EXEMPTION_START_DATE
 * CUST_TAX_GROUP_EXEMPTION_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGrouping#CUST_TAX_GROUP_EXEMPTION_END_DATE
 * CUST_TAX_GROUP_EXEMPTION_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGrouping#CUST_TAX_GROUP_SUBJECTED_START_DATE
 * CUST_TAX_GROUP_SUBJECTED_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerTaxGrouping#CUST_TAX_GROUP_SUBJECTED_END_DATE
 * CUST_TAX_GROUP_SUBJECTED_END_DATE}</li>
 * </ul>
 *
 */
public interface CustomerTaxGroupingSelectable extends EntitySelectable<CustomerTaxGrouping>
{

}
