/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint
 * CustomerUnloadingPoint}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.field.CustomerUnloadingPointField
 * CustomerUnloadingPointField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.link.CustomerUnloadingPointLink
 * CustomerUnloadingPointLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint#UNLOADING_POINT_NAME
 * UNLOADING_POINT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint#CUSTOMER_FACTORY_CALENDER_CODE
 * CUSTOMER_FACTORY_CALENDER_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint#BP_GOODS_RECEIVING_HOURS_CODE
 * BP_GOODS_RECEIVING_HOURS_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint#IS_DFLT_BP_UNLOADING_POINT
 * IS_DFLT_BP_UNLOADING_POINT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint#MONDAY_MORNING_OPENING_TIME
 * MONDAY_MORNING_OPENING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint#MONDAY_MORNING_CLOSING_TIME
 * MONDAY_MORNING_CLOSING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint#MONDAY_AFTERNOON_OPENING_TIME
 * MONDAY_AFTERNOON_OPENING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint#MONDAY_AFTERNOON_CLOSING_TIME
 * MONDAY_AFTERNOON_CLOSING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint#TUESDAY_MORNING_OPENING_TIME
 * TUESDAY_MORNING_OPENING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint#TUESDAY_MORNING_CLOSING_TIME
 * TUESDAY_MORNING_CLOSING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint#TUESDAY_AFTERNOON_OPENING_TIME
 * TUESDAY_AFTERNOON_OPENING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint#TUESDAY_AFTERNOON_CLOSING_TIME
 * TUESDAY_AFTERNOON_CLOSING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint#WEDNESDAY_MORNING_OPENING_TIME
 * WEDNESDAY_MORNING_OPENING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint#WEDNESDAY_MORNING_CLOSING_TIME
 * WEDNESDAY_MORNING_CLOSING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint#WEDNESDAY_AFTERNOON_OPENING_TIME
 * WEDNESDAY_AFTERNOON_OPENING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint#WEDNESDAY_AFTERNOON_CLOSING_TIME
 * WEDNESDAY_AFTERNOON_CLOSING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint#THURSDAY_MORNING_OPENING_TIME
 * THURSDAY_MORNING_OPENING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint#THURSDAY_MORNING_CLOSING_TIME
 * THURSDAY_MORNING_CLOSING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint#THURSDAY_AFTERNOON_OPENING_TIME
 * THURSDAY_AFTERNOON_OPENING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint#THURSDAY_AFTERNOON_CLOSING_TIME
 * THURSDAY_AFTERNOON_CLOSING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint#FRIDAY_MORNING_OPENING_TIME
 * FRIDAY_MORNING_OPENING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint#FRIDAY_MORNING_CLOSING_TIME
 * FRIDAY_MORNING_CLOSING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint#FRIDAY_AFTERNOON_OPENING_TIME
 * FRIDAY_AFTERNOON_OPENING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint#FRIDAY_AFTERNOON_CLOSING_TIME
 * FRIDAY_AFTERNOON_CLOSING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint#SATURDAY_MORNING_OPENING_TIME
 * SATURDAY_MORNING_OPENING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint#SATURDAY_MORNING_CLOSING_TIME
 * SATURDAY_MORNING_CLOSING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint#SATURDAY_AFTERNOON_OPENING_TIME
 * SATURDAY_AFTERNOON_OPENING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint#SATURDAY_AFTERNOON_CLOSING_TIME
 * SATURDAY_AFTERNOON_CLOSING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint#SUNDAY_MORNING_OPENING_TIME
 * SUNDAY_MORNING_OPENING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint#SUNDAY_MORNING_CLOSING_TIME
 * SUNDAY_MORNING_CLOSING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint#SUNDAY_AFTERNOON_OPENING_TIME
 * SUNDAY_AFTERNOON_OPENING_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerUnloadingPoint#SUNDAY_AFTERNOON_CLOSING_TIME
 * SUNDAY_AFTERNOON_CLOSING_TIME}</li>
 * </ul>
 *
 */
public interface CustomerUnloadingPointSelectable extends EntitySelectable<CustomerUnloadingPoint>
{

}
