/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTax;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTax
 * CustomerWithHoldingTax}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.field.CustomerWithHoldingTaxField
 * CustomerWithHoldingTaxField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.link.CustomerWithHoldingTaxLink
 * CustomerWithHoldingTaxLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTax#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTax#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTax#WITHHOLDING_TAX_TYPE
 * WITHHOLDING_TAX_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTax#WITHHOLDING_TAX_CODE
 * WITHHOLDING_TAX_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTax#WITHHOLDING_TAX_AGENT
 * WITHHOLDING_TAX_AGENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTax#OBLIGATION_DATE_BEGIN
 * OBLIGATION_DATE_BEGIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTax#OBLIGATION_DATE_END
 * OBLIGATION_DATE_END}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTax#WITHHOLDING_TAX_NUMBER
 * WITHHOLDING_TAX_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTax#WITHHOLDING_TAX_CERTIFICATE
 * WITHHOLDING_TAX_CERTIFICATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTax#WITHHOLDING_TAX_EXMPT_PERCENT
 * WITHHOLDING_TAX_EXMPT_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTax#EXEMPTION_DATE_BEGIN
 * EXEMPTION_DATE_BEGIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTax#EXEMPTION_DATE_END
 * EXEMPTION_DATE_END}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTax#EXEMPTION_REASON
 * EXEMPTION_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesspartner.CustomerWithHoldingTax#AUTHORIZATION_GROUP
 * AUTHORIZATION_GROUP}</li>
 * </ul>
 *
 */
public interface CustomerWithHoldingTaxSelectable extends EntitySelectable<CustomerWithHoldingTax>
{

}
